; -- Languages.iss --
; Demonstrates a multilingual installation.

; SEE THE DOCUMENTATION FOR DETAILS ON CREATING .ISS SCRIPT FILES!

[Setup]
AppName=FTP Rush
AppId=FTP Rush
AppVersion=2.2.0
AppComments=FTPRush Installer, Copyright (c) 2002-2019 wftpserver.com
AppVerName=FTPRush 2.2.0
DefaultDirName={pf}\FTPRush
DefaultGroupName=FTP Rush
UninstallDisplayIcon={app}\MyProg.exe
VersionInfoVersion=2.2.0
VersionInfoCompany=wftpserver.com
VersionInfoDescription=FTPRush 2.2.0 Unicode Installer
VersionInfoCopyright=Copyright (c) 2002-2019 wftpserver.com
AppCopyright=Copyright (c) 2002-2019 wftpserver.com
AppPublisher=wftpserver.com
AppPublisherURL=http://www.wftpserver.com
AppSupportURL=http://www.wftpserver.com/support.html
AppUpdatesURL=http://www.wftpserver.com/download.html
SolidCompression=yes
;Compression=bzip/9
Compression=lzma/max	
LicenseFile=License.txt
OutputBaseFilename=ftprush
OutputDir=..\
AllowUNCPath=no
AlwaysUsePersonalGroup=yes
WizardImageFile=..\..\RES\Splash\win.bmp
WizardSmallImageFile=..\..\RES\Splash\innosmall.bmp
; Uncomment the following line to disable the "Select Setup Language"
; dialog and have it rely solely on auto-detection.
ShowLanguageDialog=no
PrivilegesRequired=admin

; If you want all languages to be listed in the "Select Setup Language"
; dialog, even those that can't be displayed in the active code page,
; uncomment the following two lines.
;[LangOptions]
;LanguageCodePage=0

[Languages]
Name: en; MessagesFile: "compiler:Default.isl"
Name: fr; MessagesFile: "compiler:Languages\French.isl"
Name: nl; MessagesFile: "compiler:Languages\Dutch.isl"
Name: de; MessagesFile: "compiler:Languages\German.isl"
Name: cn; MessagesFile: "compiler:Languages\ChineseSimp.isl"
Name: fi; MessagesFile: "compiler:Languages\Finnish.isl"
Name: ds; MessagesFile: "compiler:Languages\Danish.isl"
Name: it; MessagesFile: "compiler:Languages\Italian.isl"
Name: hu; MessagesFile: "compiler:Languages\Hungarian.isl"
Name: no; MessagesFile: "compiler:Languages\Norwegian.isl"
Name: po; MessagesFile: "compiler:Languages\Portuguese.isl"
Name: ru; MessagesFile: "compiler:Languages\Russian.isl"
Name: cz; MessagesFile: "compiler:Languages\Czech.isl"
Name: ar; MessagesFile: "compiler:Languages\ARABIC.isl"
Name: jp; MessagesFile: "compiler:Languages\Japanese.isl"
Name: kr; MessagesFile: "compiler:Languages\Korean.isl"
Name: sk; MessagesFile: "compiler:Languages\Slovak.isl"
Name: pl; MessagesFile: "compiler:Languages\Polish.isl"
Name: tw; MessagesFile: "compiler:Languages\ChineseTrad.isl"

[Messages]
en.BeveledLabel=www.wftpserver.com
nl.BeveledLabel=www.wftpserver.com
de.BeveledLabel=www.wftpserver.com
cn.BeveledLabel=www.wftpserver.com
fr.BeveledLabel=www.wftpserver.com
fi.BeveledLabel=www.wftpserver.com
ds.BeveledLabel=www.wftpserver.com
it.BeveledLabel=www.wftpserver.com
hu.BeveledLabel=www.wftpserver.com
no.BeveledLabel=www.wftpserver.com
po.BeveledLabel=www.wftpserver.com
ru.BeveledLabel=www.wftpserver.com
cz.BeveledLabel=www.wftpserver.com
ar.BeveledLabel=www.wftpserver.com
jp.BeveledLabel=www.wftpserver.com
kr.BeveledLabel=www.wftpserver.com
sk.BeveledLabel=www.wftpserver.com
pl.BeveledLabel=www.wftpserver.com
tw.BeveledLabel=www.wftpserver.com

[Components]
Name: "main"; Description: "Main Files"; Types: full compact custom; Flags: fixed
Name: "ssl"; Description: "SSL Files"; Types: full
Name: "help"; Description: "Help Files"; Types: full
;Name: "startmg"; Description: "StartMenu Shortcuts"; Types: full
;Name: "desktopmg"; Description: "Desktop Shortcuts"; Types: full
;Name: "quickst"; Description: "QuickLaunch Shortcuts"; Types: full


[Files]
Source: ftprush.exe; DestDir: "{app}"; Flags: ignoreversion; Components: main
Source: language\*.*;    DestDir: "{app}\language"; Flags: ignoreversion; Components: main
Source: License.txt;    DestDir: "{app}"; Flags: ignoreversion; Components: main
Source: Readme.txt;    DestDir: "{app}"; Flags: ignoreversion; Components: main
Source: website.url;    DestDir: "{app}"; Flags: ignoreversion; Components: main
Source: forum.url;    DestDir: "{app}"; Flags: ignoreversion; Components: main
Source: Rushicon.lib;    DestDir: "{app}"; Flags: ignoreversion; Components: main
Source: RushInit.lib;    DestDir: "{app}"; Flags: ignoreversion; Components: main
Source: Rushuser.lib;    DestDir: "{app}"; Flags: ignoreversion; Components: main
Source: ftprush.chm; DestDir: "{app}"; Flags: ignoreversion; Components: help
Source: libeay32.dll; DestDir: "{app}"; Flags: ignoreversion; Components: ssl
Source: ssleay32.dll; DestDir: "{app}"; Flags: ignoreversion; Components: ssl

[Tasks]
Name: desktopicon; Description: "{cm:CreateDesktopIcon}"
Name: quickicon; Description: "{cm:CreateQuickLaunchIcon}"

[Icons]
Name: "{commonprograms}\FTPRush\FTPRush"; Filename: "{app}\ftprush.exe"; WorkingDir: "{app}";
Name: "{commonprograms}\FTPRush\FTPRush Help"; Filename: "{app}\ftprush.chm";
Name: "{commonprograms}\FTPRush\Visit FTPRush Web Site"; Filename: "{app}\website.url";
Name: "{commonprograms}\FTPRush\Visit FTPRush Forum"; Filename: "{app}\forum.url";
Name: "{commonprograms}\FTPRush\Uninstall FTPRush"; Filename: "{uninstallexe}"
Name: "{commondesktop}\FTPRush"; Filename: "{app}\ftprush.exe"; Components: main; Tasks: desktopicon
Name: "{userappdata}\Microsoft\Internet Explorer\Quick Launch\FTPRush"; Filename: "{app}\ftprush.exe";Components: main; Tasks: quickicon

[InstallDelete]
; Older versions created the desktop icon under {userdesktop}
Type: files; Name: "{userdesktop}\FTPRush.lnk"




















