#include "psock.hh"
#ifdef WINDOWS
#include <process.h>
#include <windows.h>
#else
#include <pthread.h>
#include <signal.h>
#endif
#include "compat.hh"
#include <stdio.h>
#include <string.h>
#include "parse.h"
#include "block.h"
#include "adb.h"
#include "h.h"
#include "utils.hh"
#include "conf.h"
#include "proxyconf.hh"
#include "hcom.hh"

bool DoAbort = false;
volatile int num_threads = 0;
bool listen_port_changed = false;

const int REQ_BUF_SIZE = 16384;
const int MAX_HOSTNAME = 256;

const int EREADHEADER = -1000;
const int EPARSEHEADER = -1001;

const char* http_methods[] = {
   "OPTIONS ",
   "GET ",
   "HEAD ",
   "POST ",
   "PUT ",
   "DELETE ",
   "TRACE ",
   0 
};

const char MSG_200b[] = "200 Blocked";
const char MSG_204[] = "204 No Content";
const char MSG_400[] = "400 Bad Request";
const char MSG_T400[] = "Your browser sent a request that this proxy could not understand.";
const char MSG_408[] = "408 Request Timeout";
const char MSG_T408[] = "The client did not produce a request within the time that the server "
  "was prepared to wait.";
const char MSG_500[] = "500 Internal Server Error";
const char MSG_T500[] = "The server encountered an unexpected condition which prevented it "
  "from fulfilling the request.";
const char MSG_502[] = "502 Bad Gateway";
const char MSG_T502[] = "The proxy received an invalid response from the upstream "
  "server it accessed in attempting to fulfill the request.";
const char MSG_999[] = "200 Automatic configuration";

bool ScanHeader(char * (&ret), char *buf, char * (&command), char * (&hostname), int &port, char * (&path), int &version, bool &is_proxyconf)
{
   is_proxyconf = false;
   command = buf;
   for (const char **m = http_methods; *m; m++) {
      int l = strlen(*m);
      if (!mystrincmp(buf, *m, l)) {
	 buf += l-1;
	 goto ScanHeader_label1;
      }
   }
   return false;
   ScanHeader_label1:
   *(buf++) = 0;
   if (!mystrincmp(buf, "/proxyconf", 10)) {
     command = "PROXYCONF";
     hostname = "proxyconf";
     port = 80;
     path = "proxyconf";
     is_proxyconf = true;
     return true;
   }
   int ofs;
   char *ret2;
   if (!ParseURI(ret2, buf, true, hostname, port, path, ofs))
     return false;
   // now HTTP/1.x
   buf = ret2;
   if (!*buf) {
      version = 0;
      ret = buf;
      return true;
   }
   *(buf++) = 0;
   if (mystrincmp(buf, "HTTP/1.", 7))
     return false;
   version = *(buf += 7) - '0';
   buf++;
   while (*buf && (*buf == ' ' || *buf == '\r' || *buf == '\n'))
     buf++;
   ret = buf;
   return true;
}

int ReadHeader(PSock *p2, char *buf, int maxsize, int &bufsize)
// read complete header into buffer
{
   int remains = maxsize;
   int count = 0;
   memset(buf, 0, maxsize+1); // correct
   bool is_nl = false;
   char *buf_start = buf;
   for(;;) {
      int r = p2->Recv(buf, remains);
      if (r <= 0)
	return EREADHEADER;
      remains -= r;
      count += r;
      char *b2 = buf, *b2end = buf+r;
      while (b2 < b2end) {
	 char c = *b2;
	 if (c == '\n') {
	    if (is_nl) {
	       // end of header, scanned \r\n\r\n or \n\n
	       // remove trailing \r\n
	       int pos = b2 - buf_start;
	       if (pos > 1 && *(b2-1) == '\r')
		 pos--;
	       bufsize = count;
	       return pos-1;
	    }
	    is_nl = true;
	 } else if (c == '\r')
	   ;
	 else
	   is_nl = false;
	 b2++;
      }
      buf += r;
      if (remains <= 0) // too long header!
	return EPARSEHEADER;
   }
}

enum ban_t {
   btOK,
   btSendGIF,
   btBan,
   btBody
};

ban_t BanURL(int count, const char *hostname, int port, const char *path, const char * (&ret_body))
{
   bool is_bodyblock = count;
   int count2 = count ? count: 1;
   int ret = blist.is_blocked(count2, hostname, port, path, is_bodyblock, ret_body);
   if (ret >= 0) {
     if (!is_bodyblock || count) {
       UpdateEntry(ret);
       return btSendGIF;
     }
     return btBody;
//      if (path && (strstr(path, "gif") || strstr(path, "GIF")))
//      else
//	return btBan;
   }
   return btOK;
}

void ClientError(PSock *p2, const char *title, const char *text, const char *text2,
		 const char *host, int port, const char *path)
{
   if (text)
     PrintError(host, port, path, title, text);
   else
     PrintError(host, port, path, title, text2);
   p2->SetStage(PSock::stNoErr);
   p2->SendStr("HTTP/1.1 ");
   p2->SendStr(title);
   p2->SendStr(CRLF_STR "Connection: Close" CRLF_STR "Content-type: text/html" CRLF_STR CRLF_STR);
   p2->SendStr("<!DOCTYPE HTML PUBLIC \"-////IETF////DTD HTML 2.0////EN\">" CRLF_STR);
   p2->SendStr("<html><head><title>Ad Buster: Error [");
   p2->SendStr(title);
   p2->SendStr("]</title><head><body><h1>");
   p2->SendStr(title);
   p2->SendStr("</h1>");
   if (text2) {
      p2->SendStr("<h2>");
      p2->SendStr(text2);
      p2->SendStr("</h2>");
   }
   if (text) {
      p2->SendStr("<h2>");
      p2->SendStr(text);
      p2->SendStr("</h2>");
      }
   p2->SendStr("</body></html>");
}

void ClientIOError(PSock *p2, const char *msg1, const char *msg2, const char *host, int port, const char *path)
{
   char s[400];
   int e = s_WSAGetLastError();
#ifdef WINDOWS
   const char *et = winsock_geterror(e);
   if (!et)
     sprintf(s, "%s%sWinSock error %i (stupid Win32 API have not additional text error messages), "
	     "Win32 error %i",
	     psock_static_error ? psock_static_error : "",
	     psock_static_error ? ": " : "",
	     e, GetLastError());
   else
     sprintf(s, "%s%s%s",
 	     psock_static_error ? psock_static_error : "",
	     psock_static_error ? ": " : "",
	     et);
#else
   sprintf(s, "%s%sError: %s",
	   psock_static_error ? psock_static_error : "",
	   psock_static_error ? ": " : "",
	   strerror(e));
#endif
   ClientError(p2, msg1, s, msg2, host, port, path);
}

void ServeClient(PSock * p2)
{

   PSock *c = 0;
   bool use_proxy2 = use_proxy;
   char *buf = new char[REQ_BUF_SIZE+1];
   char *oldhost = new char[MAX_HOSTNAME];
   char *buf2 = new char[REQ_BUF_SIZE+1];
   char *hostname = 0, *path = 0, *command = 0;
   const char *ret_body = 0;
   int port = 80;
   oldhost[0] = 0;
   int oldport = -1;
   int add_count = 0;
   num_threads++;
   bool stealth2 = false;
   PrintThreads(num_threads);
   for(;;) {
      int bufsize;
      p2->SetStage(PSock::stReadHead);
      int r = ReadHeader(p2, buf, REQ_BUF_SIZE, bufsize);
      if (r <= 0) {
	 char s[100];
	 sprintf(s, "Bad header: '%s'", buf);
	 if (r == EREADHEADER)
	   ClientIOError(p2, MSG_400, s, 0, 80, 0);
	 else
	   ClientError(p2, MSG_400, s, MSG_T400, 0, 80, 0);
	 goto sce;
      }
      char *end;
      int version;
      bool is_proxyconf;
      if (!ScanHeader(end, buf, command, hostname, port, path, version, is_proxyconf)) {
	 ClientError(p2, MSG_400, "Bad header", MSG_T400, hostname, port, path);
	 goto sce;
      }
      p2->SetStage(PSock::stClient);
      PrintStatus(hostname, port, path);
      if (is_proxyconf) {
	const char *sn = get_autoconf_proxy();
	p2->SendStr(sn);
	if (show_all)
	  PrintError(hostname, port, path, MSG_999, "Automatic configuration");
	delete sn;
	goto sce;
      }
      ban_t b = BanURL(0, hostname, port, path, ret_body);
      if (b != btOK && b != btBody) {
	 if (b == btSendGIF) {
	    p2->Send("HTTP/1.1 200 OK" CRLF_STR
		     "Content-type: image/gif" CRLF_STR CRLF_STR
		     "GIF89a\001\000\001\000\200\000\000\377\377\377\000\000"
		     "\000!\371\004\001\000\000\000\000,\000\000\000\000\001"
		     "\000\001\000\000\002\002D\001\000;", 17+27+18+15+9);
	    if (show_all)
	      PrintError(hostname, port, path, MSG_200b, "Blocked - sent image");
	 } else {
	    p2->SendStr("HTTP/1.1 204 No Content" CRLF_STR CRLF_STR);
	    if (show_all)
	      PrintError(hostname, port, path, MSG_204, "Blocked - sent empty body");
	 }
	 stealth2 = stealth_mode;
	 if (stealth2)
	   p2->Close();
	 else 
	  goto sce;
      }
      int rb_len = mystrlen(ret_body);     
      for (int t = 0; t < max_connection_tries; t++) { // try more connections to server
	 if (t)	
#ifdef WINDOWS	
	   Sleep(20);
#else
	   usleep(200);
#endif
	 const char *h = use_proxy2 ? proxy_hostname : hostname;
	 int p = use_proxy2 ? proxy_port : port;
	 if (c && c->Alive() && oldport == p && !strcmp(h, oldhost))
	   ;
	 else {
	    delete c;
	    c = new PSock;
	    if (!c->Connect(h, p))
		 continue;
	    oldport = port;
	    strcpy(oldhost, hostname);
	 }
	 c->SetStage(PSock::stSendHead);
	 if (use_proxy2)
	   sprintf(buf2, "%s http://%s:%i/%s HTTP/1.%i" CRLF_STR, command, hostname, port, path, version);
	 else
	   sprintf(buf2, "%s /%s HTTP/1.%i" CRLF_STR, command, path, version);
	 if (!c->SendStr(buf2))
	   continue;
	 // send rest of headers
	 int r2 = bufsize-(end-buf);
	 if (r2 > 0)
	   if (!c->Send(end, r2))
	     continue;
	 else {
#if 0	   
	    char *s = new char[mystrlen(hostname)+30];
	    sprintf(s, "Host: %s" CRLF_STR CRLF_STR, hostname);
	    bool r = c->SendStr(s);
	    delete s;
	    if (!r)
	      continue;
#endif	   
	 }
	 goto sc_skip1;
      }
      break; // 5 tries and no success => report error
      sc_skip1:
      SuccessfullRequest();
      c->SetStage(PSock::stServer);
	{
	   bool first = true;
//	   int read_size = 0;
	   for (;;) {
 	      PSock *o = stealth2 ? c : c->Select(p2);
	      if (o == c) {
		 // data from server to client
		 int rs = c->Recv(buf2, REQ_BUF_SIZE);
		 if (rs > 0) {
//		    read_size += rs;
		    buf2[rs] = 0;
		    if (show_all && first) {
		       first = false;
		       if (strcmp(buf2, "HTTP/1.")) {
			  char *bend = buf2 + rs;
			  char *i = buf2 + 8;
			  while (i < bend && *i && *i != ' ')
			    i++;
			  while (i < bend && *i && *i == ' ')
			    i++;
			  char *b = i;
			  while (i < bend && *i && *i != '\r' && *i != '\n')
			    i++;
			  if (b < i) {
			     char a = *i;
			     *i = 0;
			     PrintError(hostname, port, path, b, "Server answer");
			     *i = a;
			  }
		       }
		    }
		    if (b == btBody) {
		      char *l;
		      const char *buf2end = buf2+rs-rb_len;		      
//		      printf("blockbody: %s, buf2: %s (path: %s, size: %d, rb_len: %d)\n", ret_body, buf2, path, 0 /* read_size */, rb_len);
		      if (rb_len)
			for (char *b2 = buf2; b2 < buf2end && ((l = strstr(b2, ret_body)) != 0); b2 += rb_len) {
			  memset(l, ' ', rb_len); // replace with spaces
			  add_count++;
			  // l[rb_len] = s;
			}
		    }
		    if (!stealth2 && !p2->Send(buf2, rs))
		      goto sce; // client gone...
		 } else {
                    if (rs && s_WSAGetLastError() != 10038 /*WSAENOTSOCK */)
		      ClientIOError(p2, MSG_502, MSG_T502, hostname, port, path);
		    else if (rs)
		      PrintError(hostname, port, path, "499 End", "Receive: Server error");
		    goto sce;
		 }
	      } else if (o == p2) {
		 // data from client to server
		 int rs = p2->Recv(buf2, REQ_BUF_SIZE);
		 if (rs > 0) {
		    if (!c->Send(buf2, rs))
		      break;
		 } else {
		    if (rs && s_WSAGetLastError() != 10038 /*WSAENOTSOCK */)
		      ClientIOError(p2, MSG_408, MSG_T408, hostname, port, path);
		    goto sce;
		 }
	      } else {
		 // error in select
		 ClientIOError(p2, MSG_500, MSG_T500, hostname, port, path);
		 goto sce;
	      }
	   }
	   break;
	}
   }
   ClientIOError(p2, MSG_502, MSG_T502, hostname, port, path);
   sce:
   if (add_count) {
     BanURL(add_count, hostname, port, path, ret_body);
     if (show_all)
       PrintError(hostname, port, path, MSG_204, "Blocked in body - replaced with spaces");
   }
   delete c;
   delete p2;
   delete buf2;
   delete buf;
   delete oldhost;
   num_threads--;
   PrintThreads(num_threads);
}

#ifdef WINDOWS
DWORD WINAPI ServeClientWindows(LPVOID par)
{
  PSock *p2 = (PSock *) par;
  ServeClient(p2);
#ifdef __MINGW32__
  _endthread();
#else
  ExitThread(0);
#endif
  return 0;
}
#else
void * ServeClientUNIX(void * par)
{
  signal(SIGPIPE, SIG_IGN);  
  PSock *p2 = (PSock *) par;
  ServeClient(p2);
  pthread_exit(0);
}

static pthread_attr_t t_attr;

#endif

bool adbmain()
{
   PSock *p;
#ifdef UNIX
   pthread_attr_init(&t_attr);
   pthread_attr_setdetachstate(&t_attr, PTHREAD_CREATE_DETACHED);
#endif
   adbmain_start_label:
   p = new PSock;
   if (!p->Listen(listen_port))
     return false;
   while (!DoAbort) {
      if (listen_port_changed) {
	delete p;
	listen_port_changed = false;
	goto adbmain_start_label;
      }
      PSock *p2 = p->Accept(allow_nonlocal);
      if (p2) {
#ifdef WINDOWS
	 HANDLE h = (HANDLE) _beginthread((void (*)(void *)) ServeClientWindows,
					  0, (void *) p2);
	 if (h != INVALID_HANDLE_VALUE)
	   CloseHandle(h);
#else
	pthread_t t;
	pthread_create(&t, &t_attr, ServeClientUNIX, (void *) p2);
#endif
      }
   }
   delete p;
#ifdef UNIX  
   pthread_attr_destroy(&t_attr);
#endif  
   return true;
}


