{ $Header: /home/CVS/prj/zasc/ZA.PAS,v 1.7 2002/03/06 17:34:19 ralph Exp $ }
{$I comp.pas}                   { FPC; TP6; TMT; VP; dependend compiler options}
Program ZA_Log_Converter;       { 20-Aug-2000, Ralph Roth, initial creation    }
{$I-,S-}                        { For Free Pascal 1.00 (FPC)                   }
{&USE32+}                       { For Virtual Pascal 2.1                       }
{ --- History ---

change legend:  +  =  added some                   -  =  removed some
                !  =  changed some (minor fixes)   .  =  changed and added some

$Log: ZA.PAS,v $
Revision 1.7  2002/03/06 17:34:19  ralph
+ added SAP, HP, MC/SG ports to myport.lst
+ changed copyright, cvs y2k2, reformatted the HTML file

Revision 1.6.1.1  2001/04/07 13:13:46  ralph
Imported April 2001 stuff

Revision 1.8  2001/03/30 00:13:59  rose_swe.p200
+ added EndProgram (so everytime Close(OutPut)) is used for GO.BAT
. misc. changes
! ZA 1.6.2

Revision 1.7  2001/03/29 23:41:21  rose_swe.p200
+ ported to Virtual Pascal 2.1
! fixed a bug with the percentange calculation (div for /)
! removed $I func.pas, added uses rStings instead

Revision 1.6  2001/03/20 00:56:25  MaRiWa_A.S.C.
- changeidentifiers in src, unused things
! typeport desc len too short, now longer (probs /w very long desc  e.g. 21 o. 25)
! the unit func(tions) now as an include
! changed the revisionlist a little, for better understanding :)
+ ZA has now an own ICON (see ZA-LOG.ICO)
  released the 1.6.sr (sr stands for Spring Release)  :)

Revision 1.5  2001/03/15 00:24:50  rose_swe.p200
1.4.1.2 by Mathias, major enhancement, see revision history

Revision 1.4.1.2  2001/03/12 20:46:28  MaRiWa_A.S.C.
+  fieldseparator (TAB,Comma,Semicolon) for ZoneAlarm[tm] Pro added
+  change legend added ,-)

Revision 1.4.1.1  2001/02/16 02:33:14  MaRiWa_A.S.C.
!. some minor changes
!. fixed some minor bugs ,-)
+  linewrap added, if line longer as 80 chars
!. reformated the output a little bit

Revision 1.4  2001/02/07 19:53:26  rose_swe.p200
Added tons of new options (modified kommando.pas for that)

Revision 1.3  2001/02/07 18:57:09  rose_swe.p200
1.4 - enhancements requested by Mathias and Thorsten added
-IN, -OUT, -PE

Revision 1.2  2000/12/27 14:57:41  rose_swe.p200
ZA 1.3.3 send to Andreas Haak

}
uses dos, r_utils, rStrings, kommando;

type    TypePort  = Record
                      count   : LongInt;
                      desc    : String[250];  { no probs /w very long desc }
                    end;

Const   {$IFDEF FPC}
        MAXPORTS = $FFFF;
        {$ELSE}
        MAXPORTS = $1ff;
        {$ENDIF}
        Field_Separator : array[1..3] of Char = (#9,',',';');  { for ZA Pro }
        ln_wd : byte = 78;                     { length for wrap }
        sVer = '1.6.3';
        lVer = sVer+' (Spring Release)';
        FWINOUT : String[20] = 'FWIN';         { FWOUT }
        ZA_RCS_ID : array[1..2] of String[90] =
('$Header: /home/CVS/prj/zasc/ZA.PAS,v 1.7 2002/03/06 17:34:19 ralph Exp $',
 'Internal $Id: ZA.PAS,v 1.7 2002/03/06 17:34:19 ralph Exp $');



var     szWork, szPort,
        szdateOld, szOut : string;
        hIn     : Text;
        aPorts  : Array[0..MAXPORTS] of TypePort;
        wPort   : Word;
        nErr    : Integer;
        t, i    : Byte;
        lMinLevel, lTotal : LongInt;
        rMinLevel, rPercent : Real;
        sr      : SearchRec;
        oKZ     : PKommandoZeile;
        first, second   : Boolean;  { for wrap, for logfile separator }


{ ---------------------------------------------------------------------------- }
{.$I FUNC.PAS}  { function  StrOf, Wrap }

Procedure EndProgram(bExitCode: Byte);  { rar, 29.03.2001 for GO.BAT }

begin
        if bExitCode <> 0 then writeln('ZA ended unsuccessfully!');
        close(OutPut);
        halt(bExitCode)
end;

Procedure ReadPortList;

begin { ReadPortList }
        assign(hIn, 'myport.lst');
        if ioresult <> 0 then
        begin
                writeln(GuruHeadLine('ERROR'));
                writeln('Access to myport.lst denied, aborting!');
                EndProgram(1);
        end;
        reset(hIn);

        repeat
                readln(hIn, szWork);
                t := pos(',', szWork);
                val(copy(szWork,1,t-1), wPort, nErr);

                if (wPort>0) AND (wPort<=MAXPORTS) or ((wPort=0) AND (nErr=0)) then
                begin
                     szPort := Copy(szWork,t+1,255);
                     if aPorts[wPort].desc <> '' then
                        szPort := aPorts[wPort].desc+'/'+szPort;
                     if Pos('?', szPort) = 0 then
                        aPorts[wPort].desc := szPort;
                end;

                t := pos('MINREPORTLEVEL=', szWork);
                if t = 1 then
                begin
                        val(copy(szWork,t+15,255), lMinLevel, nErr);
                        if nErr <> 0 then lMinLevel := 1;
                end;
                t := pos('MINPERCENTAGE=', szWork);
                if t = 1 then
                begin
                        val(copy(szWork,t+14,255), rMinLevel, nErr);
                        if nErr <> 0 then rMinLevel := 1.5;
                end;

        until (eof(hIN));

        close(hIn);

end; { ReadPortList }

{ ---------------------------------------------------------------------------- }

Procedure DoEntry( var fs : char );

var szFrom, szTo, szProt, szService, szDate : String;
    wFrom, wTo           : Word;

Function PortSplit(var szIn: String): Word;

var       t   : Byte;
          err : Integer;
          w   : Word;
begin
     t := Pos(':', szIn);
     val(copy(szIn,t+1,255), w, err);
     PortSplit := w;
     szIn := copy(szIn, 1, t-1);
end;

begin
     for i := 1 to 3 do
     begin
          t := Pos(fs, szWork);
          if i = 2 then
               szDate := copy(szWork, 1, t-1);
          szWork := copy(szWork, t+1, 255);
     end;
     t := Pos(fs, szWork);
     szFrom := Copy(szWork, 1, t-1);
     szWork := copy(szWork, t+1, 255);
     t := Pos(fs, szWork);
     szTo := copy(szWork, 1, t-1);
     szProt:= copy(szWork,t+1,255);

     wFrom := PortSplit(szFrom);
     wTo   := PortSplit(szTo);

     szService := aPorts[wTo {$IFNDEF FPC} and MAXPORTS {$ENDIF}].desc;
     if szService = '' then
        szService := 'unknown service';
     inc(aPorts[wTo {$IFNDEF FPC} and MAXPORTS {$ENDIF}].count);

     if (szDate <> szDateOld) AND (Pos(FWINOUT+fs, szDate)=0) then
     begin
        writeln(#13#10,GuruHeadLine(szDate));
        szDateOld := szDate;
     end;
     write(szFrom:16, '  ',wFrom:5,' -> ', wTo:5, '  ');  { [1] }
     szOut := szService+' ('+szProt+')';
     first := true;
     while length(szOut) <> 0 do
     begin
      if first then Writeln(wrap(szOut,ln_wd-34))  { 34  is the length of [1]}
               else Writeln(StrOf(' ',34)+wrap(szOut,ln_wd-34));
      first := false;
     end;
end;

{ ---------------------------------------------------------------------------- }

Procedure DoTheLogFile(szLog: String);  { ZALog.txt }

begin { DoTheLogFile }

        assign(hIn, szLog);
        if ioresult <> 0 then
        begin
                writeln('Access to '+szLog+' denied, aborting!');
                EndProgram(1);
        end;
        if second then  { logfile separator }
          writeln(#13#10,'><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><',#13#10);
        writeln(GuruHeadLine('Logfile '+szLog));
        reset(hIn);

        repeat
               readln(hIn, szWork);
               if Pos(FWINOUT+#9, szWork) = 1 then DoEntry(Field_Separator[1])
               else
               if Pos(FWINOUT+',', szWork) = 1 then DoEntry(Field_Separator[2])
               else
               if Pos(FWINOUT+';', szWork) = 1 then DoEntry(Field_Separator[3]);

        until eof(hIN);
        close(hIn);
        writeln;
        second := true; { logfile separator }

end; { DoTheLogFile }

{ ---------------------------------------------------------------------------- }

Procedure Usage;

begin { Usage }
   writeln(GuruHeadLine('Usage'));
   writeln;
   writeln('-?          This short help.');
   writeln;
   writeln('-In         Lists incoming port scans (default)');
   writeln('-Out        Lists outgoing ports, usefull to see if you have a Trojan/Spyware');
   writeln('            lurking on your system. :-)');
   writeln;
   writeln('-Scan=Str   Scan for "Str," in the logs (Default -In: -Scan=FWIN)');
   writeln;
   writeln('-Mrl=#      Override parameter "MinReportLevel" (min. occurence > #)');
   writeln('-Mp=%       Override parameter "MinPerentage" (% occurence > mp)');
   writeln('-Debug      Debug mode, aborts before creating the stats');
   writeln;
   writeln('ENV var.    set ZA=-option[s] (Win32) or export ZA=-option[s] (Linux)');
   writeln;
   EndProgram(1);
end; { Usage }


{ ---------------------------------------------------------------------------- }

begin
        writeln('ZA-Log Converter '+sVer+' (c) 2000-2002 by ROSE SWE, http://come.to/rose_swe');
        writeln(StrOf(' ',length(sVer)+18)+'(c) 2001 by MaRiWa A.S.C., mariwa_asc@hotmail.com');
        writeln;
        crt2con;
        for wPort := 0 to MAXPORTS do
        begin
             aPorts[wPort].desc := '';
             aPorts[wPort].count := 0;
        end;
        second := false;  { logfile separator }
        szDateOld := 'n/a';
        lMinLevel := 0;

        new(oKZ, init);
        if oKZ^.IsOption('in') then             { incoming }
                FWINOUT := 'FWIN';
        if oKZ^.IsOption('out') then            { outgoing? -> trojan? sr by tw }
                FWINOUT := 'FWOUT';
        if oKZ^.IsOption('pe') then
                FWINOUT := 'PE';                { experimental }
        if oKZ^.IsOption('Scan') then
                FWINOUT := oKZ^.GetString('Scan');

        if oKZ^.IsOption('?') then
                usage;

        ReadPortList;                           { lMinLevel is set now }

        if oKZ^.IsOption('MRL') then
                lMinLevel := oKZ^.GetValue('MRL');
        if oKZ^.IsOption('MP') then
                rMinLevel := oKZ^.GetValueReal('MP');

        if oKZ^.IsOption('Debug') then
        begin
                writeln('FWINOUT = ', FWINOUT);
                writeln('MRL     = ', lMinLevel);
                writeln('MP      = ', rMinLevel:4:3);
                writeln('CmdLine = ', oKZ^.ParamS^);
                EndProgram(2);
        end;

        findfirst('ZAlog*.txt', AnyFile-Directory, sr);
        if DosError <> 0 then
        begin
                writeln(GuruHeadLine('ERROR'));
                writeln('I need at least one ZAlog*.txt file in the current directory!');
                writeln;
                writeln(ZA_RCS_ID[2]);
                EndProgram(1);
        end;

        while DosError = 0 do
        begin
                DoTheLogFile(sr.name);
                findnext(sr);
        end;

        lTotal := 0;
        for wPort :=0 to MAXPORTS do inc(lTotal, aPorts[wPort].count);

        if lTotal < 10 then     { avoid div 0 too }
        begin
                writeln(GuruHeadLine('ERROR'));
                writeln('Not enough data collected for a proper statistic, aborting!');
                EndProgram(4);
        end;

        assign(hIn, 'ZA_Stats.txt');
        if ioresult <> 0 then
        begin
                writeln(GuruHeadLine('ERROR'));
                writeln('Access to ZA_Stats.txt denied, aborting!');
                EndProgram(5);
        end;
        rewrite(hIn);

        writeln(hIn, '-=- Zone Alarm Port Scan Statistics ('+FWINOUT+') -=- '+lVer+ ' -=-'
        +#13#10+'-=- (c) by ROSE SWE & MaRiWa A.S.C., total scans = ',lTotal,' -=-');
        writeln(hIn, '  Count'#9'Percent',#9'  Port'#9'Description');

        for wPort :=0 to MAXPORTS do with aPorts[wPort] do
        begin
             if count>=lMinLevel then
             begin
                rPercent := count*100 / lTotal; { div instead / ?? rar }
                if rPercent > rMinLevel then
                   writeln(hIn, count:7, ' ',rPercent:7:2,#9, wPort:6,#9, desc);
             end;
        end;
        writeln(hIN);

        close(hIn);
        dispose(oKZ, done);
        EndProgram(0);
end.
