.code
;
; emulate -   (䠩 ଠ Portable Executable)
;
; on start :       ip - ਣ쭮 ᯮ 
;             codeloc - ᬥ饭    樨
;                mode - ० : 0=, 1-   ᨣ
;           file_type - ⨯ 䠩 : 0-COM, 1-EXE, 2-PE
;                          ন ⮫쪮 ⨯ 2
; on exit  :  - - - - -
;
 emulate        proc   file_type:dword, mode:dword, codeloc:dword, ip:dword
;
 emul_init:     pushad
                jmp     set_timer
;
 emulator_nfo           db 'EMULx007'            ;  
;
;  । 祭 ⠩ (  ᪠ Windows ( ᥪ㭤)), 
;  ᪠ . ⨬ ६ 樨 ᯮ ணࠬ
; ⠢ 3000 ᥪ㭤.  "temp+028" ࠭ 筮 ६ 樨
; ணࠬ  ᫥ 樨 믮  樨 㤥 ஢,
; 뫮   ਢ襭 ...
;
 set_timer:     call    GetTickCount
                add     eax,3000
                mov     dword ptr [temp+028],eax
;
;  樠樨 :
;   1) ࠭ 祭 ॣ஢ (. )
;   2) 樠 ⠩ (. )
;   3) 樠   ("ca_init")
;   4) 樠 䫠 "ࠦ" ("ill_mark")
;   5) ⠭ 祭 "㠫쭮 ⥪",  樨
;      饭 権  
;   6) ⠭ ࠬ஢ ।  楤: ip (6a) /codeloc (6b)
;
                call    ca_init                  ; * 3
                mov     dword ptr [ill_mark],0   ; * 4
;
                mov     esi,offset _stack+100000
                mov     dword ptr [regs+016],esi ; * 5
;
                mov     eax,ip                   ; * 6a
                mov     dword ptr [regs+0*4],eax ; - 砫쭮 祭 .
                                                 ;   ॣ = 窥 室
                mov     esi,codeloc              ; * 6b
;
;  । 樥 樨,  祭  㠫 ॣ஢,
; ᮤঠ ⠭ 祭 delta_value
;
 emulate_loop:  call    ca_fill_buf                
;
; "" 樨 䠩 㯠 UPX
;
                cmp     byte ptr [temp+020],1    ;  㯠 ⨫⮩ UPX ? ;)
                jnz     not_repescasb            ; 
;
;  襬 ⠯ ᯠ ᯮ塞 䠩 (㯠 ⨫⮩ UPX),
; ᫥ 樨 "repe scasb" 稭 樨,   
; 易⥫쭠.
; ய⨬    ३  ஢થ ᯠ ணࠬ.
;
                cmp     word ptr [esi],0aef2h    ; 諨  樨
                                                 ;               "repe scasb" ?
                jnz     not_repescasb            ;  
;
                inc     esi
                inc     esi                      ; ய⨬ "repe scasb"
                mov     ecx,30
 upx_srch_jmp:  cmp     word ptr [esi-1],0e961h  ; 饬 "jmp"  ஢ 
                jz      not_repescasb            ; ३  樨 室
                inc     esi
                loop    upx_srch_jmp
;
; ஢ઠ ० ࠡ  (0 - , 1 -  ஢ન 
; ᨣ)
;
 not_repescasb: mov     eax,mode
                or      eax,eax
                jnz     emulate_dasm             ; * ० 1
;
;    , ⢥饩    ᨣ 
; ⥪饩 樨.
;                                                  * ० 2
                push    file_type                ; - ⨯ 䠩
                push    offset vir_no            ; - ᬥ饭  
                push    esi                      ; - ⮯  ஢ન
                call    detect                   ; *  ᨣ
                or      eax,eax                  ; eax -  㦥
                                                 ;    ( = 0)
                jz      emulate_dasm             ; ᮢ  㦥,
                                                 ; த 
;
                mov     dword ptr [ill_mark],eax ; ᫨  㦥,
                                                 ; ⠭ 䫠  ४⨬
                jmp     emulate_ret              ;  樨
;
; ࠧ 樨   ᥬ
;
 emulate_dasm:  push    esi                      ; - ᬥ饭 樨
                call    disasm                   ; *  ᥬ
                cmp     eax,-1
                jz      emulate_ret     ; *  ⭠ ᥬ
;
; edx - ⨯ ⬠, 室  樨 樨
;       0 - 筮 ᪠  "࠭⨭"
;       1 - ॡ  樨 ᯮ
;
                or      edx,edx
                jnz     fullinst_emul            ;   ᯮ
;
; * * *  樨  ᯥ樠 ᫮
;
; 1) ७ᥬ   "instr_buf" 樨  樨 ⥪ 
;    ࠧ࠭ ᥬ஬  ࠧ ecx.
;
;     १ 稬  "instr_buf" ਬ୮:
;
;               mov     dword ptr [res_stack+1],esp
;               mov     esp,dword ptr [regs+016]
;           ... ࠧ࠭  ...
;               mov     dword ptr [regs+016],esp
; res_stack:    mov     esp, ?
;               ret
;
 prep_to_run:   mov     edi,offset instr_buf
                mov     ax,2589h
                stosw                           ; ७ᥬ "mov 4 ptr [?],esp"
;
                mov     eax,offset instr_buf    ; ⠥ ᬥ饭
                add     eax,ecx                 ; "res_stack+1" (. ) 
                add     eax,6+6+6+1
                stosd                           ; ७ᥬ "⮪" 樨
;
                mov     ax,258Bh
                stosw
                mov     eax,offset regs+016      ; ७ᥬ 
                stosd                            ; "mov esp,4 ptr [regs+16]"
;
                rep     movsb                    ; ७ᥬ ࠧ࠭
                                                 ; ᥬ஬ 
;
                mov     ax,2589h
                stosw
                mov     eax,offset regs+016      ; ७ᥬ 
                stosd                            ; "mov 4 ptr [regs+16],esp"
;
                mov     al,0bch
                stosb                            ; ७ᥬ 
                stosd                            ; "mov esp,?"
                mov     al,0c3h
                stosb                            ; ७ᥬ "ret"
;
; 2)  ࠧ࠭ 樨  ᯥ樠 ᫮ (࠭⨭)
;
;  祭 ॣ஢ ணࠬ-  ⥪
;
 run_instr:     pushad
;
;  祭 䫠 ணࠬ-  ⥪, ⥬ ७ᥬ
;  ॣ eax,     ६ "temp"
;
 save_orig_efl: pushfd
                mov     eax,dword ptr [esp]
                mov     dword ptr [temp],eax
                popfd
;
; 祭 䫠 㫨㥬  ७ᥬ  ६ "flags"  ॣ
; eax,     ⥪ ᯮ騩 ணࠬ-஬
;
 set_emul_efl:  pushfd
                mov     eax,dword ptr [flags]
                mov     dword ptr [esp],eax
;
; ⠭ 祭 ॣ஢ 㫨㥬   ६ "regs"
; 祭 esp  ⠭,   㥬 ᯮ 祭 䫠
; 㫨㥬 , ⥪ 㤥 ७ࠢ  ணࠬ "instr_buf"
;
                mov     eax,dword ptr [regs+000]
                mov     ecx,dword ptr [regs+004]
                mov     edx,dword ptr [regs+008]
                mov     ebx,dword ptr [regs+012]
                mov     ebp,dword ptr [regs+020]
                mov     esi,dword ptr [regs+024]
                mov     edi,dword ptr [regs+028]
;
;  "popfd" ⠭ 祭 䫠 㫨㥬 ,
; ஥  ࠭﫨 
;
                popfd
                call    instr_buf                ; ⨬  ᯮ
;
; ࠭  祭 ॣ஢ 㫨㥬   ६ "regs"
;
                mov     dword ptr [regs+000],eax
                mov     dword ptr [regs+004],ecx
                mov     dword ptr [regs+008],edx
                mov     dword ptr [regs+012],ebx
                mov     dword ptr [regs+020],ebp
                mov     dword ptr [regs+024],esi
                mov     dword ptr [regs+028],edi
;
;  祭 䫠 㫨㥬    ⥪, ⥬ ७ᥬ
;  ॣ eax  ࠭  ६ "flags"
;
 save_emul_efl: pushfd
                mov     eax,dword ptr [esp]
                mov     dword ptr [flags],eax
                popfd
;
; ⠭ 祭 䫠 ணࠬ-  ६ "temp"
;
 set_orig_efl:  pushfd
                mov     eax,dword ptr [temp]
                mov     dword ptr [esp],eax
                popfd
;
; ⠭ 祭 ॣ஢ ணࠬ-
;
                popad
                jmp     emulate_check
;
; * * *  権,  ॡ  樨 ᯮ
;
 fullinst_emul: push    esi
                pop     edi                   ; edi - ᬥ饭 樨
                add     esi,ecx               ;        ࠧࠫ
; 樨 ࠧ஬ 1 
 @one_byte:     cmp     cl,1
                jnz    @two_bytes
                cmp     byte ptr [edi],0AAh
                jz     @stos_bwd              ; " stosb "
                cmp     byte ptr [edi],0ACh
                jz     @lods_bwd              ; " lodsb "
                cmp     byte ptr [edi],0C3h
                jz     @found_ret             ; " ret "
                jmp     emulate_ret
; 樨 ࠧ஬ 2 
 @two_bytes:    cmp     cl,2
                jnz    @three_bytes
                cmp     byte ptr [edi],031h   ;
                jz     @found_spec            ; " xor dword ptr [ereg],ereg "
;
 @check_jmpb:   cmp     byte ptr [edi],070h   ; 樨:
                jc      emulate_ret           ; jo, jno, jb, jnb, je, jne,
                cmp     byte ptr [edi],07fh   ; jbe, ja, js, jns, jp, jnp,
                jna    @found_jmpb            ; jl, jnl, jle, jg
;
                cmp     byte ptr [edi],088h
                jc      emulate_ret
                cmp     byte ptr [edi],08Bh
                jna    @found_spec
;
 @check_loop:   cmp     byte ptr [edi],0E2h
                jz     @found_loop            ; " loop byte "
                cmp     byte ptr [edi],0EBh
                jz     @found_jmpb            ; " jmp byte "
                jmp     emulate_ret
; 樨 ࠧ஬ 3 
 @three_bytes:  cmp     cl,3
                jnz    @four_bytes
                cmp     byte ptr [edi],030h
                jz     @found_spec            ; " xor byte ptr [eregA+eregB],reg "
                cmp     byte ptr [edi],031h
                jz     @found_spec            ; " xor dword ptr [eregA+eregB],ereg "
                cmp     byte ptr [edi],080h
                jz     @found_spec            ; " cmp byte ptr [ereg],byte "
                cmp     byte ptr [edi],08Ah
                jz     @found_spec            ; " mov [reg],byte ptr [ereg+byte] "
                cmp     byte ptr [edi],08Bh
                jz     @found_spec            ; " mov [ereg],dword ptr [ereg+byte] "
                cmp     byte ptr [edi],08Fh
                jz     @found_spec            ; " pop dword ptr [eregA+eregB] "
                cmp     byte ptr [edi],0FFh   ;
                jz     @found_spec            ; " push dword ptr [eregA+eregB] "
                jmp     emulate_ret
; 樨 ࠧ஬ 4 
 @four_bytes:   cmp     cl,4
                jnz    @five_bytes
                cmp     byte ptr [edi],083h
                jz     @found_spec            ; " add byte ptr [esp+byte],byte "
                                              ; " xor byte ptr [esp+byte],byte "
                jmp     emulate_ret
; 樨 ࠧ஬ 5 
 @five_bytes:   cmp     cl,5
                jnz    @six_bytes
                cmp     byte ptr [edi],066h
                jz     @found_spec            ; " xor word ptr [ereg],word "
                cmp     byte ptr [edi],0E8h
                jz     @found_call            ; " call dword "
                cmp     byte ptr [edi],0E9h
                jz     @found_jmp             ; " jmp dword "
                jmp     emulate_ret
; 樨 ࠧ஬ 6 
 @six_bytes:    cmp     cl,6
                jnz    @seven_bytes
                cmp     byte ptr [edi],00Fh
                jnz    @six_bytes_2
;
 @check_jmpd:   cmp     byte ptr [edi+1],080h ; 樨:
                jc      emulate_ret           ; jo, jno, jb, jnb, je, jne,
                cmp     byte ptr [edi+1],08fh ; jbe, ja, js, jns, jp, jnp,
                jna    @found_jmpd            ; jl, jnl, jle, jg
;
 @six_bytes_2:  cmp     byte ptr [edi],066h
                jz     @found_spec            ; " xor  word ptr [ebp],word "
                cmp     byte ptr [edi],081h
                jz     @found_spec            ; " xor  dword ptr [ereg], dword "
                cmp     byte ptr [edi],0FEh
                jz     @found_spec            ; " dec  byte ptr [ereg+dword] "
                cmp     byte ptr [edi],0FFh
                jz     @found_spec            ; " call [ereg+dword] "
                                              ; " dec  dword ptr [ereg+dword] "
                jmp     emulate_ret
; 樨 ࠧ஬ 7 
 @seven_bytes:  cmp     cl,7
                jnz    @eight_bytes
                cmp     byte ptr [edi],080h
                jz     @found_spec            ; " xor byte ptr [ereg+dword],byte "
                cmp     byte ptr [edi],081h
                jz     @found_spec            ; " xor dword ptr [esp],dword "
                cmp     byte ptr [edi],0FFh
                jz     @found_spec            ; " dec  dword ptr [esp+dword] "
                                              ; " dec  dword ptr [erega+eregb+dword] "
                jmp     emulate_ret
; 樨 ࠧ஬ 8 
 @eight_bytes:  cmp     cl,8
                jnz    @ten_bytes
                cmp     byte ptr [edi],080h
                jz     @found_spec            ; " xor byte ptr [esp+dword],byte "
                jmp     emulate_ret
; 樨 ࠧ஬ 10 
 @ten_bytes:    cmp     cl,10
                jnz     emulate_ret
                cmp     byte ptr [edi],081h
                jz     @found_spec            ; " add dword ptr [esp+dword],dword "
                                              ; " xor dword ptr [esp+dword],dword "
                jmp     emulate_ret
; 樨 ࠧ஬ 1 
;
; * * *  ᯮ 樨 "stosb/w/d"
;
 @stos_bwd:     pushad
                mov     esi,dword ptr [regs+7*4]
                cmp     byte ptr [007+_regs],0
                jnz     @stos_bwd_002
                sub     esi,ip
                add     esi,codeloc
;
 @stos_bwd_001: mov     ebx,esi
                call    test_off
                jnc     @stos_bwd_002
                popad
                jmp     emulate_ret
;
 @stos_bwd_002: mov     ah,0c3h
                mov     al,byte ptr [edi]
                mov     word ptr [instr_buf],ax
;
                mov     eax,dword ptr [regs+0*4]
                mov     edi,dword ptr [regs+7*4]
                call    instr_buf
                popad
;
                sub     eax,eax
                mov     al,byte ptr [edi]
                sub     al,0A9h
                add     dword ptr [regs+7*4],eax
                jmp     emulate_check
;
; * * *  ᯮ 樨 "lodsb/w/d"
;
 @lods_bwd:     pushad
                mov     esi,dword ptr [regs+6*4]
                cmp     byte ptr [006+_regs],0
                jnz     @lods_bwd_002
                sub     esi,ip
                add     esi,codeloc
;
 @lods_bwd_001: mov     ebx,esi
                call    test_off
                jnc     @lods_bwd_002
                popad
                jmp     emulate_ret
;
 @lods_bwd_002: mov     ah,0c3h
                mov     al,byte ptr [edi]
                mov     word ptr [instr_buf],ax
;
                mov     eax,dword ptr [regs+0*4]
                call    instr_buf
                mov     dword ptr [regs+0*4],eax
                popad
;
                sub     eax,eax
                mov     al,byte ptr [edi]
                sub     al,0ABh
                add     dword ptr [regs+6*4],eax
                jmp     emulate_check
;
; * * *  ᯮ 樨 "ret"
;
; ஢ ᯮ 樨 祭 :
;
; 1) 室   ᫮  ⥪ 㫨㥬 
;    ( ᬥ饭   ᫮ ᮤন  "regs+16" )
; 2)  ᫮ 㤥  㪠⥫  ᬥ饭 ࠧࠥ ஬
;    樨 (祭 ॣ esi)
; 3)   ⥪ 㫨㥬 , ⮥ 祭
;    add dword ptr [regs+16],4
;
 @found_ret:    mov     esi,dword ptr [regs+016]
                lodsd
                add     dword ptr [regs+016],4
                xchg    esi,eax
                jmp     emulate_check
; 樨 ࠧ஬ 2 
; * * *  ᯮ "᫮"  "᫮" 室:
;
;       jo, jno, jb, jnb, je, jne, jbe, ja, js,
;       jns, jp, jnp, jl, jnl, jle, jg & jmp byte
;
; 1) ७ᥬ   "instr_buf" 樨  樨 ᯮ 室.
;     १ 稬  "instr_buf" :
;
;                 ()᫮ 室  ⪥ _label
;               inc     eax
; _label:       ret
;
; 2) ⠭ 祭 䫠 㫨㥬  ( ६ "flags")
;    㫨 ॣ eax
; 3) ⨬  ᯮ ᮤন "instr_buf"
;     ⮬ 砥, ᫨ 室 믮, 祭 eax 㤥 ࠢ 
;
;  ᫨ 室 믮, ᮮ⢥⢥ 室  ᬥ饭,
; ᫥㥬  (祭 ॣ esi).  ⮣ ᬮਬ ன 
; 樨,  ᮤন   ᫥  ᬥ饭.
;
 @found_jmpb:   mov     al,byte ptr [edi]
                call    test_jmpb
                or      eax,eax
                jnz     emulate_check
;
 jmpb_goto:     cmp     byte ptr [edi+1],07fh
                jna     jmpb_down
 jmpb_up:       sub     al,byte ptr [edi+1]
                sub     esi,eax
                jmp     emulate_check
 jmpb_down:     mov     al,byte ptr [edi+1]
                add     esi,eax
                jmp     emulate_check                 
;
 test_jmpb:     mov     ah,1
                push    edi
                mov     edi,offset instr_buf
                stosw
                mov     ax,0c340h
                stosw
                pop     edi
;
 jmp_ser_eflag: pushfd
                pushfd
                mov     eax,dword ptr [flags]
                mov     dword ptr [esp],eax
                sub     eax,eax
                popfd
                call    instr_buf
                popfd
 _ret                   db 0c3h                        
;
;
; * * *  ᯮ 権,   ᬥ饭
;
;   "᫮" ࠧ   ,    ,
;   ஡.
;
; ࢠ  :
;
;  樨,    ᬥ饭, ॡ  樨
; ᯮ, ⠪  ᫥㥬   ७ᥭ  ⨢  
; ᯮ      (⭮⥫쭮   
;   㤥  ணࠬ ()).
; ⥫쭮,  ᯮ 権 ⠪ த, 㦭 
; ᬥ饭,  ஬ ணࠬ 頥  ,  .  ⮣
; ᥬ ⥫쭮 ࠧࠥ 樨    "dregs"
; ᯥ樠묨 ࠬࠬ 樨,  室,   ࠢ쭮
; 樨.
;
; ᥩ  "dregs" ᮤন ਬ୮ ᫥騥 :
;  dregs + 000 : ⢮ ॣ஢ ᯮ  樨
;  dregs + 004 :  ॣ 1
;  dregs + 008 :  ॣ 2
;  dregs + n*4 :  ॣ n
;
;   室 । 㬬 祭 i ॣ஢ ᯮ 
; 樨  㪠 ᬥ饭,  ஬ 頥  
; ।     .  㤥 룫拉 ਬ୮
; ⠪:
;
; for (i=1,x=0; i<=- ॣ஢; i++)
; {
;  a = dregs[i*4] * 4;
;  x+= [regs+a];
; }
;
; :    a - ६ ६
;         i - ᯮ  稪
;         x -  ⮩ ᠬ 㬬,  室 㧭
;      regs -   ஬ ࠭ 祭 ॣ஢ 㫨㥬 ணࠬ
;     dregs -  ᠭ 
;
 @found_spec:   push    ebx esi ecx ebp
                sub     ebp,ebp
                sub     ebx,ebx
                mov     esi,offset dregs
                lodsd
                xchg    eax,ecx
 count_sum_lp:  lodsd
                cmp     byte ptr [eax+_regs],0 ; ॣ ᮤন ᫥ delta value?
                jz      count_sum
                inc     ebp
 count_sum:     call    mul_4
                add     ebx,dword ptr [regs+eax]
                loop    count_sum_lp
;
;   :
;
;   ࠧ   ⮯    ⥪騬. 祭
; 祭   ebx.
;  ⮬ 砥, ᫨   ॣ஢, ᯮ  ࠧࠥ 樨
; 㤥 ᮤঠ ⠭ delta value (. "\det\ca_ip.inc"),
; 室  ன   ⯠.
;
;  - ⨢, "㬥" । 믮﫠  楤
; ,  ᫥㥬     ॣ஢ ᮤন delta value.
; ᫨  室  ᬥ饭 ᯮ짮 ॣ,  ᮤঠ delta
; value,  祭 ॣ ebp > 0,   ࠢ .
;
                or      ebp,ebp
                pop     ebp
                jnz     spec_emul_ip                
                sub     ebx,ip
                add     ebx,codeloc
;
 spec_emul_ip:  sub     eax,eax
                pop     ecx
                push    edi
                pop     esi
;
;   :
;
;   , ॡ । ⢨  樨  믮,
;  ⢨ ந   樨  権, 
;  㠫.   ࠧ ⨯ 樨   
; 樨.
;
 spec_emul_lp:  mov     al,byte ptr [edi]
                cmp     al,030h
                jz      spec_emul_001
                cmp     al,031h
                jz      spec_emul_001x
                cmp     al,066h
                jz      spec_emul_002
                cmp     al,080h
                jz      spec_emul_003
                cmp     al,081h
                jz      spec_emul_004
                cmp     al,088h
                jz      spec_emul_005
                cmp     al,089h
                jz      spec_emul_006
                cmp     al,08Ah
                jz      spec_emul_007
                cmp     al,08Bh
                jz      spec_emul_008
                cmp     al,08Fh
                jz      spec_emul_009
                cmp     al,0FEh
                jz      spec_emul_010
                cmp     al,0FFh
                jz      spec_emul_011
                jmp     spec_emul_ret
;
;
; xor byte ptr [eregA],[reg]                030HEX, 00regrgA
; xor byte ptr [esp],[reg]                  030HEX, 00REGesp, 00espESP
; xor byte ptr [eregA+eregB],reg            030HEX, 00reg100, 00rgArgB
;
 spec_emul_001: mov     al,byte ptr [edi+1]
                cmp     cl,2
                jnz     spec_emul_001a
                call    two_regs
                jmp     spec_emul_001c
 spec_emul_001a:shr     al,3
 spec_emul_001c:call    mul_4
                mov     edx,dword ptr [regs+eax]
                call    test_off
                jc      semul_err_ret
;
                xor     byte ptr [ebx],dl
                jmp     spec_emul_ret
;
;
; xor dword ptr [eregA],[eregB]             031HEX, 00rgBrgA
; xor dword ptr [esp],[ereg]                031HEX, 00REGesp, 00espESP
; xor dword ptr [eregA+eregB],ereg          031HEX, 00reg100, 00rgArgB
;
 spec_emul_001x:mov     al,byte ptr [edi+1]
                cmp     cl,2
                jnz     spec_emul_001b
                call    two_regs
                jmp     spec_emul_001d
 spec_emul_001b:shr     al,3
 spec_emul_001d:call    mul_4
                mov     edx,dword ptr [regs+eax]
                call    test_off
                jc      semul_err_ret
;
                xor     dword ptr [ebx],edx
                jmp     spec_emul_ret
;
;
; xor word ptr [ereg],word  066HEX, 081HEX,         , word         = 5 bytes
; xor word ptr  [ebp],word  066HEX, 081HEX,   075HEX, 000HEX, WORD = 6 bytes
;
 spec_emul_002: add     esi,ecx
                dec     esi
                dec     esi
                lodsw
                call    test_off
                jc      semul_err_ret
;
                xor     word ptr [ebx],ax
                jmp     spec_emul_ret
;
;
; cmp byte ptr [ereg],byte                  080HEX, 111reg, byte
; xor byte ptr [ereg+dword],byte            080HEX, 10110reg,  dword, byte
; xor byte ptr [esp+dword],byte             080HEX, 10110esp, 024HEX, dword, byte
;
 spec_emul_003: cmp     cl,3
                jz      spec_emul_003b 
                sub     cl,5
                add     ebx,dword ptr [esi+2]
                mov     al,byte ptr [esi+ecx+4]
                xor     byte ptr [ebx],al
                jmp     spec_emul_ret
 spec_emul_003b:push    ecx esi edi
                xchg    esi,edi
                mov     edi,offset instr_buf
                cld
                rep     movsb
                mov     al,0c3h
                stosb
                mov     byte ptr [instr_buf+1],03bh
                pop     edi esi ecx
;
 cmp_set_eflag: pushfd
                pushfd
                mov     eax,dword ptr [flags]
                mov     dword ptr [esp],eax
                popfd
                call    instr_buf
                pushfd
                mov     eax,dword ptr [esp]
                mov     dword ptr [flags],eax
                popfd
                popfd
                jmp     spec_emul_ret
;
;
; xor dword ptr [ereg],dword                081HEX, 00110reg, dword = 6 bytes
; xor dword ptr [esp],dword                 081HEX, 00110100, 024HEX, dword = 7 bytes
; add dword ptr [ereg+dword],dword          081HEX, 10000reg, dword, dword = 10 bytes
; add dword ptr [esp+dword],dword           081HEX, 10000100, 024HEX, dword, dword = 11 bytes
; xor dword ptr [ereg+dword],dword          081HEX, 10110reg, dword, dword = 10 bytes
; xor dword ptr [esp+dword],dword           081HEX, 10110100, 024HEX, dword = 11 bytes
;
 spec_emul_004: mov     eax,dword ptr [esi+ecx-4]
                cmp     byte ptr [esi],10000000b
                jae     spec_emul_004b
;
                call    test_off
                jc      semul_err_ret
                xor     dword ptr [ebx],eax
                jmp     spec_emul_ret
;
 spec_emul_004b:add     ebx,dword ptr [esi+ecx-8]
                call    test_off
                jc      semul_err_ret
;
                push    eax edi
                mov     al,byte ptr [edi+1]
                sub     al,80h
                xor     al,byte ptr [dregs+004]
                inc     al
                mov     ah,03h
                mov     edi,offset instr_buf
                stosw
                mov     al,0c3h
                stosb
                pop     edi eax
                call    instr_buf
                jmp     spec_emul_ret
;
;
; mov byte ptr [ereg],[reg]                 088HEX,00regErg
;
 spec_emul_005: mov     al,byte ptr [edi+1]
                call    reg8_pos
                mov     dl,byte ptr [regs+eax]
                call    test_off
                jc      semul_err_ret
;
                mov     byte ptr [ebx],dl
                jmp     spec_emul_ret
;
;
; mov dword ptr [ergA],[ergB]               089HEX,00rgBrgA
;
 spec_emul_006: mov     al,byte ptr [edi+1]
                call    two_regs
                call    mul_4
                mov     edx,dword ptr [regs+eax]
                call    test_off
                jc      semul_err_ret
;
                mov     dword ptr [ebx],edx
                jmp     spec_emul_ret
;
;
; mov [reg],byte ptr [ereg]                 08AHEX, 00regErg
; mov [reg],byte ptr [esp]                  08AHEX, 00regESP, 00espESP
; mov [reg],byte ptr [ebp]                  08AHEX, 01regEBP, 00000000
; mov [reg],byte ptr [ereg+byte]            08AHEX, 01regErg, byte
; mov [reg],byte ptr [esp+byte]             08AHEX, 01regESP, 00espESP, byte
;
 spec_emul_007: mov     al,byte ptr [esi+1]
                cmp     al,01000000b
                jc      spec_emul_007b
                xor     al,01000000b
                sub     edx,edx
                mov     dl,byte ptr [esi+ecx-1]
                add     ebx,edx
;
 spec_emul_007b:call    reg8_pos
                call    test_off
                jc      semul_err_ret
                mov     dl,byte ptr [ebx]
                mov     byte ptr [regs+eax],dl
                jmp     spec_emul_ret
;
;
; mov [eregA],dword ptr [eregB]             08BHEX, 00rgArgB
; mov [ereg],dword ptr [esp]                08BHEX, 00regESP, 00espESP
; mov [ereg],dword ptr [ebp]                08BHEX, 01regEBP, 00000000
; mov [eregA],dword ptr [eregB+byte]        08BHEX, 01rgArgB, byte
; mov [ereg],dword ptr [esp+byte]           08BHEX, 01regESP, 00espESP, byte
;
;   ᯮ  ᫥ 権   ᮢ
; , ⥬,  ࠧ  "spec_emul_007".
;
 spec_emul_008: mov     al,byte ptr [esi+1]
                cmp     al,01000000b
                jc      spec_emul_008b
                xor     al,01000000b
                sub     edx,edx
                mov     dl,byte ptr [esi+ecx-1]
                add     ebx,edx
;
 spec_emul_008b:call    two_regs
                call    mul_4
                call    test_off
                jc      semul_err_ret
;
                mov     edx,dword ptr [ebx]
                mov     dword ptr [regs+eax],edx
                jmp     spec_emul_ret
;
;
; pop dword ptr [eregA+eregB]               08FHEX, 00000100, 00rgBrgA
;
 spec_emul_009:
                call    test_off
                jc      semul_err_ret
;
                call    get_from_vstack
                mov     dword ptr [ebx],eax
                jmp     spec_emul_ret
;
;
; dec  dword ptr [ereg+dword]               0FEHEX, 10001reg,   dword
; dec  dword ptr [esp+dword]                0FEHEX, 10001100,  024HEX, dword
;
 spec_emul_010: lodsw
                cmp     ah,10001000b
                jc      spec_emul_ret
                cmp     ah,10001111b
                ja      spec_emul_ret
;
                add     ebx,dword ptr [esi-2+ecx-4]
                call    test_off
                jc      semul_err_ret
                dec     byte ptr [ebx]
                jmp     spec_emul_ret
;
;
; push dword ptr [eregA+eregB]              0FFHEX, 00110100, 00rgBrgA
; dec  dword ptr [ereg+dword]               0FFHEX, 10001reg, dword
; dec  dword ptr [esp+dword]                0FFHEX, 10001100,   024HEX, dword
; dec  dword ptr [eregA+eregB+dword]        0FFHEX, 10001100, 00rgArgB, dword
; call [ereg+dword]                         0FFHEX, 10010reg, dword
;
 spec_emul_011: lodsb
                lodsb
                cmp     al,00110100b
                jz      spec_emul_011a
;
                add     ebx,dword ptr [esi-2+ecx-4]
;
                cmp     al,10001000b
                jc      spec_emul_ret
                cmp     al,10001111b
                jna     spec_emul_011b
;
                cmp     al,10010000b
                jc      spec_emul_ret
                cmp     al,10010111b
                jna     spec_emul_011c
                jmp     spec_emul_ret
;
 spec_emul_011a:call    test_off
                jc      semul_err_ret
;
                mov     eax,dword ptr [ebx]
                call    put_to_vstack
                jmp     spec_emul_ret
;
 spec_emul_011b:
                call    test_off
                jc      semul_err_ret
                dec     dword ptr [ebx]
                jmp     spec_emul_ret
;
 spec_emul_011c:push    eax edi
                mov     eax,esi
                sub     dword ptr [regs+016],4
                mov     edi,dword ptr [regs+016]
                stosd
                pop     edi eax
                call    test_off
                jc      semul_err_ret
                mov     esi,dword ptr [ebx]
;
 spec_emul_ret: pop     esi ebx
                jmp     emulate_check
 semul_err_ret: pop     esi ebx
                jmp     emulate_ret
;
;
; * * *  ᯮ 樨 "loop byte"
;
; 1) 室 㬥 祭 㥫쭮 ॣ "ecx" (regs+004)  1
; 2) ᫨ 祭 祭 ॣ 㤥 ࠢ 0, 室  ᬥ饭
;      ஬ ᮤঠ  樨
;
 @found_loop:   dec     dword ptr [regs+004]   ; 㬥訬 祭 ॣ
                cmp     dword ptr [regs+004],0 ; ᫨ "ecx" 㫨㥬 
                jz      emulate_check          ; ࠢ 0, 멤  横
                sub     esi,ecx                ;  ⠥ ᬥ饭
                sub     esi,eax                ; 砫 横
                jmp     emulate_check          ; ३  ᫥饩 㪨
; 樨 ࠧ஬ 5 
;
; * * *  ᯮ 権: call dword
;                                       jmp  dword
;
;  室  ᬥ饭 (祭 esi) 樨,  㤥
; ᫥饩 ᯮ ஬.
;   砥 ᫨  ࠧࠥ "call", 室 ࠭  㠫쭮 ⥪
; ᬥ饭 樨 ᫥饩 אַ  "call"'.
;
 @found_call:   push    eax edi
                mov     eax,esi
                sub     dword ptr [regs+016],4
                mov     edi,dword ptr [regs+016]
                stosd
                pop     edi eax
;
 @found_jmp:    sub     eax,eax
                cmp     dword ptr [edi+ecx-4],7fffffffh
                ja      jmp_up
 jmp_down:      add     esi,dword ptr [edi+ecx-4] ;  esi
                jmp     jmp_chk_type
 jmp_up:        sub     eax,dword ptr [edi+ecx-4]
                sub     esi,eax                   ;  esi
;
;  ᫨ 㫨㥬 䠩 ଠ PE    㯠 UPX,  室
; ⪮४஢ ᬥ饭,  砩 ᫨  ᮢ襭 室  
; ᥪ樨  .
;
 jmp_chk_type:  mov     eax,file_type
                cmp     al,2
                jnz     emulate_check
;
                cmp     byte ptr [temp+020],0
                jnz     emulate_check            ; 䠩 㯠 UPX ?
;
                sub     esi,codeloc
                add     esi,ip
                push    esi
                call    real_off    ; * ४㥬 ᬥ饭
                mov     ip,esi      ; *  ਣ쭮   
                mov     codeloc,eax ; *          ⭮⥫쭮 ⨢᭮ 
                xchg    esi,eax
                jmp     emulate_check
; 樨 ࠧ஬ 6 
;
; * * *  ᯮ "᫮"  "᫮" 室:
;
; jo, jno, jb, jnb, je, jne, jbe, ja, js, jns, jp, jnp, jl, jnl, jle, jg
;
 @found_jmpd:   mov     al,byte ptr [edi+1]
                sub     al,10h
                call    test_jmpb
                or      eax,eax
                jz      @found_jmp
;
 emulate_check: call    ca_check_buf
                call    GetTickCount             ; ᫨ 뫮 ਢ襭 .
                cmp     eax,dword ptr [temp+028] ; ६, ⢥ 
                jc      emulate_loop             ;  ணࠬ, 멤

 emulate_ret:   mov     dword ptr [emul_stop],esi ;  ᬥ饭,  ஬
                                                  ; ⠭ 
                popad
                ret
 endp
;
; ⠥ 32- ⭮ ᫮  "㠫쭮" ⥪  ॣ eax
;
 get_from_vstack        proc
;
                push    edi
                mov     esi,dword ptr [regs+016]
                lodsd
                add     dword ptr [regs+016],4
                pop     esi
                ret
 endp
;
;  32- ⭮ ᫮  ॣ eax  "㠫" ⥪
;
 put_to_vstack  proc
;
                push    edi
                sub     dword ptr [regs+016],4
                mov     edi,dword ptr [regs+016]
                stosd
                pop     esi
                ret
 endp
;
; reg8_pos - । ᬥ饭 8- ⭮ ॣ ( ண 㪠
;             ॣ al) ⭮⥫쭮 ⠡ "regs"
;
; on start :  al -  8- ⭮ ॣ
; on exit  : eax - ᬥ饭,  祭  ॣ ⭮⥫쭮 ⠡ "regs"
;
 reg8_pos       proc
;
                push    ecx edx
                sub     ecx,ecx
                call    two_regs
                cmp     al,4
                jc      reg8_low
                sub     al,4
                inc     ecx
 reg8_low:      call    mul_4
                add     eax,ecx
                pop     edx ecx
                ret
 endp
;
; test_off - ஢ઠ "⨬" ᬥ饭 㪠  ॣ ebx
;
;   ᯮ 権,    ᬥ饭,  祭
; 让  訡   "" ᬥ饭.
;    ᫥⢨:
;
; - 訡  ࠡ⪨  ,  ய⨫ 楤
;    delta value     ᮡ .
; - ࠢ쭮 樨 ⪠   樨.
; -  १ । (ࠧࠡ稪) 訡  ணࠬ.
;
;   砥 ᫨   ᪮쪮   ⢥ত ୮, 㤥 
;    ⥩ ⨢   ,  ᯮ
; ணࠬ  ࠧ 楫  "ࠡ"    ⮫쪮 ⨢, 
;    ᫥㥬 ணࠬ. ⮬   ᠭ
; ⨢.
;
;  ᫥㥬 ணࠬ  짮 묨 ⮫쪮  "⨢᭮
; ",  ⮨   "६": "junk"  "buffer".  
;  ᯮ짮 "㠫 ⥪" (६ "_stack").
;
; on start : ebx    - ᬥ饭
; on exit  : cf = 0 - ଠ쭮 ᬥ饭
;            cf = 1 - ⨬ ᬥ饭
;
;
 test_off       proc
;
                cmp     ebx,offset junk
                jc      test_off_ret
                cmp     ebx,offset ((_stack + (100000 * 2) )-4)
                ja      test_off_ret
                clc
                ret
 test_off_ret:  stc
                ret
 endp
;
; eax = eax * 4
; ࢮ砫쭮 祭 ॣ஢ ecx, edx ࠭
;
 mul_4          proc
;
                push    ecx edx
                sub     edx,edx
                mov     dl,4
                mul     edx
                pop     edx ecx
                ret
 endp
;
