#############################################################################
# (g)awk script to accumulate RHBVS/VIRSCAN PLUS log files
# (c) 1998-2024 by ROSE SWE, rose_swe@hotmail.com
# $Id: rhbvscum.awk,v 1.22 2023/12/30 11:30:35 ralph Exp $
# LF (UNIX), UTF-8 formatting
#############################################################################
# 25.12.98 - 1.00 - ROSE SWE, Ralph Roth (rar) - initial creation
# 25.12.98 - 1.01 - rar, added sum + percentage
# 29.12.98 - 1.02 - rar, changed szName handling
# 30.12.98 - 1.10 - rar, added CHANNELS.AWK from RIMC project
# 09.01.99 - 1.11 - rar, added detection of date, option -nd
# 05.03.99 - 1.12 - rar, fixed the "started" bug
# 27.05.99 - 1.14 - rar, ITW stats added
# 22.10.12 - 1.17 - rar, cleanup
#############################################################################
# usage awk -f rhbvscum.awk rhbvs.log | rsort -u > rhbvs.stat
# usage awk -f rhbvscum.awk virscan.log | rsort -u > virscan.stat
#
# Options:   -nh for "no header"
#            -nd for "don't print at summary the creation date"
#
#############################################################################

BEGIN { rimc   = 0;
        sum    = 0;
        difftypes = 0;
        szDate = "";
        ##### CONSTANTS ############
        szMalware = "Misc. Malware";
        szTrojans = "Misc. Trojans";
        szMirc    = "Misc. Mirc Scripts";
	FS=" ";	# ws
      }

##################### cumulate infections ########################
/^.:\\/ { if ($2 != "")
          {
                szName = $2;#" "$3" "$4;
                a[ szName ]++;
                rimc ++;
          }
        }

##################### cumulates IRC channels ######################
/^#/    { a[ $1 ] ++;  }

/started/ { if ($2 == "Scan") { szDate = $5 " at " $7; };
        }
/ROSE SWE/ { if ($10 == "Version") { szVersion = "using RHBVS " $11; }
        }

# /Scan/  { }	# used by?

############################################################################

{
        # main
        # do nothing (yet)
}

############################################################################

END {

     for (i in ARGV) {
        if (ARGV[i] == "-nh") rimc = 0;
        if (ARGV[i] == "-nd") szDate = "";
        if (ARGV[i] == "?") {
                printf "RHBVSCUM: Usage:  %s [options] <infile|stdin>\n\n", ARGV[0];
                print  "Options:  -?, -nh {no header}, -nd {no date}, see rhbvscum.awk for help!\n";
                exit;
        }
     }

     if (rimc > 0) {
        print "---=[ Cumulated Statistics ]=------------------------------#-------%----";
     }

     for (i in a) {
        sum += a[i];
        if  (a[i] > 0) difftypes++;
     }  # 100.0 %
     difftypes++;
     nSchwelle = int(sum/difftypes)+1;

     if (sum > 500) nSchwelle++;
     if (sum > 1500) nSchwelle++;
     if (nSchwelle > 30) nSchwelle += 5;
     if (nSchwelle > 40) nSchwelle += 5;

     for (i in a) { printf " %-50s\t%4d\t%5.2f \n", i, a[i], a[i] * 100.0 /sum; };

     if (rimc > 0) {
        print "------------------------------------------------------------------------";
        printf "Total infections                                      %6d   100.00\n", sum;
        printf "Total different types of malware                      %6d\n", difftypes;
        printf "Minimum occurrence to be included into statistic      %6d\n", nSchwelle;

        if (szDate != "") {
           print "------------------------------------------------------------------------";
           printf ("This statistic was created %s", szDate);
           if (szVersion != "") printf(", %s", szVersion);
           printf "\n";
           }
       print "\n";

        for (i in a)
        {
                if (a[i] > nSchwelle) hot[i]+= a[i]
                else
                 if (match(i, "Mirc") > 0) hot[szMirc] += a[i]
                else
                 if (match(i, "Trojan") > 0) hot[szTrojans] += a[i]
                else
                 hot[szMalware] += a[i];
        }
        for (i in hot)
        {       # DIF = Data Interchange Format - Excel :(
                print i "\t" hot[i] > "rimchotlist.dif";
                print "    " i > "itw-list.txt";
        }
     }

     # for (i in ARGV) print i, ARGV[i];
}
