#!/bin/sh
#
# Control script for Postfix RAV AntiVirus filter

PREFIX="/usr/local"
DATA_PATH="/var/rav"
SCRIPT_NAME="${PREFIX}/etc/rc.d/rpostfix.sh"
DAEMON_PATH="${PREFIX}/bin"
DAEMON_NAME="ravpostfix"
DAEMON_ARGS=" --server_port 10025 --client_port 10026"
DAEMON="${DAEMON_PATH}/${DAEMON_NAME}"
PIDFILE="${DATA_PATH}/run/${DAEMON_NAME}.pid"

RETVAL=0

start() {
	# Start daemon.
	echo "Starting ${DAEMON_NAME} ..."
	${DAEMON} ${DAEMON_ARGS}
	RETVAL=$?
	echo ""
}

stop() {
	# Stop daemon.
	if [ -f ${PIDFILE} ]; then
	    echo "Shutting down ${DAEMON_NAME} ..."
	    kill `cat ${PIDFILE}`
	else
	    echo "${DAEMON_NAME} is stopped (pid file does not exist)."
	fi
	RETVAL=$?
	echo ""
}

reload() {
	#Get pid of process
	if [ -f ${PIDFILE} ]; then
	    echo "Sending -HUP signal to ${DAEMON_NAME} ..."
	    kill -HUP `cat ${PIDFILE}`
	else
	    echo "${DAEMON_NAME} is stopped (pid file does not exist)."
	fi
	RETVAL=$?
	echo
}

# See how we were called.
case "$1" in
  start)
	start
	;;
  stop)
	stop
	;;
  restart)
	stop
	start
	RETVAL=$?
	;;
  reload)
	reload
	;;
  status)
	if [ -f ${PIDFILE} ]; then
	    echo "${DAEMON_NAME} is running with pid: `cat ${PIDFILE}`"
	else
	    echo "${DAEMON_NAME} is stopped."
	fi
	RETVAL=$?
	;;
  *)
	echo "Usage: ${SCRIPT_NAME} {start|stop|restart|status}"
	exit 1
esac

exit ${RETVAL}

