#!/bin/sh
# RAV AntiVirus for Mailservers uninstall script.
# Author: RAV Development Team <ravteam@ravantivirus.com>
# http://www.ravantivirus.com

main()
{
RAV_PRODUCTS=0;
for i in `pkg_info -I -a | grep -e ^rav | cut -d" " -f1`; do
	RAV_PRODUCTS=$(($RAV_PRODUCTS+1));
done

if [ $RAV_PRODUCTS -eq 0 ];then
 echo -e "No RAV packages have been found on your computer, exiting!\n"
 exit 1
fi
clear
welcome
interface
echo "Press ENTER to continue..."
read x
main
}

welcome()
{
cat << EOF

				Welcome 

 This script will help you uninstall the RAV AntiVirus for Mailservers product.
 Please note that you must have root privileges in order to uninstall 
 these packages.

EOF


}

interface()
{
cat << EOF

Please select the package(s) that you would like to uninstall 
(please also check the dependencies):

 0. exit without doing anything
EOF

j=1
for i in `pkg_info -I -a | grep ^rav | cut -d" " -f1`; do
  echo -e " $j. $i"
  j=$(($j+1));
  explain_package $i
  echo -e "$EXPLANATION"
done
echo ""

echo -n $n "Component? [0" 
j=1
while [ $j -le $RAV_PRODUCTS ]; do
  echo -n " $j"
  j=$(($j+1))
done
echo "]"
read component
case "$component" in
0|[XxQq]) exit 0  ;;
[123456789]) suretouninstall_package $(get_nth $component) ;;
   *) refresh  ;;
esac

}

refresh()
{
clear
welcome
interface
}

explain_package()
{

EXPLANATION="   unknown package"

if [ "`echo $1 |grep ravcore`x" != "x" ]; then
 export EXPLANATION="   DESCRIPTION: package that contains the scanning engine and the virus signature database\n   NEEDED BY: ravmd"
 return
fi

if [ "`echo $1 |grep ravmd`x" != "x" ]; then
 export EXPLANATION="   DESCRIPTION: RAV mail scanning daemon\n   NEEDED BY: ravqmail, ravsendmail, ravcgate, ravpostfix, ravmilter, ravexim, ravdmail, ravcourier"
 return
fi

if [ "`echo $1 |grep ravqmail`x" != "x" ]; then
 export EXPLANATION="   DESCRIPTION: RAV filter for qmail MTA\n   NEEDS: qmail, ravmd, ravcore "
 return
fi

if [ "`echo $1 |grep ravpostfix`x" != "x" ]; then
 export EXPLANATION="   DESCRIPTION: RAV filter for postfix MTA\n   NEEDS: postfix, ravmd, ravcore"
 return
fi

if [ "`echo $1 |grep ravsendmail`x" != "x" ]; then
 export EXPLANATION="   DESCRIPTION: RAV filter for sendmail MTA\n   NEEDS: sendmail, ravmd, ravcore"
 return
fi

if [ "`echo $1 |grep milter`x" != "x" ]; then
 export EXPLANATION="   DESCRIPTION: RAV filter for sendmail with libmilter MTA\n   NEEDS: sendmail with libmilter, ravmd, ravcore"
 return
fi

if [ "`echo $1 |grep ravcgate`x" != "x" ]; then
 export EXPLANATION="   DESCRIPTION: RAV filter for CommuniGate PRO\n   NEEDS: CommuniGate PRO, ravmd, ravcore"
 return
fi

if [ "`echo $1 |grep ravexim`x" != "x" ]; then
 export EXPLANATION="   DESCRIPTION: RAV filter for Exim MTA\n   NEEDS: exim, ravmd, ravcore"
 return
fi

if [ "`echo $1 |grep ravdmail`x" != "x" ]; then
 export EXPLANATION="   DESCRIPTION: RAV filter for DMail MTA\n   NEEDS: DMail, ravmd, ravcore"
 return
fi

if [ "`echo $1 |grep ravcourier`x" != "x" ]; then
 export EXPLANATION="   DESCRIPTION: RAV filter for Courier MTA\n   NEEDS: Courier, ravmd, ravcore"
 return
fi

}

get_nth()
{
j=1
for i in `pkg_info -I -a | grep -e ^rav | cut -d" " -f1`; do
  if [ "$j" = "$1" ]; then 
    echo $i
    return
  fi
  j=$(($j+1))
done
echo "unknown"
return
}

suretouninstall_package()
{
echo "selected package: $1"
explain_package $1
echo -e "this package was used for:\n$EXPLANATION"

echo $n "are you sure you wish to uninstall this package ? [y/n] $c"
read ynquestion
case "$ynquestion" in
y|Y) uninstall_package $1 ;;
n|N) echo "not touching $1" ;;
  *) echo "it was a y/n question ..."  ;; 
esac
}

uninstall_package()
{
pkg_delete -f $1
}

main
