#!/bin/sh
#An e-mail address where updating results will be sent
ADMIN_ADDRESS="postmaster"

#Specify when should the administrator be notified by the update process
#VERBOSE="silent"
VERBOSE="noisy"
#VERBOSE="errors"

# If you run `ravupdate.sh --periodic &` then automatic updates will
# be performed every $UPDATE_PERIOD seconds.
# Please make sure you include the command from above in a init script 
# that is run after poweron. If you run it in the console you will
# loose the updating process after logout. Also do NOT use the same time 
# interval as for the TIMEOUT_PERIOD.
# DEFAULT VALUE = 1800 #seconds (30 minutes)
UPDATE_PERIOD="1800"

# end of configurable area
#
#--------------------------------------------------------------

#Path to the update program
BINDIR="/usr/local"
DATADIR="/var/rav"
EXECUTABLE="${BINDIR}/bin/ravav"
VERSION_OPT="-v"
RAVUPDATE="${BINDIR}/bin/ravupdate -c/usr/local/etc/rav/rup.conf"
RAVEPATH=" --ravepath=/var/rav "

#Name of RAV AntiVirus scanning process
DAEMON_PID=`cat ${DATADIR}/run/ravmd.pid`
MAIL=`which mail`
if [ -z "$MAIL" ]; then 
    MAIL=`which mailx`
    if [ -z "$MAIL" ]; then
        MAIL=`which Mail`
        if [ -z "$MAIL" ]; then
            echo "ERROR: no 'mail' utility found in system..."
	    exit
        fi 
    fi
fi 

#Reroute error messages to heaven
exec 2>/dev/null

update_ok()
{
$MAIL -s "RAV AntiVirus: update successful" $ADMIN_ADDRESS << EOF

 The update process was successful.
 The RAV AntiVirus daemon has been restarted. 

________________ 
current status

engine status: $CURRENT_ENG_STATUS
engine info:
=========== 
$CURRENT_ENG_INFO1
$CURRENT_ENG_INFO2


________________
ravupdate log

${UPDATE_OUT}

Worry less! RAV is watching.
.
EOF

}

update_failed()
{
$MAIL -s "RAV AntiVirus: update failed" $ADMIN_ADDRESS << EOF

 The update process has failed with error level ${RESULT}. 
 Your virus signature database has not been successfully downloaded 
 from ${MIRROR} and the scanning daemon is using 
 the last known good signature database (if one is available).

 Try to change the MIRROR update site from the $0 shell script.

________________ 
current status

engine status: $CURRENT_ENG_STATUS
engine info:
===========
$CURRENT_ENG_INFO1
$CURRENT_ENG_INFO2

________________ 
ravupdate log

${UPDATE_OUT}

.
EOF

}

update_failed_dbf()
{
$MAIL -s "RAV AntiVirus: update failed - database corrupted" $ADMIN_ADDRESS << EOF

The update process has failed. Your virus signature database is corrupt.

_______________
current status

engine status: $CURRENT_ENG_STATUS
engine info:
============
$CURRENT_ENG_INFO1
$CURRENT_ENG_INFO2
 
If you see a text resembling "failed to load module module_name" please remove
the file ${DATADIR}/rave/module_name

If the info is "Can t init the engine: 0xfffffffe" 
then please remove every file from ${DATADIR}/rave and retry the update process
 
rm -f ${DATADIR}/rave/*
$0

If you feel that something is wrong please contact us at
mailto:<ravteam@ravantivirus.com>

________________
full debug info

$RAVAV_INFO

.
EOF

}

update_failed_timeout()
{
$MAIL -s "RAV AntiVirus: update failed - timeout exceeded" $ADMIN_ADDRESS << EOF

 The update process has failed. Your virus signature database has not been 
successfully downloaded from ${MIRROR} and the 
scanning daemon is using the last known good signature database 
(if one is available).
 The timeout period of ${TIMEOUT_PERIOD} seconds has been exceeded or another ravupdate 
process has been started before the old would have had the time to finish.
 If you are sure that no network related incident can be the cause of the 
problem, then please edit the $0 file and increase the 
TIMEOUT_PERIOD, the UPDATE_PERIOD or simply select other MIRROR site.

_______________
current status

engine status: $CURRENT_ENG_STATUS
engine info:
============ 
$CURRENT_ENG_INFO1
$CURRENT_ENG_INFO2

 If you feel that something is wrong please contact us at
 mailto:<ravteam@ravantivirus.com>
.
EOF

}

update_not_needed()
{
$MAIL -s "RAV AntiVirus: update was not needed" $ADMIN_ADDRESS << EOF

 You already have the newest signature database on your system.
 It is not needed to restart the RAV AntiVirus daemon.

_______________
current status

engine status: $CURRENT_ENG_STATUS
engine info:
============ 
$CURRENT_ENG_INFO1
$CURRENT_ENG_INFO2

Worry less! RAV is watching.
.
EOF

}

show_help()
{
cat << EOF
Usage: $0 [OPTION]
ravupdate.sh  - virus signature and engine update script 
		for RAV for MailServers

options:
--help          this help
--periodic	scheduled updates will be performed. 
		look inside the update script for details.  

Report any sugestions or bugs to <ravteam@ravantivirus.com>
EOF
}

get_engine_stats()
{
case $RESULTP in

32)
    CURRENT_ENG_STATUS="Ok"
    CURRENT_ENG_INFO1=`echo "$RAVAV_INFO"| grep "Last update"`
    CURRENT_ENG_INFO2=`echo "$RAVAV_INFO"| grep "Scanning for"`
    ;;
143)
    #timeout exceeded
    RESULT="143"
    ;;
*)
    RESULT="30"
    CURRENT_ENG_STATUS="broken"
    CURRENT_ENG_INFO=`echo -e "${RAVAV_INFO}" |grep "kernel:"`
    if [ "x${CURRENT_ENG_INFO}" = "x" ]; then
	CURRENT_ENG_INFO=`echo -e "${RAVAV_INFO}" |grep "engine:"`
    fi
esac
}

main()
{

UPDATE_OUT="`${RAVUPDATE}`"
RESULT=$?
RAVAV_INFO="`${EXECUTABLE} ${RAVEPATH} ${VERSION_OPT}`"
RESULTP=$?

get_engine_stats

case ${RESULT} in

0)	#load new signatures databases and configuration
	kill -HUP ${DAEMON_PID}
	echo "update successful"
	if [ $VERBOSE = "noisy" ]; then
		update_ok
	fi
	;;
1)
	echo "update was not needed"
	if [ $VERBOSE = "noisy" ]; then
		update_not_needed
	fi
	;;
30)
	echo "update failed: corrupt database"
	if [ $VERBOSE != "silent" ]; then
		update_failed_dbf
	fi
	;;
6)
	echo "update failed"
	if [ $VERBOSE != "silent" ]; then
		update_failed
	fi
	;;
*)
	echo "update failed"
	if [ $VERBOSE != "silent" ]; then
		update_failed
	fi
	;;
esac

}

case $1 in

--periodic)
	while true; do
	main &
	sleep ${UPDATE_PERIOD}
	done
	;;
--help)
	show_help
	exit 0
	;;
*)
	main
	;;

esac

exit 0
