#!/bin/sh
#
# configurable area
#

prefix="/etc/opt/rav"
lng_dir=${prefix}/languages
string="g3nera+0r"
src_lng=".source.gen"
src_eqv=".source.equiv.gen"

# please do not modify anything from this point on
#
#####################################################

sanity_check()
{
 for i in ${src_lng} ${src_eqv} ; do
	rm -f ${lng_dir}/${src_lng} 2> /dev/null
	rm -f ${lng_dir}/${src_eqv} 2> /dev/null
	create_generators
 done
}

create_lng()
{
 lng=`basename ${1}`
 cat ${lng_dir}/${src_eqv} | grep -v "equivalence generator" | sed "s|${string}|${lng}|g" > ${lng_dir}/${lng}.equiv
    
 if ! [ -f ${lng_dir}/${lng} ]; then
    cat ${lng_dir}/${src_lng} | grep -v "language generator" | sed "s|${string}|${lng}|g" > ${lng_dir}/${lng}
    echo "${lng} language pack has been created in ${lng_dir}"
 else
    echo "${lng}.equiv file recreated"
 fi
}

show_help()
{

cat << EOF
Usage: ravlnggen.sh [OPTION] [LANGUAGE]...
ravlnggen.sh  - language pack generator for RAV for MailServers

options:
--help 		this help
--faq		Frequently Asked Questions
--create [lng]	creates a new language pack
--recreate 	recreates the equiv files for every language

Report any sugestions or bugs to <ravteam@ravantivirus.com>
EOF
}

show_faq()
{
less --quit-at-eof << EOF

Multilanguage FAQ

Q1. What is a language pack?
Q2. How can I create a new language pack?
Q3. Are there known limitations?

Q1. What is a language pack?
A1. For each language there are 2 files: one with the name of the language
(the language file) - it contains the translation of the warning messages, 
and the other with the name of the language and with the ".equiv" extension 
(the equivalence file) - it contains the equivalances between keywords known 
by ravmd and the variables containing the translation.
 The language file must be included in the ravmd.conf in the WARNING MAILS 
MESSAGE DECLARATION SECTION:
   
_include /etc/opt/rav/languages/my_language
   
you can include here as many languages as you like.
    
The equivalence file must be included in the group declarations (look inside 
/etc/opt/rav/languages/global for an example):
     
_include /etc/opt/rav/languages/my_language.equiv
    
The good part is that you can include different languages for different groups
(one for each group).
    
-------------------------------------------------------------------------------
    
Q2. How can I create a new language pack?
A2. We have provided the ravlnggen.sh shell script that will help you get going.
Let's say you wish to write a translation for Spanish. You should do the 
following:
    
 - generate a new language pack for spanish. This command will generate the
spanish and spanish.equiv files:
ravlnggen.sh --create spanish
      
 - modify the "spanish" file (replace all the <<not defined>> strings with your 
translation) and then include this new language pack to your configuration 
(see Q1 on how to do this).
      
-------------------------------------------------------------------------------
      
Q3. Are there known limitations?
A3. We currently suport only 8bit/character languages. Kanji support (needed for
asian languages) is comming soon.


Report any sugestions or bugs to <ravteam@ravantivirus.com>
EOF
}

create_generators()
{
cat << EOF > ${lng_dir}/${src_lng}
###
#
# g3nera+0r language file
#
# DO NOT REMOVE THIS FILE - this is a new language generator file

## WARNING MAILS MESSAGE DECLARATIONS SECTION 
# This section starts with the keyword _define_strings and it can
# be included anywhere in the configuration file provided that it is placed before
# group definitions.
# Here you can define subjects and messages for warning mails that will be sent
# to those who are interested.
# Syntax:
# variable = string
# The variable will contain the specified string.
# The strings that the warning message will be created from can contain the
# following macros, which will be replaced by RAV with the proper values:
#	FILE_NAME   	-> the full path and name of the scanned file,
#  	ATTACH_NAME 	-> the name of the scanned attachment,
#	VIRUS_NAME  	-> virus name found,
#	FROM_USER   	-> mail sender address,
#	TO_USER(S)  	-> mail addresses of receiver(s),
#	SUBJECT     	-> mail subject,
#	QUARANTINE_NAME -> the name of the file saved to quarantine by move or 
#		copy actions. 
#	HEADER			-> the entire mail header
#	HEADER_RECEIVED	-> the "Received:" fields from the mail header
#	ON_HOST			-> the mail server name
_define_strings

# RAV AntiVirus scan results
digest_subject_g3nera+0r = "<<not defined>> "

# The file ATTACH_NAME attached to mail (with subject:SUBJECT) sent by FROM_USER
# to TO_USER(S) is infected with virus: VIRUS_NAME.
infected_m_g3nera+0r = "
<<not defined>> "

# The file ATTACH_NAME attached to mail (with subject:SUBJECT) sent by FROM_USER
# to TO_USER(S) contains suspicious code.
suspicious_m_g3nera+0r = "
<<not defined>> "

# The file was successfully cured by RAV AntiVirus.
cleaned_m_g3nera+0r = "
<<not defined>> "

# The file was moved to quarantine with name: QUARANTINE_NAME.
moved_m_g3nera+0r = "
<<not defined>> "

# The file was copied to quarantine with name: QUARANTINE_NAME.
copied_m_g3nera+0r = "
<<not defined>> "

# The infected file was saved to quarantine with name: SAVED_FILE_NAME.
saved_inf_m_g3nera+0r = "
<<not defined>> "

# The suspicious file was saved to quarantine with name: SAVED_FILE_NAME.
saved_sus_m_g3nera+0r = "
<<not defined>> "

# The file was successfully deleted by RAV AntiVirus.
deleted_m_g3nera+0r = "
<<not defined>> "

# The file was successfully renamed by RAV AntiVirus.
renamed_m_g3nera+0r = "
<<not defined>> "

# Cannot clean this file.
cannot_clean_m_g3nera+0r = "
<<not defined>> "

# Cannot move this file to quarantine.
cannot_move_m_g3nera+0r = "
<<not defined>> "

# Cannot copy this file to quarantine.
cannot_copy_m_g3nera+0r = "
<<not defined>> "

# Cannot copy this infected file to quarantine.
cannot_save_inf_m_g3nera+0r = "
<<not defined>> "

# Cannot copy this suspicious file to quarantine.
cannot_save_sus_m_g3nera+0r = "
<<not defined>> "

# Cannot delete this file (most probably it's in an archive).
cannot_delete_m_g3nera+0r = "
<<not defined>> "

# Cannot rename this file (most probably it's in an archive).
cannot_rename_m_g3nera+0r = "
<<not defined>> "

# The file was ignored because all previous actions failed.
#
# It is highly recommended not to use this file.
ignored_m_g3nera+0r = "
<<not defined>> "

# The mail was not delivered because it contained dangerous code.
rejected_m_g3nera+0r = "
<<not defined>> "

# The mail was silently discarded because it contained dangerous code.
discarded_m_g3nera+0r = "
<<not defined>> "

# This file has been removed because it contained dangerous code.
warn_txt_m_g3nera+0r = "
<<not defined>> "

# This e-mail has been scanned by my Company's server.
advertising_m_g3nera+0r = "
<<not defined>> "

#-----------------------
# RAV Antivirus results
#-----------------------
warn_header_m_g3nera+0r = "
<<not defined>> "

#------------------------
#this is a copy of the e-mail header:
#
#HEADER_RECEIVED
warn_footer_m_g3nera+0r = "
<<not defined>> "

# The original mail (attached) is virus free.
embedded_clean_m_g3nera+0r = "
<<not defined>> "

# The original mail (attached) contained dangerous code.
# It was cleaned by RAV AntiVirus
embedded_cleaned_m_g3nera+0r = "
<<not defined>> "

# ATTENTION: the original mail (attached) contains dangerous code.
# It is highly recommended not to open it.
embedded_unclean_m_g3nera+0r = "
<<not defined>> "

# X-RAV-Bulk: RAV AntiVirus considers this e-mail to be spam
bulk_extra_header_g3nera+0r = "<<not defined>>"

# Possible SPAM: 
bulk_extra_subject_g3nera+0r = "<<not defined>>"

# The original mail (attached) was tagged as SPAM
bulk_embedded_m_g3nera+0r = "<<not defined>>"

EOF

cat << EOF > ${lng_dir}/${src_eqv}
# equivalence file for g3nera+0r language
# DO NOT REMOVE THIS FILE - this is an equivalence generator file
# you should not modify this file, it is created by ravlnggen.sh

# Texts used in the embedded mails
embedded_clean_msg = embedded_clean_m_g3nera+0r
embedded_cleaned_msg = embedded_cleaned_m_g3nera+0r
embedded_unclean_msg = embedded_unclean_m_g3nera+0r

# Advertising text added at the end of the every scanned mail
advertising_msg = advertising_m_g3nera+0r

#warning texts
warn_txt_msg = warn_txt_m_g3nera+0r

# Header and footer of the warning message
warn_footer_msg = warn_footer_m_g3nera+0r
warn_header_msg = warn_header_m_g3nera+0r

# Texts used for bulk mails


# These are the messages used to create the warning notifications when a virus
# is found in the e-mail.
# Syntax:
# keyword = variable
# This section starts with the keyword _virus_warning_messages

_virus_warning_messages

# the subject used in the notification e-mail
warning_mail_subj = digest_subject_g3nera+0r

# the message body used if a virus is found
infected_msg = infected_m_g3nera+0r

# the message body used if a suspicious code is found
suspicious_msg = suspicious_m_g3nera+0r

# the strings used for different actions performed by RAV
cleaned_msg = cleaned_m_g3nera+0r
moved_msg = moved_m_g3nera+0r
copied_msg = copied_m_g3nera+0r
deleted_msg = deleted_m_g3nera+0r
renamed_msg = renamed_m_g3nera+0r
saved_inf_msg = saved_inf_m_g3nera+0r
saved_sus_msg = saved_sus_m_g3nera+0r

cannot_clean_msg = cannot_clean_m_g3nera+0r
cannot_move_msg = cannot_move_m_g3nera+0r
cannot_copy_msg = cannot_copy_m_g3nera+0r
cannot_delete_msg = cannot_delete_m_g3nera+0r
cannot_rename_msg = cannot_rename_m_g3nera+0r
cannot_save_inf_msg = cannot_save_inf_m_g3nera+0r
cannot_save_sus_msg = cannot_save_sus_m_g3nera+0r

ignored_msg = ignored_m_g3nera+0r
rejected_msg = rejected_m_g3nera+0r
discarded_msg = discarded_m_g3nera+0r

# These are the messages used to create the warning notifications when the
# content filtering is enabled and the e-mail subject matches one of the
# defined rules.
# The section must begin with _subject_filter_warning_messages
_subject_filter_warning_messages

warning_mail_subj = digest_subject_g3nera+0r

infected_msg = infected_m_g3nera+0r
suspicious_msg = suspicious_m_g3nera+0r
cleaned_msg = cleaned_m_g3nera+0r
moved_msg = moved_m_g3nera+0r
copied_msg = copied_m_g3nera+0r
deleted_msg = deleted_m_g3nera+0r
renamed_msg = renamed_m_g3nera+0r
saved_inf_msg = saved_inf_m_g3nera+0r
saved_sus_msg = saved_sus_m_g3nera+0r

cannot_clean_msg = cannot_clean_m_g3nera+0r
cannot_move_msg = cannot_move_m_g3nera+0r
cannot_copy_msg = cannot_copy_m_g3nera+0r
cannot_delete_msg = cannot_delete_m_g3nera+0r
cannot_rename_msg = cannot_rename_m_g3nera+0r
cannot_save_inf_msg = cannot_save_inf_m_g3nera+0r
cannot_save_sus_msg = cannot_save_sus_m_g3nera+0r

ignored_msg = ignored_m_g3nera+0r
rejected_msg = rejected_m_g3nera+0r
discarded_msg = discarded_m_g3nera+0r

# These are the messages used to create the warning notifications when the
# content filtering is enabled and an attached file name matches one of the
# defined rules.
# The section must begin with _attachment_filter_warning_messages
_attachment_filter_warning_messages

warning_mail_subj = digest_subject_g3nera+0r

infected_msg = infected_m_g3nera+0r
suspicious_msg = suspicious_m_g3nera+0r

cleaned_msg = cleaned_m_g3nera+0r
moved_msg = moved_m_g3nera+0r
copied_msg = copied_m_g3nera+0r
deleted_msg = deleted_m_g3nera+0r
renamed_msg = renamed_m_g3nera+0r
saved_inf_msg = saved_inf_m_g3nera+0r
saved_sus_msg = saved_sus_m_g3nera+0r

cannot_clean_msg = cannot_clean_m_g3nera+0r
cannot_move_msg = cannot_move_m_g3nera+0r
cannot_copy_msg = cannot_copy_m_g3nera+0r
cannot_delete_msg = cannot_delete_m_g3nera+0r
cannot_rename_msg = cannot_rename_m_g3nera+0r
cannot_save_inf_msg = cannot_save_inf_m_g3nera+0r
cannot_save_sus_msg = cannot_save_sus_m_g3nera+0r

ignored_msg = ignored_m_g3nera+0r
rejected_msg = rejected_m_g3nera+0r
discarded_msg = discarded_m_g3nera+0r

# These are the messages used to create the warning notifications when the
# content filtering is enabled and the e-mail body contains a string which
# matches one of the defined rules.
# The section must begin with _content_filter_warning_messages
_content_filter_warning_messages

warning_mail_subj = digest_subject_g3nera+0r

infected_msg = infected_m_g3nera+0r
suspicious_msg = suspicious_m_g3nera+0r

cleaned_msg = cleaned_m_g3nera+0r
moved_msg = moved_m_g3nera+0r
copied_msg = copied_m_g3nera+0r
deleted_msg = deleted_m_g3nera+0r
renamed_msg = renamed_m_g3nera+0r
saved_inf_msg = saved_inf_m_g3nera+0r
saved_sus_msg = saved_sus_m_g3nera+0r

cannot_clean_msg = cannot_clean_m_g3nera+0r
cannot_move_msg = cannot_move_m_g3nera+0r
cannot_copy_msg = cannot_copy_m_g3nera+0r
cannot_delete_msg = cannot_delete_m_g3nera+0r
cannot_rename_msg = cannot_rename_m_g3nera+0r
cannot_save_inf_msg = cannot_save_inf_m_g3nera+0r
cannot_save_sus_msg = cannot_save_sus_m_g3nera+0r

ignored_msg = ignored_m_g3nera+0r
rejected_msg = rejected_m_g3nera+0r
discarded_msg = discarded_m_g3nera+0r

EOF

}

main()
{

case $1 in

--help)
    show_help
    exit 0
    ;;
--faq)
    show_faq
    exit 0
    ;;
--recreate)
    languages=`ls -1 ${lng_dir} | grep -v "\."` 
    ;;
--create)
    languages="${2} ${3}"
    ;;
*)
    show_help
    exit 0
    ;;
esac    
    
sanity_check

for i in ${languages}; do
    create_lng $i
done
}

main $1 $2 $3
rm -f ${lng_dir}/${src_lng} 2> /dev/null
rm -f ${lng_dir}/${src_eqv} 2> /dev/null

echo
exit 0
