{*****************************************************************************}
{*                                                                           *}
{* This is the source code of mr2s_rs for mr2s                               *}
{* RCS branch 2.x and higher is mr2s_rs                                      *}
{*     branch 1.x is mr2sdemo (standalone scanner module for testing)        *}
{*                                                                           *}
{*                                                                           *}
{*           Ŀ                              *}
{*            ROSE Softwareentwicklung                                    *}
{*            Dipl.-Ing. Ralph Roth                                       *}
{*            Finkenweg 24                                                *}
{*                                                                        *}
{*            D 78658 Zimmern o. R.                                       *}
{*                                                                        *}
{*                                        *}
{*                                          *}
{*                                                                           *}
{*                                                                           *}
{*****************************************************************************}

{
$Header: /home/CVS/tp/MARX/MR2S_RS.PAS,v 3.9 2005/01/09 19:01:43 ralproth Exp $

$Log: MR2S_RS.PAS,v $
Revision 3.9  2005/01/09 19:01:43  ralproth
Changes made in Zimmern and Brechen, y2k5 update

Revision 3.8  2004/08/03 20:43:37  ralproth
Sourcecode branch BEFORE adding new (v3) VBS/IRC stuff

Revision 3.7  2003/12/23 21:35:00  ralproth
! Changed (C)opyright from -2003 to -2004

Revision 3.6  2003/09/06 17:13:26  ralproth
Ported some AVR modules to fpc/vpc, fixed therefor a lot of the old programs

Revision 3.5  2003/06/05 17:46:51  ralproth
Rechecked in on P4/C2000

Revision 3.4  2003/01/28 21:27:05  ralph roth
y2k3 and first runtime error fixes

Revision 3.3  2002/11/20 18:04:04  ralph roth
WinCVS complains about not checked in version!

Revision 3.2  2002/09/10 21:27:59  ralph
Changes for Mr2S 1.21 release

Revision 2.10  2001/07/30 15:58:54  rar_ulm
Fixed changes introduced with AVR_MIRC

Revision 2.9  2001/01/04 20:38:53  rar
Working version (VBS) send out to Andreas Haak for ANTS.

Revision 2.8  2000/12/31 15:23:54  rose_swe.p300
Finally bugfixed ANTS engine (ralph)

Revision 2.7  2000/12/31 13:54:02  rose_swe.p300
Before capsulation the ANTS part for better debugging.

Revision 2.6  2000/12/30 13:54:08  rose_swe.p200
Version for Zimmern, may enhancements and bug fixes in the ANTS section

Revision 2.5  2000/12/29 12:23:53  rose_swe.p200
Fuer ANTS 2.0/Project1.exe erweitert und um Fehler bereinigt.
VBS Erkennung gefixed, LongInt als Filesize wird bergeben

Revision 2.4  2000/12/29 09:58:34  rose_swe.p200
ANTS Modifications by Andreas, delay by rar

Revision 2.3  2000/12/23 16:36:08  Zimmern
*** empty log message ***

Revision 2.2  2000/12/23 16:21:55  Zimmern
Misc source beautifing

Revision 2.1  2000/12/23 16:12:05  Zimmern
Mr2s_RS/ANTS
Initial RCS version, stored as branch 2.1


Non RCS versions
~~~~~~~~~~~~~~~~
        version 1.0     mr2s, 4.x
        version 1.1     mr2s, 4.x + ANTS
        version 1.2     mr2s, 4.x fixed by Fetti
        version 1.3     mr2s, 4.x fixed by ralph
        version 1.31    ANTS, semaphore, rar
        version 1.4     mr2s "consolidated" by rar
        version 1.41    fixes for ANTS (-a) and skipping of JPG/GIF etc., rar


}

{$M 16384,0,450000}
{$A+,B+,D+,E-,G+,L+,N-,V-,I-,R-,S-}

Program Mr2S_or_Ants;

uses  test286, r_utils, rStrings, avrvbs,
      crt, dos, avrmem, avr_poly, killer2,
      avrmini, famr, famcrypt, killer1,
      famvcl, drvtypes, avrwin32, avr_troj,
      constant, killer, nonport,
      netzwerk;                 { netzwerk nicht erforderlich! }

Const VirusMinLen =  10;          { Darunter infiziert er nicht! }
      PATHLEN     =  46;          { Auf soviel wird Pfad gekrzt! }
      {$i regnr.inc}
      szTab :  String[10] =  ' - ';
      RCS_ID =
      '$Header: /home/CVS/tp/MARX/MR2S_RS.PAS,v 3.9 2005/01/09 19:01:43 ralproth Exp $';

Var     { wegen Stack! }
    szSearch    :  String;
    szName      :  String;
    szHome      :  String;
    szParam     :  String;
    szTmp       :  String;
    szLog       :  String;
    bAllFiles   :  Boolean;
    bVerbose    :  Boolean;
    bLogFile    :  Boolean;
    bLogAll     :  Boolean;
    bSubDir     :  Boolean;
    hLog        :  Text;
    i           :  Byte;
    lTotal, lFound :  LongInt;

(* ************************************************************************ *)

Function  AVR_VSPAllEngines(Buffer : TremorBufferPtr;
                            bHeur : Boolean;
                            wScanLen : Word) :  String;

{ IN:
  Buffer[1...wScanLen] - Pointer auf Viruscode at resolved EntryPoint
  bHeur                - Heuristic: Nur fuer Gurus :)
  wScanLen             - Lnge des zu berprfenden Bereiches

  OUT:
  [false positive]     - FP, Packer [LZEXE], [MSDOS], [Win95] -> skip!
  ''                   - kein Virus
  Virus Name           - Virenname, ohne "Virus"
  Type_                - heuristisch erkannter Virus

  Sideeffekt:  Buffer muss mind. 2 KB (range check) dimensoniert sein

  -------------------------------------------------------------------

  Folgende Scannerengines koennen noch integriert werden:

Function AVR_Neuroquila (filename: String; Remove : Boolean) : String;
Function AVR_Predator(filename: String; bRemove: Boolean) : String;
Function AVR_Delwin(filename: String; bRemove: Boolean) : String;
Function AVR_Burglar(filename: String; bRemove: Boolean) : String;
Function AVR_Major(filename: String; bRemove: Boolean) : String;
Function AVR_Taipan(filename: String; bRemove: Boolean) : String;
Function AVR_Werewolf(filename: String; bRemove: Boolean) : String;
Function AVR_Pieck(filename: String; bRemove: Boolean) : String;
Function AVR_Spanska(filename: String; bRemove: Boolean) : String;
Function AVR_OneHalf(filename: String) : String;
Function AVR_Barrotes(filename: String; bRemove: Boolean) : String;
Function AVR_Suleiman(filename: String; bRemove: Boolean) : String;

}

Var s, szKit :  String;

Begin
     s := avr_codes(Buffer, wScanLen, FALSE);
     { avr_dumbvirus, avr_memcodes --> avr_bootvirus }

     If s = '' Then
        s := avr_mini(Buffer, bHeur, wScanLen);
     If s = '' Then
        s := avr_Sonstige(Buffer, bHeur, wScanLen);  { fixed 0.02 }
     If s = '' Then
        s := avr_cryptcom(Buffer, {wScanLen,} bHeur);

     If s = '' Then
        s := avr_trident(Buffer);
     If s = '' Then	 { changed/added 06.09.2003 (19:11) by Ralph Roth }
        s := avr_washburn(Buffer, wScanLen, FALSE);

     If s = '' Then
        s := avr_bw(Buffer, wScanLen);
     If s = '' Then
        s := AVR_Manzon(Buffer); { changed/added 06.09.2003 (19:08) by Ralph Roth }
     If s = '' Then
        s := avr_weizen(Buffer, bHeur);
     If s = '' Then
        s := avr_vcl(Buffer, bHeur);
     If s = '' Then
        s := avr_vienna(Buffer, bHeur);                 { 15.05.99! }
     If s = '' Then
        s := avr_wordswap(Buffer, bHeur);
     If s = '' Then
        s := avr_qux(Buffer, bHeur);

     If s = '' Then
        s := avr_CallNull(Buffer, bHeur, FALSE );       { 15.05.99! }

     { ----- neu! ----- }
     If s = '' Then                                     { 15.05.99! }
        s := AVR_MtE(Buffer, wScanLen, TRUE);
     If s = '' Then                                     { 15.05.99! }
        s := AVR_Tremor(Buffer, wScanLen);
     If s = '' Then                                     { 15.05.99! }
        s := AVR_Natas(Buffer, wScanLen, FALSE);
     If s = '' Then                                     { 15.05.99! }
        s := AVR_VCL(Buffer, FALSE);                    { 19.05.99! }

{$IFDEF FULL}	{ fully heur? }
     If s = '' Then
        s := avr_StackDec(Buffer, FALSE);               { 30.07.99 -> bHeur }
     If s = '' Then
        s := avr_codes(Buffer, wScanLen, TRUE);         { FULL HEUR - 07.11.99 }
     If s = '' Then
        s := avr_CallNull(Buffer, bHeur, TRUE );        { FULL HEUR - 07.11.99 }
{$ENDIF}

     If pos('TYPE', Upper(s)) > 0 Then    { VCL, PS-MPC, G2, BW etc. }
        Begin
           szKit := GetVirusKit(Buffer, wScanLen);
           If szKit <> '' Then s := szKit;
        End;

     AVR_VSPAllEngines := s;
End;

{ ---------------------------------------------------------------------- }

Function AVR_Mr2SAll(szName: String; lSize: LongInt) :  String;
{ 02.01.96, 01.09.96 [20.06.98], 13.09.2000 }

Var
    hIn                    :  File;
    wAttr, wVLen, nT, wDLen:  Word;
    szAVR                  :  String;
    szLen                  :  String[10];
    Buffer                 :  pEinKilo;   { 5b }
    bMode                  :  Byte;
    XorByte                :  Byte;
    w, LastPage, NumPages  :  Word;
    lDatum, lCrc32         :  LongInt;
    dt                     :  DateTime;
    wEP                    :  LongInt;
    wSS,wSP,wCS,wIP,wXorKey:  Word;
    bFlag                  :  Boolean;
    vPtr, vKey, vAdd, vXor :  Word;
    r1, r2, vCmp           :  Word;

   Label Exit_here, Exit_Here2;

Begin
   AVR_Mr2SAll := '';
   szAVR := '';

   If (IsHTMLExtension(szName) Or bAllFiles)
      And (lSize > VIRUSMINLEN)
      Then
      Begin
         szAVR := AVR_VBS(szName, FALSE, FALSE);

         If szAVR = '' Then
            szAVR := AVR_MIrc(szName, FALSE);
      End;

   If IsJPGExtension(szName) Then goto exit_here2;      { 03122000, rar }

     If szAVR = '' Then
        szAVR     :=  AVR_Neuroquila(szName, False);

     If szAVR <> '' Then
        goto exit_here2;

     szAVR     :=  AVR_Spanska(szName, False);
     If szAVR <> '' Then
        goto exit_here2;
     szAVR     :=  AVR_OneHalf(szName);
     If szAVR <> '' Then
        goto exit_here2;

     If Not FopenBin(hIn, szName) Then exit; { access denied }
     new(buffer);
     For r1 := 1 To $20 Do
        buffer^[r1] := 0;

     blockread(hIn, buffer^, $20);      { head }

     { new, 27.05.2000 }
	lCrc32 := CheckSum(@buffer^[0]);
     szAVR := Trojan_Win32(szName, FileSize(hIn), lCrc32 );
     If szAVR <> '' Then
        goto exit_here;

     szAVR := Trojan_CheckPuffer(@buffer^[0]);
     If szAVR <> '' Then
        goto exit_here;

     { --- new 26.01.2003, win32 scanner! ---- }
(*
     lCrc32 := 0;
     for r1 := 0 to 31 do lCrc32 := (lCrc32 shl 1) + buffer^[r1];

     szAVR = Trojan_Win32(szName, FileSIze(hIn), lCrc32);
     If szAVR <> '' Then
        goto exit_here;
*)

     wEP := SeekEP(buffer^);

     If wEP > FileSize(hIn)
        Then goto Exit_Here;    { kein COM/EXE file }

     seek(hIn, wEP);
     If ioresult <> 0 Then goto Exit_Here; { corrupted! }

     blockread(hIn, buffer^, sizeof(buffer^), wVLen);
     If ioresult <> 0 Then
        goto exit_Here;

     szAVR := AVR_VSPAllEngines(@buffer^, false, wVLen); { 15.05.99 }

     If (szAVR = '') And (FileSize(hIn) > 7600) Then     { 15.05.99! }
        szAVR := AVR_Hare(@Buffer^, wVLen);


   Exit_Here:
               close(hIn);
     If ioresult <> 0 Then { tp sucks again };

     If szAvr <> ''
        Then szAVR := szAVR + GetVirusLength(@buffer^, wVLen, wVLen, FALSE);

     dispose(buffer);

   Exit_Here2:

                AVR_Mr2SAll := szAVR;

End; { Mr2SAll }


{ ---------------------------------------------------------------------- }

Procedure Bearbeite(pfad: String);

Var sr:  SearchRec;
    t :  Byte;

Begin { Bearbeite }

   FindFirst('*.*', anyfile-VolumeId, sr);
   while (DosError=0) Do
    Begin
       If ((sr.attr And directory) = Directory) And (sr.name[1] <> '.')
          Then
          Begin
             If bSubDir Then
                Begin
                   szName := pfad+'\'+sr.name;
                   chdir(szName);
                   If ioresult = 0 Then
                      bearbeite(szName);
                End;
          End
       Else
          If sr.name[1] <> '.' Then
             Begin
                szName := pfad+'\'+sr.name;
                If bVerbose Then
                   Begin
                      write(pathfit(szname,PATHLEN));
                      clreol;
                      write(#13);
                   End;

        { targets }

                szSearch := AVR_Mr2sAll(szName, sr.size);

                inc(lTotal);
                If (szSearch <> '') And (szSearch[1] <> '[') Then
                   Begin
          { Found something! }

                      inc(lFound);
                      For t := 1 To length(szSearch) Do
                         If szSearch[t] In ['-','?'] Then szSearch[t] := '_';

                      If bVerbose Then
                         Begin
                            textcolor(white);
                            write(copy(pathfit(szName,PATHLEN)+
                            '                                           ',1,PATHLEN+5));
                            textcolor(yellow);
                            writeln(szSearch);
                            textcolor(7);
                         End;

                   End;
                If bLogFile Then
                   Begin
                      i := FileMode;
                      FileMode := 2;
                      If bLogAll Or ((szSearch <> '') And (szSearch[1] <> '[')) Then
                         Begin
                            If szSearch[1] = '[' Then szSearch := ''; { FP! }

                            szName := szName;
                            If szSearch <> '' Then writeln(hLog, szName, szTab {' - '},
                                                           szSearch)
                                 Else writeln(hLog, szName);
                         End;
                      FileMode := i;
                   End;
                If ioresult <> 0 Then { ? };
             End;


       FindNext(sr);
       If keypressed Then exit;
    End;
   chdir('..');
   If ioresult <> 0 Then {-???-};

End; { Bearbeite }

{ ------------------------------------------------------------------- }

Procedure Header;
Begin
       writeln1(GuruHeadLine('MR2Scan - ROSE SWE - Version 5.'+format(regnr_word)));
       writeln1('(c) 1989-2005 by ROSE SWE, Dipl.Ing. Ralph Roth, http://come.to/rose_swe' );
       writeln('Special Standalone Scanner version for the MR2Scan Project - ', reg_datum) ;
       {$IFDEF VTC}
       writeln('MR2S Version! - Options hard coded in: -s -t -r');
       {$ENDIF}
       {$IFDEF ANTS}
       writeln('ANTS Version! - Options hard coded in: -s -t -r');
       writeln('INPUT: stdin, OUTPUT: stdout, QUIT: EXIT');
       {$ENDIF}
       {$IFDEF FULL}
       writeln(' WARNING: With full heuristic enabled ...');
       {$ENDIF}
       writeln;
End;

{ ------------------------------------------------------------------- }

Procedure Usage;

Begin
       header;
       writeln1('usage:  mr2s_rs  drive:\path -option(s)');
       writeln;
       writeln1(GuruHeadLine('Options'));
       writeln('-a      all files');
       writeln('-d      delemiter = tab  - default = " - "');
       writeln('-l<path to logfile>      - only infected files');
       writeln('-r<path to reportfile>   - all files are logged');
       writeln('-s      no subdirectories');
       writeln('-t      terse, not verbose :-))');
       writeln(#7);
       halt(1);
End;

Procedure CreateLog;

Var f :  byte;

Begin
     f := FileMode;
     FileMode := 2;

     If exists(szLog) Then unlink(szLog);
     If ioresult <> 0 Then { error };
     assign(hLog, szLog);
     If ioresult <> 0 Then
        Begin
           writeln('ERROR: Can not create/open LOG file: '+szLog);
           halt(5);
        End;
     rewrite(hLog);
     If ioresult <> 0 Then
        Begin
           writeln('ERROR: Can not write to LOG file: '+szLog);
           halt(5);
        End;
     FileMode := f;

End;

{ ------[MAIN: Recursive Scanning, Mr2S/Standalone Scanner]------------ }

Procedure MainRecursive;

Begin { MainRecursive }

   If length(szParam) = 2
      Then szParam := szParam+'\';

   ChDir(szParam);
   If ioresult <> 0 Then
      Begin
         writeln1(GuruHeadLine('Fatal Error'));
         writeln1('Can not chdir to '+szParam);
         halt(7);
      End;
   GetDir(0, szParam);
   If length(szParam) = 3
      Then szParam := copy(szParam, 1, 2);

   If bVerbose Then
      Begin
         Header;
         writeln(' Loaded  '+klformat(ANZAHL_TROJANS)+
         ' entries for trojan horses and droppers');
         writeln(' Loaded  '+klformat(ANZAHL_MIRC_WORMS)+
         ' entries for unique MIRC/PIRC script worms');
         writeln(' Loaded    '+klformat(ANZAHL_VBS_VIREN)+
         ' entries for VBS/JS/CS/HTML etc. script viruses');
         writeln(' Loaded '+klformat(trunc(regnr_word/4)+2500)+' entries for viruses');
         writeln;
         writeln1(GuruHeadLine(szParam));
      End;
   clearkeys;
   Bearbeite(szParam);
   ChDir(szHome);

   If ioresult <> 0 Then { tp sux };
   clreol;
  { writeln; }

   If bLogFile Then
      Begin
         writeln(hLog);
         close(hLog);
      End;

   If bVerbose Then
      Begin
         writeln1(GuruHeadLine('Statistics'));
         writeln1('  Files checked ............................ '+format(lTotal));
         If lTotal>0 Then str(lFound/lTotal*100:3:1,szTmp)
            Else szTmp := '0.0';
         writeln1('  Suspicious files ......................... '+format(lFound)+
         '         ('+szTmp+'%)');
         writeln1(GuruHeadLine('Scanning finished!'));
      End;

End; { MainRecursive }

{ ------------------------------------------------------------------------ }

{$IFDEF ANTS}

Var fTalkFile : text;

Function MyFileSize(Filename:String): integer;

Var SR : SearchRec;

Begin
  FindFirst(Filename,AnyFile,SR);
  If DosError=0 Then
    MyFileSize := SR.Size
  Else
    MyFileSize := -1;

{ FindClose(SR); }

End; {MyFileSize}

{ ------------------------------------------------------------------------ }

Procedure deletefile(szFileName:String);

   Var fDummyFile : file;

Begin { deletefile }

  assign(fDummyFile, szFileName);
  erase(fDummyFile);
  If ioresult <> 0 Then writeln('Error on deletefile '+szFileName);

End; { deletefile }

{ ------------------------------------------------------------------------ }

Procedure ANTS_Main;  { ralph, 31.12.2000 }

   Var
     szFound, szTmp, szSize :  String; { ants }
     lSize       : LongInt; { ANTS }
     nErr        : Integer;
{
Var
  szDir: DirStr;
  szName: NameStr;
  szExt: ExtStr;
}

Begin { ANTS_Main }

   Repeat

      Repeat
         { wait for semaphore }
         { delay(1); }

      Until (myFileSize('input.dat')>0) And (myFileSize('semaphre.dat')=-1);

      { ACHTUNG:  WIR SIND Wir NIE GANZ SICHER, OB DATEI <> 0 BYTES IST!!! }

      assign(fTalkFile, 'input.dat');
      reset(fTalkFile);
      readln(fTalkFile, szTmp);
      readln(fTalkFile, szSize); { 28122000, rar }
      close(fTalkFile);

      val(szSize, lSize, nErr);

      If ioresult <> 0 Then writeln('Error: FClose on input.dat');
      { writeln('input ok'); }

      szTmp := Upper(KillSpace(szTmp));
      writeln(szTmp + ' ',lsize);


      If (szTmp <> '') And (szTmp <> 'EXIT') And (nErr = 0) Then
        Begin
          assign(fTalkFile, 'output.dat');
          If ioresult <> 0 Then
            writeln('IO-Error on FWrite output.dat!');
          rewrite(fTalkFile);
          writeln('fcreate output ok, IORES=', ioresult);
          szFound := AVR_Mr2sAll(szTmp, lSize);
          writeln('Scan ok, IORES=',ioresult);
          writeln(szTmp, szTab, lSize, szTab, szFound);
          writeln(fTalkFile,szTmp+szTab+szFound);
          writeln('fwrite output ok');
          If ioresult <> 0 Then writeln('IO-Error on write '+szTmp);
          close(fTalkfile);
          If ioresult <> 0 Then writeln('IO-Error on close output.dat!');
          writeln('fclose output ok');
        End;


      {Ich nutz die input.dat als semaphor. Nicht das ich noch vor Dir
      auf die output.dat zugreife}

      deletefile('input.dat');

      { delay(2); }

   Until szTMP = 'EXIT';

End; { ANTS_Main }


{$ENDIF}

{ ------[MAIN]--------------------------------------------------------- }

Begin

   If ParamCount < 1 Then
      usage;

   GetDir(0, szHome);
   szParam  := ParamStr(1);
   szParam  := Upper(DirAdust(szParam));
   bAllFiles := FALSE;
   bVerbose := TRUE;
   bSubDir  := TRUE;
   bLogFile := FALSE;
   bLogAll  := TRUE;
   szLog    := 'MR2S_RS.LOG';
   lFound   := 0;
   lTotal   := 0;

   Trojan_Init;

  { ------- params -------- }

   For i := 2 To ParamCount Do
      Begin
         szTmp := Upper(ParamStr(i));
         If szTmp[1] In ['-','/'] Then
            Case szTmp[2] Of
               'A' :  bAllFiles := TRUE;
               'T' :  bVerbose  := FALSE;
               'L','R' :
                          Begin
                             szLog := copy(szTmp,3,255);
                             CreateLog;
                             bLogFile := TRUE;
                             bLogAll  := szTmp[2] = 'R';
                          End;
               'S' :  bSubDir   := FALSE;
               'D' :  szTab     := ' '#9' ';   { delemiter! }
               '?' :  Usage;
               Else
             {$IFNDEF ANTS} Usage {$ENDIF};
            End;
      End;

  { ---------------------------------------------------------------- }
  {$IFDEF VTC}
  { MR2S special version }

   bAllFiles := TRUE;
   bLogAll   := TRUE;
   bLogFile  := TRUE;
   bSubDir   := FALSE;
   bVerbose  := FALSE;
   szLog     := 'mr2ssub2.rep';
   CreateLog;
  {$ENDIF}
  { ---------------------------------------------------------------- }

  { ---------------------------------------------------------------- }
  {$IFDEF ANTS}
  { ANTS special version }
   bAllFiles := TRUE;          { changed 03.12.2000, req. by AH, rech.: VBS }
   bLogAll   := TRUE;
   bLogFile  := TRUE;
   bSubDir   := FALSE;
   bVerbose  := FALSE;

   crt2con;

   If ioresult <> 0 Then ;

   Header;

         writeln(' Loaded  '+klformat(ANZAHL_TROJANS)+
         ' entries for trojan horses and droppers');
         writeln(' Loaded  '+klformat(ANZAHL_MIRC_WORMS)+
         ' entries for unique MIRC/PIRC script worms');
         writeln(' Loaded    '+klformat(ANZAHL_VBS_VIREN)+
         ' entries for VBS/JS/CS/HTML etc. script viruses');
         writeln(' Loaded '+klformat(trunc(regnr_word/4)+2500)+' entries for viruses');
         writeln;

   Writeln(GuruHeadLine('Mr2S-ANTS: Ready!')); { check if this is the first line }
   writeln('Current Dir=', szHome);

   ANTS_Main;   { the working horse }

   Writeln(GuruHeadLine('Mr2S-ANTS: Exit!')); { check if this is the last line }

  { ---------------------------------------------------------------- }
  {$ELSE}
   MainRecursive;
  {$ENDIF}

   ChDir(szHome);

End.
