{*****************************************************************************}
{*                                                                           *}
{*           Ŀ                              *}
{*            ROSE Softwareentwicklung                                    *}
{*            Dipl.-Ing.  Ralph Roth                                      *}
{*            Finkenweg 24                                                *}
{*                                                                        *}
{*            D 78658 Zimmern o. R.                                       *}
{*                                                                        *}
{*                                        *}
{*                                          *}
{*                                                                           *}
{* Part of the Mr2S package: MR2S_CHK, checks for viruses in memory          *}
{*                                                                           *}
{*****************************************************************************}

{ * $Header: /home/CVS/tp/MARX/MR2S_CHK.PAS,v 3.8 2005/02/18 21:36:21 ralproth Exp $
}
{ *
  * $Log: MR2S_CHK.PAS,v $
  * Revision 3.8  2005/02/18 21:36:21  ralproth
  * fmirc 6.10/6.11 forced commit (VBS format 3.0)
  *
  * Revision 3.7  2005/01/09 19:01:43  ralproth
  * Changes made in Zimmern and Brechen, y2k5 update
  *
  * Revision 3.6  2003/12/23 21:35:00  ralproth
  * ! Changed (C)opyright from -2003 to -2004
  *
  * Revision 3.5  2003/06/05 17:46:51  ralproth
  * Rechecked in on P4/C2000
  *
  * Revision 3.4  2003/01/28 21:27:05  ralph roth
  * y2k3 and first runtime error fixes
  *
  * Revision 3.3  2002/11/20 18:04:04  ralph roth
  * WinCVS complains about not checked in version!
  *
  * Revision 3.2  2002/03/27 21:39:33  ralph
  * Fixed to work with mr2s/win32 (crt2con)
  *
  *
}
{ *
  * (C)opyright 1989-2005 by ROSE SWE, Dipl.Ing. Ralph Roth, ROSE_SWE@hotmail.com
  *                          http://come.to/rose_swe - ALL RIGHTS RESERVED!
  *
}

{$M 16384,0,150000}
{$A+,B+,D+,E-,G+,L+,N-,V-,I-,R-,S-}

Program Mr2s_MemCheck;

uses  r_utils,    { G+/286 check nicht erforderlich }
      crt, dos, avrmem, avr_poly, killer2, avrvbs, 
      avrmini, famr, famcrypt, killer1,
      famvcl, drvtypes, checksum,
      rstrings, constant, killer,
      netzwerk;                 { netzwerk nicht erforderlich! }


{ ------[MAIN]--------------------------------------------------------- }

Begin

  crt2con;
  avrmem_language := English;                           (* Deutsch! *)
  Verify_AVRVBS;        { checks the signature files for tampering! 12.02.2005 23:20 }
  If QuickMemScan(FALSE) Then halt(1);                  (* vIRUS *)
  If HLL_LiveGoat Then halt(2);                         { Stealth virus found! }
  If Win_LiveGoat Then halt(3);                         { Stealth virus found! }

  CheckFilesThere;                                      (* halt 1, if err *)
  close(output);
  halt(0);                                              (* -ok- *)

End.
