{ $Header: /home/CVS/tp/MARX/MR2S.PAS,v 4.13 2005/02/18 21:36:21 ralproth Exp $ }
{$IFDEF WINDOWS} {$mode delphi} {$ENDIF}
Program mr2s;                       { mr2s binder program, 15/05/1999 am }
{$I comp.pas}
{$IFNDEF FPC}
{$G+}
{$M $5000,0,$4000}
{$ENDIF}

{ -------------------[ history, see history.doc ]------------------------


  $Log: MR2S.PAS,v $
  Revision 4.13  2005/02/18 21:36:21  ralproth
  fmirc 6.10/6.11 forced commit (VBS format 3.0)

  Revision 4.12  2005/01/09 19:01:43  ralproth
  Changes made in Zimmern and Brechen, y2k5 update

  Revision 4.11  2004/06/14 19:49:05  ralproth
  Many fixes for F_Mirc 6.72 and VSP 14.08 release (VTC)

  Revision 4.10  2004/01/06 20:30:12  ralproth
  Mr2s 1.47 changes

  Revision 4.9  2003/10/26 18:21:12  ralproth
  Mr2S 1.46 - enhanced lock.dat file

  Revision 4.8  2003/10/10 10:02:35  ralproth
  Check in for Brechen

  Revision 4.7  2003/07/14 20:41:53  ralproth
  Mr2S 1.42 - maintenance release for CRCI

  Revision 4.6  2003/02/11 21:18:44  ralph
  Changes for Mr2s 1.41 (VTC release): fixes for Win32

  Revision 4.5  2003/02/02 20:29:37  ralph
  Small enhancements and fixes done in Brechen.

  Revision 4.4  2003/01/28 21:27:04  ralph roth
  y2k3 and first runtime error fixes

  Revision 4.3  2002/11/20 18:04:03  ralph roth
  WinCVS complains about not checked in version!

  Revision 4.2  2002/09/13 10:13:05  ralph
  Changed ERRORLEVL==1 to ERRORLEVEL 1

  Revision 4.1  2002/09/10 22:13:09  ralph roth
  Cha
  Revision 4.0  2002/09/10 22:05:55  ralph roth
  Ported to win32

  Revision 3.4  2001/12/12 21:52:34  ralph
  Mr2S 1.20, released for VTC scanner test

  Revision 3.3  2001/11/21 21:39:22  Administrator
  Fixed a bug detected by Sunny Mok: When calling mr2s from the root (e.g.
  A: or E:) mr2s crashes. Fixed hopefully :)

  Revision 3.2  2001/11/07 17:49:07  ralph
  Added CVS keywords

  Revision 1.6  2001/08/02 12:40:34  rar_ulm
  1.18 - added IRC/Batch scan engine from RHBVS (virscan.irc).
  Approx 600 new viruses added.

  Revision 1.5  2001/06/25 17:40:23  rar_ulm
  1.17 for VTC test. Added approx 100 VBS/HTML and 100 HLLx viruses

  Revision 1.4  2001/06/09 13:47:04  rar_ulm
  Version 1.16 - VBE/JSE + anti heuristic VBS

  Revision 1.3  2000/12/23 16:33:15  Zimmern
  lock file enhanced

  Revision 1.2  2000/12/23 16:28:59  Zimmern
  rcs 5.7.4
  mr2s 1.14 -> 1.15

  Revision 1.1  2000/12/23 16:25:21  Zimmern
  Initial revision

  ------- old version history -------------------------------------------

  0.97  - rar, added brute force log file scanning
  0.98  - rar, bug fixing for vtc
  0.99  - rar, translated to English, Statistic, GuruHeadLine etc. FIXED WRONG COUNTING!
  1.00  - rar, 12-sept-99, relase 1.00, fixed NT 4.00 NTFS problem
  1.01  - rar, 14-nov-99
  1.02  - rar, 11-april-2000, only signature update from RHBVS, lChk>0 - rar, 06-May-2000, released
  1.03 - ah, fixed counter bug, adding semaphor file and changed the output style
  1.03p2 - rar, 04-aug-99, fixed wherey-1
  1.10  - rar, 04-June-2000, source code released, 600 new trojans, 100 new viruses added. Check added if dir is empty
  1.11  - rar, 09-July-2000, new viruses, changed layout of the .OVR files
  1.12  - rar, 17-Aug-2000, new viruses, compiled with FPC 1.00
  1.13  - rar, 13-Sept-2000, new viruses, Win32 Stealth Live Bait test
  1.14  - rar, 03-Dec-2000, new viruses, rewritten mr2s_rs/ants engine
        - rar, 23-Dec-2000, put into RCS


  Requests:
  - show an percentange indicator
  - port to Linux

  ----------------------------------------------------------------------- }


uses
 crt,

{$IFDEF haak}
unzip, chkpak,
{$ENDIF}
 rStrings, r_utils, {nt bug paramstr(0)}
{$IFDEF ROSE}
 test286, syserr,
{$ENDIF}
 {$IFDEF WINDOWS} windows,{$ENDIF}
dos;

Const
{$i regnr.inc}
NAME  = 'Mr2S'{$IFDEF FPC}+'/32'{$ELSE}+'/16'{$ENDIF}
                +' - Version 2.0.0-Final';


Var report : string;
    r, lock: text;
    lDirs, lChk, lFound : longint;
    t, v : Byte;
    szHomeDir : String;         { whereis mr2s.exe? }


{ ####################   Routinen   ######################## }

Function Mr2S_UpString(st : String) : string; {Hinweis: Ohne Umlaute!!!}

Var lauf1 : byte;
Begin
  For lauf1:=1 To length(st) Do
    st[lauf1] := upcase(st[lauf1]);
  Mr2S_UpString := st;
End;

(* ************************************************************************ *)

{$IFDEF WINDOWS}
function GetFullName(FileName: string): string;
var
  pFileName: array [0..2048] of char;
  pFile : LPSTR;
begin
  GetFullPathName(pchar(FileName), 2048, pFileName, pFile);
  Result := strpas(pFileName);
end;

function GetShortName(FileName: string): string;
var
  pFileName: array [0..2048] of char;
begin
  GetShortPathName(pchar(FileName), pFileName, 2048);
  Result := strpas(pFileName);
end;
{$ELSE}
function GetFullName(szFileName: string): string;

begin { GetFullName }
   GetFullName := Mr2S_UpString(szFileName);
end; { GetFullName }


function GetShortName(szFileName: string): string;

begin { GetShortName }
   GetShortName := Mr2S_UpString(szFileName);
end; { GetShortName }
{$ENDIF}


(* ************************************************************************ *)

Function FileExists(FileName: String): Boolean;

Var
  F: file;

Begin
  {$I-}
  Assign(F, FileName);
  Reset(F);
  Close(F);
  {$I+}
  FileExists := (IOResult = 0) And (FileName <> '');
End;  { FileExists }

{ --- [Writeln1 ] ------------------------------------------------------- }

Procedure writeln1(szWhat: String); { 17.03.96, rar }

Begin
     For t := 1 To length(szWhat) Do
       Begin
          v := byte(szWhat[t]);
          textcolor(7);
          If v < 48 Then textcolor(3);
          If v In [91..96] Then textcolor(3+8);
          If v > 122 Then textcolor(1+8);
          If v = 254 Then textcolor(white);
          (* if (chr(v) in ['A'..'Z']) then textcolor(11); *)
          write(szWhat[t]);
       End;
     textcolor(7);
     writeln;

End; { writeln1 }

Procedure write1(szWas: String); { 17.03.96, rar }

Begin
     For t := 1 To length(szWas) Do
       Begin
          v := byte(szWas[t]);
          textcolor(7);
          If v < 48 Then textcolor(3);
          If v In [91..96] Then textcolor(3+8);
          If v > 122 Then textcolor(1+8);
          If v = 254 Then textcolor(white);
          (* if (chr(v) in ['A'..'Z']) then textcolor(11); *)
          write(szWas[t]);
       End;
     textcolor(7);

End; { write1 }

{ --- [Statistik] --------------------------------------------------------- }

Procedure Statistik;  { 08.01.97, rar }

Var s : String;

 Function sFormat(l : LongInt) : String;

 Var s : String;

 Begin { format }
   s := Format(l);
   while length(s) < 10 Do s := ' '+s;
   sFormat := s;
 End; { format }

Begin { Statistik }
   clreol;
   writeln;
   writeln1(GuruHeadLine('Statistics'));
   writeln;
   writeln1(' Files checked ................................ '+sformat(lChk));
   If lChk>0 Then str(lFound*100 / lChk:3:1,s) { fpc100 }
            Else s := '0.0';
   writeln1(' Suspicious files ............................. '+sformat(lFound)+'  ('+s+
   '%)');
   writeln1(' Directories scanned .......................... '+sformat(lDirs));
   writeln;
   writeln1(GuruHeadLine('Scanning finished! Have a virus free time!'));

End; { Statistik }


{ ------------------------------------------------------------------------ }
{ Call - Working Horse - Call all scanners, read the logs and process them }
{ ------------------------------------------------------------------------ }

Procedure call(wo : String);  { am, 15.05.99 }

Var t,t2   : text;
    lauf   : integer;
    st,st2 : string;      { fixed, 17.05.99, rar }
    i, n   : integer;
    n1, n2 : Byte;
    szF1, szF2 : String;  { filename from the files1 & files2 }
    szV1, szV2 : String;  { Virus, if found }
    sr         : SearchRec;
    szWoS      : String;

Begin

  findfirst(wo+'*.*', anyfile-directory-volumeid, sr);

  If (doserror = 18) Then  { nothing to do! }
       exit;               { q'n'd speed up, rar 6.june.2000 }

  gotoxy(1,wherey);             { new for mr2s/32 }
  textcolor(lightgray);
  szWoS := GetShortName(wo);
  write(szWoS);  { \ Vernderte Verzeichnisausgabe (ah) }
  clreol;        { /                                    }

   swapvectors;
{writeln('tscan');}
   exec(szHomeDir+'\mr2ssub1.exe',szWoS);
{writeln('mr2s_rs');}
   exec(szHomeDir+'\mr2ssub2.exe',szWoS);
   swapvectors;

  {$I-}
  assign(t,'sub1.rep');                         { <---- $$$$$$$$$$$$$$$ }
  reset(t);

  For lauf:=1 To 2 Do
    readln(t,st);   { tscan }

  readln(t, st);
  st := TrimR(st);

  If (st<>'') Then
    Repeat
      inc(lChk);

      n1 := Pos(' - ',st);
      If n1 = 0 { found? }
        Then n1 := 255;

      szF1 := TrimR(copy(st, 1, n1));

    { brute force from beginning }
      assign(t2,'mr2ssub2.rep');
      reset(t2);
      Repeat
          readln(t2, st2);
          n2 := Pos(' - ',st2);
          If n2 = 0 { found? }
             Then n2 := 255;

          szF2 := TrimR(copy(st2, 1, n2));

    { -- debug -- }
    { writeln(r, 'FN: //',szf1,'//',szf2,'//'); }

      Until eof(t2) Or (szF1 = szF2);
      close(t2);

    { ok, now cat them together

      szF1 = szF2 = FileName
      n1, n2 - pos of Virus

    }

      szV1 := copy(st, n1+3, 255);
      szV2 := copy(st2, n2+3, 255);


    { -- debug -- }
    { writeln(r, 'VN: //',szv1,'//',szv2,'//'); }

      st := GetFullName(szF1);

      If szV2 <> '' Then
        Begin
          If szV1 = '' Then st := st + ' - ' + szV2
                      Else st := st + ' - ' + szV1 + ' ('+szV2+')';
        End
       Else
         If szV1 <> '' Then st := st + ' - ' + szV1;

 { -------------------------------------------------------------- }

      If pos(' - ',st)<>0 Then
        Begin
          textcolor(red);

      { --- VSP/RHBVS don`t uses "Infektion" --- }
          If (Pos('Infektion: ', st) = 0) And (Pos('Warnung', st) = 0)
             And (Pos('Fehler', st) = 0) Then
            Begin
              n := Pos(' - ', st);
              st := copy(st, 1, n+2)+'Infektion: '+copy(st,n+3,255);
            End;

          n := Pos('Infektion:', st);
          If n > 1 Then
            Begin
                         inc(lFound);
                         st[n+4] := 'c';  { Infection }
                    End;
          writeln(st);                   { Ausgabe falls Virus gefunden }
        End
      Else textcolor(lightgray);

      If report<>'' Then writeln(r,st);
      readln(t, st);

    Until (st='') Or eof(t);

  close(t);
  { ------------------------ aufrumen -------------------- }
  If ioresult <> 0 Then { mr2s_rs: sux };

{  write('OK?'); readln; }

  erase(t2);
  erase(t);

{$I-}
  i := ioresult;
  If i<>0 Then
    Begin
      textcolor(lightred);
      writeln(#7'!!! Fatal: Mr2S I/O-Error !!!'#7);
      textcolor(lightgray);

    End;
End;

{ ------------------------------------------------------------------ }

Procedure SucheDateien(p : String);


   Var gg : searchrec;

begin { SucheDateien }
  inc(lDirs);
  If p[length(p)]<>SLASH
        Then p := Mr2S_UpString(p)+SLASH
        Else p := Mr2S_UpString(p);
  findfirst(p+'*.*',anyfile,gg);
  while (doserror=0) Do
  Begin
    With gg Do
      Begin
        If (name[1]<>#46) And ((attr And volumeid)=0) Then
          Begin
            If attr And directory=0 Then
              Begin

          { skip files! }

              End
            Else
              Begin
          {$IFDEF HAAK}
                chkpak(p+name+SLASH);
          {$ENDIF}
                call(p+name+SLASH);
                suchedateien(p+name+SLASH); {rekursiv}
              End;
          End;
      End;
    findnext(gg);
  End;
end; { SucheDateien }

{ ------------------------------------------------------------------ }

Procedure Scanne(p : String);

begin { Scanne }
  { p := Mr2S_UpString(p); }
  {$ifdef VERBOSE}
  writeln('Directory to scan: '+p);
  writeln;
  {$endif}

  p := Mr2S_UpString(p);
  If p[length(p)]<>SLASH Then p := p+SLASH;
  call(p);
  suchedateien(p);

  gotoxy(1,wherey);
  clreol;
end; { Scanne }

{ ------------------------------------------------------------------ }

Var path : String;
    antwort: char;

Begin
  lDirs := 0;
  lChk := 0;
  lFound := 0;

  writeln;
  writeln1(GuruHeadLine('Mr. Double Scan - '+NAME+'-'+ KillSpace(format(BUILD_MR2S))+' - '+Reg_Datum));
  writeln ('(c) 1989-2005 by Andreas Haak, Andreas Marx & Ralph Roth - ALL RIGHTS RESERVED!');

  { deletefile('lock.dat'); }
  If fileexists('lock.dat') Then
    Begin
      writeln;
      writeln1('A lock file was found. Do NOT start Mr2S in several tasks!');
      writeln1('If you continue and Mr2S is still active, Mr2S will crash!');
      write1('Do you want to continue (y/N) ?');
      antwort := readkey;
      writeln1(antwort);
      If upcase(antwort)<>'Y' Then halt(1);
    End;

  assign(lock, 'lock.dat');
  rewrite(lock);
  writeln(lock, 'MrDoubleScan - LockFile! Please do not delete!');
  writeln(lock, '$Header: /home/CVS/tp/MARX/MR2S.PAS,v 4.13 2005/02/18 21:36:21 ralproth Exp $');
  writeln(lock, datum,'/',time);
  writeln('ParamStr(1) = ', ParamStr(1));
  close(lock);

  GetDir(0, szHomeDir);
  if (length(szHomeDir) = 3) then       { fix, 1.19b - sunny mok }
    szHomeDir := copy(szHomeDir, 1, 2);

  swapvectors;
  exec(szHomeDir+'\mr2s_chk.ovr','');
  swapvectors;
  writeln;

  If paramcount=0 Then
    Begin
      writeln1(GuruHeadLine('Usage'));
      writeln ('mr2s   drive:\[path2scan]   [name_of_logfile]');
      writeln;
      writeln ('Internal version $Id: MR2S.PAS,v 4.13 2005/02/18 21:36:21 ralproth Exp $');
      {$Ifdef VERBOSE} writeln('Verbose/Debug version! HomeDir=', szHomeDir); {$endif}
      erase(lock);
      halt(1);
    End;
  path := paramstr(1);
  If paramcount=2 Then report := paramstr(2)
  Else report := '';

  If report<>'' Then
    Begin
      assign(r,report);
      rewrite(r);

      writeln(r);
      writeln(r,'--- ',Name,' --- Report --- START ---');
      writeln(r);
    End;

  writeln1(GuruHeadLine(Path));
  scanne(path);

  Statistik;

  If report<>'' Then
    Begin
      writeln(r);
      writeln(r,'--- ',name,' --- Report --- END ---');
      writeln(r);

      writeln(r,'Directories scanned: ',lDirs);
      If lChk <> 0 Then
        writeln(r,'Files scanned: '+Format(lChk)+', suspious: '+Format(lFound)
           +' (',(lFound*100 / lChk): 2: 2,'%)');   { fpc100 }
      writeln(r,#13#10);

      close(r);
    End;
  erase(lock);

  close(OutPut);
  chdir(szHomeDir);

End.
