#!/usr/bin/perl
#
#	(c) FRISK Software International
#	author: Svavar Ingi Hermannsson 2003
#
#	http://www.f-prot.com
#
#	This is an installation script for F - Prot Antivirus for Unix.
use strict;
use Cwd;
eval 'use warnings';

my $manDirectory 	= "";
my $fileCheckStatus	= 1;
my $creationMask	= 0755;
my $binDirectory 	= "";
my $sbinDirectory 	= "";
my $man8Directory 	= "";
my $man1Directory 	= "";
my $sourceDirectory 	= "/usr/local/f-prot/";
my $currentDirectory	= "";
my $readLine		= "";
my $OperatingSystem;
my $HardwarePlatform;

## Posible distributions:
##
##	rh:		RedHat
##	suse: 		SuSE
##	deb: 		Debian
##	md: 		Mandrake
##	undefined: 	(Unknown)
my $distro		= "";

## fprotVersion: 
##
## 	- Workstation
## 	- File Server
## 	- Mail Server
my $fprotVersion 	= 'workstation';

sub detectFprotVersion
{
	if ($OperatingSystem =~ /openbsd/i)
	{
		if (-e $sourceDirectory . "f-protd-openbsd" . $distro)
		{
			$fprotVersion = 'File Server';
		}
	}
	else
	{
		if (-e $sourceDirectory . "f-protd")
		{
			$fprotVersion = 'File Server';
		}
	}
	if (-e $sourceDirectory . "tools/scan-mail.pl")
	{
		$fprotVersion = 'Mail Server';
	}
}

## This is a sub function which explains why unzip is needed, if 
## the checkForUnzip sub function was unable to locate it.
sub noticeUnzip
{
	print "Warning: Unable to locate unzip. This program is required\n"
		. "\tin order to be able to run the check-updates.pl script\n"
		. "\tto check for virus signature updates.\n\n";
}

## This is a sub function which tries to locate unzip.
sub checkForUnzip
{
	open (UNZIPCHECK, "which unzip|");
	while ($readLine = <UNZIPCHECK>)
	{
		if ($readLine != "")
		{
			if ($readLine =~ /no unzip/i || $readLine =~ /:/)
			{
				&noticeUnzip;
				return;
			}
		}
	}
}

sub getBinSymbolicLink
{
	my $newBin;
	my $answer;
        $binDirectory = "/bin/";
        if (-e "/usr/local/bin/")
        {
                $binDirectory = "/usr/local/bin/";
        }

        print "Where do you want a symbolic link for F - Prot Antivirus to be generated?\n[" . $binDirectory . "] : ";
        while (1)
	{
		chop($newBin = <STDIN>);
		if ($newBin eq "" && -e $binDirectory)
		{
			return;
		}
		elsif ($newBin eq "")
		{
			print "You must provide a location for the symbolic link location.\n[" . $binDirectory . "] : ";
        	}
		else
		{
			## Here you make sure the user passed a trailing slash/ for the directory
			if (substr($newBin, length($newBin) - 1, 1) ne "/")
			{
				$newBin = $newBin . "/";
			}
			## If the supplied directory exists, you are done.
			if (-e $newBin)
			{
        	        	$binDirectory = $newBin;
				return;
			}

			## The supplied directory does not exist.
			## Do you wish to create it ?
			print "The directory: '" . $newBin . "' does not exist. Do you want to create it? (y/N): ";
			chop($answer = <STDIN>);
			if ($answer =~ /y/i)
			{
				mkdir ($newBin, $creationMask) || 
					die "Error: Unable to create directory: $newBin\nError: $!\n\n"
						. "Exiting...\n";
				$binDirectory = $newBin;
				return;
			}
			else
			{
				print "You must provide a location for the symbolic link location.\n[" 
					. $binDirectory . "] : ";
			}
		}
	}
}

sub getMan8SymbolicLink
{
	my $newMan8 	= "";
	my $answer 	= "";
	## Here you ask for the location of the system administration manuals (man8).
	if (-e "/usr/local/man/man8")
	{
		$man8Directory = "/usr/local/man/man8/";
	}
	elsif (-e "/usr/share/man/man8")
	{
		$man8Directory = "/usr/share/man/man8/";
	}

	print "Where do you want the symbolic links for section 8 manuals to be generated (man8)?\n"
		. "[" . $man8Directory . "] : ";
	while (1)
	{
		chop($newMan8 = <STDIN>);
		if ($newMan8 eq "" && -e $man8Directory)
		{
			return;
		}
		elsif ($newMan8 eq "")
		{
			print "You need to supply a valid entry for the location of symbolic links for your manual pages.\n"
				. "[" . $man8Directory . "] : ";
		}
		else
		{
			if (substr($newMan8, length($newMan8) - 1, 1) ne "/")
			{
				$newMan8 = $newMan8 . "/";
			}

			## If the supplied directory exists, you are done.
			if ( -e $newMan8)
			{
				$man8Directory = $newMan8;
				return;
			}

			## The supplied directory does not exist.
			## Do you want to create it?
			print "The directory: '" . $newMan8 . "' does not exist. Do you want to create it? (y/N): ";
			chop($answer = <STDIN>);
			if ($answer =~ /y/i)
			{
				mkdir ($newMan8, $creationMask) ||
					die "Error: Unable to create directory: $newMan8\nError: $!\n\n"
						. "Exiting...\n";
				$man8Directory = $newMan8;
				return;
			}
			else
			{
				print "You need to supply a valid entry for the location of symbolic links for \n"
					. "your manual pages.\n"
				. "[" . $man8Directory . "] : ";
			}
		}
	}
}

sub getMan1SymbolicLink
{
	my $newMan1 	= "";
	my $answer 	= "";
        ## Here you ask for the location of the executable programs manuals (man1).
        if (-e "/usr/local/man/man1")
        {
                $man1Directory = "/usr/local/man/man1/";
        }
        elsif (-e "/usr/share/man/man1")
        {
                $man1Directory = "/usr/share/man/man1/";
        }

        print "Where do you want the symbolic links for the manuals for executable programs to be generated (man1)?\n"
		. "[" . $man1Directory . "] : ";
	while (1)
	{
		chop($newMan1 = <STDIN>);
		if ($newMan1 eq "" && -e $man1Directory)
		{
			return;
		}
		elsif($newMan1 eq "")
		{
			print "You need to supply a valid entry for the location of symbolic links for your manual pages.\n"
				. "[" . $man1Directory . "] : ";
		}
		else
		{	
			if (substr($newMan1, length($newMan1) - 1, 1) ne "/")
			{
				$newMan1 = $newMan1 . "/";
			} 

			if (-e $newMan1)
			{
				$man1Directory = $newMan1;
				return;
			}

			## The supplied directory does not exist.
			## Do you want to create it?
			print "The directory: '" . $newMan1 . "' does not exist. Do you want to create it? (y/N): ";
			chop($answer = <STDIN>);
			if ($answer =~ /y/)
			{
				mkdir($newMan1, $creationMask) ||
					die "Error: Unable to create directory: $newMan1\nError: $!\n\n"
						. "Exiting...\n";
				$man1Directory = $newMan1;
				return;
			}
			else
			{
				print "You need to supply a valid entry for the location of symbolic links for\n"
					. "your manual pages.\n"
				. "[" . $man1Directory . "] : ";
			}
		}
	}
}

sub getSbinSymbolicLink
{
	my $answer;
	my $newSbin;
	$sbinDirectory  = "/sbin/";

	if (-e "/usr/local/sbin/")
	{
		$sbinDirectory = "/usr/local/sbin/";
	}
	print "Where do you want a symbolic link for the F - Prot Antivirus Daemon Scanner (f-protd) to be generated?\n"
		. "[" . $sbinDirectory . "] : ";
	while (1)
	{
		chop($newSbin = <STDIN>);
		if ($newSbin eq "" && -e $sbinDirectory)
		{
			return;
		}
		elsif($newSbin eq "")
		{
			print "You need to supply a valid entry for the symbolic link to be placed for f-protd .\n"
				. "[" . $sbinDirectory . "] : ";
			return;
		}
		else
		{
			if (substr($newSbin, length($newSbin) - 1, 1) ne "/")
			{
				$newSbin = $newSbin . "/";
			}

			if (-e $newSbin)
			{
				$sbinDirectory = $newSbin;
				return;
			}

			## The supplied directory does not exist.
			## Do you wish to create it?
			print "The directory: '" . $newSbin . "' does not exist. Do you want to create it? (y/N): ";
			chop ($answer = <STDIN>);
			if ($answer =~ /y/i)
			{
				mkdir($newSbin, $creationMask) ||
					die "Error: Unable to create directory: $newSbin\nError: $!\n\n"
						. "Exiting...\n";
				$sbinDirectory = $newSbin;
				return;
			}
			else
			{
				print "You need to supply a valid entry for the f-protd symbolic link to be placed\n"
					. "[" . $sbinDirectory . "] : "; 
			}

		}
	}
}

## You will only accept /usr/local/f-prot as the source directory.
sub getSourceLocation
{
	my $newSource = getcwd() . "/";
	if ($newSource ne $sourceDirectory)
        {
		die 	"This installation script for F - Prot Antivirus only supports installation from:\n"
			. "\t" . $sourceDirectory . "\n\n"
			. "Please decompress the F - Prot Antivirus $fprotVersion under /usr/local,\n"
			. "so that once extracted it will become:\n\n"
			. "\t/usr/local/f-prot. \n(This is particularly useful since all our documentation,\n"
			. "manuals and support services assume this location.)\n\n"
			. "If you want to install f-prot into another directory, you will need to do it manually.\n"
			. "(for further information on manual installation, read the HTML help-file.\n"
			. "The latest version of the HTML help-file is always available at \n"
			. "\thttp://www.f-prot.com/support/helpfiles/unix )\n"
			. "\nPlease decompress the f-prot " . $fprotVersion . " distribution under /usr/local/\n"
			. "and try re-running this script again from within the created directory:\n"
			. "\t/usr/local/f-prot\n\nExiting...\n";
        }
}

sub getDistribution
{
	$OperatingSystem = `uname -s`;
	chop($OperatingSystem);

	$HardwarePlatform = `uname -m`;
	chop($HardwarePlatform);

	if ($OperatingSystem =~ /linux/i)
	{
		if (-e "/etc/redhat-release")
		{
			## This is a Red Hat distribution.
			$distro = 'rh';
			return;
		}

		if (-e "/etc/SuSE-release")
		{
			## This is a SuSE distribution.
			$distro = 'suse';
			return;
		}

		if (-e "/etc/mandrake-release")
		{
			## This is a Mandrake distribution.
			$distro = 'md';
			return;
		}
	
		if (-e "/etc/debian_version")
		{
			## This is a Debian distribution.
			$distro = 'deb';
			return;
		}
	}	
	if ($OperatingSystem =~ /openbsd/i)
	{
		$distro = `uname -r`;
		chop($distro);
		my @obsdVersion = split(/\./, $distro);
		if (@obsdVersion != 2)
		{
			print "Error while getting Operating System version information.\n"
				. "Exiting...\n";
			exit(-1);
		}

		# For future versions of OpenBSD when they go to 4.x (assuming 3.4 will stay
		# compatible.
		if ($obsdVersion[0] > 3)
		{
			$distro = "3.4";
			return;
		}
		elsif ($obsdVersion[0] < 3)
		{
			print "Error: Unsupported platform.\nExiting...\n";
			exit(1);
		}
		elsif ($obsdVersion[1] >= 4)
		{
			$distro = "3.4";
			return;
		}
		else
		{
			$distro = "3.3";
		}

		return;
	}
	## If you were unable to discover which distribution you have..
	$distro = 'undefined';
	return;
}

sub startingConfiguration
{
	print 	"\n######################################################\n"
		. "# You are starting the configuration part of the:    #\n"
		. "#     F - Prot Antivirus installation.               #\n"
		. "######################################################\n\n";
}

sub configureInstallation
{
	&startingConfiguration;
	&getSourceLocation;
	&getBinSymbolicLink;
	&getMan8SymbolicLink;
	&getMan1SymbolicLink;

	## If you have either the File Server or Mail Server version of 
	## F - Prot Antivirus, you'll need to set up the daemon as well. 
	## (If not you've done all you need to do.)
	if ($fprotVersion =~ /workstation/i)
	{
		return;
	}
	&getSbinSymbolicLink;
}

sub checkForPreExistingFoldersAndLinks
{
	if ( -e "/usr/local/f-prot")
	{
		print "/usr/local/f-prot/ already exists\n";
	}
}

sub printWelcome
{
	print "(c) FRISK Software International\n\nhttp://www.f-prot.com/\n\n";
	print "\tF - Prot Antivirus - $fprotVersion - for Unix.\n\n"
	
}

## This sub function takes three arguments:
##	$sourceFile
##	$destDir
##	$destFile
##
## this function should be called like the following:
##
## &linkFile("sourceFile", "destinationdirectory/", "destinationFile");
sub linkFile
{
	my $sourceFile	= $_[0];
	my $destDir 	= $_[1];
	my $destFile 	= $_[2];
	my $answer	= "";

	print "Setting up symbolic link: " . $destDir . $destFile . ": ";
	if (-l $destDir . $destFile || -e _)
	{
		if (-l $destDir . $destFile)
		{
			my $preExistingLink = readlink($destDir . $destFile) ||
				die "Unable to read already existing symbolic link: '" . $destDir . $destFile
					. "\nError: " . $! . "\nExiting...\n";
			if ($preExistingLink eq $sourceDirectory . $sourceFile)
			{
				print "\n\t(symbolic link already exists) Continuing...\n";
				return
			}
			else
			{
				## There's no reason to let the user know about this.
				unlink($destDir . $destFile) ||
					die "Unable to remove pre-existing link: '" . $destDir . $destFile
						. "'\nError: " . $! . "\nExiting...\n";
				## If you were able to unlink without problems, you'll continue down
				## to the symlink bellow.
			}
		}
		elsif (-d $destDir . $destFile)
		{
			print "A directory already exists with the same name. Do you want to remove it (Y/n): ";
			chop($answer = <STDIN>);
			if ($answer =~ /n/i)
			{
				## If you don't want to remove the directory.
				die "A directory already exists where you wanted to place a symbolic link:\n"
					. "\t" . $destDir . $destFile . "/\n"
					. "Remove the directory or choose a different location for your binary symbolic link"
					. "\nExiting...\n";
			}

			## You wish to remove the directory. (Here you assume the directory is empty)
			rmdir($destDir . $destFile) ||
				die "Unable to remove directory: " . $destDir . $destFile
					. "/\nError: " . $! . "\nExiting...\n";

			## If you were able to remove the directory you'll continue.
		}
		else
		{
			print $destDir . $destFile . " already exists.\nDo you want to remove it? (y/N): ";
			chop($answer = <STDIN>);
			if ($answer =~ /y/i)
			{
				unlink($destDir . $destFile) ||
					die "Unable to remove file: '" . $destDir . $destFile
						. "\nError: " . $! . "\nExiting...\n";
			}
			else
			{
				&unSupportedEvent;
			}
		}
	}

	## No symbolic link exists so you can create it.
	symlink($sourceDirectory . $sourceFile, $destDir . $destFile) || 
		die "Unable to create symbolic link: '" . $destDir . $destFile . "\nError: '" . $! . "\nExiting...\n";
	print "OK.\n";
}

sub unSupportedEvent
{
	die "An event has occurred which this installation script does not support.\n"
		. "Please consult the manual installation instructions in the HTML help-file\n"
		. "(The latest version of the HTML help-file is always available at\n"
		. "\thttp://www.f-prot.com/support/helpfiles/unix) for\n"
		. "information on how to install F - Prot manually, or try re-running this script.\n"
		. "Exiting...\n";
}

sub makeFprotExecutable
{
	print "\n\nChanging file permissions:\n\n";
	if ($OperatingSystem =~ /openbsd/i)
	{
		chmod(0755, $sourceDirectory . "f-prot-openbsd" . $distro) || 
			die "Unable to change file permissions of " . $sourceDirectory . "f-prot-openbsd" . $distro . "\n"
			. "Error: " . $! . "\nExiting...\n";
		print "File permissions: " . $sourceDirectory . "f-prot-openbsd" . $distro . " rwxr-x-r-x\tOK.\n";
	}
	else
	{
		chmod(0755, $sourceDirectory . "f-prot") || 
			die "Unable to change file permissions of " . $sourceDirectory . "f-prot\n"
			. "Error: " . $! . "\nExiting...\n";
		print "File permissions: " . $sourceDirectory . "f-prot rwxr-x-r-x\tOK.\n";
	}

	chmod(0700, $sourceDirectory . "tools/check-updates.pl") ||
		die "Unable to change file permissions of " . $sourceDirectory . "tools/check-updates.pl\n"
			. "Error: " . $! . "\nExiting...\n";
	print "File permissions: " . $sourceDirectory . "tools/check-updates.pl rwx------\tOK.\n";

	if ($fprotVersion =~ /workstation/i)
	{
		return;
	}

	if ($OperatingSystem =~ /openbsd/i)
	{
		chmod(0755, $sourceDirectory . "f-protd-openbsd" . $distro) ||
			die "Unable to change file permissions of " . $sourceDirectory . "f-protd-openbsd" . $distro . "\n"
				. "Error: " . $! . "\nExiting...\n";

		print "File permissions: " . $sourceDirectory . "f-protd-openbsd" . $distro . " rwxr-xr-x\tOK.\n";
	}
	else
	{
		chmod(0755, $sourceDirectory . "f-protd") ||
			die "Unable to change file permissions of " . $sourceDirectory . "f-protd\n"
				. "Error: " . $! . "\nExiting...\n";
		print "File permissions: " . $sourceDirectory . "f-protd rwxr-xr-x\tOK.\n";
	}

	if ($fprotVersion =~ /file server/i)
	{
		return;
	}

	if ($OperatingSystem =~ /openbsd/i)
	{
		chmod(0755, $sourceDirectory . "tools/f-prot-qmail-openbsd" . $distro) ||
			die "Unable to change file permissions of " . $sourceDirectory . "tools/f-prot-qmail-openbsd" . $distro . "\n"
				. "Error: " . $! . "\nExiting...\n";
		print "File permissions: " . $sourceDirectory . "tools/f-prot-qmail-openbsd" . $distro . " rwxr-xr-x\tOK.\n";
		chmod(0755, $sourceDirectory . "tools/f-prot-milter-openbsd" . $distro) ||
			die "Unable to change file permissions of " . $sourceDirectory . "tools/f-prot-milter-openbsd" . $distro . "\n"
				. "Error: " . $! . "\nExiting...\n";
		print "File permissions: " . $sourceDirectory . "tools/f-prot-milter-openbsd" . $distro . " rwxr-xr-x\tOK.\n";
	}
	else
	{
		if ($OperatingSystem =~ /aix/i)
		{
			## Do nothing for qmail/milter plugins.
		}
		else
		{
			chmod(0755, $sourceDirectory . "tools/f-prot-qmail") ||
				die "Unable to change file permissions of " . $sourceDirectory . "tools/f-prot-qmail\n"
					. "Error: " . $! . "\nExiting...\n";
			print "File permissions: " . $sourceDirectory . "tools/f-prot-qmail rwxr-xr-x\tOK.\n";
	
			chmod(0755, $sourceDirectory . "tools/f-prot-milter") ||
				die "Unable to change file permissions of " . $sourceDirectory . "tools/f-prot-milter\n"
					. "Error: " . $! . "\nExiting...\n";
			print "File permissions: " . $sourceDirectory . "tools/f-prot-milter rwxr-xr-x\tOK.\n";
		}
	}

	chmod(0755, $sourceDirectory . "tools/scan-mail.pl") ||
		die "Unable to change file permissions of " . $sourceDirectory . "tools/scan-mail.pl\n"
			. "Error: " . $! . "\nExiting...\n";
	print "File permissions: " . $sourceDirectory . "tools/scan-mail.pl rwxr-xr-x\tOK.\n";

	## You're done.
	return;
}

sub copyRCFile
{
	@_;
	my $sourceFile = $_[0];
	my $destinationFile = $_[1];
	open(SOURCE, $sourceFile) || die "Unable to open source RC file: '" . $sourceFile . "'\n"
		. "Error: " . $! . "\nExiting...\n";
	open(DESTINATION, ">$destinationFile") || die "Unable to open destination RC file: '" . $destinationFile . "'\n"
		. "Error: " . $! . "\nExiting...\n";

	while (<SOURCE>)
	{
		print DESTINATION $_;
	}
	close (SOURCE);
	close (DESTINATION);
	chmod(0755, $destinationFile) ||
		die "Unable to change file permissions of: '" . $destinationFile . "'\n"
			. "Error: " . $! . "\nExiting...\n";
}

sub askStartFprotdNow
{
	my $answer = "";
	print "Do you want to activate the F-Prot Antivirus daemon automatically now and\n"
		. "everytime your system is rebooted? (Y/n): ";
	chop($answer = <STDIN>);
	if ($answer =~ /n/i)
	{
		return 0;
	}

	return 1;
}

sub askStartScanmailNow
{
	my $answer = "";
	print "Do you want to activate the scan-mail daemon automatically now and everytime your system is\n"
		. "rebooted? (Y/n): ";
	chop($answer = <STDIN>);
	if ($answer =~ /n/i)
	{
		return 0;
	}

	return 1;
}

sub linkRCFiles
{
	my $scanmailActivated = 0;
	if ($distro =~ /rh/i)
	{
		&copyRCFile($sourceDirectory . "tools/rc_scripts/f-protd.rc-redhat", "/etc/rc.d/init.d/f-protd");
		if ($fprotVersion =~ /mail server/i)
		{
			&copyRCFile($sourceDirectory . "tools/rc_scripts/scan-mail.rc.redhat", "/etc/rc.d/init.d/scan-mail");
		}
		if ( &askStartFprotdNow )
		{
			system("chkconfig --add f-protd");
			system("/etc/rc.d/init.d/f-protd start");
			if ($fprotVersion =~ /mail server/i)
			{
				if (&askStartScanmailNow)
				{
					system("chkconfig --add scan-mail");
					system("/etc/rc.d/init.d/scan-mail start");
					$scanmailActivated = 10;
				}
				else
				{
					$scanmailActivated = 5;
				}
			}
		}
		else
		{
			$scanmailActivated = 1;
		}
	}
	elsif ($distro =~ /suse/i)
	{
		&copyRCFile($sourceDirectory . "tools/rc_scripts/f-protd.rc-suse", "/etc/rc.d/f-protd");
		if ($fprotVersion =~ /mail server/i)
		{
			&copyRCFile($sourceDirectory . "tools/rc_scripts/scan-mail.rc.suse", "/etc/rc.d/scan-mail");
		}
		if ( &askStartFprotdNow )
		{
			system("chkconfig f-protd on");
			if ($fprotVersion =~ /mail server/i)
			{
				if (&askStartScanmailNow)
				{
					system("chkconfig scan-mail on");
					$scanmailActivated = 10;
				}
				else
				{
					$scanmailActivated = 5;
				}
			}
			system("/sbin/SuSEconfig");
			system("/etc/rc.d/f-protd start");
			if ($scanmailActivated == 10)
			{
				system("/etc/rc.d/scan-mail start");
			}
		}
		else
		{
			$scanmailActivated = 1;
		}
	}
	elsif ($distro =~ /deb/i)
	{
		&copyRCFile($sourceDirectory . "tools/rc_scripts/f-protd.rc-debian", "/etc/init.d/f-protd");
		if ($fprotVersion =~ /mail server/i)
		{
			&copyRCFile($sourceDirectory . "tools/rc_scripts/scan-mail.rc.debian", "/etc/init.d/scan-mail");
		}
		if ( &askStartFprotdNow)
		{
			system("/etc/init.d/f-protd start");
			print "You need to create links from the runlevel directories (f.ex. /etc/rc3.d)\n"
				. "to /etc/init.d/f-protd\n";
			if ($fprotVersion =~ /mail server/i)
			{
				if(&askStartScanmailNow)
				{
					system("/etc/init.d/scan-mail start");
					print "You need to create links from the runlevel directories (f.ex. /etc/rc3.d)\n"
					. "to /etc/init.d/scan-mail\n";
					$scanmailActivated = 10;
				}
				else
				{
					$scanmailActivated = 5;
				}
			}
		}
		else
		{
			$scanmailActivated = 1;
		}
	}
	elsif ($distro =~ /md/i)
	{
		&copyRCFile($sourceDirectory . "tools/rc_scripts/f-protd.rc-mandrake", "/etc/rc.d/init.d/f-protd");
		if ( &askFprotdNow )
		{
			system("chkconfig --add f-protd start");
			system("/etc/rc.d/init.d/f-protd start");
		}
	}
	else
	{
		if ($fprotVersion =~ /mail server/i)
		{
			print "You will need to modify the rc-files manually to make them work with your distribution\n"
				. "Consult the HTML help-file. (The latest version of the HTML help-file is always\n"
				. "available at\n\t http://www.f-prot.com/support/helpfiles/unix ) for further information.\n";
		}
	}

	if ($scanmailActivated > 0 && $scanmailActivated < 10 && $fprotVersion =~ /mail server/i)
	{
		print "WARNING: You have NOT configured scan-mail yet.\n\n";
		print "IMPORTANT:\tthe first time you call /etc/init.d/scan-mail.pl start, you will be\n";
		print "\t\tasked to choose between diffrent configuration options. It is important that\n";
		print "\t\tyou configure this script before you try to get it automatically started\n";
		print "\t\tby initd (e.g. next boot). If the scan-mail rc script has not been configured\n";
		print "\t\tbefore it's first time booting. You will be prompted for these configuration\n";
		print "\t\toptions during boot-up.\n";
	}
}

sub startingInstallation
{
	print 	"\n######################################################\n"
		. "# You are starting the installation part of the:     #\n"
		. "#     F - Prot Antivirus installation.               #\n"
		. "######################################################\n\n";
}

sub performInstallation
{
	&startingInstallation;
	if ($OperatingSystem =~ /openbsd/i)
	{
		&linkFile("f-prot-openbsd" . $distro, $sourceDirectory, "f-prot");
	}
	&linkFile("f-prot.sh", $binDirectory, "f-prot");
	&linkFile("man_pages/check-updates.pl.8", $man8Directory, "check-updates.pl.8");
	&linkFile("man_pages/f-prot.1", $man1Directory, "f-prot.1");
	if ($fprotVersion =~ /workstation/i)
	{
		return;
	}
	if ($OperatingSystem =~ /openbsd/i)
	{
		&linkFile("f-protd-openbsd" . $distro, $sourceDirectory, "f-protd");
	}
	&linkFile("man_pages/f-protd.8", $man8Directory, "f-protd.8");
	&linkFile("f-protd", $sbinDirectory, "f-protd");
	if ($OperatingSystem =~ /linux/i && lc($HardwarePlatform) ne "s390")
	{
		&linkFile("man_pages/f-prot.so.8", $man8Directory, "f-prot.so.8");
	}
	if ($OperatingSystem =~ /linux/i)
	{
		&linkRCFiles;
	}
	if ($fprotVersion =~ /file server/i)
	{
		return;
	}
	if ($OperatingSystem =~ /openbsd/i)
	{
		&linkFile("tools/f-prot-qmail-openbsd" . $distro, $sourceDirectory, "tools/f-prot-qmail");
		&linkFile("tools/f-prot-milter-openbsd" . $distro, $sourceDirectory, "tools/f-prot-milter");
	}
	&linkFile("man_pages/scan-mail.pl.8", $man8Directory, "scan-mail.pl.8");
	if ($OperatingSystem =~ /aix/i)
	{
		## Do nothing related to qmail/milter plugins.
	}
	else
	{
		&linkFile("man_pages/f-prot-qmail.8", $man8Directory, "f-prot-milter.8");
		&linkFile("man_pages/f-prot-milter.8", $man8Directory, "f-prot-milter.8");
	}
}

sub installCompleted
{
	print 	"\n######################################################\n"
		. "# Installation of F - Prot Antivirus is completed.   #\n"
		. "######################################################\n\n";
}

sub checkingFiles
{
	print 	"\n######################################################\n"
		. "# You are starting the file-check part of the:       #\n"
		. "#     F - Prot Antivirus installation.               #\n"
		. "######################################################\n\n";
}

sub checkFile
{
	my $fileToCheck = $_[0];
	print "Checking file: '" . $sourceDirectory . $fileToCheck . "': ";
	if (! -e $sourceDirectory . $fileToCheck)
	{
		print "\n\tError: file is missing.\n";
		$fileCheckStatus = 0;
	}
	else
	{
		print "OK.\n";
	}
}


sub checkFiles
{
	&checkingFiles;
	if ($OperatingSystem =~ /openbsd/i)
	{
		&checkFile("f-prot-openbsd" . $distro);
	}
	else
	{
		&checkFile("f-prot");
	}
	&checkFile("man_pages/f-prot.1");
	&checkFile("man_pages/check-updates.pl.8");
	if ($fprotVersion =~ /workstation/i)
	{
		return;
	}
	if ($OperatingSystem =~ /openbsd/i)
	{
		&checkFile("f-protd-openbsd" . $distro);
	}
	else
	{
		&checkFile("f-protd");
	}
	&checkFile("man_pages/f-protd.8");
	if ($OperatingSystem =~ /linux/i && lc($HardwarePlatform) ne "s390")
	{
		&checkFile("tools/f-prot.so");
		&checkFile("man_pages/f-prot.so.8");
	}
	if ($OperatingSystem =~ /linux/i)
	{
		&checkFile("tools/rc_scripts/f-protd.rc-redhat");
		&checkFile("tools/rc_scripts/f-protd.rc-debian");
		&checkFile("tools/rc_scripts/f-protd.rc-suse");
		&checkFile("tools/rc_scripts/f-protd.rc-mandrake");
	}

	if ($fprotVersion =~ /file server/i)
	{
		return;
	}

	&checkFile("tools/scan-mail.pl");
	if ($OperatingSystem =~ /aix/i)
	{
		## Do nothing.
	}
	elsif ($OperatingSystem =~ /openbsd/i)
	{
		&checkFile("tools/f-prot-qmail-openbsd" . $distro);
		&checkFile("tools/f-prot-milter-openbsd" . $distro);
	}
	else
	{
		&checkFile("tools/f-prot-qmail");
		&checkFile("tools/f-prot-milter");
	}
	
	&checkFile("man_pages/scan-mail.pl.8");
	if ($OperatingSystem =~ /aix/i)
	{
		## Do nothing.
	}
	else
	{
		&checkFile("man_pages/f-prot-qmail.8");
		&checkFile("man_pages/f-prot-milter.8");
	}
	if ($OperatingSystem =~ /linux/i)
	{
		&checkFile("tools/rc_scripts/scan-mail.rc.redhat");
		&checkFile("tools/rc_scripts/scan-mail.rc.debian");
		&checkFile("tools/rc_scripts/scan-mail.rc.suse");
	}
}

sub updateSignatures
{
	print "Checking for new virus signatures:\n";
	system("/usr/local/f-prot/tools/check-updates.pl");
}

&getDistribution;
&detectFprotVersion;
&printWelcome;
&configureInstallation;
&checkFiles;
if ($fileCheckStatus == 0)
{
	die "\nSome files needed in the installation were not found.\n"
		. "Fatal error.\nExiting...\n";
}
&performInstallation;
&makeFprotExecutable;
&updateSignatures;
&installCompleted;
