.code
;
; emulate -  ⪠ 
;
; on start :       ip - ਣ쭮 ᯮ 
;            codesize - ࠧ   樨
;             codeloc - ᬥ饭    樨
; on exit  :  - - - - -
;
 emulate        proc   codeloc: dword, codesize: dword, ip: dword
;
;  樠樨 , । ࠡ⮩  ⪮ 
;  ) ࠭ 祭 ॣ஢
;  ) ⠭ ࠬ஢ ।  楤 (ip/codesize/codeloc)
;  ) ⠭ 祭 "㠫쭮 ⥪",  樨 饭 権
;      
;
 emul_init:     push    eax ecx edx ebx ebp esi edi
                call    ca_init
                mov     dword ptr [ill_mark],0   ; ⠭ 祭 䫠
                mov     esi,offset _stack+10000  ;   ,  樨
                mov     dword ptr [regs+016],esi ; ⠭ 祭
                mov     esi,codeloc              ; ᬥ饭  砫 
                mov     ebx,esi
                add     ebx,codesize             ; ebx - ᬥ饭   
;
 emulate_loop:
;
;    樨 ਯ஢ ᮧ ⨫⮩ UPX, ᫥ 樨
; "repe scasb" 稭  樨,   ய᪠ 
; 樨
;
                cmp     word ptr [esi],0aef2h
                jnz     not_repescasb
                inc     esi
                inc     esi
                mov     ecx,30
 upx_srch_jmp:  cmp     byte ptr [esi],0e9h
                jz      not_repescasb
                inc     esi
                loop    upx_srch_jmp
                jmp     emulate_ret
;
 not_repescasb: push    offset vir_no
                push    esi                      ; ந  ᨣ
                call    detect                   ; ᫨  襫 ,
                or      eax,eax                  ;  eax -    
                jz      emulate_dasm             ; ᫨ , த 
                mov     dword ptr [ill_mark],eax ;  ⠭ 䫠 
                jmp     emulate_ret              ; ४⨬  樨
;
 emulate_dasm:  push    esi                      ; ࠧ६  
                call    disasm                   ;  ᥬ
                cmp     eax,-1             ; ᫨  ⭠
                jnz     copy_instr         ; ᥬ, த ࠧ
 emulate_error: jmp     emulate_ret        ;  (!)  멤
;
; ᫨   ॡ  樨 믮 (edx == 0), 
; ७ᥬ   "instr_buf" 樨  樨 ⥪ 
; ࠧ࠭ ᥬ஬  ࠧ ecx
;
;  १ 稬  "instr_buf" ਬ୮:
;
;               mov     dword ptr [res_stack+1],esp
;               mov     esp,dword ptr [regs+016]
;           ... ࠧ࠭  ...
;               mov     dword ptr [regs+016],esp
; res_stack:    mov     esp, ?
;               ret
;
 copy_instr:    or      edx,edx
                jnz     fullinst_emul
;
 prep_to_run:   mov     edi,offset instr_buf
                mov     ax,2589h
                stosw                           ; ७ᥬ "mov 4 ptr [?],esp"
;
                mov     eax,offset instr_buf    ; ⠥ ᬥ饭
                add     eax,ecx                 ; "res_stack+1" (. ) 
                add     eax,6+6+6+1             ; ७ᥬ ⮪ 樨
                stosd
;
                mov     ax,258Bh                 ; ७ᥬ 
                stosw                            ; "mov esp,4 ptr [regs+16]"
                mov     eax,offset regs+016
                stosd
;
                rep     movsb                    ; ७ᥬ ࠧ࠭
                                                 ; ᥬ஬ 
;
                mov     ax,2589h                 ; ७ᥬ 
                stosw                            ; "mov 4 ptr [regs+16],esp"
                mov     eax,offset regs+016
                stosd
;
                mov     al,0bch                  ; ७ᥬ 
                stosb                            ; "mov esp,?"
                stosd
                mov     al,0c3h                  ; "⠢ ᫥ "
                stosb                            ; ७ᥬ "ret"
;
; "אַ " ࠧ࠭ 樨  ᯥ樠 ᫮ (࠭⨭)
;
;  祭 ॣ஢ ணࠬ-  ⥪
;
 run_instr:     push    eax ecx edx ebx ebp esi edi
;
;  祭 䫠 ணࠬ-  ⥪, ⥬ ७ᥬ
;  ॣ eax,     ६ "temp"
;
 save_orig_efl: pushfd
                mov     eax,dword ptr [esp]
                mov     dword ptr [temp],eax
                popfd
;
; 祭 䫠 㫨㥬  ७ᥬ  ६ "flags"  ॣ
; eax,     ⥪ ᯮ騩 ணࠬ-஬
;
 set_emul_efl:  pushfd
                mov     eax,dword ptr [flags]
                mov     dword ptr [esp],eax
;
; ⠭ 祭 ॣ஢ 㫨㥬   ६ "regs"
; 祭 esp  ⠭,   㥬 ᯮ 祭 䫠
; 㫨㥬 , ⥪ 㤥 ७ࠢ  ணࠬ "instr_buf"
;
                mov     eax,dword ptr [regs+000]
                mov     ecx,dword ptr [regs+004]
                mov     edx,dword ptr [regs+008]
                mov     ebx,dword ptr [regs+012]
                mov     ebp,dword ptr [regs+020]
                mov     esi,dword ptr [regs+024]
                mov     edi,dword ptr [regs+028]
;
;  "popfd" ⠭ 祭 䫠 㫨㥬 , ஥  ࠭﫨 
;
                popfd
                call    instr_buf                ; ⨬  ᯮ
;
; ࠭  祭 ॣ஢ 㫨㥬   ६ "regs"
;
                mov     dword ptr [regs+000],eax
                mov     dword ptr [regs+004],ecx
                mov     dword ptr [regs+008],edx
                mov     dword ptr [regs+012],ebx
                mov     dword ptr [regs+020],ebp
                mov     dword ptr [regs+024],esi
                mov     dword ptr [regs+028],edi
;
;  祭 䫠 㫨㥬    ⥪, ⥬ ७ᥬ
;  ॣ eax  ࠭  ६ "flags"
;
 save_emul_efl: pushfd
                mov     eax,dword ptr [esp]
                mov     dword ptr [flags],eax
                popfd
;
; ⠭ 祭 䫠 ணࠬ-  ६ "temp"
;
 set_orig_efl:  pushfd
                mov     eax,dword ptr [temp]
                mov     dword ptr [esp],eax
                popfd
;
; ⠭ 祭 ॣ஢ ணࠬ-
;
                pop     edi esi ebp ebx edx ecx eax
                jmp     emulate_check
;
; ࠧ 権,  ॡ  樨 ᯮ
;
 fullinst_emul: push    esi
                pop     edi                   ; edi - ᬥ饭 樨
                add     esi,ecx               ;        ࠧࠫ
; 樨 ࠧ஬ 1 
 @one_byte:     cmp     cl,1
                jnz    @two_byte
;                cmp     byte ptr [edi],0A4h
;                jz     @found_movsb           ; " movsb "
                cmp     byte ptr [edi],0C3h
                jz     @found_ret             ; " ret "
                jmp     emulate_ret
; 樨 ࠧ஬ 2 
 @two_byte:     cmp     cl,2
                jnz    @three_byte
                 cmp     byte ptr [edi],031h   ;
                 jz     @found_spec            ; " xor dword ptr [ereg],ereg "
;
 @check_jmpb:   cmp     byte ptr [edi],072h   ; 樨:
                jc      emulate_ret           ; jb, jnb, je, jne,
                cmp     byte ptr [edi],079h   ; jbe, ja, js, jns
                jna    @found_jmpb            ;
;
                cmp     byte ptr [edi],088h
                jc      emulate_ret
                cmp     byte ptr [edi],08Bh
                jna    @found_spec
;
 @check_loop:   cmp     byte ptr [edi],0E2h
                jz     @found_loop            ; " loop byte "
                cmp     byte ptr [edi],0EBh
                jz     @found_jmpb            ; " jmp byte "
                jmp     emulate_ret
; 樨 ࠧ஬ 3 
 @three_byte:   cmp     cl,3
                jnz    @five_byte
                cmp     byte ptr [edi],030h
                jz     @found_spec            ; " xor byte ptr [eregA+eregB],reg "
                cmp     byte ptr [edi],031h
                jz     @found_spec            ; " xor dword ptr [eregA+eregB],ereg "
                cmp     byte ptr [edi],080h
                jz     @found_spec            ; " cmp byte ptr [ereg],byte "
                cmp     byte ptr [edi],08Ah
                jz     @found_spec            ; " mov [reg],byte ptr [ereg+byte] "
                cmp     byte ptr [edi],08Bh
                jz     @found_spec            ; " mov [ereg],dword ptr [ereg+byte] "
                cmp     byte ptr [edi],08Fh
                jz     @found_spec            ; " pop dword ptr [eregA+eregB] "
                cmp     byte ptr [edi],0FFh   ;
                jz     @found_spec            ; " push dword ptr [eregA+eregB] "
                jmp     emulate_ret
; 樨 ࠧ஬ 5 
 @five_byte:    cmp     cl,5
                jnz    @six_byte
                cmp     byte ptr [edi],066h
                jz     @found_spec            ; " xor word ptr [ereg],word "
                cmp     byte ptr [edi],0E8h
                jz     @found_call            ; " call dword "
                cmp     byte ptr [edi],0E9h
                jz     @found_jmp             ; " jmp dword "
                jmp     emulate_ret
; 樨 ࠧ஬ 6 
 @six_byte:     cmp     cl,6
                jnz    @seven_byte
                cmp     byte ptr [edi],066h
                jz     @found_spec            ; " xor word ptr [ebp],word "
                cmp     byte ptr [edi],081h
                jz     @found_spec            ; " xor dword ptr [ereg], dword "
                cmp     byte ptr [edi],0FFh
                jna    @found_spec            ; " call [ereg+dword] "
                jmp     emulate_ret
; 樨 ࠧ஬ 7 
 @seven_byte:   cmp     cl,7
                jnz    @eight_bytes
                cmp     byte ptr [edi],080h
                jz     @found_spec            ; " xor byte ptr [ereg+dword],byte "
                jmp     emulate_ret
; 樨 ࠧ஬ 8 
 @eight_bytes:  cmp     cl,8
                jnz     emulate_ret
                cmp     byte ptr [edi],080h
                jz     @found_spec            ; " xor byte ptr [esp+dword],byte "
                jmp     emulate_ret
; 樨 ࠧ஬ 1 
; * * * 樨 ᯮ 樨 "ret"
;
; ஢ ᯮ 樨 祭 :
;
; 1) 室   ᫮  ⥪ 㫨㥬 
;    ᬥ饭   ᫮ ᮤন  "regs+16"
; 2)  ᫮ 㤥  㪠⥫  ᬥ饭 ࠧࠥ ஬
;    樨 (祭 ॣ esi)
; 3)   ⥪ 㫨㥬 , ⮥ 祭
;    add dword ptr [regs+16],4
;
 @found_ret:    mov     esi,dword ptr [regs+016]
                lodsd
                add     dword ptr [regs+016],4
                xchg    esi,eax
                jmp     emulate_check
; 樨 ࠧ஬ 2 
; * * *  ᯮ "᫮"  "᫮" 室:
;       jb, jnb, je, jne, jbe, ja, js, jns, & jmp byte
;
; 1) ७ᥬ   "instr_buf" 樨  樨 ᯮ 室
;     १ 稬  "instr_buf" ਬ୮:
;
;                 ()᫮ 室  ⪥ _label
;               inc     eax
; _label:       ret
;
; 2) ⠭ 祭 䫠 㫨㥬  ( ६ "flags")
;    ⠭ 祭 ॣ eax = 0
; 3) ⨬  ᯮ ᮤন "instr_buf"
;     ⮬ 砥, ᫨ 室 믮, 祭 eax 㤥 ࠢ 
;
;  ᫨ 室 믮, ᮮ⢥⢥ 室  ᬥ饭,
; ᫥㥬  (祭 ॣ esi).  ⮣ ᬮਬ ன 
; 樨,  ᮤন   ᫥  ᬥ饭.
;
 @found_jmpb:   mov     ah,1
                mov     al,byte ptr [edi]
                push    edi
                mov     edi,offset instr_buf
                stosw
                mov     ax,0c340h
                stosw
                pop     edi
;
 jmp_ser_eflag: pushfd
                pushfd
                mov     eax,dword ptr [flags]
                mov     dword ptr [esp],eax
                sub     eax,eax
                popfd
                call    instr_buf
                popfd
                or      eax,eax
                jnz     emulate_check
;
 jmpb_goto:     cmp     byte ptr [edi+1],07fh
                jna     jmpb_down
 jmpb_up:       sub     al,byte ptr [edi+1]
                sub     esi,eax
                jmp     emulate_check
 jmpb_down:     mov     al,byte ptr [edi+1]
                add     esi,eax
                jmp     emulate_check                 
;
; * * * 樨 ᯮ 権   ᬥ饭
;
;   "᫮" ࠧ   ,    ,
;   ஡.
;
; ࢠ  :
;
;  樨,    ᬥ饭, ॡ  樨
; ᯮ, ⠪  ᫥㥬   ७ᥭ  ⨢  
; ᯮ     , ⭮⥫쭮   
;   㤥  ணࠬ ().
; ⥫쭮  ᯮ 権 ⠪ த, 㦭 
; ᬥ饭,  ஬ ணࠬ 頥  ,  .  ⮣
; ᥬ ⥫쭮 ࠧࠥ 樨    "dregs"
; ᯥ樠묨 ࠬࠬ 樨,  室,   ࠢ쭮
; 樨.
;
; ᥩ  "dregs" ᮤন ਬ୮ ᫥騥 :
;  dregs + 000 : ⢮ ॣ஢ ᯮ  樨
;  dregs + 004 :  ॣ 1
;  dregs + 008 :  ॣ 2
;  dregs + n*4 :  ॣ n
;
;   室 । 㬬 祭 i ॣ஢ ᯮ 
; 樨  㪠 ᬥ饭,  ஬ 頥  
; ।     .  㤥 룫拉 ਬ୮
; ⠪:
;
; for (i=1,x=0; i<=- ॣ஢; i++)
; {
;  a = dregs[i*4] * 4;
;  x+= [regs+a];
; }
;
; :    a - ६ ६
;         i - ᯮ  稪
;         x -  ⮩ ᠬ 㬬,  室 㧭
;      regs -   ஬ ࠭ 祭 ॣ஢ 㫨㥬 ணࠬ
;     dregs -  ᠭ 
;
 @found_spec:   push    ebx esi ecx ebp
                sub     ebp,ebp
                sub     ebx,ebx
                mov     esi,offset dregs
                lodsd
                xchg    eax,ecx
 count_sum_lp:  lodsd
                cmp     byte ptr [eax+_regs],0 ; ॣ ᮤন ᫥ delta value?
                jz      count_sum
                inc     ebp
 count_sum:     call    mul_4
                add     ebx,dword ptr [regs+eax]
                loop    count_sum_lp
;
;   :
;
;   室  ࠧ   ⮯  
;  ⥪饬. 祭 祭   ebx.
;  ⮬ 砥, ᫨   ॣ஢, ᯮ  ࠧࠥ 樨
; 㤥 ᮤঠ ⠭ delta value (. "\det\ca_ip.inc"),
; 室  ன   ⯠.
;
;  - ⨢, "㬥" । 믮﫠  楤
; ,  ᫥㥬     ॣ஢ ᮤন delta value.
; ᫨  室  ᬥ饭 ᯮ짮 ॣ,  ᮤঠ ip, 
; 祭 ॣ ebp > 0,   ࠢ .
;
                or      ebp,ebp
                pop     ebp
                jnz     spec_emul_ip                
                sub     ebx,ip
                add     ebx,codeloc
 spec_emul_ip:  sub     eax,eax
                pop     ecx
                push    edi
                pop     esi
;
;  (᫥ ) :
;
;   , ॡ । ⢨  樨  믮,
;  ⢨ ந   樨  権, 
;  㠫.   ࠧ ⨯ 樨   
; 樨.
;
 spec_emul_lp:  mov     al,byte ptr [edi]
                cmp     al,030h
                jz      spec_emul_001
                cmp     al,031h
                jz      spec_emul_001x
                cmp     al,066h
                jz      spec_emul_002
                cmp     al,080h
                jz      spec_emul_003
                cmp     al,081h
                jz      spec_emul_004
                cmp     al,088h
                jz      spec_emul_005
                cmp     al,089h
                jz      spec_emul_006
                cmp     al,08Ah
                jz      spec_emul_007
                cmp     al,08Bh
                jz      spec_emul_008
                cmp     al,08Fh
                jz      spec_emul_009
                cmp     al,0FFh
                jz      spec_emul_010
                jmp     spec_emul_ret
;
; xor byte ptr [eregA],[reg]                030HEX, 00regrgA
; xor byte ptr [esp],[reg]                  030HEX, 00REGesp, 00espESP
; xor byte ptr [eregA+eregB],reg            030HEX, 00reg100, 00rgArgB
;
 spec_emul_001: mov     al,byte ptr [edi+1]
                cmp     cl,2
                jnz     spec_emul_001a
                call    two_regs
                jmp     spec_emul_001c
 spec_emul_001a:shr     al,3
 spec_emul_001c:call    mul_4
                mov     edx,dword ptr [regs+eax]
;
                push    eax
                call    test_off
                or      eax,eax
                jz      semul_err_ret
                pop     eax
;
                xor     byte ptr [ebx],dl
                jmp     spec_emul_ret
;
; xor dword ptr [eregA],[eregB]             031HEX, 00rgBrgA
; xor dword ptr [esp],[ereg]                031HEX, 00REGesp, 00espESP
; xor dword ptr [eregA+eregB],ereg          031HEX, 00reg100, 00rgArgB
;
 spec_emul_001x:mov     al,byte ptr [edi+1]
                cmp     cl,2
                jnz     spec_emul_001b
                call    two_regs
                jmp     spec_emul_001d
 spec_emul_001b:shr     al,3
 spec_emul_001d:call    mul_4
                mov     edx,dword ptr [regs+eax]
;
                push    eax
                call    test_off
                or      eax,eax
                jz      semul_err_ret
                pop     eax
;
                xor     dword ptr [ebx],edx
                jmp     spec_emul_ret
;
; xor word ptr [ereg],word  066HEX, 081HEX,         , word         = 5 bytes
; xor word ptr  [ebp],word  066HEX, 081HEX,   075HEX, 000HEX, WORD = 6 bytes
;
 spec_emul_002: add     esi,ecx
                dec     esi
                dec     esi
                lodsw
;
                push    eax
                call    test_off
                or      eax,eax
                jz      semul_err_ret
                pop     eax
;
                xor     word ptr [ebx],ax
                jmp     spec_emul_ret
;
; cmp byte ptr [ereg],byte                  080HEX, 111reg, byte
; ~cmp dword ptr [ereg],dword               081HEX, 111reg, dword
; xor byte ptr [ereg+dword],byte            080HEX, 10110reg,  dword, byte
; xor byte ptr [esp+dword],byte             080HEX, 10110esp, 024HEX, dword, byte
;
 spec_emul_003: cmp     cl,3
                jz      spec_emul_003b 
                sub     cl,5
                add     ebx,dword ptr [esi+2]
                mov     al,byte ptr [esi+ecx+4]
                xor     byte ptr [ebx],al
                jmp     spec_emul_ret
 spec_emul_003b:push    ecx esi edi
                xchg    esi,edi
                mov     edi,offset instr_buf
                cld
                rep     movsb
                mov     al,0c3h
                stosb
                mov     byte ptr [instr_buf+1],03bh
                pop     edi esi ecx
;
 cmp_set_eflag: pushfd
                pushfd
                mov     eax,dword ptr [flags]
                mov     dword ptr [esp],eax
                popfd
                call    instr_buf
                pushfd
                mov     eax,dword ptr [esp]
                mov     dword ptr [flags],eax
                popfd
                popfd
                jmp     spec_emul_ret
;
; xor dword ptr [ereg],dword                081HEX, 00110reg, dword = 6 bytes
;
 spec_emul_004: inc     esi
                inc     esi
                lodsd
;
                push    eax
                call    test_off
                or      eax,eax
                jz      semul_err_ret
                pop     eax
;
                xor     dword ptr [ebx],eax
                jmp     spec_emul_ret
;
; mov byte ptr [ereg],[reg]                 088HEX,00regErg
;
 spec_emul_005: mov     al,byte ptr [edi+1]
                call    reg8_pos
                mov     dl,byte ptr [regs+eax]
;
                push    eax
                call    test_off
                or      eax,eax
                jz      semul_err_ret
                pop     eax
;
                mov     byte ptr [ebx],dl
                jmp     spec_emul_ret
;
; mov dword ptr [ergA],[ergB]               089HEX,00rgBrgA
;
 spec_emul_006: mov     al,byte ptr [edi+1]
                call    two_regs
                call    mul_4
                mov     edx,dword ptr [regs+eax]
;
                push    eax
                call    test_off
                or      eax,eax
                jz      semul_err_ret
                pop     eax
;
                mov     dword ptr [ebx],edx
                jmp     spec_emul_ret
;
; mov [reg],byte ptr [ereg]                 08AHEX, 00regErg
; mov [reg],byte ptr [esp]                  08AHEX, 00regESP, 00espESP
; mov [reg],byte ptr [ebp]                  08AHEX, 01regEBP, 00000000
; mov [reg],byte ptr [ereg+byte]            08AHEX, 01regErg, byte
; mov [reg],byte ptr [esp+byte]             08AHEX, 01regESP, 00espESP, byte
;
;  ।塞 ⨯ ࠧࠥ 樨  蠥, 室 , ਡ 
; ᬥ饭 (ᮤঠ饬  ebx) ᫮ "byte". ᫨  室, 
; ⠥ ᯮ ᫠ "byte".
;
 spec_emul_007: mov     al,byte ptr [edi+1]
                push    eax
                call    two_regs
                pop     eax
                cmp     dl,101b           ; ᫨  樨 ᯮ
                jz      spec_emul_007b    ; ॣ ebp,  ண 
                cmp     al,01000000b      ; 樨 > "01000000"
                jc      spec_emul_007b    ;  祣 ਡ  㦭
;
                cmp     dl,100b       ; ᫨ ᯮ esp,  ࠧ
                jnz     spec_emul_007a; 樨   1 ,
                inc     ecx           ; -> ᯮ byte  1  ""
 spec_emul_007a:push    eax
                mov     al,byte ptr [edi+ecx-1]
                add     ebx,eax       ; ਡ  ᫥ ᬥ饭 "byte"
                pop     eax
                xor     al,01000000b  ; 㡥६ "譨 "
 spec_emul_007b:call    reg8_pos
;
                push    eax
                call    test_off
                or      eax,eax
                jz      semul_err_ret
                pop     eax
;
                mov     dl,byte ptr [ebx]
                mov     byte ptr [regs+eax],dl
                jmp     spec_emul_ret
;
; mov [eregA],dword ptr [eregB]             08BHEX, 00rgArgB
; mov [ereg],dword ptr [esp]                08BHEX, 00regESP, 00espESP
; mov [ereg],dword ptr [ebp]                08BHEX, 01regEBP, 00000000
; mov [eregA],dword ptr [eregB+byte]        08BHEX, 01rgArgB, byte
; mov [ereg],dword ptr [esp+byte]           08BHEX, 01regESP, 00espESP, byte
;
;   ᯮ  ᫥ 権   ᮢ
; , ⥬,  ࠧ  "spec_emul_007".
;
 spec_emul_008: mov     al,byte ptr [edi+1]
                push    eax
                call    two_regs
                pop     eax
                cmp     dl,101b
                jz      spec_emul_008b
                cmp     al,01000000b
                jc      spec_emul_008b
                push    eax
                cmp     dl,100b
                jnz     spec_emul_008a
                inc     ecx
 spec_emul_008a:mov     al,byte ptr [edi+ecx-1]
                add     ebx,eax
                pop     eax
                xor     al,01000000b
 spec_emul_008b:call    two_regs
                call    mul_4
;
                push    eax
                call    test_off
                or      eax,eax
                jz      semul_err_ret
                pop     eax
;
                mov     edx,dword ptr [ebx]
                mov     dword ptr [regs+eax],edx
                jmp     spec_emul_ret
;
; pop dword ptr [eregA+eregB]               08FHEX, 00000100, 00rgBrgA
;
 spec_emul_009: push    eax                      ; ஢ਬ  
                call    test_off                 ; ᯮ짮 ᬥ饭
                or      eax,eax                  ; 㪠  ॣ ebx,
                jz      semul_err_ret            ; ᫨ , 멤  訡
                pop     eax
;
                call    get_from_vstack
                mov     dword ptr [ebx],eax
                jmp     spec_emul_ret
;
; push dword ptr [eregA+eregB]              0FFHEX, 00110100, 00rgBrgA
; call [ereg+dword]                         0FFHEX, 10010reg, dword
;
 spec_emul_010: cmp     cl,3
                jnz     spec_emul_010b
;
                push    eax                      ; ஢ਬ  
                call    test_off                 ; ᯮ짮 ᬥ饭
                or      eax,eax                  ; 㪠  ॣ ebx,
                jz      semul_err_ret            ; ᫨ , 멤  訡
                pop     eax
;
                mov     eax,dword ptr [ebx]
                call    put_to_vstack
                jmp     spec_emul_ret
;
 spec_emul_010b:push    eax edi
                mov     eax,esi
                sub     dword ptr [regs+016],4
                mov     edi,dword ptr [regs+016]
                stosd
                pop     edi eax
                add     ebx,dword ptr [edi+2]
;
                push    eax
                call    test_off
                or      eax,eax
                jz      semul_err_ret
                pop     eax
;
                mov     esi,dword ptr [ebx]
;
 spec_emul_ret: pop     esi ebx
                jmp     emulate_check
 semul_err_ret: pop     eax esi ebx
                jmp     emulate_ret
;
; * * * 樨 ᯮ 樨 "loop byte"
;
;  室 㬥 祭 ॣ "ecx" (regs+004), ᫥㥬 
;  1, ᫨ 祭 祭 ॣ 㤥 ࠢ 0,  ३  ᬥ饭
;   ஬ ᮤঠ  樨
;
 @found_loop:   dec     dword ptr [regs+004]   ; 㬥訬 祭 ॣ
                cmp     dword ptr [regs+004],0 ; "ecx" 㫨㥬 
                jz      emulate_check          ; ᫨ ࠢ 0, 멤  横
                sub     esi,ecx                ;  ⠥ ᬥ饭
                sub     esi,eax                ; 砫 横
                jmp     emulate_check          ; ३  ᫥饩 㪨
; 樨 ࠧ஬ 5 
; * * * 樨 ᯮ 権: call dword
;                                       jmp  dword
;
;   室  ᬥ饭 (祭 esi) 樨,  㤥
; ᫥饩 ᯮ ஬.
;   砥 ᫨  ࠧࠥ "call", 㦭 ࠭  ⥪ 㫨㥬
; ⪠ ᬥ饭 樨 ᫥饩 אַ  call',   ⮬ 
;  "ret"    ᬥ饭
;
 @found_call:   push    eax edi
                mov     eax,esi
                sub     dword ptr [regs+016],4
                mov     edi,dword ptr [regs+016]
                stosd
                pop     edi eax
 @found_jmp:    add     esi,dword ptr [edi+1]    ;  esi
                cmp     byte ptr [temp+020],0
                jnz     emulate_check            ; 㫨 ਯ UPX ?
                sub     esi,codeloc
                add     esi,ip
                push    esi
                call    real_off                 ;  室  ᥪﬨ
                mov     esi,eax
;
; esi - 㪠⥫    ࠧ
; ebx - ।,    "⥫쭮"
;
 emulate_check: cmp     esi,ebx                  ; ᫨   諨  ।
                jc      emulate_loop             ; த 横 樨

 emulate_ret:   push    offset vir_no
                push    esi                      ; 砥 -
                call    detect                   
                mov     dword ptr [ill_mark],eax ;  ⠭ 䫠 
;
                mov     dword ptr [emul_stop],esi ;  ᫥ ᬥ饭
                pop     edi esi ebp ebx edx ecx eax
                ret
 endp
;
; get_from_vstack - ⠥ 祭  "㠫쭮" stack'  ॣ eax
;
; on exit  : eax - ᫮ ஥ 뫮 ⠭
;
 get_from_vstack        proc
;
                push    edi
                mov     esi,dword ptr [regs+016]
                lodsd
                add     dword ptr [regs+016],4
                pop     esi
                ret
 endp
;
; put_to_vstack -  祭  ॣ eax  "㠫" stack
;
; on start : eax - ᫮ ஥ 室 
;
 put_to_vstack  proc
;
                push    edi
                sub     dword ptr [regs+016],4
                mov     edi,dword ptr [regs+016]
                stosd
                pop     esi
                ret
 endp
;
; reg8_pos - । ᬥ饭 8- ⭮ ॣ ( ண 㪠
;             ॣ al) ⭮⥫쭮 ⠡ "regs"
;
; on start :  al -  8- ⭮ ॣ
; on exit  : eax - ᬥ饭,  祭  ॣ ⭮⥫쭮 ⠡ "regs"
;
 reg8_pos       proc
;
                push    ecx edx
                sub     ecx,ecx
                call    two_regs
                cmp     al,4
                jc      reg8_low
                sub     al,4
                inc     ecx
 reg8_low:      call    mul_4
                add     eax,ecx
                pop     edx ecx
                ret
 endp
;
; test_off - ஢ઠ "⨬" ᬥ饭 㪠   ebx
;
;   ᯮ 権,    ᬥ饭,  祭
; 让  訡   "" ᬥ饭.
;    ᫥⢨:
;
; - 訡  ࠡ⪨ -,  ய⨫ 楤
;    delta value     ᮡ .
; - "ࠢ쭮" 㫨஢ ⪠ ,  ।祭 
;    ஢ ⨢ ணࠬ, ⠪ 뢠
;   -᪨/⫠ .
; -  १ । (ࠧࠡ稪) 訡  ணࠬ.
;
;   砥 ᫨   ᪮쪮   ⢥ত ࠢ, 饭 
; ⠪ ᬥ饭 ਢ  訡 - ன ⨢  .
;   㤥     ⥩ ⨢   ,
;  ᯮ ணࠬ  ࠧ 楫  "ࠡ"  
;  ⮫쪮 ⨢,     ᫥㥬 ணࠬ.
;
;  ᫥㥬 ணࠬ  짮 묨 ⮫쪮  "⨢᭮
; ",  ⮨   "६": "junk"  "buffer".  
;  ᯮ짮 "㠫 " (६ "_stack").
;
; on start : ebx      - ਣ ip 
; on exit  : eax == 0 - ⨬ ᬥ饭
;            eax != 0 - ଠ쭮 ᬥ饭
;
 test_off       proc
;
                sub     eax,eax
                cmp     ebx,offset _stack
                jc      test_off_ret
                cmp     ebx,offset buffer+10000000-4
                ja      test_off_ret
                inc     eax
 test_off_ret:  ret
 endp
;
; eax = eax * 4
; ࢮ砫쭮 祭 ॣ஢ ecx, edx ࠭
;
 mul_4          proc
;
                push    ecx edx
                sub     edx,edx
                mov     dl,4
                mul     edx
                pop     edx ecx
                ret
 endp
;
