@echo off
 echo 
 echo CHKDOS - Demo batch file to demonstrate the /C and /Q options of CrCheck!
 echo 
 rem $Header: /home/cvs/src/prj/CrCheck/chkdos.bat,v 1.8 2011-02-03 14:17:38 Ralph Exp $
 rem $Log: chkdos.bat,v $
 rem Revision 1.8  2011-02-03 14:17:38  Ralph
 rem CrCheck 4.58 release + SP3 Check
 rem
 rem Revision 1.7  2008/03/06 20:15:59  Ralph
 rem added WinXP Sp2.Eng
 rem
 rem Revision 1.6  2005/01/11 21:51:07  ralproth
 rem changes for 4.52 release
 rem
 rem Revision 1.5  2003/09/07 17:59:57  ralproth
 rem CrCheck 4.51 - misc changes
 rem
 rem Revision 1.4  2002/02/15 22:30:24  ralph
 rem Fixes provided by Rick Lively
 rem
 rem Revision 1.3  2002/02/15 22:16:30  ralph
 rem Zimmern: CrCheck fixes
 rem Revision 1.2  2001/11/26 22:18:34  Administrator
 rem Added CVS keywords (Header/Log), converted from OEM to ANSI were appicable
 rem

 echo You should view/edit this demo batch file for better understanding the
 echo usage of the CrCheck package!

 if not exist crcheck.exe copy crcheckeng.exe crcheck.exe>NUL
 if exist crcheck.exe goto lfound1
  echo CRCHECK.EXE does not exist, so this demonstration program will not work!
  echo.
  goto End2

:lfound1
 if exist crctest.exe goto lfound2
  echo CRCTEST.EXE does not exist, so this demonstration program will not work!
  echo.
  goto End2

:lfound2
 echo Hint: This batch file uses the old ERRORLEVEL 1 for checking if the
 echo checksum is wrong. Better usage is ERRORLEVEL 20
 echo.
 if not exist c:\command.com goto chknxt4

 echo The following check is only valid for Novell-DOS 7.0p13 (German patch)
 crcheck c:\command.com /C=1cf91367 -q
 if errorlevel 1 goto chknxt1
  goto ok

:chknxt1
 echo The following check is only valid for Novell-DOS 7.0p12 (English patch)
 crcheck C:\COMMAND.COM /C=ac510582 -q
 if errorlevel 1 goto chknxt2
  goto ok

:chknxt2
 echo The following check is only valid for Win 0.95a/b (German edition)
 crcheck C:\COMMAND.COM /C=dcd6e860 -q
 if errorlevel 1 goto chknxt3a
  goto ok

:chknxt3a
 crcheck C:\COMMAND.COM /C=8be8ef19 -q
 if errorlevel 1 goto chknxt3
  goto ok

:chknxt3
 echo The following check is only valid for MS-DOS 6.20 (German edition)
 crcheck C:\COMMAND.COM /C=9304e476 -q
 if errorlevel 1 goto chknxt4
  goto ok

:chknxt4
 if not exist %ComSpec% goto nocmdcom
  echo The following check is only valid for Win NT 4.0/SP6a (German edition)
  crcheck %ComSpec% /C=01C8C2EB -q
  if errorlevel 1 goto chknxt5
   goto ok

:chknxt5
 echo The following check is only valid for Win98SE (German Edition)
 crcheck c:\command.com /C=7839509A -q
 if errorlevel 1 goto chknxt6
   goto ok

:chknxt6
 echo The following check is only valid for Win98SE (German Edition)
 crcheck c:\command.com /C=7839509A -q
 if errorlevel 1 goto chknxt7
   goto ok

:chknxt7
 echo The following check is only valid for WinXP.SP1 (English Edition)
 crcheck %ComSpec% /C=1C34E666 -q
 if errorlevel 1 goto chknxt8
   goto ok

:chknxt8
 echo The following check is only valid for WinXP.SP2 (English Edition)
 crcheck %ComSpec% /C=D2BD298F -q
 if errorlevel 1 goto chknxt9

:chknxt9
 echo The following check is only valid for WinXP.SP3 (English Edition)
 crcheck %ComSpec% /C=C299C503 -q

 if errorlevel 1 goto error

:ok
 echo C:\COMMAND.COM (%ComSpec%) unchanged!?
 goto end

:error
 echo C:\COMMAND.COM has been changed or does not exist!
 echo The C:\COMMAND.COM checksum is:
 crcheck C:\COMMAND.COM /c /s
 echo The %ComSpec% checksum is:
 crcheck %ComSpec% /c /s

:end
 echo.
 echo Demonstration of the supplied program CrcTest
 echo Testing: %ComSpec%, CRC: 12345678
 crctest %ComSpec% 12345678
 if errorlevel 2 goto bad_end
 if errorlevel 1 goto ok2
 if errorlevel 0 goto bad_end

:ok2
 echo CRC OK
 goto end2

:bad_end
 if errorlevel 2 echo wrong parameters!
 if errorlevel 0 if not errorlevel 2 echo CRC wrong!
 echo CRC changed... (or another DOS version :)
 goto end2

:nocmdcom
 echo C:\COMMAND.COM does not exist, so this demonstration program will not work!
 echo Probably you are using Win-NT/XP or Win2000
 echo.

:end2
 echo 
 echo.
