// nimdaDlg.cpp : implementation file
//

#include "stdafx.h"
#include "nimda.h"
#include "nimdaDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

CString GetText(CWnd& wnd)
{
	CString s;
	wnd.GetWindowText(s);
	return s;
}



/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CNimdaDlg dialog

CNimdaDlg::CNimdaDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CNimdaDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CNimdaDlg)
	//}}AFX_DATA_INIT
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CNimdaDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CNimdaDlg)
	DDX_Control(pDX, IDC_ROOT, root);
	DDX_Control(pDX, IDOK, btnOk);
	DDX_Control(pDX, IDC_OUTPUT, output);
	DDX_Control(pDX, IDC_SKIPPED, skipped);
	DDX_Control(pDX, IDC_SCANRATE, scanrate);
	DDX_Control(pDX, IDC_ERRORS, errors);
	DDX_Control(pDX, IDC_DELETED, deleted);
	DDX_Control(pDX, IDC_VELOCITY, velocity);
	DDX_Control(pDX, IDC_TIME, time);
	DDX_Control(pDX, IDC_SCANNED, scanned);
	DDX_Control(pDX, IDC_INFECTED, infected);
	DDX_Control(pDX, IDC_FILE, file);
	DDX_Control(pDX, IDC_DIRECTORIES, directories);
	DDX_Control(pDX, IDC_CLEANED, cleaned);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CNimdaDlg, CDialog)
	//{{AFX_MSG_MAP(CNimdaDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_TIMER()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CNimdaDlg message handlers

BOOL CNimdaDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	/* setup columns in output list */
	output.InsertColumn(0,"File",LVCFMT_LEFT,150);
	output.InsertColumn(1,"Status",LVCFMT_LEFT,80);
	output.InsertColumn(2,"Path",LVCFMT_LEFT,240);

	/* initial defaults */
	root.SetWindowText("c:\\");

	/* set the statistics update timer */
	SetTimer(1,200,NULL);

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CNimdaDlg::OnInfected(LPCTSTR filename, VirusKiller::SCANRESULT result)
{
	if ((result&~VirusKiller::SCANNED)>0) {
		CString file(filename), path;

		/* find the path break */
		int brk;
		if ((brk=file.ReverseFind('\\'))==-1) brk=0;
		
		/* extract path */
		if (brk) path=file.Left(brk);

		/* extract file */
		file=file.Mid(brk+1);
		
		/* build the action string */
		CString action;
		switch (result) {
			case VirusKiller::SKIPPED: action="skipped"; break;
			case VirusKiller::SCANNED: action="scanned"; break;
			case VirusKiller::INFECTED: action="infected"; break;
			case VirusKiller::CLEANED: action="cleaned"; break;
			case VirusKiller::DELETED: action="deleted"; break;
		default:
			action="error"; break;
		}

		/* add item to output list control */
		int itemid=output.InsertItem(0,file);

		/* set fields */
		output.SetItemText(itemid,1,action);
		output.SetItemText(itemid,2,path);
	}
}

void CNimdaDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CNimdaDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

HCURSOR CNimdaDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CNimdaDlg::OnTimer(UINT nIDEvent) 
{
	if (nIDEvent==1)
		UpdateStatistics();
	else
		CDialog::OnTimer(nIDEvent);
}

void CNimdaDlg::UpdateStatistics() 
{
	if (GetText(btnOk)!="Start") {
		CString s;
		
		/* scanned files */
		s.Format("%d ", Scanned());
		scanned.SetWindowText(s);

		/* directories */
		s.Format("%d ", Directories());
		directories.SetWindowText(s);

		/* errors */
		s.Format("%d ", Errors());
		errors.SetWindowText(s);

		/* skipped */
		s.Format("%d ", Skipped());
		skipped.SetWindowText(s);

		/* deleted */
		s.Format("%d ", Deleted());
		deleted.SetWindowText(s);

		/* scan rate */
		int seconds=Duration().GetTotalSeconds();
		if (seconds>0) {
			s.Format("%6.2f ", ((double)BytesScanned() / seconds)/1024/1024 );
			scanrate.SetWindowText(s);
		}

		/* velocity */
		s.Format("%8.1f ", Velocity());
		velocity.SetWindowText(s);

		/* infected files */
		s.Format("%d ", Infected());
		infected.SetWindowText(s);

		/* cleaned files */
		s.Format("%d ", Cleaned());
		cleaned.SetWindowText(s);

		/* elapsed time */
		time.SetWindowText(Duration().Format("%H : %M : %S "));

		/* current file */
		file.SetWindowText(LastFileScanned());

		if (!Running())
			if (GetText(btnOk)!="Close") btnOk.SetWindowText("Close");
	}
}

void CNimdaDlg::OnOK() 
{
	if (Scanned()>0)	
		CDialog::OnOK();
	else {
		/* get the root directory */
		CString scan_root=GetText(root);
		
		/* set root directory of scan */
		Root(scan_root);

		/* start the scan */
		Start();

		/* change button text */
		btnOk.SetWindowText("Stop");
	}
}
