// VirusCleaner.h: interface for the CVirusCleaner class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_VIRUSCLEANER_H__0C2F5D44_E182_44B9_B6EC_99169BDEE15B__INCLUDED_)
#define AFX_VIRUSCLEANER_H__0C2F5D44_E182_44B9_B6EC_99169BDEE15B__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "ServiceThread.h"
#include <set>

/* type definition for virus scanners & killers */
class VirusKiller {
public:
	/* enumerator for scan/clean return values */
	typedef enum{ SKIPPED=0, SCANNED=1, INFECTED=2, CLEANED=4, DELETED=8, ERR=128 } SCANRESULT;

	/* collection of virus killers */
	typedef set<VirusKiller*> Set;

	/* constructors */
	VirusKiller(LPCTSTR name, LPCTSTR extensions=NULL, bool all_files=false);
	VirusKiller(const VirusKiller& copy);

	/* destructor */
	virtual ~VirusKiller() {}

	/* assignment */
	VirusKiller& operator=(const VirusKiller& copy);

	/* returns the name of the virus */
	inline const CString& Name() const { return m_name; }

	/* returns file extensions associated with this virus (seperated by semi-colons) */
	inline const CString& Extensions() const { return m_extensions; }

	/* returns whether all files with this extension will be cleaned */
	inline bool AllFiles() const { return m_allfiles; }
	void AllFiles(bool allfiles) { m_allfiles=allfiles; }

	/* returns the signature for this virus :
			You must set the m_signature in the child class so the scanning algorithm will
			know what to scan for in the files.
	*/
	inline LPBYTE Signature() const { return m_signature; }

	/* cleans a file that contains a recognized signature 
			Called by the scanner when it has detected a file that must be cleaned. You must
			override this method in any child class.
	*/
	virtual SCANRESULT Clean(LPCTSTR file) { ASSERT(FALSE); return ERR; }

	/* comparison operator sorts collection of virus killers by name */
	inline bool operator<(const VirusKiller& rhs) const { return m_name<rhs.m_name; }

protected:
	CString	m_name,			/* name of the virus */
			m_extensions;	/* extensions associated with virus */
	LPBYTE	m_signature;	/* signature string of virus */
	bool	m_allfiles;		/* all files with this signature will be cleaned */
};



class CVirusCleaner  : public CServiceThread
{
public:
	/* scan starts immediately */
	CVirusCleaner(LPCTSTR root=NULL);

	/* stops scan (if in progress) and destroys object */
	virtual ~CVirusCleaner();

	/* get or set the root directory the scan begins at */
	inline const CString& Root() const { return m_root; }
	void Root(LPCTSTR root) { ASSERT(root); m_root=root; }

	/* number of files scanned */
	inline int Scanned() const { return m_scanned; }

	/* number of files skipped in scan */
	inline int Skipped() const { return m_skipped; }

	/* number of errors encountered scanning files */
	inline int Errors() const { return m_errors; }

	/* number of directories scanned */
	inline int Directories() const { return m_directories; }

	/* velocity of scanning in files / second */
	double Velocity() const;

	/* number of files cleaned */
	inline int Cleaned() const { return m_cleaned; }

	/* number of files deleted */
	inline int Deleted() const { return m_deleted; }

	/* number of files infected */
	inline int Infected() const { return m_infected; }

	/* start of scanning */
	inline CTime StartTime() const { m_starttime; }

	/* duration of scanning */
	inline CTimeSpan Duration() const { if (Running()) return CTime::GetCurrentTime()-m_starttime; else return m_stoptime-m_starttime; }

	/* last file scanned */
	inline const CString& LastFileScanned() const { return m_lastfile; }

	/* amount of data scanned in bytes */
	inline DWORD BytesScanned() const { return m_bytesscanned; }

	/* true if cleaner is to scan all files */
	inline bool ScanAll() const { return false; }

	/* notification method that a file has been scanned as infected */
	virtual void OnInfected(LPCTSTR filename, VirusKiller::SCANRESULT result) {}

	/* overloads of service thread */
	virtual bool Start() { m_starttime=CTime::GetCurrentTime(); return CServiceThread::Start(); }

protected:
	/* starting directory of scan */
	CString m_root;

	/* scan statistics */
	int		m_scanned,
			m_skipped,
			m_errors,
			m_infected,
			m_deleted,
			m_cleaned,
			m_directories;
	double	m_velocity;
	DWORD	m_bytesscanned;
	CTime	m_starttime,
			m_stoptime;
	CString	m_lastfile;

	/* log file */
	CFile	m_logfile;

	/* scan algorithm configuration */
	DWORD	m_read_block_size;	/* size of each file read operation */


	/* collection of virus scanners & killers */
	VirusKiller::Set	m_killers;

	/* start of worker thread : starts scanning from root */
	virtual void run();

	/* definition of a collection of virus keyed by extension */
	typedef map<CString , VirusKiller::Set > VirusGraph;

	/* collection of virus signatures when scan is active */
	VirusGraph	m_killergraph;

	/* builds a graph of file extensions and associated virus killers given a list of virus killers */
	VirusGraph BuildVirusGraph(const VirusKiller::Set& kset);

	/* scans a single directory for infected files : uses recursion */
	bool scandirectory(LPCTSTR root);

	/* scans a file for a virus signature */
	bool scanfile(LPCTSTR file);

	/* cleans a specified file by a specified number of virus killers */
	VirusKiller::SCANRESULT cleanfile(LPCTSTR file, VirusKiller::Set& infections);
};

#endif // !defined(AFX_VIRUSCLEANER_H__0C2F5D44_E182_44B9_B6EC_99169BDEE15B__INCLUDED_)
