//////////////////////////////////////////////////////////////////////
//
// ServiceThread.h: interface for the CServiceThread class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_SERVICETHREAD_H__09E5CAF8_41F3_11D4_ACD1_0080C6F185C3__INCLUDED_)
#define AFX_SERVICETHREAD_H__09E5CAF8_41F3_11D4_ACD1_0080C6F185C3__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "Property.h"

//all thread procedures have to be prepended with __cdecl()
#define THREADPROC __cdecl


class CServiceThread
{
public:
	CServiceThread(bool autostart=false);
	virtual ~CServiceThread();

	virtual bool Start();
	virtual bool Stop(bool wait=true);
	inline bool Running() const { return m_threadid>1; }
	inline bool StopPending() const { return m_threadid==1; }

	// parameter methods
	CServiceThread& operator+=(const Properties& parameters);
	CServiceThread& operator=(const Properties& parameters);

protected:
	DWORD		m_threadid;
	Properties	m_parameters;

	
	// Overload this virtual function and provide your own
	// thread implementation.
	virtual void run();

	static void THREADPROC s_run(void* importobj);
};

#endif // !defined(AFX_SERVICETHREAD_H__09E5CAF8_41F3_11D4_ACD1_0080C6F185C3__INCLUDED_)
