// ServiceThread.cpp: implementation of the CServiceThread class.
//
//////////////////////////////////////////////////////////////////////

#include "ServiceThread.h"
#include "process.h"


#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CServiceThread::CServiceThread( bool autostart) : m_threadid(0)
{
	if (autostart) Start();
}

CServiceThread::~CServiceThread()
{
	int timeout=1000;
	if (m_threadid>1)
		Stop();
	else
	{
		while ((timeout--) && (m_threadid==1))
			Sleep(10);
		if (!timeout)
			TRACE0("<CServiceThread>  Destructor has timed out while waiting for thread to exit.\r\n");
	}
}

CServiceThread& CServiceThread::operator+=(const Properties& parameters)
{
	m_parameters += parameters;
	return *this;
}

CServiceThread& CServiceThread::operator=(const Properties& parameters)
{
	m_parameters = parameters;
	return *this;
}

bool CServiceThread::Start()
{
	// restart thread if already running
	if (Running()) Stop();
	m_threadid = _beginthread( s_run,0,(void *)this);
	return m_threadid>0;
}

bool CServiceThread::Stop(bool wait)
{
	int timeout=1000;
	if (Running())
	{
		m_threadid=1;
		if (wait)
			while ((m_threadid>0) && (timeout--))
				Sleep(10);
	}
	return (timeout>0);
}


void THREADPROC CServiceThread::s_run(void* importobj)
{
	((CServiceThread*)importobj)->run();
	((CServiceThread*)importobj)->m_threadid=0;
}

void CServiceThread::run()
{
}


