// Property.h: interface for the Property class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_Property_H__D75B0E64_DC11_11D3_ACCF_C873CA3F5932__INCLUDED_)
#define AFX_Property_H__D75B0E64_DC11_11D3_ACCF_C873CA3F5932__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#define VC_EXTRALEAN		// Exclude rarely-used stuff from Windows headers
#include "afx.h"

#include "stl.h"

class Property : public CString
{
friend class Properties;
public:
	Property();
	Property(LPCTSTR name, LPCTSTR value="");
	Property(LPCTSTR name, bool value);
	Property(LPCTSTR name, long value);
	Property(LPCTSTR name, double value);
	virtual ~Property();

	inline bool IsValid() const { return this==&InvalidProperty; }
	inline bool operator < (const Property& object) const { return false; }

	CString Name;

	// synonymous property methods (modify the AsString variable)
	__declspec(property(get=asstring,put=asstring)) bool AsString;
	__declspec(property(get=asbool,put=asbool)) bool AsBool;
	__declspec(property(get=asint,put=asint)) long AsInteger;
	__declspec(property(get=asfloat,put=asfloat)) double AsFloat;

	// conversion operators
	inline operator bool() const { return AsBool; }
	inline operator int() const { return AsInteger; }
	inline operator long() const { return AsInteger; }
	inline operator double() const { return (double)AsFloat; }

	// assignment operators
	inline Property& operator =(LPCTSTR s) { AsString=s; return *this; }
	inline Property& operator =(const bool b) { asbool(b); return *this; }
	inline Property& operator =(const long l) { asint(l); return *this; }
	inline Property& operator =(const double f) { asfloat((double)f); return *this; }

	static Property	InvalidProperty;

	CString&	asstring();
	void		asstring(LPCTSTR s);
	bool		asbool() const;
	void		asbool(const bool b);
	long		asint() const;
	void		asint(const long i);
	double		asfloat() const;
	void		asfloat(const double f);
};

class Properties : public vector<Property>
{
public:
	Properties();
	Properties(const Properties& p);

	const Property&	operator()(LPCTSTR name) const;
	Property&	operator()(LPCTSTR name);

	bool contains(LPCTSTR name) const;
	static bool IsPropertyList(LPCTSTR s);

	Properties& operator +=(const Properties& p);
	Properties& operator =(const Properties& p);
	Properties& operator =(LPCTSTR plist);
};

#endif // !defined(AFX_Property_H__D75B0E64_DC11_11D3_ACCF_C873CA3F5932__INCLUDED_)
