// Property.cpp: implementation of the Property class.
//
//////////////////////////////////////////////////////////////////////

#include "Property.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// Static property indicating invalid parameter
Property	Property::InvalidProperty;




Property::Property()
{
}

Property::Property(LPCTSTR name, LPCTSTR value)
{
	if (name) Name=name;
	if (value) CString::operator=(value);
}

Property::Property(LPCTSTR name, bool value)
	: Name(name), CString( value?"true":"false" )
{
}

Property::Property(LPCTSTR name, long value)
	: Name(name)
{
	AsInteger=value;
}

Property::Property(LPCTSTR name, double value)
	: Name(name)
{
	AsFloat=value;
}

Property::~Property()
{
}

CString& Property::asstring()
{
	return *this;
}

void Property::asstring(LPCTSTR s)
{
	*this = s;
}

bool Property::asbool() const
{
	return (operator[](0)=='T') || (operator[](0)=='t');
}

void Property::asbool(const bool b)
{
	AsString=(b?"true":"false");
}

long Property::asint() const
{
	return atol(*this);
}

void Property::asint(const long i)
{
	AsString.Format("%d",i);
}

double Property::asfloat() const
{
	return atof(*this);
}

void	 Property::asfloat(const double f)
{
	AsString.Format("%f",f);
}

Properties::Properties()
{
}

Properties::Properties(const Properties& p)
{
	operator=(p);
}

const Property&	Properties::operator()(LPCTSTR name) const
{
	for(const_iterator p=begin(), e=end(); p!=e; p++)
		if ((*p).Name.CompareNoCase(name)==0)
			return *p;
	return Property::InvalidProperty;
}

Property&	Properties::operator()(LPCTSTR name)
{
	for(iterator p=begin(), e=end(); p!=e; p++)
		if ((*p).Name.CompareNoCase(name)==0)
			return *p;

	// Create a new parameter named 'name' and set to ""
	p=insert(end(),Property(name));
	return *p;
}

bool Properties::contains(LPCTSTR name) const
{
	for(const_iterator p=begin(), e=end(); p!=e; p++)
		if ((*p).Name.CompareNoCase(name)==0)
			if ((*p).IsEmpty())
				return false;
			else
				return true;
	return false;
}

bool Properties::IsPropertyList(LPCTSTR s)
{
	return (s[0]=='{') && (s[strlen(s)-1]=='}');
}


Properties& Properties::operator =(const Properties& p)
{
	clear();
	insert(end(),p.begin(), p.end());
	return *this;
}

Properties& Properties::operator +=(const Properties& p)
{
	insert(end(),p.begin(), p.end());
	return *this;
}

Properties& Properties::operator =(LPCTSTR plist)
{
	if (IsPropertyList(plist))
	{
		CString list = plist;
		CString name, value;
		int istart, iend;
		list = list.Mid(1,list.GetLength()-2);

		// trim the properties list
		list.TrimRight();  list+=';';

		while (!list.IsEmpty())
		{
			list.TrimLeft();
			istart = list.Find('(');
			iend   = list.Find(");");
			if ((istart>0) && (iend>0))
			{
				
				name = list.Left(istart);  name.TrimRight();
				value = list.Mid(istart+1,iend-istart-1);  value.TrimLeft();  value.TrimRight();
				operator()(name) = value;
				list=list.Mid(iend+2);
			}
			else
				list.Empty();
		}

	}
	return *this;
}

