IMPLEMENTATION MODULE AidsPanel;
FROM SYSTEM IMPORT ADDRESS,ADR,ASSEMBLER;
FROM System IMPORT Terminate;
FROM Display IMPORT displayLines,displayCols,displayMode;
FROM Keyboard IMPORT F1,SF9,SF10,PgUp,PgDn,End,GetKeyCh;
FROM Windows IMPORT Window,OpenWindow,CloseWindow;
FROM Terminal IMPORT WriteString,WriteLn;
FROM Strings IMPORT Assign,CompareStr,Concat,Append,Length;
FROM Files IMPORT Close,Create,WRITE,READ,Write,Rename,Delete;
FROM Directories IMPORT SetFileAttr,GetFileAttr;
FROM NumberConversion IMPORT CardToString;

FROM StorageSelector IMPORT alloc,dealloc;
FROM ScreenManager IMPORT smfmt,smput,smufmt,smtype,smwrit,smread,smqcurs,
	smgetn,dispAtt,alphAtt,smclr,smmenu,SpecialKeyAction;
FROM MoveDown IMPORT WordDown;
FROM MenuBox IMPORT Dialogue,SelectMenu;
FROM MESSAGE IMPORT MessageList,Message;
FROM Voie IMPORT useDOSMem,garer;

FROM AidsFile IMPORT CreateFile,ExistFile,Aids,Bak;
FROM AidsList IMPORT Path,total,fList,FileWindow,Voierror,MakeString;
(*
FROM DumpOut IMPORT PrintString,Print,PrintCard,PrintLn,PrintAddr,Pause,
	PrintInt,PrintHex,PrintBool;
FROM deMFUs IMPORT HeapCheck;*)

(* $L- ,$T-, $R- ,$S- *)
(*
PROCEDURE DumpFile ();
BEGIN
	WITH FileWindow DO
		PrintString (' stat=');Print(wStat);PrintString (' name=|');
		PrintString (wName);
		Print (',');
		PrintString (wExt);PrintString ('| path=|');
		PrintString (wDir);Print ('|');PrintLn;
		PrintString (cur);PrintLn;
		PrintString (org);PrintLn;
	END;(*WITH*)
END DumpFile;

PROCEDURE ListUp ();
VAR
	c: CARDINAL;
BEGIN
Pause (' List up File List . change log file');
	FOR c := 1 TO total DO
		PrintCard (c,5);
		IF garer (fList,c) THEN
			PrintString (' Voie Error ');
		ELSE
			DumpFile ();
		END;(*IF*)
		PrintLn;
	END;(*FOR*)
END ListUp;
*)
CONST
	baseLine = 1;
	bottom = 1;
	maxLine = 43;
	DIRECTORY = 4;
	READONLY = 0;
TYPE
	List = ARRAY [1..3200] OF CARDINAL;
VAR
	bottomLine,lineDepth,lineLimit :CARDINAL;
	lOrg,tous,lEnd :CARDINAL;
	line: CARDINAL;
	mask:ARRAY [0..10] OF CHAR;
	list : POINTER TO List;
	flush,toggle,refresh:BOOLEAN;
	win: Window;
(* $L- *)
PROCEDURE makePanel ();
VAR
	line,fld :CARDINAL;
BEGIN
(*PrintString (' in make Panel s=');PrintLn;
PrintString ('line=');PrintCard (displayLines,4);
PrintString (' col=');PrintCard (displayCols,4);
PrintString (' mode=');PrintCard (displayMode,4);
PrintString (' bottom=');PrintCard (bottomLine,4);PrintLn;*)
		bottomLine := displayLines - bottom;
(*AssertScreen (s,'Initial screen');*)
		lineDepth := bottomLine - baseLine;
		IF lineDepth > maxLine THEN
			lineDepth := maxLine;
			bottomLine := lineDepth + baseLine
		END;(*IF*)
		lineLimit := lineDepth - 5;
(*PrintString (' bottom=');PrintCard (bottomLine,4);PrintLn;
PrintString (' line=');PrintCard (lineDepth,4);
PrintString (' bottom=');PrintCard (bottomLine,4);PrintLn;*)
		smfmt (255,1,69,1,11,0,dispAtt);
		smfmt (254,1,58,1,10,2,alphAtt);
		smfmt (253,1,53,1,4,0,dispAtt);
		smput (253,MessageList^.list[30]^);
		smfmt (252,1,35,1,10,0,dispAtt);
		smfmt (251,1,1,1,20,0,dispAtt);
		smput (251,MessageList^.list[31]^);
		FOR line := 2 TO lineDepth + 1 DO
			fld :=line - 1;
(*PrintString ('line=');PrintCard (line,4);
PrintString (' fld=');PrintCard (fld,4);PrintLn;*)
			smfmt (fld,line,1,1,2,2,017H);
			INC (fld,lineDepth);
			smfmt (fld,line,5,1,8,0,07);
			INC (fld,lineDepth);
			smfmt (fld,line,17,1,3,0,07);
			INC (fld,lineDepth);
			smfmt (fld,line,22,1,50,0,07);
		END;(*FOR*)
		smmenu (MessageList^.list[38]^,FALSE);
		smmenu (MessageList^.list[39]^,TRUE);
(*AssertScreen (s,'Initial screen');
Pause ('Exit of makePanel');
HeapCheck ();*)
END makePanel;


PROCEDURE sortList (term: CARDINAL);(* Il faut reserver l'ordre vieux *)
VAR
	f,s,l,m,n :CARDINAL;
	queue,moin,plus :CARDINAL;
	cmp : INTEGER;
	keep,mode :BOOLEAN;
	value :Path;
	ch :CHAR;

PROCEDURE Compare ():INTEGER;
VAR
	x :Path;
	res :INTEGER;
BEGIN
(*PrintString ('compare |');*)
	WITH FileWindow DO
		IF term = 1 THEN
			Assign (wName,x);
		ELSIF term = 2 THEN
			Assign (wExt,x);
		ELSE
			Assign (wDir,x)
		END;(*IF*)
	END;(*fileWindow*)
(*PrintString (x);Print ('|');PrintString (value);Print ('|');*)
		res := CompareStr (x,value);
(*PrintInt (res,4);PrintLn;*)
	RETURN res;
END Compare;

BEGIN
	queue := 0;
	IF flush THEN tous := total END;
(*PrintString ('sortList ');PrintString (mask);PrintCard (term,4);PrintLn;*)
	WITH FileWindow DO
		FOR n := 1 TO tous DO
(*PrintLn;PrintString (' Num=');PrintCard (n,4);*)
			IF flush THEN
				s := n
			ELSE
				s := list^[n]
			END;(*IF*)
(*PrintString (' rec=');PrintCard (s,4);Print (' ');*)
			keep := garer (fList,s);
			IF keep THEN
				Voierror ()
			ELSE
(*Print (wStat);Print (' ');PrintString (wName);Print('.');PrintString (wExt);*)
				m := 0;
				LOOP
					ch := mask[m];
					IF ch = 00X THEN EXIT END;
					keep := ch = FileWindow.wStat;
					IF keep THEN EXIT END;
					INC (m);
					IF m > 8 THEN EXIT END;
				END;(*LOOP*)
				IF keep THEN
(*PrintString ('accepted ');*)
					option := 00X;
					IF term = 0 THEN
						list^[queue + 1] := s;
					ELSE
						IF term = 1 THEN
							Assign (wName,value)
						ELSIF term = 2 THEN
							Assign (wExt,value)
						ELSE
							Assign (wDir,value);
						END;(*IF*)
(*PrintString ('value');PrintString (value);*)
(* sorting *)
(*PrintString (' queue=');PrintCard (queue,4);PrintLn;*)
						IF queue = 0 THEN
							list^[1] := s
						ELSE
							moin := 1;
							IF garer (fList,list^[moin]) THEN Voierror () END;
							cmp := Compare ();
(*PrintString ('statrt 1 ');PrintInt (cmp,4);PrintLn;*)
							IF cmp > 0 THEN
(*PrintString (' top');PrintLn;*)
								WordDown (list^[1],queue);
								list^[1] := s
							ELSE
								plus := queue;
								IF garer (fList,list^[plus]) THEN Voierror () END;
								cmp := Compare ();
(*PrintString (' queue=');PrintCard (queue,4);PrintInt (cmp,4);PrintLn;*)
								IF cmp <= 0 THEN
(*PrintString (' bottom');PrintLn;*)
									list^[queue + 1] := s;
								ELSE
									LOOP
										m := (moin + plus) DIV 2;
(*PrintString ('loop moin=');PrintCard (moin,4);
PrintString (' plus=');PrintCard (plus,4);
PrintString (' queue=');PrintCard (queue,4);PrintLn;*)
										f := list^[m];
										IF garer (fList,list^[m]) THEN Voierror () END;;
										cmp := Compare ();
(*PrintString (' m=');PrintCard (m,4);PrintInt (cmp,4);PrintLn;*)
										IF cmp > 0 THEN
											plus := m
										ELSIF cmp < 0 THEN
											moin := m;
										ELSE
											REPEAT
												INC (m);
												IF garer (fList,list^[m]) THEN Voierror () END;
												cmp := Compare ();
(*PrintString (' mm=');PrintCard (m,4);PrintInt (cmp,4);PrintLn;*)
												IF cmp  > 0 THEN EXIT END;
											UNTIL m = plus;
										END;(*meno*)
										IF plus - moin  = 1 THEN
											m := moin + 1;
											EXIT
										END;
									END;(*LOOP*)
(*PrintString ('out of loop moin=');PrintCard (moin,4);
PrintString (' plus=');PrintCard (plus,4);
PrintString (' queue=');PrintCard (queue,4);PrintLn;*)
									f := queue - m + 1;
(*PrintString ('fin moin=');PrintCard (moin,4);
PrintString (' m=');PrintCard (m,4);
PrintString (' f=');PrintCard (f,4);
PrintString (' plus=');PrintCard (plus,4);
PrintString (' queue=');PrintCard (queue,4);PrintLn;*)
									WordDown (list^[m],f);
									list^[m] := s;
								END;(*plus*)
							END;(*meno*)
						END;(*IF*)
					END;(*sorted*)
					INC (queue);
(*PrintString (' end of step queue=');PrintCard (queue,4);PrintLn;
FOR f := 1 TO queue DO PrintCard (list^[f],5) END;PrintLn;*)
				ELSE
(*PrintString (' skipped');*)
				END;(*keep*)
			END;(*IF*)
		END;(*FOR*)
	END;(*WITH*)
	tous := queue;
	flush := FALSE;
	refresh := TRUE;
	lOrg := 0;
END sortList;
(* $L- *)
PROCEDURE newPanel ();
VAR
		f,l,line,col,fBase : CARDINAL;
		str :Path;
		c: CHAR;
		number :ARRAY [0..11] OF CHAR;
BEGIN
(*PrintLn;PrintString ('newPanel ');PrintLn;*)
	WITH FileWindow DO
		IF toggle THEN
			smput (252,MessageList^.list[32]^)
		ELSE
			smput (252,MessageList^.list[33]^)
		END;(*IF*)
		lEnd := tous - lOrg;
		IF lEnd >= lineDepth THEN lEnd := lineDepth END;
(*PrintString ('lOrg=');PrintCard (lOrg,4);
PrintString (' lEnd=');PrintCard (lEnd,4);
PrintString (' lines=');PrintCard (lineDepth,4);
PrintLn;*)
		FOR line := 1 TO lEnd DO
			l :=line + lOrg;
			f := list^[l];
(*PrintString (' line=');PrintCard (line,4);
PrintString (' win=');PrintCard (f,4);*)
			IF garer (fList,f) THEN Voierror () END;
	 		fBase := line;
(*PrintString (' fBase=');PrintCard (fBase,4);*)
			Concat (wStat,option,str);
			smput (fBase,str);
			smtype (fBase,2);
			INC (fBase,lineDepth);
(*PrintString (' fBase=');PrintCard (fBase,4);*)
			smput (fBase,wName);
			INC (fBase,lineDepth);
(*PrintString (' fBase=');PrintCard (fBase,4);*)
			smput (fBase,wExt);
			INC (fBase,lineDepth);
(*PrintString (' fBase=');PrintCard (fBase,4);*)
			IF toggle THEN
				smput (fBase,wDir)
			ELSE
				IF (wStat = 'D') OR (wStat = 'd') THEN
					smput (fBase,org)
				ELSE
					smput (fBase,cur);
				END;(*IF*)
			END;(*IF*)
(*PrintLn;*)
		END;(*FOR*)
		IF lEnd < lineDepth THEN
			FOR line := lEnd + 1 TO lineDepth DO
(*PrintString (' line=');PrintCard (line,4);PrintLn;*)
				fBase := line;
				FOR col := 0 TO 3 DO
(*PrintString ('erased =');PrintCard (fBase,4);*)
					smtype (fBase,0);
					smput (fBase,"");
					INC (fBase,lineDepth)
				END;(*FOR*)
(*PrintLn;*)
			END;(*FOR*)
		END;(*IF*)
		smput (254,mask);
		CardToString (tous,str,5);
		l := 11;
		number[l] := 00X;
		FOR f := 4 TO 0 BY -1 DO
			c := str[f];
			IF c <> ' ' THEN
				DEC (l);
				number[l] := c;
			END;(*IF*)
		END;(*FOR*)
		DEC (l);
		number[l] := '/';
		f := lOrg + 1;
		CardToString (f,str,5);
		FOR f := 4 TO 0 BY -1 DO
			c := str[f];
			IF c <> ' ' THEN
				DEC (l);
				number[l] := c;
			END;(*IF*)
		END;(*FOR*)
		WHILE l > 0 DO
			DEC (l);
			number[l] := ' '
		END;(*WHILE*)
		smput (255,number);
(*PrintString (' term=');PrintCard (term,4);*)
	END;(*WITH*)
	refresh := FALSE;
(*HeapCheck ();
Pause (' Exit of newPanel');*)
END newPanel;

PROCEDURE saveLog ();
CONST
	Size = 70;
VAR
	out: INTEGER;
	n,r,p: CARDINAL;
	c: CHAR;
	Line: ARRAY [0..Size] OF CHAR;
	adr : ADDRESS;
BEGIN
	IF CreateFile THEN
		Delete (Aids)
	ELSE
		Rename (Aids,Bak)
	END;(*IF*)
	Create (out,Aids,READ);
(*Delete ("Test.lg");
Create (out,"Test.lg",READ);*)
	adr := ADR (Line);
	IF out > 0 THEN
		FOR n := 1 TO total DO
(*PrintCard (n,4);*)
			IF garer (fList,n) THEN Voierror () END;
			WITH FileWindow DO
				c := CAP(wStat);
(*Print (' ');Print (c);PrintLn;*)
				IF (c <> 'D') AND (c <> 'E') THEN
					p := 0;
					r := 1;
					LOOP
						c := wName[r];
						IF c = 00X THEN EXIT END;
						Line[p] := c;
						INC (r);
						INC (p);
						IF r > 8 THEN EXIT END
					END;(*LOOP*)
					IF r < 9 THEN
						REPEAT
							Line[p] := ' ';
							INC (p);
							INC (r);
						UNTIL r > 8;
					END;(*IF*)
					Line[p] := ',';
					INC (p);
					r := 1;
					LOOP
						c := wExt[r];
						IF c = 00X THEN EXIT END;
						Line[p] := c;
						INC (r);
						INC (p);
						IF r > 3 THEN EXIT END
					END;(*LOOP*)
					IF r < 4 THEN
						REPEAT
							Line[p] := ' ';
							INC (p);
							INC (r);
						UNTIL r > 3;
					END;(*IF*)
					Line[p] := ',';
					INC (p);
					FOR r := 0 TO 49 DO
						Line[p] := cur[r];
						INC (p);
					END;(*FOR*)
(*Print (';');PrintCard (p,4);PrintLn;*)
					Line[p] := ';';
					INC (p);
(*Print ('D');PrintCard (p,4);PrintLn;*)
					Line[p] := 0DX;
					INC (p);
(*Print ('D');PrintCard (p,4);PrintLn;*)
					Line[p] := 0AX;
					INC (p);
					Line[p] := 00X;
					Write (out,adr,p,r);
(*FOR r := 0 TO p DO
c := Line[r];
Print (c);PrintString ('|    ');PrintHex (ORD(c),2);PrintCard (r,4);PrintLn;
END;
Pause (' next');*)
					IF r <> p THEN
						Message (28);
						Close (out);
						RETURN
					END;
				END;(*IF*)
			END;(*WITH*)
		END;(*FOR*)
		Close (out);
		c := Dialogue (4,MessageList^.list[6]^);
(*PrintString ('Aids closed ');PrintCard (out,5);PrintLn;*)
	ELSE
		Message (1);
	END;(*IF*)
END saveLog;

PROCEDURE eraseFiles ();
VAR
	hold: BOOLEAN;
	n,f,count: CARDINAL;
	c : CHAR;
	num : ARRAY [0..5] OF CHAR;
	str : Path;
(* $L+ *)
PROCEDURE DeleteFile ();
VAR
	path: Path;
	code: CARDINAL;
	attr: BITSET;
BEGIN
	WITH FileWindow DO
		IF wStat > 60X THEN
			Concat (wDir,wName,path);
			Append (path,'.');
			Append (path,wExt)
		ELSE
			Assign (wDir,path);
			code := Length (path);
			DEC (code);
			IF path[code] = '\' THEN path[code] := 00X END;
		END;
		GetFileAttr (path,attr);
(*PrintLn;PrintString ('Deletefile ');PrintString (path);
PrintString (' attr ');PrintHex (CARDINAL(attr),4);
PrintString (' path=');PrintAddr (ADR(path));*)
		IF READONLY IN attr THEN
			MakeString (str,37,path);
			c := CAP(Dialogue (6,str));
(*Print (',');Print (c);*)
			IF (c <> 'Y') AND (c <> 'O') THEN RETURN END;
			EXCL (attr,READONLY);
(*PrintString (' ew attr=');PrintHex (CARDINAL(attr),4);PrintLn;*)
			SetFileAttr (path,attr);
		END;(*IF*)
(*PrintString (' DELETED	!');PrintString (path);PrintLn;*)
		IF DIRECTORY IN attr THEN
			code := 3AH
		ELSE
			code := 41H
		END;(*IF*)
		ASM
			MOV	AX,SS
			MOV	DS,AX
			LEA	DX,path
			MOV	AH,code
			INT	21H
			JC	error
			MOV	AX,0
error:
			MOV	code,AX
			MOV	DS,CS:[0]
		END;
		IF code = 0 THEN
			IF DIRECTORY IN attr THEN
				wStat := 'E'
			ELSE
				wStat := 'e';
			END;(*IF*)
			option := 00X;
			flush := TRUE;
		ELSE
			CardToString (code,num,4);
			MakeString (str,34,num);
			Append (str,path);
			c := Dialogue (7,str);
		END;(*IF*)
(*		Delete (path);*)
	END;(*WITH*)
END DeleteFile;
(* $L- *)
BEGIN
(*PrintString (' Erase File');PrintLn;*)
	hold := TRUE;
	count := 0;
	FOR n := 1 TO tous DO
		f := list^[n];
(*PrintCard (n,3);PrintCard (f,4);PrintCard (count,4);PrintBool (hold);*)
		IF garer (fList,f) THEN Voierror () END;
		WITH FileWindow DO
(*Print (' ');Print(wStat);Print(option);Print ('|');PrintString (wDir);
PrintString (wName);Print ('.');PrintString (wExt);*)
			IF option = 'E' THEN
				DeleteFile ();
(*PrintLn;*)
				hold := FALSE
			END;(*IF*)
			IF hold THEN
				IF option = 'M' THEN INC (count) END;
			END;(*IF*)
		END;(*WITH*)
(*PrintLn;*)
	END;(*FOR*)
	IF hold AND (count > 0) THEN
		CardToString (count,num,5);
		MakeString (str,36,num);
		c := CAP(Dialogue (12,str));
(*PrintString ('erase marked');PrintCard (count,4);Print (c);*)
		IF (c = 'Y') OR (c = 'O')  THEN
			FOR n := 1 TO tous DO
				f := list^[n];
(*PrintCard (n,3);PrintCard (f,4);PrintCard (count,4);PrintBool (hold);*)
				IF garer (fList,f) THEN Voierror () END;
				WITH FileWindow DO
(*Print (' ');Print(wStat);Print(option);Print ('|');PrintString (wDir);
PrintString (wName);Print ('.');PrintString (wExt);*)
					IF option = 'M' THEN
						DeleteFile ();
(*PrintLn;*)
					END;(*IF*)
				END;(*WITH*)
(*PrintLn;*)
			END;(*FOR*)
		END;(*IF*)
	END;(*IF*)
END eraseFiles;

PROCEDURE gatherFiles ();
VAR
	n,f,p: CARDINAL;
BEGIN
	p := 0;
(*PrintString (' gatherFiles');PrintLn;*)
	FOR n := 1 TO tous DO
(*PrintCard (n,4);*)
		f := list^[n];
(*PrintCard (f,4);PrintCard (p,4);Print (' ');*)
		IF garer (fList,f) THEN Voierror () END;
		WITH FileWindow DO
(*Print (option);Print (' ');PrintString (wName);PrintLn;*)
			IF option <> 00X THEN
				INC (p);
				list^[p] := f;
				IF option = 'M' THEN option := 00X END;
			END;(*IF*)
		END;(*WITH*)
	END;(*FOR*)
	tous := p;
	lOrg := 0;
	refresh := TRUE;
END gatherFiles;

PROCEDURE viewDetail (l:CARDINAL);
VAR  lin,fld: CARDINAL;
		str: Path;
		ch: CHAR;
BEGIN
(*PrintString ('viewDetail ');PrintCard (l,4);*)
	IF l >  lineLimit THEN
		lin := lineLimit
	ELSE
		lin := l
	END;(*IF*)
	fld := list^[l + lOrg];
(*PrintCard (fld,4);*)
	IF garer (fList,fld) THEN Voierror () END;
	WITH FileWindow DO
		Concat (wDir,wName,str);
		Append (str,'.');
		Append (str,wExt);
(*Print (' ');PrintString (str);PrintLn;*)
		OpenWindow (win,lin,17,lin+3,75,TRUE,str);
		WriteString (cur);WriteLn;
		WriteString  (org);
		GetKeyCh (ch);
		CloseWindow (win);
	END;(*WITH*)
END viewDetail;
(* no *)
(* $L- *)
PROCEDURE HelpEdit (VAR ch:CHAR);
VAR
	i :CARDINAL;
BEGIN
	IF ch = F1 THEN
		i := smqcurs ();
		ch := 00X;
		IF i = 254 THEN
			IF SelectMenu (i,3,23,MessageList^.list[35]^) THEN
				IF i = 0 THEN
					mask := "cdnu";
				ELSIF i = 1 THEN
					mask := "cnu"
				ELSIF i = 2 THEN
					mask := "cn"
				ELSIF i = 3 THEN
					mask := "cdenuDENX"
				ELSE
					mask := "cnuNX"
				END;(*IF*)
				smwrit (254,mask);
				flush := TRUE;
				refresh := TRUE;
				ch := End
			END;
		ELSE
			OpenWindow (win,3,3,17,73,TRUE,MessageList^.list[40]^);
			FOR i := 41 TO 52 DO
				WriteString (MessageList^.list[i]^);WriteLn;
			END;(*FOR*)
			WriteString (MessageList^.list[53]^);
			GetKeyCh (ch);
			CloseWindow (win);
		END;(*IF*)
	ELSIF ch = PgUp THEN
		ch := SF9
	ELSIF ch = PgDn THEN
		ch := SF10
	END;(*IF*)
END HelpEdit;
(* $L- *)
PROCEDURE panel ();
VAR
	n,k :CARDINAL;
	sort: CARDINAL;
	fld,next,action: CARDINAL;
	c: CHAR;
	str: Path;

PROCEDURE up ();
BEGIN
(*PrintString ('up');PrintCard (lOrg,4);PrintCard (lineDepth,4);*)
		IF lOrg > lineDepth THEN
			DEC (lOrg,lineDepth - 1);
		ELSE
			lOrg := 0
		END;(*IF*)
(*PrintCard (lOrg,4);PrintLn;*)
END up;
PROCEDURE down ();
BEGIN
(*PrintString ('down');PrintCard (lOrg,4);PrintCard (lineDepth,4);PrintCard (tous,4);*)
		IF lineDepth < tous THEN
			IF lOrg + lineDepth < tous THEN
				INC (lOrg,lineDepth - 1);
			ELSIF tous > lineDepth THEN
				lOrg := tous + 1 - lineDepth;
			END;(*IF*)
		END;
(*PrintCard (lOrg,4);PrintLn;*)
END down;
(* $L- *)
BEGIN
(*	ListUp ();*)
	mask := "nc";
	sort := 0;
	alloc (list,total * 2);
	makePanel ();
	flush := TRUE;
	tous := total;
	sortList (0);
	newPanel ();
	LOOP
			SpecialKeyAction := HelpEdit;
			smread (action,next,fld);
(*PrintString (' smread ');PrintCard (action,4);
PrintCard (next,4);PrintCard (fld,4);PrintLn;*)
			IF fld > 0 THEN
				WHILE next > 0 DO
					fld := next;
					smgetn (next,str);
					IF fld = 254 THEN
						Assign (str,mask);
						flush := TRUE;
					ELSE
						line := list^[fld + lOrg];
(*PrintString (' field=');PrintCard (fld,4);
PrintString (' line=');PrintCard (line,4);
PrintString (' str=');PrintString (str);PrintLn;*)
						IF garer (fList,line) THEN Voierror () END;
						c := CAP(str[0]);
						IF (c = 'M') OR (c = 'E') THEN
							WITH FileWindow DO
								option := c;
								Concat (wStat,c,str)
							END;(*FileWindow*)
						ELSIF c = 'V' THEN
							viewDetail (fld);
						ELSE
							FileWindow.option := 00X;
							Concat (FileWindow.wStat,'?',str);
						END;(*IF*)
						smput (fld,str);
					END;(*IF*)
				END;(*WHILE*)
			END;(*IF*)
(*PrintString ('flush');PrintBool (flush);PrintLn;*)
			IF flush THEN
				IF (action < 7) OR (action = 10) THEN sortList (0) END;
			END;(*IF*)
(*PrintString (' action');PrintCard (action,4);PrintBool (flush);
PrintBool (refresh);PrintLn;*)
			CASE action OF
				0,1:|
				2:saveLog ()|
				3:EXIT|
				4:eraseFiles()|
				5:gatherFiles()|
				6:n := smqcurs();
					IF n < 250 THEN viewDetail (n) END|
				7:sort := 1;flush := TRUE|
				8:sort := 2;flush := TRUE|
				9:sort := 3;flush := TRUE|
				10:toggle := NOT toggle;refresh := TRUE|
				19:up ();refresh := TRUE|
				20:down ();refresh := TRUE|
			ELSE
				c := Dialogue (20,"Oh non.......N'y touchez pas.");
			END;(*CASE*)
(*PrintString (' refresh=');PrintBool (refresh);
PrintString (' flush=');PrintBool (flush);PrintLn;*)
			IF flush THEN sortList (sort) END;
			IF refresh THEN newPanel () END;
	END;(*LOOP*)
(*HeapCheck ();*)
	dealloc (list,total*2);
	smclr ();
	smufmt ();
(*HeapCheck ();*)
END panel;
(* $L- *)
BEGIN
	useDOSMem := TRUE;
END AidsPanel.
