IMPLEMENTATION MODULE AidsList;
FROM SYSTEM IMPORT TSIZE;
FROM System IMPORT TermProcedure;
FROM Directories IMPORT NORMAL,DIRECTORY;
FROM Strings IMPORT Assign,Pos,Delete,Insert,Length,Concat,Append;
FROM Voie IMPORT avancer,fermer;
FROM Terminal IMPORT Read;

FROM AidsGlobal IMPORT FileName,FILESTATUS,PtrFILESTATUS,Name,Extent,ExistAncre,AncreFile,more;
FROM AidsFile IMPORT GetExistFile;
FROM AidsComp IMPORT CompareFileName,CompareFile;
FROM TermOut IMPORT WriteString,WriteLongCard,WriteLn,Write,handle;
FROM NumberConversion IMPORT LongCardToString,NumToString;
FROM MESSAGE IMPORT MessageList,STRING,PtrString,Message;
FROM StorageSelector IMPORT alloc,dealloc;
(* $L-, $T-, $R-, $S- *)
(*
FROM DumpOut IMPORT Print,PrintCard,PrintBool,PrintString,PrintHex,PrintAddr,PrintLn,Pause;
*)
VAR
	ExistDir,FileDir,Status : BOOLEAN;
	relation : CARDINAL;
	size : LONGCARD;
	count: CARDINAL;
(*
PROCEDURE DumpFile ();
BEGIN
PrintString ('Window');PrintCard (total,4);
	WITH FileWindow DO
		PrintString (' stat=');
		Print(wStat);PrintString (' Name=|');
		PrintString (wName);
		Print ('.');
		PrintString (wExt);PrintString ('| Path=|');
		PrintString (wDir);Print ('|');PrintLn;
		PrintString (cur);PrintLn;
		PrintString (org);PrintLn;
	END;(*WITH*)
END DumpFile;
*)

PROCEDURE QuitVoie ();
BEGIN
	IF fList <> NIL THEN
		IF fermer (fList) THEN Message (27) END;;
	END;(*IF*)
(*PrintString ('Quit Voie');*)
END QuitVoie;

PROCEDURE Voierror ();
BEGIN
	QuitVoie ();
	makePanel := FALSE;
END Voierror;

PROCEDURE MakeString (VAR str:ARRAY OF CHAR;num:CARDINAL;insert:ARRAY OF CHAR);
VAR l,p : CARDINAL;
BEGIN
	Assign (MessageList^.list[num]^,str);
	l := Length (str);
	p := Pos ('||',str);
	IF p < l THEN
		Delete (str,p,2)
	END;
	Insert (insert,str,p);
END MakeString;

PROCEDURE  report (directory:ARRAY OF CHAR);
VAR
	str,text : STRING;

PROCEDURE Prochain ():PtrFILESTATUS;
VAR
	p : PtrFILESTATUS;
BEGIN
	p := AncreFile^.prochain;
	dealloc (AncreFile,TSIZE (FILESTATUS));
	RETURN p;
END Prochain;
(* $L- *)
PROCEDURE LineEnd;
VAR c: CHAR;
BEGIN
	WriteLn;
	IF more THEN
		INC (count);
		IF count >= 20 THEN
			handle := 2;
			WriteString ('                                                            MORE?');
			Read (c);
			count := 0;
			Write (0DX);
			handle := 1
		END;(*IF*)
	END;(*IF*)
END LineEnd;

PROCEDURE FillStr (VAR dest: ARRAY OF CHAR; source: ARRAY OF CHAR);
VAR
	d,s,p: CARDINAL;
	c: CHAR;
BEGIN
	d := HIGH (dest);
	s := HIGH (source);
(*PrintCard (d,4);PrintCard (s,4);PrintLn;*)
	p := 0;
	LOOP
		c := source[p];
(*Print (c);PrintCard (p,4);PrintHex (ORD(c),3);PrintLn;*)
		IF c = 00X THEN EXIT END;
		dest[p] := c;
		INC (p);
		IF s < p THEN EXIT END;
	END;(*LOOP*)
	IF p <= d THEN
		REPEAT
			dest[p] := ' ';
			INC (p);
(*Print ('*');PrintCard (p,4);PrintLn;*)
		UNTIL p > d;
	END;(*IF*)
END FillStr;

PROCEDURE makeName (stat: PtrFILESTATUS);
BEGIN
	WITH FileWindow DO
(*DumpFile ();*)
		IF makePanel THEN
			INC (total);
			IF avancer (fList) THEN Voierror () END;
		END;
		wName :=stat^.Fname;
		wExt :=stat^.Ftype
	END;(*WITH*)
END makeName;
(* $L- *)
PROCEDURE makeList (VAR list: List; stat: PtrFILESTATUS);
VAR
	name: Name;
BEGIN
	WITH stat^ DO
		FillStr (name,Ftime);
		Assign (name,list);
		Append (list,',');
		FillStr (name,Fdate);
		Append (list,name);
		Append (list,',');
		NumToString (CARDINAL(Fattr),16,text,4);
		Append (list,text);
		Append (list,',');
		NumToString (CheckSum,16,text,4);
		Append (list,text);
		Append (list,',');
		NumToString (CheckCRC,16,text,4);
		Append (list,text);
		Append (list,',');
		NumToString (CHXmodem,16,text,4);
		Append (list,text);
		Append (list,',');
		LongCardToString (Fsize,text,12);
		Append (list,text);
(*PrintString ('list>');
PrintString (list);PrintLn;*)
	END;(*WITH*)
END makeList;
(* $L- *)
PROCEDURE WriteLine ();
VAR c: CHAR;
		name: Name;
		type: Extent;
BEGIN
	WITH FileWindow DO
		FillStr (name,wName);
		WriteString (name);
		Write (',');
		FillStr (type,wExt);
		WriteString (type);
		Write (',');
		IF (wStat = 'd') OR (wStat = 'D') THEN
			WriteString (org);
		ELSE
			WriteString (cur);
		END;(*IF*)
	END;(*WITH*)
	LineEnd ();
END WriteLine;

PROCEDURE Header ();
BEGIN
		LongCardToString (size,str,12);
		Concat (directory,str,text);
		MakeString (str,7,text);
(*		Write (0AX);*)
		WriteString (str);
		LineEnd;
		Status := FALSE;
END Header;

PROCEDURE NewFile ();
BEGIN
	IF Status THEN
		Header ();
	END;(*if*)
	str := MessageList^.list[8]^;
	WITH FileWindow DO
		makeName (AncreFile);
		wStat := 'n';
		makeList (cur,AncreFile);
		Assign (str,org);
	END;(*WITH*)
	WriteString (str);
	WriteLine ();
	AncreFile := Prochain ();
END NewFile;

PROCEDURE DeletedFile ();
BEGIN
	IF Status THEN
		Header ()
	END;(*if*)
	str := MessageList^.list[9]^;
	WITH FileWindow DO
		makeName (ExistAncre);
		wStat := 'd';
		makeList (org,ExistAncre);
		Assign (str,cur);
	END;(*WITH*)
	WriteString (str);
	WriteLine ();
	GetExistFile ();
END DeletedFile;

PROCEDURE NewDirectory ();
BEGIN
(*PrintString ('New Directory');PrintLn;*)
	MakeString (str,10,AncreFile^.Fname);
	WITH FileWindow DO
		makeName (AncreFile);
		Assign (directory,wDir);
		wStat := 'N';
		makeList (cur,AncreFile);
		Assign (str,org);
	END;(*WITH*)
	WriteString (str);
	LineEnd;
	AncreFile := Prochain ();
	WHILE AncreFile <> NIL DO
(*PrintString ('AncreFile=');PrintAddr (AncreFile);
PrintString (AncreFile^.Fname);Print ('.');PrintString (AncreFile^.Ftype);
Print ('|');PrintBool (FileDir);PrintHex (CARDINAL(AncreFile^.Fattr),4);PrintLn;*)
		NewFile ();
	END;(*WHILE*)
END NewDirectory;

PROCEDURE DeletedDirectory ();
BEGIN
	MakeString (str,11,ExistAncre^.Fname);
	WITH FileWindow DO
		makeName (ExistAncre);
		Assign (directory,wDir);
		wStat := 'D';
		makeList (org,ExistAncre);
		Assign (str,cur);
	END;(*WITH*)
	WriteString (str);
	LineEnd;
	GetExistFile ();
	WHILE (ExistAncre<>NIL) AND (ExistAncre^.Fattr <> DIRECTORY) DO
(*PrintString ('ExistFile=');PrintAddr (ExistAncre);
PrintString (ExistAncre^.Fname);Print ('.');PrintString (ExistAncre^.Ftype);
Print ('|');PrintBool (ExistDir);PrintHex (CARDINAL(ExistAncre^.Fattr),4);PrintLn;*)
		DeletedFile ()
	END;(*WHILE*)
END DeletedDirectory;
(* $L- *)
BEGIN
(*PrintLn;
PrintString (directory);
PrintString ('            Report ');PrintAddr (AncreFile);
PrintString (' Ancre ');PrintAddr (ExistAncre);PrintLn;*)
	WriteString ('                                                                              ');
	Write (0DX);
	handle := 1;
	LOOP
		ExistDir := (ExistAncre = NIL) OR (DIRECTORY = ExistAncre^.Fattr);
		FileDir := DIRECTORY = AncreFile^.Fattr;
(*PrintString ('AncreFile=');PrintAddr (AncreFile);
PrintString (AncreFile^.Fname);Print ('.');PrintString (AncreFile^.Ftype);
Print ('|');PrintBool (FileDir);PrintHex (CARDINAL(AncreFile^.Fattr),4);PrintLn;
PrintString ('ExistFile=');PrintAddr (ExistAncre);
PrintString (ExistAncre^.Fname);Print ('.');PrintString (ExistAncre^.Ftype);
Print ('|');PrintBool (ExistDir);PrintHex (CARDINAL(ExistAncre^.Fattr),4);PrintLn;*)
		relation := CompareFileName (AncreFile,ExistAncre);
(*PrintString (' relation=');PrintCard (ORD(relation),3);PrintLn;*)
		IF ExistDir THEN
			IF FileDir THEN
				CASE relation OF
					0 :	NewDirectory ()|
					1 :
							size := AncreFile^.Fsize;
							WITH FileWindow DO
								makeName (AncreFile);
								Assign (directory,wDir);
								wStat := 'X';
								makeList (cur,AncreFile);
								makeList (org,ExistAncre);
							END;(*WITH*)
							AncreFile := Prochain ();
							GetExistFile ();
							Status := TRUE;
					|
					2:	DeletedDirectory ();
				END;(*CASE*)
			ELSE
				NewFile ()
			END;(*IF*)
		ELSE
			CASE relation OF
				0:	NewFile ()|
				1:
					WITH FileWindow DO
						makeName (AncreFile);
						makeList (cur,AncreFile);
						IF CompareFile (AncreFile,ExistAncre) THEN
							makeList (org,ExistAncre);
							wStat := 'c';
							IF Status THEN
								Header ()
							END;(*if*)
							WriteString (MessageList^.list[12]^);
							WriteLine ();
						ELSE
							wStat := 'u';
							org := "unchanged"
						END;(*IF*)
					END;(*WITH*)
					GetExistFile ();
					AncreFile := Prochain ();
				|
				2:	DeletedFile ()
			END;(*CASE*)
		END;(*IF*)
(*Pause (' again');*)
		IF AncreFile = NIL THEN EXIT END;
	END;
	WHILE (ExistAncre <> NIL) AND (ExistAncre^.Fattr <> DIRECTORY) DO
		DeletedFile ();
	END;(*WHILE*)
	IF Status THEN
		LongCardToString (size,str,12);
		Concat (directory,str,text);
		MakeString (str,13,text);
(*		Write (0DX);*)
		WriteString (str);
		LineEnd;
		Status := FALSE;
	END;(*if*)
	handle := 2;
(*Pause (' end of report ');*)
END report;
(* $L- *)
BEGIN
	TermProcedure (QuitVoie);
	count := 0;
	handle := 2;
END AidsList.
