IMPLEMENTATION MODULE AidsLib;
FROM SYSTEM IMPORT BYTE,ADR,TSIZE,ADDRESS;
FROM SDLC IMPORT CRC,CheckCRC;
FROM XMODEM IMPORT XModem,CheckXmodem;
FROM Files IMPORT Open,Close,Read,READ;
FROM AidsGlobal IMPORT Name,FileName;
FROM TermOut IMPORT WriteString,Write;
(* $L-, $T-, $R-, $S- *)
CONST
	max = 8192;
VAR
	Buffer : ARRAY [0..max-1] OF CHAR;
	adr : ADDRESS;
PROCEDURE FileCheck (VAR sdlc,xmodem,checksum:CARDINAL;file:ARRAY OF CHAR):LONGCARD;
VAR
	stream :INTEGER;
	Size : LONGCARD;
	res,count : CARDINAL;
	c :CHAR;
BEGIN
	Open (stream,file,READ);
	Size := 0L;
	checksum := 0;
	CRC := 0FFFFH;
	XModem := 0;
	IF stream  = -1 THEN
		RETURN 0L
	END;(*IF*)
	WriteString ('                                                                             ');
	Write (0DX);
	WriteString (file);
	Write (0DX);
	Read (stream,adr,max,res);
	count := 0;
	WHILE count <> res DO
		c := Buffer [count];
		INC (Size);
		CheckXmodem (c);
		CheckCRC (c);
		checksum := checksum + ORD (c);
		INC (count);
		IF count = max THEN
			count := 0;
			Read (stream,adr,max,res)
		END;(*IF*)
	END;(*WHILE*)
	Close (stream);
	sdlc := CRC;
	xmodem := XModem;
	RETURN Size;
END FileCheck;
PROCEDURE ConvertTime (Time:CARDINAL;VAR str:Name);
VAR
	hour,minute,second:CARDINAL;
BEGIN
	second := (Time MOD 32 ) * 2;
	Time := Time DIV 32;
	minute := Time MOD 64;
	hour := Time DIV 64;
	str[1] := CHR(hour DIV 10 + 30H);
	str[2] := CHR(hour MOD 10 + 30H);
	str[3] := ':';
	str[4] := CHR(minute DIV 10 + 30H);
	str[5] := CHR(minute MOD 10 + 30H);
	str[6] := ':';
	str[7] := CHR(second DIV 10 + 30H);
	str[8] := CHR(second MOD 10 + 30H);
END ConvertTime;
PROCEDURE ConvertDate (Date:CARDINAL;VAR str:Name);
VAR
	year,month,day :CARDINAL;
BEGIN
	day := Date MOD 32;
	Date := Date DIV 32;
	month := Date MOD 16;
	year := (Date DIV 16) + 80;
	str[1] := CHR(day DIV 10 + 030H);
	str[2] := CHR(day MOD 10 + 030H);
	str[3] := '/';
	str[4] := CHR(month DIV 10 + 030H);
	str[5] := CHR(month MOD 10 + 030H);
	str[6] := '/';
	str[7] := CHR(year DIV 10 + 030H);
	str[8] := CHR(year MOD 10 + 030H);
END ConvertDate;
PROCEDURE GetPath (VAR path:ARRAY OF CHAR;VAR filename:FileName);
VAR
	i,j,l,max:CARDINAL;
	c:CHAR;
BEGIN
	max := HIGH (path);
	i := 0;
	j := 0;
	l := 0;
	LOOP
		c := path [i];
		INC (i);
		filename[j] := c;
		INC (j);
		IF (c = '\') OR (c = ':') THEN
			l := i;
			j := 0;
		 END;
		IF c = '.' THEN
			path [l] := 00X;
			REPEAT
				c := path[i];
				filename[j] := c;
				INC (i);
				INC (j);
				UNTIL c = 00X;
			RETURN;
		 END; (* IF *)
		IF c = 00X THEN
			path[l] := 00X;
			RETURN;
		 END; (* IF *)
		IF i > max THEN RETURN END;
	 END; (* LOOP *)
END GetPath;
BEGIN
	adr := ADR (Buffer);
END AidsLib.