IMPLEMENTATION MODULE AidsFile;
FROM SYSTEM IMPORT ADR,TSIZE,ADDRESS;
FROM System IMPORT Terminate,ErrorMessage;
FROM Directories IMPORT DirEntry,GetFirstDir,GetNextDir;
FROM Strings IMPORT Length,Assign,Concat,CompareStr;
FROM NumberConversion IMPORT NumToString,LongCardToString;
FROM ASCII IMPORT EOF,EOL,CR,LF;
FROM StorageSelector IMPORT alloc,dealloc;
FROM Files IMPORT Open,Close,Create,READ,WRITE,Read,Write,Rename,Delete;
FROM AidsGlobal IMPORT FileName,Name,Extent,ExistAncre,SearchAttr,
	PtrListGotten,PtrFILESTATUS,FILESTATUS;
FROM AidsLib IMPORT GetPath;
FROM Paths IMPORT Locate;
FROM MESSAGE IMPORT LoadMessage,Message,MessageList,STRING,PtrString;
FROM LineScan IMPORT tag,scan;
(*
FROM DumpOut IMPORT PrintString,PrintBool,Print,PrintHex,PrintCard,PrintLn;
*)
(*$L-, $T-, $R-, $S- *)

TYPE
	CharSet = SET OF CHAR;
	Hex = ARRAY [0..3] OF CHAR;
	OutBuf = RECORD
		name : Name;
		sep1 : CHAR;
		type : Extent;
		sep2 : CHAR;
		time : Name;
		sep3 : CHAR;
		date : Name;
		sep4 : CHAR;
		attr : Hex;
		sep5 : CHAR;
		sum  : Hex;
		sep6 : CHAR;
		sdlc : Hex;
		sep7 : CHAR;
		xmdm : Hex;
		sep8 : CHAR;
		size : ARRAY [0..11] OF CHAR;
		semi : CHAR;
		cr   : CHAR;
		lf   : CHAR;
	END;(*RECORD*)

CONST
	Digit = CharSet {'0'..'9'};
	Hexa = CharSet {'0'..'9','A'..'F','a'..'f'};
	aids = 'AIDS.LOG';
	bak  = 'AIDS.BAK';
	OutSize = TSIZE (OutBuf);
	max = 512;

VAR
	count : CARDINAL;
	lim,res,pos : CARDINAL;
	in,out :INTEGER;
	InBuffer : ARRAY [0..max - 1] OF CHAR;
	OutBuffer : OutBuf;
	In,Out : ADDRESS;
	skip : BOOLEAN;
	c : CHAR;
	line : STRING;
(*	tg: tag;
	tete,adr : PtrString;
	fld,l,s : CARDINAL;
	status : BOOLEAN;*)
(* $L- *)
PROCEDURE FileList (path: ARRAY OF CHAR; VAR count :CARDINAL;
	VAR Anchor:PtrListGotten);
VAR i :CARDINAL;
		Current:PtrListGotten;
		Dir	: DirEntry;
		done : BOOLEAN;
BEGIN
 GetFirstDir (path,BITSET(SearchAttr),Dir,done);
 IF NOT done THEN
		Anchor := NIL;
 		RETURN
 END;
 alloc (Anchor,SIZE(Anchor^));
 count := 1;
 Current := Anchor;
 GetPath (Dir.name,Anchor^.filename);
 Anchor^.filetime := Dir.time;
 Anchor^.filedate := Dir.date;
 Anchor^.filesize := Dir.size;
 Anchor^.attribute:= Dir.attribute;
 Anchor^.Next := NIL;
 GetNextDir (Dir,done);
 WHILE done DO
  alloc (Current^.Next,SIZE(Anchor^));
  Current := Current^.Next;
  GetPath (Dir.name,Current^.filename);
  Current^.filetime := Dir.time;
  Current^.filedate := Dir.date;
  Current^.filesize := Dir.size;
  Current^.attribute := Dir.attribute;
  Current^.Next := NIL;
  INC (count);
  GetNextDir (Dir,done);
  END; (* WHILE *)
 RETURN;
END FileList;
(* $L- *)
PROCEDURE Getc (VAR c:CHAR);
BEGIN
	IF c = EOF THEN RETURN END;
	LOOP
		IF pos = max THEN
			Read (in,In,max,lim);
			pos := 0;
		END;(*IF*)
		IF pos = lim THEN
			c := EOF;
			RETURN
		END;(*if*)
		c := InBuffer[pos];
		INC (pos);
		IF skip THEN
			IF c = CR THEN
				skip := FALSE;
				EXIT
			END;(*IF*)
		ELSE
			IF c = '*' THEN
				skip := TRUE
			ELSE
				EXIT
			END;(*IF*)
		END;(*IF*)
	END;(*LOOP*)
END Getc;

PROCEDURE OpenFile (Directories:ARRAY OF CHAR;dove:BOOLEAN);
BEGIN
(*PrintString ('OpenFile dir=');PrintString (Directories);
PrintBool (ExistFile);PrintBool (CreateFile);PrintBool (dove);PrintLn;*)
	IF dove THEN
		Concat (Directories,aids,Aids);
		Concat (Directories,bak,Bak);
	ELSE
		Aids := aids;
		Bak := bak;
	END;(*IF*)
(*PrintString (' aids =');PrintString (Aids);
PrintString (' BAK=');PrintString (Bak);PrintLn;*)
	IF CreateFile THEN
		IF ExistFile THEN
			Delete (Bak);
			Rename (Aids,Bak);
			Open (in,Bak,READ);
		ELSE
			Delete (Aids)
		END;(*IF*)
		Create (out,Aids,READ);
		IF out = -1 THEN
			Message (1);
			HALT;
		ELSE
			Message (2);
			WITH OutBuffer DO
				sep1 := ',';
				sep2 := ',';
				sep3 := ',';
				sep4 := ',';
				sep5 := ',';
				sep6 := ',';
				sep7 := ',';
				sep8 := ',';
				semi := ';';
				cr := CR;
				lf := LF;
			END;(*WITH*)
			Out := ADR (OutBuffer);
		END;(*IF*)
	ELSE
		Open (in,Aids,READ);
	END;(*IF*)
	IF ExistFile THEN
		IF in < 1 THEN
			Message (3);
			HALT
		ELSE
			Message (4);
			lim := max;
			pos := max;
			skip := FALSE;
			alloc (ExistAncre,TSIZE(FILESTATUS));
			Getc (c);
			GetExistFile;
			Message (5);
		END;(*if*)
	END;(*IF*)
END OpenFile;
(* $L- *)
PROCEDURE WriteFileInfo (Item:PtrFILESTATUS);

PROCEDURE ToString (src:ARRAY OF CHAR; VAR str:ARRAY OF CHAR);
VAR
	i,len:CARDINAL;
	cut :BOOLEAN;
	k : CHAR;
BEGIN
	len := HIGH (str);
	i := 0;
(*PrintString (' To String len=');PrintCard (len,4);PrintString (' |');
PrintString (src);PrintString ('| ');*)
	cut := FALSE;
	FOR i := 0 TO len DO
		IF cut THEN
			str[i] := ' ';
		ELSE
			k := src[i];
(*PrintHex (ORD(k),2);PrintString (' |');Print (k);PrintString ('| ');*)
			IF k = 00X THEN
				cut := TRUE;
				str[i] := ' '
			ELSE
				str[i] := k
			END;(*IF*)
		END;(*IF*)
	END;(*FOR*)
(*PrintLn;*)
END ToString;

BEGIN
	WITH Item^ DO
		ToString (Fname,OutBuffer.name);
		ToString (Ftype,OutBuffer.type);
		ToString (Ftime,OutBuffer.time);
		ToString (Fdate,OutBuffer.date);
		NumToString (CARDINAL(Fattr),16,OutBuffer.attr,4);
		NumToString (CheckSum,16,OutBuffer.sum,4);
		NumToString (CheckCRC,16,OutBuffer.sdlc,4);
		NumToString (CHXmodem,16,OutBuffer.xmdm,4);
		LongCardToString (Fsize,OutBuffer.size,12);
	END;(*WITH*)
	Write (out,Out,OutSize,res);
	IF res <> OutSize THEN
		Message (28);
		Terminate (1);
	ELSE
		
	END;(*IF*)
END WriteFileInfo;

PROCEDURE CloseFile (ExistFile,CreateFile:BOOLEAN);
BEGIN
	IF ExistFile THEN Close (in) END;
	IF CreateFile THEN
		Close (out);
		Message (6);
	END;
END CloseFile;
(* $L- *)
PROCEDURE GetExistFile ();
VAR res : CARDINAL;
PROCEDURE ReadToken (VAR str:ARRAY OF CHAR);
VAR
	i,len:CARDINAL;
	cut :BOOLEAN;
BEGIN
	WHILE (c = ',') OR (c = ';') DO
		Getc (c);
	END; (*WHILE*)
	len := HIGH (str) + 2;
	i := 0;
	cut := TRUE;
	LOOP
		IF (c = ',') OR (c = EOL) OR (c = ';')  THEN
			str[i] := 00X;
			EXIT;
		ELSIF c = ' ' THEN
			str[i] := 00X;
			cut := FALSE
		ELSIF cut THEN
		  str[i] := c;
		END;(*IF*)
		INC (i);
		Getc (c);
		IF i >= len THEN
		 EXIT END;
	END;(* LOOP *)
	END ReadToken;

PROCEDURE ReadHex (VAR card:CARDINAL);
VAR
	i : INTEGER;
BEGIN
	WHILE NOT (c IN Hexa) DO
	 Getc (c);
	 END;(*WHILE*)
	card := 0;
	LOOP
		IF ((c >='0') AND (c <= '9')) THEN
			card := card * 16 + ORD (c) - 48
		ELSIF ((c >='A') AND (c <='F')) THEN
			card := card * 16 + ORD (c) - 55
		ELSIF ((c >='a') AND (c <='f')) THEN
			card := card * 16 + ORD (c) - 87
		ELSE
			EXIT
		END;(*IF*)
		Getc (c);
		IF NOT (c IN Hexa) THEN EXIT END;
	END;(*LOOP*)
END ReadHex;

PROCEDURE ReadLongCard (VAR card:LONGCARD);
VAR
	i : CARDINAL;
	n : LONGCARD;
BEGIN
	WHILE NOT (c IN Digit) DO
		Getc (c);
		END; (*WHILE*)
	card := 0L;
	REPEAT
		i := ORD (c) - 48;
		n := LONG (i);
		card := card * 10L + n;
		Getc (c);
	UNTIL NOT (c IN Digit);
END ReadLongCard;

BEGIN
(* Fisrt record *)
	IF c = EOF THEN
		dealloc (ExistAncre,TSIZE(FILESTATUS));
		ExistAncre := NIL;
	ELSE
		WITH ExistAncre^ DO
			ReadToken (Fname);
			ReadToken (Ftype);
			ReadToken (Ftime);
			ReadToken (Fdate);
			ReadHex (res);
			Fattr := BITSET (res);
			ReadHex (CheckSum);
			ReadHex (CheckCRC);
			ReadHex (CHXmodem);
			ReadLongCard (Fsize);
		END;(*WITH*)
		REPEAT
			Getc (c)
		UNTIL (c = EOL) OR (c = LF) OR (c = EOF);
	END;(*if*);
	Getc (c);
END GetExistFile;

PROCEDURE GetLine (VAR line:ARRAY OF CHAR):BOOLEAN;
VAR
	cs,high : CARDINAL;
BEGIN
	cs := 0;
	high := HIGH (line);
		LOOP
		IF pos = max THEN
			Read (in,In,max,lim);
			pos := 0;
		END;(*IF*)
		IF pos = lim THEN
			RETURN TRUE
		END;(*if*)
		c := InBuffer[pos];
		INC (pos);
		IF c = LF THEN
			IF cs <> 0 THEN EXIT END
		ELSIF c <> CR THEN
			line [cs] := c;
			INC (cs)
		END;(*IF*)
		IF cs > high THEN EXIT END;
	END;(*LOOP*)
	IF cs < high THEN line[cs] := 00X END;
	RETURN FALSE;
END GetLine;
(* $L- *)
BEGIN
	In:= ADR (InBuffer);
	Locate ('AIDS.MSG',"PATH",line,skip);
	IF skip THEN
		MessageList := LoadMessage (line)
	ELSE
		ErrorMessage ("Il n'y a pas 'AIDS.MSG'.");
		Terminate (1);
	END;
END AidsFile.
