IMPLEMENTATION MODULE AidsComp;
FROM Strings IMPORT CompareStr;
FROM Directories IMPORT NORMAL,DIRECTORY;
FROM AidsGlobal IMPORT FILESTATUS,Name,Extent,PtrFILESTATUS;
(* $L-, $T-, $R-, $S- *)
PROCEDURE CompareFileName (a,b:PtrFILESTATUS):CARDINAL;
VAR
(*	count : CARDINAL;*)
	i,j,r : CARDINAL;
	c,d : CHAR;
	D : BOOLEAN;
	
PROCEDURE CompareName ():CARDINAL;
BEGIN
	IF a^.Fname[2] = ':' THEN
		i := 3
	ELSE
		i := 1
	END;(*IF*)
	IF b^.Fname[2] = ':' THEN
		j := 3
	ELSE
		j := 1
	END;(*IF*)
	LOOP
		c := a^.Fname[i];
		d := b^.Fname[j];
		IF c < d THEN
			RETURN 0
		ELSIF c > d THEN
			RETURN 2
		ELSIF c = 00X THEN
			EXIT
		END;(*IF*)
		INC (i);
		IF i = 9 THEN EXIT END;
		INC (j);
		IF j = 9 THEN EXIT END;
	END;(*LOOP*)
	RETURN 1
END CompareName;

PROCEDURE CompareType ():CARDINAL;
BEGIN
	i := 1;
	LOOP
		c := a^.Ftype[i];
		d := b^.Ftype[i];
		IF c < d THEN
			RETURN 0
		ELSIF c > d THEN
			RETURN 2
		ELSIF c = 00X THEN
			EXIT
		END;(*IF*)
		INC (i);
		IF i = 4 THEN EXIT END;
	END;(*LOOP*)
	RETURN 1;
END CompareType;

BEGIN
	IF b = NIL THEN RETURN 0 END;
	D := DIRECTORY = b^.Fattr;
	IF DIRECTORY = a^.Fattr THEN
		IF D THEN
			r := 2 - CompareType ();
			IF r = 1 THEN r := CompareName () END;
		ELSE
			r := 2
		END;(*IF*)
	ELSE
		IF D THEN
			r := 0
		ELSE
			r := CompareName ();
			IF r = 1 THEN r := CompareType () END;
		END;(*IF*)
	END;(*IF*)
	RETURN r;
END CompareFileName;

PROCEDURE CompareFile (a,b:PtrFILESTATUS): BOOLEAN;
BEGIN
	IF CompareStr (a^.Fdate, b^.Fdate) = 0 THEN
		IF CompareStr (a^.Ftime, b^.Ftime) = 0 THEN
			IF a^.Fsize = b^.Fsize THEN
				IF a^.Fattr = b^.Fattr THEN
					IF a^.CheckSum = b^.CheckSum THEN
						IF a^.CheckCRC = b^.CheckCRC THEN
							IF a^.CHXmodem = b^.CHXmodem THEN
								RETURN FALSE
							END
						END
					END
				END
			END
		END
	END;(*IF*)
	RETURN TRUE;
END CompareFile;
END AidsComp.
