#include <stdlib.h>
#include "sock.h"
#include "sockio.h"
#include "qtcp.h"

int main(argc, argv)
int argc;
char *argv[];
{
    int port = 26000;
    int sd;
	char hostname[2048];
	serverinfo_t si;
	int stat;
	extern int verbose;
	extern char buf[];

	if (argc>1){
		strcpy(hostname, argv[1]);
	}
	else {
		printf("%s hostname [port]\n", argv[0]);
		exit(1);
	}
	if (argc>2) port = atoi(argv[2]);
	if (argc>3) verbose = 1;

	if (verbose) printf("SockOpen(%s, %d, UDP)...\n", hostname, port);
	sd = SockOpen(hostname, port, SOCK_DGRAM);

	if (sd == -1){ exit(1); }

	stat = GetServerInfo(sd, &si.address, &si.hostname, &si.map,
		&si.numplayers, &si.maxplayers, &si.version);

	if (stat > 0) PrintServerInfo(&si);
	else exit(1);

	PrintAllPlayerInfo(sd, si.numplayers);
	PrintAllRuleInfo(sd, buf);

	exit(0);
}

