/************************************************************
QuakePing version 1.1
(c) 1995 Len Norton
************************************************************/
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/param.h>
#include <sys/time.h>
#include <netinet/in.h>
#include <netdb.h>

#ifndef EXIT_SUCCESS
#define EXIT_SUCCESS 0
#define EXIT_FAILURE 1
#endif
#define EXIT_ERROR 2

#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif

#define BUFLEN 1024
#define STRLEN 80

/* server query packet, optained from Damian Frank's qsniff */
char InitString[] = { 0x80, 0x00, 0x00, 0x0C, 0x02, 
                      'Q', 'U', 'A', 'K', 'E', '\0', 0x01 };

/* some global vars */
int QuakePort = 26000;
int TimeoutSec = 3;
int NumRetries = 3;
char HostName[ MAXHOSTNAMELEN + 1 ];
int ReadFromFile = TRUE;
int PrintHeader = TRUE;
int ExitStatus = EXIT_FAILURE;
FILE *InputStream = stdin;

/* hash table and linked list stuff to keep track of found servers */
#define HASHSIZE 256
#define HASHF(a) ( ntohl( a ) & 0x000000ff )
typedef struct ListNode {
    u_long Address;        /* store in network order for efficiency */
    struct ListNode *Next;
} ListNode;
ListNode *HashTable[ HASHSIZE ];

void ZeroHashTable( ListNode *HashTable[] )
{
     memset( HashTable, 0, HASHSIZE );
}

void AddToHashTable( u_long Address, ListNode *HashTable[] )
{
    int Index;
    ListNode *pListNode;

    Index = HASHF( Address );
    pListNode = HashTable[ Index ];

    if( pListNode == NULL )
    {

        HashTable[ Index ] = malloc( sizeof( ListNode ) );
        HashTable[ Index ]->Address = Address;
        HashTable[ Index ]->Next = NULL;
    }
    else
    {
        while( pListNode->Next != NULL ) pListNode = pListNode->Next;
        pListNode->Next = malloc( sizeof( ListNode ) );
        pListNode = pListNode->Next;
        pListNode->Address = Address;
        pListNode->Next = NULL;
    }
}

int InHashTable( u_long Address, ListNode* HashTable[] )
{
    ListNode *pListNode;

    pListNode = HashTable[ HASHF( Address ) ];
    while( pListNode != NULL )
    {
        if( pListNode->Address == Address )
            return TRUE;
        pListNode = pListNode->Next;
    }
    return FALSE;        
}

/*********************************************************
void PrintHashTable( ListNode *HashTable[] )
{
    int i = 0;
    ListNode *pListNode;
    struct in_addr addr;

    for( i = 0; i < HASHSIZE; i++ )
    {
        pListNode = HashTable[ i ];
        while( pListNode != NULL )
        {
            addr.s_addr = pListNode->Address;
            printf( "%d : %s\n", i, inet_ntoa( addr ) );      
            pListNode = pListNode->Next;
        }
    }
}
**********************************************************/

void CheckOptions( int argc, char *argv[] )
{
    int c, i = 1;
    int GotHost = FALSE;
    while( i < argc )
    {
        if( strcmp( argv[i], "-r" ) == 0 )
        {
            i++;
            if( i < argc )
            {
                if( ( NumRetries = atoi( argv[i] ) ) == 0 )
                {
                    fprintf( stderr, "%s: %s: invalid retries\n",
                             argv[0], argv[i] );
                    exit( EXIT_ERROR );
                }
                else
                {
                    i++;
                    continue;
                }
            }          
            else
            {
                fprintf( stderr, "usage: %s [-h] | [-r retries] [-t timeout]"
                         " [-f serverlist | [host [port]]]\n", argv[0] );
                exit( EXIT_ERROR );
            }
        }

        if( strcmp( argv[i], "-t" ) == 0 )
        {
            i++;
            if( i < argc )
            {
                if( ( ( TimeoutSec = atoi( argv[i] ) ) == 0 ) &&
                    ( (argv[i])[0] != '0' ) )
                {
                    fprintf( stderr, "%s: %s: invalid timeout\n",
                             argv[0], argv[i] );
                    exit( EXIT_ERROR );
                }
                else
                {
                    i++;
                    continue;
                }
            }
            else
            {
                fprintf( stderr, "usage: %s [-h] | [-r retries] [-t timeout]"
                         " [-f serverlist | [host [port]]]\n", argv[0] );
                exit( EXIT_ERROR );
            }
        }

        if( strcmp( argv[i], "-f" ) == 0 )
        {
            i++;
            if( i < argc )
            {
                if( ( InputStream = fopen( argv[i], "r" ) ) == NULL )
                {
                    fprintf( stderr, "%s: %s: file not found\n", argv[0],
                             argv[i] );
                    exit( EXIT_ERROR );
                }
                else
                {
                    i++;
                    continue;
                }
            } 
            else
            {
                fprintf( stderr, "usage: %s [-h] | [-r retries] [-t timeout]"
                         " [-f serverlist | [host [port]]]\n", argv[0] );
                exit( EXIT_ERROR );
            }
        }

        if( strcmp( "-h", argv[i] ) == 0 )
        {
            printf( "usage: %s [-h] | [-r retries] [-t timeout]"
                    " [-f serverlist | [host [port]]]\n", argv[0] );
            printf( "where  -h           : this help display\n" 
        "       -r retries   : number of retries per host (default = 3)\n"
        "       -t timeout   : seconds to wait for reponses (default = 3)\n"
        "       -f servers   : a file containing a list of servers\n"
        "       host         : the name of the host to ping\n"
        "       port         : the port to check (default = 26000)\n"
        "If no host is given then qping reads from standard input.\n"
        "The first word on each line is interperated as a hostname.\n" );
            exit( EXIT_SUCCESS );
        }

        if( strncmp( "-", argv[i], 1 ) == 0 )
        {
            fprintf( stderr, "%s: %s: invalid option\n", argv[0], argv[i] );
            fprintf( stderr, "usage: %s [-h] | [-r retries] [-t timeout]"
                     " [-f serverlist | [host [port]]]\n", argv[0] );
            exit( EXIT_ERROR );
        }

        if( !GotHost )
        {
            strcpy( HostName, argv[i] );
            GotHost = TRUE;
            ReadFromFile = FALSE;
            i++;
            continue;
        }
 
        if( ( QuakePort = atoi( argv[i] ) ) == 0 )
        {
            fprintf( stderr, "%s: %s: invalid port\n", argv[0], argv[i] );
            exit( EXIT_ERROR );
        }

        return;
    }
}

int SendPacket( int SocketFd, int Port, char *Host, char *Data, 
               int DataLen, int NumPackets )
{
    struct sockaddr_in HostAddr;
    struct hostent *HostEnt;
    int i, NumBytes;
    
    if( ( HostEnt = gethostbyname( Host ) ) == NULL )
    {
         fprintf( stderr, "%s: unknown host\n", Host );
         if( !ReadFromFile )
             exit( EXIT_ERROR );
         else
             return -1;
    }

    HostAddr.sin_family = AF_INET;
    HostAddr.sin_port = htons( Port );
    HostAddr.sin_addr = *((struct in_addr *)HostEnt->h_addr);
    memset( &(HostAddr.sin_zero), 0, sizeof(HostAddr.sin_zero) );

    for( i = 0; i < NumPackets; i++ )
         if( ( NumBytes = sendto( SocketFd, Data, DataLen, 0, \
                 (struct sockaddr *)&HostAddr, sizeof(HostAddr) ) ) == -1 )
             perror( "sendto" );
    return NumBytes;
}

int ReadLine( FILE *File, char *HostName, int *Port )
{
    /* yea, I know this routine sucks */

    char ReadBuffer[ BUFLEN ];
    char *pReadBuffer;
    char PortBuffer[ BUFLEN ];
    char TempBuffer[ BUFLEN ];
    int TempPort;

    pReadBuffer = ReadBuffer;

    if( fgets( pReadBuffer, sizeof(ReadBuffer), File ) != NULL )
    {
        if( sscanf( pReadBuffer, "%s", HostName ) == 0 )
            return FALSE;  /* line is empty */

        if( ( HostName[0] == '#' ) || ( HostName[0] == ';' ) )
            return FALSE;  /* line starts with comment */

        pReadBuffer += strlen( HostName ) + 1;
        if( sscanf( pReadBuffer, "%s%s", TempBuffer, PortBuffer ) < 2 )
            return TRUE;  /* no more data */

        if( ( PortBuffer[0] == '#' ) || ( PortBuffer[0] == ';' ) )
            return TRUE;  /* we don't have a port, but a comment */
            
        if( ( TempPort = atoi( PortBuffer ) ) == 0 )
        {
            fprintf( stderr, "invalid port: %s\n", PortBuffer );
            return FALSE;
        }

        *Port = TempPort;
        return TRUE; /* we have a port */
    }
    else
    {   /* we got an EOF */
        ReadFromFile = FALSE;  /* this is bad practice, but who cares */
        return FALSE;
    }
}

int main( int argc, char *argv[] )
{
    int SocketFd;
    struct sockaddr_in MyAddr;
    struct sockaddr_in TempAddr;
    int AddrLen, NumBytes = 0, i = 0, sr;
    char Buffer[ BUFLEN ];
    char *pBuffer;
    fd_set ReadFds;
    struct timeval Timeout;
    struct timeval *pTimeout;
    char ServerAddress[ STRLEN ], ServerName[ STRLEN ], MapName[ STRLEN ];
    int NumPlayers;
    int TempQuakePort;
    int ReadResult;
 
    ZeroHashTable( HashTable );

    CheckOptions( argc, argv );
   
    if( ( SocketFd = socket( AF_INET, SOCK_DGRAM, 0 ) ) == -1 )
    {
        perror( "socket" );
        return EXIT_ERROR;
    }

    MyAddr.sin_family = AF_INET;
    MyAddr.sin_port = htons( 0 );    /* bind to any available port */
    MyAddr.sin_addr.s_addr = INADDR_ANY;
    memset( &(MyAddr.sin_zero), 0, sizeof(MyAddr.sin_zero) );

    if( bind( SocketFd, (struct sockaddr *)&MyAddr, sizeof(struct sockaddr) 
            ) == -1 )
    {
        perror( "bind" );
        close( SocketFd );
        return EXIT_ERROR;
    }


    Timeout.tv_usec = 0;
    if( ReadFromFile )
        Timeout.tv_sec = 0;
    else
        Timeout.tv_sec = TimeoutSec;
    if( TimeoutSec == 0 )  /* no timeout */
        pTimeout = NULL;
    else 
        pTimeout = &Timeout;

    if( !ReadFromFile )
    {
        SendPacket( SocketFd, QuakePort, HostName, 
                   (char*)&InitString, sizeof(InitString), NumRetries );
    }

    for(;;)
    {
        FD_ZERO( &ReadFds );
        FD_SET( SocketFd, &ReadFds );
    
        sr = select( 128, &ReadFds, NULL, NULL, pTimeout );

        if( ( sr == 0 ) && ( pTimeout->tv_sec != 0 ) ) break;
        if( sr < 0 )
        {
            perror( "select" );
            return EXIT_ERROR;
        }

        if( FD_ISSET( SocketFd, &ReadFds ) )
        {
             AddrLen = sizeof(struct sockaddr);
             if( ( NumBytes = recvfrom( SocketFd, Buffer, BUFLEN, 0, 
                 (struct sockaddr *)&TempAddr, &AddrLen ) ) == -1 )
             {
                 perror( "recvfrom" );
                 return EXIT_ERROR;
             }
             if( !InHashTable( TempAddr.sin_addr.s_addr, HashTable ) )
             {
                 AddToHashTable( TempAddr.sin_addr.s_addr, HashTable );

                 pBuffer = Buffer;
                 pBuffer += 5;
                 strcpy( ServerAddress, pBuffer );
                 pBuffer += strlen( pBuffer ) + 1;
                 strcpy( ServerName, pBuffer );
                 pBuffer += strlen( pBuffer ) + 1;
                 strcpy( MapName, pBuffer );
                 pBuffer += strlen( pBuffer ) + 1;

                 if( PrintHeader )
                 {
                     printf( "Server Name      Map Name     Address:Port"
                             "            Players (Max)\n" );
                     PrintHeader = FALSE;
                 }
             
                 printf( "%-16s %-12s %-22s %2d (%-d)\n", ServerName, 
                         MapName, ServerAddress, pBuffer[0], pBuffer[1] );
                 ExitStatus = EXIT_SUCCESS;
             } /* end if not in hash table */
        } /* end if recv packet */

        for( i = 0; ( i < 20 ) && ReadFromFile; i++ ) /* read next 20 lines */
        {
            TempQuakePort = QuakePort;
            if( ReadResult = ReadLine( InputStream, HostName, &TempQuakePort ) )
                SendPacket( SocketFd, TempQuakePort, HostName, 
                            (char*)&InitString, sizeof(InitString), 
                            NumRetries );
        } /* end input loop */

        if( !ReadFromFile && ( TimeoutSec != 0 ) )
        {
            Timeout.tv_sec = TimeoutSec;
            Timeout.tv_usec = 0;
            pTimeout = &Timeout;
        }
   } /* end forever loop */

   close( SocketFd );
   if( InputStream != stdin ) fclose( InputStream );
   /* clean up hash table if your OS won't */
   return ExitStatus;
}
