/* sock.c */
/*
 
 * Copyright 1994,1996 A.Oliver De Guzman
 * All rights reserved

 *   Permission is granted to any individual to copy, use, and/or
 * distribute this software provided that the distribution retains this
 * entire copyright notice. No part of this software may be used and/or
 * sold for profit or used with any commercial product.

 * DISCLAIMER:
 *   This software comes with NO WARRANTIES of any kind. In no event
 * will the author be liable for any financial, physical, moral, and/or
 * mental damages incurred directly or indirectly by the use or intent
 * to use of this software.
 
 */

#include <stdlib.h>
#include <stdio.h>
#include "sock.h"

/*
TODO:
TURBOC: udp: SOCKOPEN
win95?
*/

#ifdef __TURBOC__
int SockOpen(sd, server, port, type)
tcp_Socket *sd;
char *server;
int port;
int type;
{
    longword host;
    int status;

    host = resolve(server);
    if (!host) {
        printf("Could not resolve host '%s'", server);
        return(-1);
    }

    if (!tcp_open(sd, 0, host, port, NULL)){
        printf("Sorry, unable to connect to '%s'", server);
        return(-1);
    }

    sock_wait_established(sd, sock_delay, NULL, &status);

    return(1);

sock_err:
    switch (status) {
       case 1: printf("Connection closed.");
        return(-1);
       case -1: printf("Connection Reset.");
        return(-1);
    }
}

#else

int SockOpen(hostname, port, type)
char *hostname;
int port;
int type;
{
	int sd;
    struct sockaddr_in insock;
    struct hostent *hp;

    /* obtain a descriptor for the socket */
    if ((sd = socket(AF_INET, type, 0)) == -1){
        perror("Sock_Open: socket");
		return(-1);
	}

	/*
    bzero(&insock, sizeof(struct sockaddr_in));
    */
	memset((char *) &insock, 0, sizeof(insock));

	if (hostname){
    	if ((hp = gethostbyname(hostname)) == 0){
            perror("Sock_Open: gethostbyname");
			return(-1);
		}
		/*
    	bcopy(hp->h_addr, &insock.sin_addr, hp->h_length);
    	*/
    	insock.sin_addr = *((struct in_addr *)hp->h_addr);
	}
    insock.sin_family = AF_INET;
    insock.sin_port = htons(port);

	if (hostname){
    	if (connect(sd, (struct sockaddr *) &insock, sizeof(insock)) == -1){
            perror("Sock_Open: connect");
			return(-1);
		}
	}
	else {
    	if (bind(sd, (struct sockaddr *) &insock, sizeof(insock)) == -1){
            perror("Sock_Open: bind");
			return(-1);
		}
	}

	return(sd);
}
#endif

int SockWrite(sd, buff, n)
#ifdef __TURBOC__
tcp_Socket *sd;
#else
int sd;
#endif
char buff[];
int n;
{
	int nb, where = 0;

	do{
#ifdef __TURBOC__
        if ((nb=sock_write(sd, &(buff[where]), n-where)) < 0){
#else
		if ((nb=write(sd, &(buff[where]), n-where)) < 0){
#endif
			perror("Sock_Write: write failed");
			return(-1);
		}
		where += nb;
	} while(n-where > 0 && nb > 0);

	return(where);
}

int SockRead(sd, buff, n)
#ifdef __TURBOC__
tcp_Socket *sd;
#else
int sd;
#endif
char *buff;
int n;
{
#ifdef __TURBOC__
    int status;
#endif
	int nb, where = 0;

	do{
#ifdef __TURBOC__
        sock_wait_input(sd, sock_delay, NULL, &status);
        if ((nb=sock_read(sd, &(buff[where]), n-where)) < 0){
#else
		if ((nb=read(sd, &(buff[where]), n-where)) < 0){
#endif
            perror("Sock_Read: read failed");
			return(-1);
		}
		where += nb;
	} while(n-where > 0 && nb > 0);

	return(where);

#ifdef __TURBOC__
sock_err:
    switch (status) {
       case 1: printf("Connection closed.");
        return(1);
       case -1: printf("Remote Host Closed Connection.");
        return(-1);
    }
#endif
}
