/* server.c */

/*

 * Copyright 1996 A.Oliver De Guzman <oliber@aiko.upd.edu.ph>

 *   Permission is granted to any individual to copy, use, and/or
 * distribute this software provided that the distribution retains this
 * entire copyright notice. No part of this software may be used and/or
 * sold for profit or used with any commercial product.

 */

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <signal.h>
#include <setjmp.h>
#include <sys/time.h>
#include <sys/wait.h>
#include "sock.h"
#include "sockio.h"
#include "node.h"
#include "config.h"
#include "server.h"
#include "qcontrol.h"
#include "log.h"
#include "command.h"

#define CONSOLE		"con: "

#define printIP(str, peer)	sprintf(str, "%d.%d.%d.%d",\
							(int)(htonl(peer.sin_addr.s_addr) >> 24) & 0xFF,\
							(int)(htonl(peer.sin_addr.s_addr) >> 16) & 0xFF,\
							(int)(htonl(peer.sin_addr.s_addr) >>  8) & 0xFF,\
							(int)(htonl(peer.sin_addr.s_addr)      ) & 0xFF)
     

int sd, newfd = -1, consolefd;
FILE *fp;
int port = PORT_NUMBER;
jmp_buf mainloop;

int setfds(rfds)
fd_set *rfds;
{
	int i;
	int maxfd = 0;

	FD_ZERO(rfds);
	FD_SET(sd, rfds);
	maxfd = sd;

	for (i=0; i<MAX_NODES; i++){
		if (!IsUnused(nodes[i])){
			FD_SET(nodes[i].sd, rfds);
			if (nodes[i].sd > maxfd)
				maxfd = nodes[i].sd;
		}
	}

	return(maxfd+1);
}

void ResetNode()
{
#ifdef DEBUG
	printf("ResetNode[%d]\n", nodeidx);
#endif
	if (newfd != -1) close(newfd);
    signal(SIGPIPE, ResetNode);
	longjmp(mainloop, 1);
}

void ResetNodeIdx(idx)
int idx;
{
	nodeidx = idx;
	ResetNode();
}

void ChildSignal()
{
	/* exit when controled process exits */
	ServerExit(9);
}

char EMAIL[128] = "user@nowhere.com", ALIAS[128] = "status";
Config cconfigs[] = {
	{ "alias", "STR", ALIAS, "status", "", "Client alias" },
	{ "email", "STR", EMAIL, "user@nowhere.com", "", "Contact email address" },
};
#define CNUMCONFIGS		(sizeof(cconfigs)/sizeof(Config))

int server(serverfd)
int serverfd;
{
	char msg[MAXMSG+1];
	char IPaddress[4*4+10];
	struct sockaddr_in peer;
	int peersize = sizeof(peer);
	fd_set rfds, trfds;
	struct timeval tv;
	int maxfd;
	int i, n;
	int idx;
	static nodeidx = -1;

	sprintf(msg, "220 %s ready.\n", SERVERID);
	if (loglevel & 1) logger(logfp, msg);

	consolefd = serverfd;

#ifdef DEBUG
    printf("Listener_Start on port [0x%x]\n", port);
#endif

    sd = SockOpen(NULL, port, SOCK_STREAM);
    if (sd == -1) ServerExit(2);

    signal(SIGCHLD, ChildSignal);
    signal(SIGPIPE, ResetNode);
    InitNodes();

	switch(setjmp(mainloop)){
	case 2:
	case 1:
		if (nodeidx != -1){
			sprintf(msg, "! %s left.\n", NodeStat(nodeidx));
			InitNode(nodeidx);
			nodeidx = -1;
			if (loglevel & 1) logger(logfp, msg);
			WriteGods(msg);
		}
#ifdef DEBUG
		printf("\nListener_Listen port[%d]...", port);
		fflush(stdout);
#endif

	case 0:
	while (1){

		ExpireConnections();
		newfd = -1;
		tv.tv_sec = 1;

   		/* wait for and then accept a connect request */
   		if (listen(sd, 5) == -1){
       		perror("Listener: listen failed");
			continue;
		}

		maxfd = setfds(&rfds);

		FD_SET(serverfd, &rfds);
		if (serverfd > maxfd)
			maxfd = serverfd;

		trfds = rfds;
		if ((i = select(maxfd, &trfds, NULL, NULL, &tv)) < 0){
			perror("Listener: select");
			continue;
		}
		else { if (i == 0) continue; }

		if (FD_ISSET(sd, &trfds)){
   			if ((newfd = accept(sd, NULL, NULL)) == -1){
   				perror("Listener: accept failed");
				continue;
			}
		} else { /* handle all ready clients */

			if (FD_ISSET(serverfd, &trfds)){
				strcpy(msg, CONSOLE);
				while ((n = NBSockReadLine(serverfd, msg+strlen(CONSOLE), MAXMSG-strlen(CONSOLE))) > 0){
					if (loglevel & 4) logger(logfp, msg);
					WriteGods(msg);
				}
			}

			for (i=0; i<MAX_NODES; i++){
				if (!IsUnused(nodes[i]) && FD_ISSET(nodes[i].sd, &trfds)){
					nodeidx = i;
					if (NBSockReadLine(nodes[nodeidx].sd, msg, MAXMSG) == -1){
						ResetNode();
					}

					if (DoCommand(serverfd, nodeidx, msg) == -1){
						sprintf(msg, "501 type \"/help\" for command list.\n");
						NBSockWriteS(nodes[nodeidx].sd, msg);
					}
				}
			}

			continue;
		}

		getpeername(newfd, (struct sockaddr *)&peer, &peersize);
		printIP(IPaddress, peer);
		if (!strcmp(IPaddress, "127.0.0.1")){
			getsockname(newfd, (struct sockaddr *)&peer, &peersize);
			printIP(IPaddress, peer);
		}

		nodeidx = -1;

		idx = NewNode(STATUS, newfd, ALIAS, EMAIL, IPaddress);
		if (idx == -1){
			SockWrite(newfd, SORRY, strlen(SORRY));
			close(newfd);
			continue;
		}
		else {
			sprintf(msg, "+ %s connected.\n", NodeStat(idx));
			if (loglevel & 1) logger(logfp, msg);
			WriteGods(msg);
		}
		
		sprintf(msg, "220 %s ready. (%s)\n", SERVERID, nodes[idx].salt);
		if (NBSockWriteS(newfd, msg) < 0)
			continue;

		newfd = -1;

#ifdef DEBUG
		printf("\nListener_Listen port[%d]...", port);
		fflush(stdout);
#endif
	}
	break;
	}
	return(0);
}

