/* qcontrol.c */

/*

 * Copyright 1996 A.Oliver De Guzman <oliber@aiko.upd.edu.ph>

 *   Permission is granted to any individual to copy, use, and/or
 * distribute this software provided that the distribution retains this
 * entire copyright notice. No part of this software may be used and/or
 * sold for profit or used with any commercial product.

 */

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <sys/types.h>
#ifdef SOLARIS
#include <signal.h>
#else
#include <sys/signal.h>
#endif
#include <sys/socket.h>
#include "lib.h"
#include "log.h"
#include "server.h"
#include "qcontrol.h"
#include "config.h"

pid_t pid;
FILE *logfp=NULL;
int loglevel=7;
char autoexec[1024]="qcontrol.cfg", servercfg[1024]="server.cfg";
char msg[MAXLINE+1];
int connecttime=3600; /* 1 hour: max console connection time in secs */
int passwordtries=3;
char password[1024];
char bannermsg[1024];
char logfile[1024];
char exepath[1024], exename[1024]="xquake", gamename[1024]="id1";
extern int port;
char maxplayers[64]="8";
char udpport[64]="26000";
int iudpport, imaxplayers;
char inifile[2048] = "qcontrol.ini";
int autosave = 1;

Config inicfg[] = {
	/* will not take effect until next restart */
	{ "game", "STR", &gamename, "id1", "", "Modified game name" },
	{ "maxplayers", "INT", &imaxplayers, "8", "", "Maximum number of players" },
	{ "udpport", "INT", &iudpport, "26000", "", "UDP port where quake listens" },
	{ "port", "INT", &port, "26000", "", "TCP port qcontrol listens to" },
#ifdef INSECURE
	{ "logfile", "STR", &logfile, "qcontrol.log", "", "Logfile" },
	{ "exename", "STR", &exename, "xquake", "", "quake executable filename" },
#endif
	{ "autoexec", "STR", &autoexec, "qcontrol.cfg", "", "quake server config file" },

	/* takes effect immediately */
	{ "loglevel", "INT", &loglevel, "7", "", "Loglevel" },
	{ "connecttime", "INT", &connecttime, "3600", "", "Maximum console connection time (seconds)" },
	{ "password", "STR", &password, "invalid password", "", "Console password" },
	{ "passwordtries", "INT", &passwordtries, "3", "", "Maximum password entry retries" },
	{ "banner", "STR", &bannermsg, "Quake Control Center", "", "Single-line banner message" },
	{ "autosave", "INT", &autosave, "1", "", "<0|1> Auto-save config to inifile" },
};
#define NUMINI		(sizeof(inicfg)/sizeof(Config))
int numini = NUMINI;


void handler(n)
int n;
{
	logger(logfp, "SIGPIPE error: Lost connection to console.\n");
	sprintf(msg, "504 %s aborting.\n", SERVERID);
	logger(logfp, msg);
	ServerExit(2);
}

void shutup(n)
int n;
{
	sprintf(msg, "505 %s shutdown.\n", SERVERID);
	logger(logfp, msg);
	ServerExit(3);
}

void ServerExit(n)
int n;
{
	if (pid > 0){
		kill(pid, SIGINT);
	}
	exit(n);
}

void ValidateString(s)
char *s;
{
	char invalidchars[] = "`~!@#$%^&*()+=|\\{}[]:;\"'<,>?";
	int i;

	for (i=0; i<strlen(invalidchars); i++){
		if (strchr(s, invalidchars[i])){
			s[i] = '\0';
		}
	}
}

int main(argc, argv)
int argc;
char *argv[];
{
	int fd[2];
	int n;
	FILE *fp;
	extern void ChildSignal();

	signal(SIGPIPE, handler);
	signal(SIGINT, shutup);
	signal(SIGCHLD, ChildSignal);

	strcpy(password, PASSWD);
	strcpy(bannermsg, BANNER);

	sprintf(logfile, "qcontrol-%d.log", port);
	if ((n = CheckParm("-ini", argc, argv)) && (n < argc-1))
		strcpy(inifile, argv[n+1]);

	if (readconfig(inifile, QUAKEPATH, inicfg, NUMINI) == -1){
		fprintf(stderr, "Cannot open config file. Using defaults.\n");
		fflush(stderr);
	}

	if ((n = CheckParm("-port", argc, argv)) && (n < argc-1))
		port = atoi(argv[n+1]);

	if ((n = CheckParm("-logfile", argc, argv)) && (n < argc-1))
		strcpy(logfile, argv[n+1]);

	if ((n = CheckParm("-loglevel", argc, argv)) && (n < argc-1))
		loglevel = atoi(argv[n+1]);

	if ((n = CheckParm("-exename", argc, argv)) && (n < argc-1))
		strcpy(exename, argv[n+1]);

	if ((n = CheckParm("-autoexec", argc, argv)) && (n < argc-1))
		strcpy(autoexec, argv[n+1]);

	if ((n = CheckParm("-maxplayers", argc, argv)) && (n < argc-1))
		strcpy(maxplayers, argv[n+1]);

	if ((n = CheckParm("-game", argc, argv)) && (n < argc-1))
		strcpy(gamename, argv[n+1]);

	if ((n = CheckParm("-udpport", argc, argv)) && (n < argc-1))
		strcpy(udpport, argv[n+1]);

	if ((n = CheckParm("-connecttime", argc, argv)) && (n < argc-1))
		connecttime = atoi(argv[n+1]);

	if ((n = CheckParm("-passwordtries", argc, argv)) && (n < argc-1))
		connecttime = atoi(argv[n+1]);

	if ((n = CheckParm("-autosave", argc, argv)) && (n < argc-1))
		autosave = atoi(argv[n+1]);

	if (socketpair(AF_UNIX, SOCK_STREAM, 0, fd) < 0){
		perror("pipe error");
		exit(1);
	}

	if ((pid = fork()) < 0){
		perror("pipe error");
		exit(1);
	}
	else if (pid > 0){
		if (loglevel > 0){
			if ((logfp = openlog(logfile)) == NULL){
				perror("error opening logfile");
			}
		}

		close(fd[1]);

		fp = fopen(autoexec, "r");
		if (fp != NULL){
			while (fgets(msg, MAXLINE, fp)){
				if (msg[0] != '#') write(fd[0], msg, strlen(msg));
			}
			fclose(fp);
		}
		else {
			logger(logfp, "init: canot open autoexec file.\n");
		}

		server(fd[0], pid);

		if (loglevel > 0) closelog(logfp);
		ServerExit(0);
	}
	else {
		close(fd[0]);
		if (fd[1] != STDIN_FILENO){
			if (dup2(fd[1], STDIN_FILENO) == -1){
				perror("dup2 error");
				exit(1);
			}
		}
		if (fd[1] != STDOUT_FILENO){
			if (dup2(fd[1], STDOUT_FILENO) == -1){
				perror("dup2 error");
				exit(1);
			}
		}
		if (fd[1] != STDERR_FILENO){
			if (dup2(fd[1], STDERR_FILENO) == -1){
				perror("dup2 error");
				exit(1);
			}
		}

		ValidateString(gamename);
		sprintf(exepath, "%s/%s", QUAKEPATH, exename);
		sprintf(maxplayers, "%d", imaxplayers);
		sprintf(udpport, "%d", iudpport);
		if (execl(exepath, exepath,
			"-dedicated", maxplayers,
			"-nosound",
			"-udpport", udpport,
#ifdef REGISTERED
			"-game", gamename,
#endif
			(char *) 0) < 0){
				perror("execl error");
				exit(1);
		}
		exit(1);
	}
	exit(0);
}

