#ifndef NODE_H
#define NODE_H

typedef struct{
	int type;		/* status, god */
	int status;		/* unused, active, sleeping */
	int sd;			/* socket descriptor */
	char alias[16];
	char email[128];
	char ip[4*4+10];
	time_t connect_time;
	int tries;		/* passwd tries */
	char salt[16];
} Node;

enum { STATUS, GOD, UNKNOWN };
enum { UNUSED, ACTIVE, SLEEP };

#define MAX_STATUS			4
#define MAX_GODS			2
#define MAX_NODES			(MAX_STATUS+MAX_GODS)
#define MAXMSG				4096

extern Node nodes[];
extern int nodeidx;

#define IsUnused(nd)		((nd).status == UNUSED)
#define IsActive(nd)		((nd).status == ACTIVE)
#define IsAsleep(nd)		((nd).status == SLEEP)
#define IsStatus(nd)		((nd).type == STATUS && \
			((nd).status == ACTIVE || ((nd).status == SLEEP)))
#define IsGod(nd)			((nd).type == GOD && \
			((nd).status == ACTIVE || ((nd).status == SLEEP)))


#ifdef __STDC__
int InitNode(int);
int InitNodes();
int NewNodeIndex();
int NewNode(int, int, char *, char *, char *);
int GetNodeType(char *);
char *StrNodeType(int);
int WriteNode(int, char *);
int WriteNodes(char *);
int WriteGods(char *);
char *NodeStat(int);
char *StatusStat();
char *GodStat();
int NumStatus(void);
int NumGods(void);
void RecollectNodes(void);
int ExpireConnections(void);
#else
int InitNode();
int InitNodes();
int NewNodeIndex();
int NewNode();
int GetNodeType();
char *StrNodeType();
int WriteNode();
int WriteNodes();
int WriteGods();
char *NodeStat();
char *StatusStat();
char *GodStat();
int NumStatus();
int NumGods();
void RecollectNodes();
int ExpireConnections();
#endif

#endif
