/* node.c */
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <sys/time.h>
#include "node.h"
#include "sockio.h"
#include "pass.h"
#include "log.h"

Node nodes[MAX_NODES];
int nodecount = 0, nodeidx = -1;

char *nodetypes[] = {
	"status",
	"god",
	"unknown",
};

int InitNode(n)
int n;
{
	nodes[n].type = STATUS;
	nodes[n].status = UNUSED;
	if (nodes[n].sd != -1){
		close(nodes[n].sd);
	}
	nodes[n].sd = -1;
	strcpy(nodes[n].alias, "alias");
	strcpy(nodes[n].email, "email@host");
	strcpy(nodes[n].ip, "0.0.0.0");
	nodes[n].connect_time = 0;
	nodes[n].tries = 0;
	strcpy(nodes[n].salt, "aa");

	return(n);
}

int InitNodes()
{
	int i;
	for (i=0; i<MAX_NODES; i++) InitNode(i);

	return(MAX_NODES);
}

int NewNodeIndex()
{
	int i;
	for (i=0; i<MAX_NODES; i++)
		if (IsUnused(nodes[i])) return(i);

	return(-1);
}

int NewNode(type, sd, alias, email, ip)
int type;
int sd;
char *email, *alias;
char *ip;
{
	int n;

	n = NewNodeIndex();
	if (n!=-1){
		nodes[n].status = ACTIVE;
		nodes[n].type = type;
		nodes[n].sd = sd;
		if (alias) strcpy(nodes[n].alias, alias);
		if (email) strcpy(nodes[n].email, email);
		if (ip) strcpy(nodes[n].ip, ip);
		nodes[n].connect_time = time(NULL);
		nodes[n].tries = 0;
		strcpy(nodes[n].salt, GenerateSalt());
	}
	return(n);
}

int NumStatus()
{
	int i, n=0;
	for (i=0; i<MAX_NODES; i++)
		if (IsStatus(nodes[i])) n++;
	return(n);
}

int NumGods()
{
	int i, n=0;
	for (i=0; i<MAX_NODES; i++)
		if (IsGod(nodes[i])) n++;
	return(n);
}

int NumClients()
{
	return(NumGods()+NumStatus());
}

int GetNodeType(s)
char *s;
{
	int i;
	for (i=0; i< UNKNOWN; i++)
		if (!strcmp(s, nodetypes[i])) return(i);

	return(UNKNOWN);
}

char *StrNodeType(type)
int type;
{
	if (type < UNKNOWN) return(nodetypes[type]);
	else return(nodetypes[UNKNOWN]);
}

int WriteNode(nodeidx, msg)
int nodeidx;
char *msg;
{
	if (IsActive(nodes[nodeidx])){
		return(NBSockWriteS(nodes[nodeidx].sd, msg));
	}
	return(0);
}

int WriteNodes(msg)
char *msg;
{
	int n=0;

	for (nodeidx=0; nodeidx<MAX_NODES; nodeidx++){
		if (IsActive(nodes[nodeidx])){
			NBSockWriteS(nodes[nodeidx].sd, msg);
			n++;
		}
	}
	return(n);
}

int WriteGods(msg)
char *msg;
{
	int n=0;

	for (nodeidx=0; nodeidx<MAX_NODES; nodeidx++){
		if (IsActive(nodes[nodeidx]) && IsGod(nodes[nodeidx])){
			NBSockWriteS(nodes[nodeidx].sd, msg);
			n++;
		}
	}
	return(n);
}

char *NodeStat(n)
int n;
{
	static char msg[MAXMSG+1];

/*
	sprintf(msg, "%s <%s> [%s]", nodes[n].alias, nodes[n].email, nodes[n].ip);
*/
	sprintf(msg, "%s", nodes[n].ip);

	return(msg);
}


char *StatusStat()
{
	static char msg[MAXMSG+1];
	char buff[128];
	int i;

	msg[0] = '\0';
	if (NumStatus()){
		sprintf(msg, "* Status");
		sprintf(buff, "(%d):", NumStatus()); strcat(msg, buff);
		for (i=0; i<MAX_NODES; i++){
			if (IsStatus(nodes[i])){
				sprintf(buff, "\n* %2d ", i); strncat(msg, buff, MAXMSG);
				strncat(msg, NodeStat(i), MAXMSG);
			}
		}
	}
	return(msg);
}


char *GodStat()
{
	static char msg[MAXMSG+1];
	char buff[128];
	int i;

	msg[0] = '\0';
	if (NumGods()){
		sprintf(msg, "* Gods");
		sprintf(buff, "(%d):", NumGods()); strcat(msg, buff);
		for (i=0; i<MAX_NODES; i++){
			if (IsGod(nodes[i])){
				sprintf(buff, "\n* %2d ", i); strncat(msg, buff, MAXMSG);
				strncat(msg, NodeStat(i), MAXMSG);
			}
		}
	}
	return(msg);
}

int ExpireConnections()
{
	time_t time_now;
	extern connecttime;
	extern void ResetNodeIdx();
	int idx;
	char msg[MAXMSG+1];
	extern FILE *logfp;
	extern int loglevel;

	time_now = time(NULL);
	for (idx=0; idx<MAX_NODES; idx++){
		if (IsActive(nodes[idx])){
			if ((time_now - nodes[idx].connect_time) > connecttime){
				sprintf(msg, "! %s timeout.\n", NodeStat(idx));
				WriteGods(msg);
				if (loglevel & 1) logger(logfp, msg);
				InitNode(idx);
			}
		}
	}
	return(0);
}
