/* log.c */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
#include <sys/stat.h>
#include "log.h"

FILE *openlog(fname)
char *fname;
{
	umask(0077);
	return(fopen(fname, "a+"));
}

int closelog(fp)
FILE *fp;
{
	if (fp) return(fclose(fp));
	return(0);
}

int logger(fp, s)
FILE *fp;
char *s;
{
	time_t t;
	char st[64];

#ifdef USERIP
	char *userip;
	char *p, *q, username[1024];
	extern char udpport[];
	extern char *get_userip();
	int pport;

#define BEGINSTR "qcontrol:player_enter_begin:"
#define ENDSTR ":player_enter_end"

	if ((p = strstr(s, BEGINSTR)) != NULL){
		q = strstr(s, ENDSTR);
		if (q != NULL) *q = '\0';
		strcpy(username, p+strlen(BEGINSTR));
		pport = atoi(udpport);
		userip = get_userip("localhost", pport, username);
		sprintf(s, "%s entered the game from %s\n", username, userip);
	}

#endif

	if (fp){
		t = time(NULL);
		strcpy(st, ctime(&t));
		st[strlen(st)-1] = '\0';
		fprintf(fp, "%s %s", st, s);
		fflush(fp);
		return(0);
	}
	return(-1);
}
