/* command.c */

#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>

#ifdef SOLARIS
#include <signal.h>
#else
#include <sys/signal.h>
#endif

#include "node.h"
#include "log.h"
#include "lib.h"
#include "sockio.h"
#include "server.h"
#include "qcontrol.h"
#include "config.h"
#include "pass.h"

typedef struct{
	char *name;
	int (*func)(char *);
} Command;

int PrintStat();
int PrintVars();
int Banner();
int ToGod();
int QuitCmd();
int Help();
int SetVar();
int SaveVars();
int Shutdown();
int Restart();

Command commands[] = {
	{ "status", PrintStat },
	{ "stat", PrintStat },
	{ "vars", PrintVars },
	{ "banner", Banner },
	{ "god", ToGod },
	{ "pass", ToGod },
	{ "?", Help },
	{ "help", Help },
    { "bye", QuitCmd },
    { "exit", QuitCmd },
    { "set", SetVar },
    { "save", SaveVars },
    { "crypt", ToGod },
    { "shut", Shutdown },
    { "shutdown", Shutdown },
    { "restart", Restart },
};
#define NCOMMANDS		(sizeof(commands)/sizeof(Command))

char msg2[MAXMSG+1];
char *helpstr[] = {
	"214- /stat                  - print server status",
	"214- /vars                  - print server variables",
	"214- /banner                - print qcontrol banner message",
	"214- /god <password>        - admin mode (console)",
	"214- /crypt <password>      - admin mode (console), crypted passwd",
	"214- /set <varname> <value> - **set qcontrol variable value",
	"214- /set                   - **view qcontrol variable values",
	"214- /save                  - **save qcontrol variables to ini file",
	"214- /restart               - **restart server",
	"214- /shutdown              - **shutdown server",
	"214- /help                  - this help message",
	"214- /exit                  - quit",
	"214 end of help message.",
};
#define NHELP		(sizeof(helpstr)/sizeof(char *))

extern int connecttime;
extern int passwordtries;
extern char password[], bannermsg[];
extern Config inicfg[];
extern char inifile[];
extern int numini;

extern void ResetNode();
extern void ResetNodeIdx();

extern void handler();

char *STATS[] = {
	"version",
	"status",
};

char *VARS[] = {
	"hostname",
	"fraglimit",
	"timelimit",
	"pausable",
	"host_framerate",
	"sys_ticrate",
	"net_messagetimeout",
	"sv_aim",
	"sv_friction",
	"sv_stopspeed",
	"sv_gravity",
	"sv_maxvelocity",
	"sv_nostep",
	"sv_idealpitchscale",
	"sv_maxspeed",
	"sv_accelerate",
	"teamplay",
	"coop",
	"deathmatch",
	"samelevel",
	"skill",
};
#define NSTATS	(sizeof(STATS)/sizeof(char *))
#define NVARS	(sizeof(VARS)/sizeof(char *))

int ServerStat(sd)
int sd;
{
	char msg[MAXMSG+1];
	extern int consolefd;
	int n;

	sprintf(msg, "214- %s\n", bannermsg);
	NBSockWriteS(sd, msg);

	sprintf(msg, "214- myid: %s\n", SERVERID);
	NBSockWriteS(sd, msg);

	signal(SIGPIPE, handler);

	for (n=0; n<NSTATS; n++){
		sprintf(msg2, "%s\n", STATS[n]);
		write(consolefd, msg2, strlen(msg2));
	}

	while ((n = NBSockReadLine(consolefd, msg, MAXMSG)) > 0){
		signal(SIGPIPE, ResetNode);
		sprintf(msg2, "214- %s", msg);
		WriteNode(nodeidx, msg2);
		signal(SIGPIPE, handler);
	}
	signal(SIGPIPE, ResetNode);
	sprintf(msg2, "214 end of status.\n");
	WriteNode(nodeidx, msg2);

	return(0);
}

int ServerVars(sd)
int sd;
{
	char msg[MAXMSG+1];
	extern int consolefd;
	int n;

	sprintf(msg, "214- %s\n", bannermsg);
	NBSockWriteS(sd, msg);

	signal(SIGPIPE, handler);

	for (n=0; n<NVARS; n++){
		sprintf(msg2, "%s\n", VARS[n]);
		write(consolefd, msg2, strlen(msg2));
	}

	while ((n = NBSockReadLine(consolefd, msg, MAXMSG)) > 0){
		signal(SIGPIPE, ResetNode);
		sprintf(msg2, "214- %s", msg);
		WriteNode(nodeidx, msg2);
		signal(SIGPIPE, handler);
	}
	signal(SIGPIPE, ResetNode);
	sprintf(msg2, "214 end of variables.\n");
	WriteNode(nodeidx, msg2);

	return(0);
}

int PrintStat(cmd)
char *cmd;
{
	ServerStat(nodes[nodeidx].sd);

	return(0);
}

int PrintVars(cmd)
char *cmd;
{
	return(ServerVars(nodes[nodeidx].sd));
}

int Banner(cmd)
char *cmd;
{
	sprintf(msg2, "213 %s\n", bannermsg);
	return(NBSockWriteS(nodes[nodeidx].sd, msg2));
}

int ToGod(cmd)
char *cmd;
{
	char *s;
	char *passwd = password;

	if (IsGod(nodes[nodeidx])){
		NBSockWriteS(nodes[nodeidx].sd, "301 Already in admin mode.\n");
		return(0);
	}
	else {
		if (NumGods() < MAX_GODS && !IsUnused(nodes[nodeidx])){
			s = strchr(cmd, ' ');
			if (strstr(cmd, "/crypt") == cmd){
				passwd = Encrypt(password, nodes[nodeidx].salt);
			}
			if (s != NULL && !strncmp(passwd, s+1, strlen(passwd))){
				sprintf(msg2, "# %s authenticated.\n", NodeStat(nodeidx));
				if (loglevel & 1) logger(logfp, msg2);
				nodes[nodeidx].type = GOD;
				NBSockWriteS(nodes[nodeidx].sd, GODOK);
				return(0);
			}
		}
		sprintf(msg2, "%% %s invalid authentication code.\n", NodeStat(nodeidx));
		if (loglevel & 1) logger(logfp, msg2);
		NBSockWriteS(nodes[nodeidx].sd, GODFAIL);
		if (++nodes[nodeidx].tries >= passwordtries)
			ResetNodeIdx(nodeidx);
	}
	return(-1);
}

int QuitCmd(cmd)
char *cmd;
{
	NBSockWriteS(nodes[nodeidx].sd, GOODBYE);
	ResetNode();

	/* not reached */
	return(-1);
}

int Help(cmd)
char *cmd;
{
	int i;

	msg2[0] = '\0';
	for (i=0; i< NHELP; i++){
		strncat(msg2, helpstr[i], MAXMSG);
		strncat(msg2, "\n", MAXMSG);
	}

	return(NBSockWriteS(nodes[nodeidx].sd, msg2));
}

int SetVar(cmd)
char *cmd;
{
	char *s;
	int n;
	int AutoSaver();
	extern Config inicfg[];
	extern int numini;

	if (IsGod(nodes[nodeidx])){
		s = strchr(cmd, ' ');
		if (s){

			n = configline(s+1, inicfg, numini);
			if (n == -1){
				sprintf(msg2, "502 Unknown variable.\n");
				NBSockWriteS(nodes[nodeidx].sd, msg2);
			}
			else AutoSaver();
		}
		else {
			for (n=0; n<numini; n++){
			/*
				sprintf(msg2, "214-%s\n", inicfg[n].cfgdesc);
				NBSockWriteS(nodes[nodeidx].sd, msg2);
			*/
				sprintf(msg2, "214-= %s\n", printvar(&inicfg[n]));
				NBSockWriteS(nodes[nodeidx].sd, msg2);
			}
			sprintf(msg2, "214 end of qcontrol variables.\n");
			NBSockWriteS(nodes[nodeidx].sd, msg2);
		}
		return(0);
	} else
	{
		sprintf(msg2, "503 Not in admin mode.\n");
		NBSockWriteS(nodes[nodeidx].sd, msg2);
	}
	return(-1);
}

int DoCommand(serverfd, idx, cmd)
int serverfd;
int idx;
char *cmd;
{
	int i;

	sprintf(msg2, "* %s %s", NodeStat(idx), cmd);
	StripWhite(msg2);
	strcat(msg2, "\n");
	if (loglevel & 2) logger(logfp, msg2);
	if (!IsGod(nodes[idx])) WriteGods(msg2);

	nodeidx = idx;

	if (IsGod(nodes[idx]) && cmd[0] != '/'){
		signal(SIGPIPE, handler);
		if (write(serverfd, cmd, strlen(cmd)) < strlen(cmd)){
			ResetNode();
		}
		signal(SIGPIPE, ResetNode);
		return(0);
	}

	StripWhite(cmd);

	for (i=0; i<NCOMMANDS; i++){
		if (!strncmp(cmd+1, commands[i].name, strlen(commands[i].name))){
			(commands[i].func)(cmd);
			return(i);
		}
	}
	return(-1);
}

int SaveToFile(w)
int w;
{
	int n;
	FILE *fp;
	char buf2[2048];

	strcpy(msg2, "");
	strcat(msg2, "# qcontrol.ini\n\n");
	for (n=0; n<numini; n++){
		sprintf(buf2, "# %s\n", inicfg[n].cfgdesc);
		strcat(msg2, buf2);
		sprintf(buf2, "%s\n\n", printvar(&inicfg[n]));
		strcat(msg2, buf2);
	}

	if ((fp = fopen(inifile, "w+")) == NULL){
		sprintf(msg2, "507 Cannot write to file [%s].\n", inifile);
		if (w) NBSockWriteS(nodes[nodeidx].sd, msg2);
		logger(logfp, msg2);
		return(0);
	}

	if (fwrite(msg2, sizeof(char), strlen(msg2), fp) != strlen(msg2)){
		sprintf(msg2, "508 Cannot write to file [%s].\n", inifile);
		if (w) NBSockWriteS(nodes[nodeidx].sd, msg2);
		logger(logfp, msg2);
		fclose(fp);
		return(0);
	}

	sprintf(msg2, "216 Wrote config to ini file (%s).\n", inifile);
	if (w) NBSockWriteS(nodes[nodeidx].sd, msg2);
	logger(logfp, msg2);
	fclose(fp);
	return(1);
}

int SaveVars(cmd)
char *cmd;
{
	if (IsGod(nodes[nodeidx])){
		SaveToFile(1);
		return(0);
	}
	else{
		sprintf(msg2, "503 Not in admin mode.\n");
		NBSockWriteS(nodes[nodeidx].sd, msg2);
	}
	return(-1);
}

int AutoSaver()
{
	extern int autosave;
	extern char inifile[];

	if (autosave){
		sprintf(msg2, "217 Auto-saving config to ini file (%s).\n", inifile);
		logger(logfp, msg2);
		return(SaveToFile(0));
	}
	return(0);
}

int Shutdown()
{
	if (IsGod(nodes[nodeidx])){
		sprintf(msg2, "509 normal shutdown.\n");
		NBSockWriteS(nodes[nodeidx].sd, msg2);
		logger(logfp, msg2);
		ServerExit(99);
	}
	else{
		sprintf(msg2, "503 Not in admin mode.\n");
		NBSockWriteS(nodes[nodeidx].sd, msg2);
	}
	return(0);
}

int Restart()
{
	if (IsGod(nodes[nodeidx])){
		sprintf(msg2, "510 normal restart.\n");
		NBSockWriteS(nodes[nodeidx].sd, msg2);
		logger(logfp, msg2);
		ServerExit(10);
	}
	else{
		sprintf(msg2, "503 Not in admin mode.\n");
		NBSockWriteS(nodes[nodeidx].sd, msg2);
	}
	return(0);
}
