/*
IP_ALIAS.EXE, by Rob Albin <albinatr@apci.net>
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define TRUE 1
#define FALSE 0


FILE *infile, *outfile;
int _IP_addr,
	 _IP_port,
	 _IP_host,
	 _HN_length;

char open_infile( char *f_name )
{
	infile = fopen( f_name, "rt" );
	if (!infile)
	{
		fclose( infile );
		printf( "input file %s not found", f_name );
		return FALSE;
	}
	else
		return TRUE;
}

char open_outfile( char *f_name )
{
	outfile = fopen( f_name, "wt" );
	if (!outfile)
	{
		fclose( outfile );
		printf( "could not open output file: %s", f_name );
		return FALSE;
	}
	else
		return TRUE;
}


void read_ini(char *file_name)
{
	FILE *fp;
	char fn[100], buf[200];
	int i;
	strcpy( fn, file_name );

	i = strlen(fn);

	for ( ; i>0; i-- )
	{
		if (fn[i-1] == '.')
			break;
	}
	fn[i] = 'I'; fn[i+1] = 'N'; fn[i+2] = 'I'; fn[i+3] = NULL;

	fp = fopen( fn, "rt" );
	if (! fp)
	{
		fclose( fp );
		fp = fopen( fn, "wt" );
		if (!fp)
		{
			fclose( fp );
			printf( "ERROR: could not create ini file: %s\n", fn );
			exit(1);
		}
		//defaults
		_IP_addr = 10;
		_IP_port = 26;
		_IP_host = 32;
		_HN_length = 19;

/*
 236   0 206.30.198.74   27500 Gnatnet TeamFortres 2fort23  16 of 16
*/
		/*
		# character start pos. of IP address
		10
		# character start pos. of IP port
		26
		# character start pos. of host name
		32
		# max. number of characters in hostname
		19
		*/
		fprintf( fp, "%s", "# character start pos. of IP address\n" );
		fprintf( fp, "%d\n", _IP_addr );
		fprintf( fp, "%s", "# character start pos. of IP port\n" );
		fprintf( fp, "%d\n", _IP_port );
		fprintf( fp, "%s", "# character start pos. of host name\n" );
		fprintf( fp, "%d\n", _IP_host );
		fprintf( fp, "%s", "# max. number of characters in hostname\n" );
		fprintf( fp, "%d\n#\n", _HN_length );

		fprintf( fp, "%s", "# Hack notice: It will crash if you change\n"
								 "# anything in the above format but the numbers.\n" );
		fclose( fp );
		printf( "Default ini file %s created.\n", fn );
		return;
	}

	char flag = FALSE;

	for (i=1;i<9;i++)
	{
		if ((fgets(buf, 190, fp)) == NULL) flag = TRUE;
		else
		{
			strcat( buf, "\n" );
			if (i == 2)
				sscanf(buf, "%d", &_IP_addr);
			else if (i == 4)
				sscanf(buf, "%d", &_IP_port);
			else if (i == 6)
				sscanf(buf, "%d", &_IP_host);
			else if (i == 8)
				sscanf(buf, "%d", &_HN_length);
		}

		if (flag)
		{
			fclose( fp );
			printf("Error reading %s, you should delete it and rerun\n"
					 "the program to create a new copy...\n", fn);
			exit(1);
		}
	}

	fclose( fp );
	printf( "Defaults read from %s\n", fn );

}

void convert_parms()
{
	_IP_addr--;
	_IP_port--;
	_IP_host--;
}

void build_outfile()
{
	char buf[300],
		  alias_name[20];
	char flag, ch;
	int i, alias_num = 0;

	char ip_addr[50],
		  ip_port[50],
		  ip_host[50];

	convert_parms();


	for (;;)
	{
		for (i=0; i<300; i++) buf[i] = NULL;
		if ((fgets(buf, 290, infile)) == NULL)
			return;

			for (i=0; i<_HN_length; i++)
			{
				ch = buf[i+_IP_host];
				if (ch == ' ' || ch == '\t' || ch == ';' || ch == '"')
					ch = '_';

				ip_host[i] = ch;
			}
			ip_host[i] = NULL;

			for ( i--; i>0; i--)
			{
				if (ip_host[i] == '_')
					ip_host[i] = NULL;
				else
					break;
			}


			for (i=0; ; i++)
			{
				ch = buf[i+_IP_addr];

				flag = FALSE;
				if (ch >= '0' && ch <= '9') flag = TRUE;
				if (ch == '.') flag = TRUE;

				if (flag)
					ip_addr[i] = ch;
				else
				{
					ip_addr[i] = NULL;
					break;
				}
			}

			for (i=0; ; i++)
			{
				ch = buf[i+_IP_port];

				if (ch >= '0' && ch <= '9')
					ip_port[i] = ch;
				else
				{
					ip_port[i] = NULL;
					break;
				}
			}



		alias_num++;
		sprintf( alias_name, "s%d", alias_num );
		fprintf( outfile, "alias \"%sn\" \"echo %s\"\n",
					alias_name, ip_host );
		fprintf( outfile, "alias \"%s\" \"%sn; connect %s:%s\"\n",
					alias_name, alias_name, ip_addr, ip_port );

	}

}

void main(int argc, char *argv[] )
{
	char inf_name[100], outf_name[100];

	if (argc != 2)
	{
		printf( "%s",
				  "Syntax:\n"
				  "ip_alias <file_name>\n"
				  "ex:\n"
				  "ip_alias servers\n"
				  "(would open servers.txt, process, and output servers.cfg)\n"
				  "Uses a text file made by copying server list from QSPY, must\n"
				  "be in this format unchanged.\n" );
		return;
	}
	strcpy( inf_name, argv[1] );
	strcpy( outf_name, argv[1] );
	strcat( inf_name, ".txt" );
	strcat( outf_name, ".cfg" );

	read_ini( argv[0] );

	if (! open_infile( inf_name ) )
		return;
	if (! open_outfile( outf_name ) )
		return;

	printf( "%s = input file\n", inf_name );

	build_outfile();

	fclose( infile );
	fclose( outfile );

	printf( "%s = output file\n", outf_name );

}