/* gzip_layer.c -- compressing/decompressing small packets front-end
 * Copyright (C) 1997 Valery Shchedrin
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License, see the file COPYING.
 */

#include <stdlib.h>
#include "gzip.h"

int level;
ush *tab_prefix, *d_buf;
uch *window, *inbuf, *inp, *outp;
unsigned outcnt, outsft;

void zip_unpackinit(void)
{
	window = malloc(WSIZE*2);
	outcnt = outsft = 0;
}

void zip_unpackcleanup(void)
{
	free(window);
}

void zip_packinit(void)
{
	int method = DEFLATED;
	unsigned short attr = 0, df = 0;
	level = 6;
	window = malloc(WSIZE*2);
	tab_prefix = malloc(sizeof(ush)*(1<<BITS));
	inbuf = malloc(INBUFSIZ);
	d_buf = malloc(DIST_BUFSIZE*sizeof(ush));
	bi_init();
	ct_init(&attr, &method);
	lm_init(level, &df);
}

void zip_packcleanup(void)
{
	free(window);
	free(tab_prefix);
	free(inbuf);
	free(d_buf);
}

static uch *inpe;

int zip_pack(uch *in, int inlen, uch *out)
{
	inp = in; inpe = inp+inlen; outp = out;
	deflate();
	return outp-out;
}

int zip_unpack(uch *in, int inlen, uch *out)
{
	inp = inbuf = in; outp = out;
	inflate();
	return outp-out;
}

int file_read(char *buf, unsigned size)
{
	if (inp >= inpe) return -1;
	if (size > (inpe-inp)) size = (unsigned)(inpe-inp);
	if (size == 0) return 0;
	memcpy(buf, inp, size);
	inp += size;
	return (int)size;
}

void flush_window(void)
{
	memcpy(outp, window + outsft, outcnt-outsft);
	outp += outcnt-outsft;
	if (outcnt < WSIZE) {
		outsft = outcnt;
	} else {
		outsft = outcnt = 0;
	}
}

