/* qw_mp.c -- main program parses command strings and deal with network
 * Copyright (C) 1997 Valery Shchedrin
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License, see the file COPYING.
 */

#ifndef lint
static char rcs_id[] = {"$Id: qw_mp.c,v 0.6 1998/01/02 19:56:45 valery Exp $"};
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>

#include "qw_mp.h"

#ifdef HAVE_ERRNO_H
#include <errno.h>
#endif

#ifdef HAVE_GETOPT_H
# include <getopt.h>
#else
  extern int getopt();
  extern char *optarg;
  extern int optind;
#endif

#ifdef HAVE_ARPA_INET_H
# include <arpa/inet.h>
#else
  extern int inet_aton(const char *cp, struct in_addr *inp);
#endif

#ifdef HAVE_NETDB_H
#include <netdb.h>
#endif

#define PORT 27500
static struct sockaddr_in adresse, cnt;
static char *host_dest, *host_recc;
static int port, sock, rdr, c, unpacked, packed, avgpktlen;
static time_t start_time;
#define MAXBUF 8192
static char buf[MAXBUF], buf1[MAXBUF];

char usage[] = {"\
  QuakeWorld Modem Protocol v0.3a\n\
Syntax: qw_mp [-h] [-p port] [-s destination host] [-i input dev] [-o output dev]\n\
              [-d input/output dev] [-c chat prog] [-t secs] [-r reconnect host]"};

static int name_resolve(const char *name, struct in_addr *addr);

static int name_resolve(const char *name, struct in_addr *addr)
{
#ifdef HAVE_NETDB_H
	struct hostent *host_ent;
#endif
	
	if (!inet_aton(name, addr)) {
#ifdef HAVE_NETDB_H
		if (!(host_ent = gethostbyname(name))) return 0;
		memcpy(addr, host_ent->h_addr, host_ent->h_length);
#endif
		return 0;
	}
	return 1;
}

static void print_stats(void)
{
	time_t elapsed;
	elapsed = time(0) - start_time;
	if (unpacked)
	fprintf(stderr, "Packed %d [%d/s], Unpacked %d [%d/s], Ratio %d%%, Avgpktlen = %d\n",
		packed, packed/elapsed,unpacked, unpacked/elapsed,
		(packed*100)/unpacked, avgpktlen);
}

static void sender(void);
static void receiver(void);

int main(int ac, char **av)
{
	in_dev = out_dev = chat_prog = host_dest = NULL;
	unpacked = packed = 0; avgpktlen = 0; ack_timer = 1;
	port = PORT;
	while ((c = getopt(ac, av, "hp:c:d:o:i:s:t:r:")) != EOF) {
		switch(c) {
		case 'p': port = atoi(optarg); break;
		case 's': host_dest = optarg; break;
		case 'h': puts(usage); exit(0); break;
		case 'i': in_dev = optarg; break;
		case 'o': out_dev = optarg; break;
		case 'd': in_dev = out_dev = optarg; break;
		case 'c': chat_prog = optarg; break;
		case 't': ack_timer = atoi(optarg); break;
		case 'r': host_recc = optarg; break;
		}
	}
	
	if (!host_recc) {
		if (dev_init() < 0) {
			fprintf(stderr, "Can't initialize IO\n");
			exit(-1);
		}
	}
	
	if (host_dest) {
		char *p;
		
		if ((p = strchr(host_dest, ':')) != NULL) {
			*p++ = 0;
			port = atoi(p);
		}
	}
	
	if ((sock = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP)) == -1) {
		perror("socket");
		exit(-1);
	}
	
	adresse.sin_family = AF_INET;
	adresse.sin_addr.s_addr = htonl(INADDR_ANY);
	if (!host_dest && !host_recc) adresse.sin_port = htons(port); else adresse.sin_port = 0;
	if (bind(sock, (struct sockaddr *) &adresse, sizeof(struct sockaddr_in)) == -1) {
		perror("bind");
		exit(-1);
	}
	
	if (host_recc) {
		c = sprintf(buf, "qchs<%s>\n", host_recc);
		if (!host_dest || !name_resolve(host_dest, (struct in_addr *)&cnt.sin_addr)) {
			name_resolve("127.0.0.1", (struct in_addr *)&cnt.sin_addr);
		}
		cnt.sin_port = htons(port);
		cnt.sin_family = AF_INET;
		fprintf(stderr, "Reconnecting to %s\n", host_recc);
		sleep(1);
		sendto(sock, buf, c, 0, (struct sockaddr *)&cnt, sizeof(struct sockaddr_in));
		exit(0);
	}

	if (!host_dest) {
		atexit(print_stats);
		start_time = time(0);
		fprintf(stderr, "Waiting connection....\n");
		rdr = sizeof(struct sockaddr_in);
		rdr = recvfrom(sock, buf, MAXBUF, 0, (struct sockaddr *)&cnt, &rdr);
		fprintf(stderr, "Connected....\n");
	} else {
		rdr = -1;
		cnt.sin_family = AF_INET;
		cnt.sin_port = htons(port);
		if (!name_resolve(host_dest, (struct in_addr *)&cnt.sin_addr)) {
			fprintf(stderr, "Error: unable to resolve destination.\n");
			exit(-1);
		}
		printf("Destination host resolved. Waiting for sender.\n");
	}
	fork_sender(sender);
	receiver();
	return 0;
}

static void receiver(void)
{
	char *p, *p1;
	
	connect(sock, (struct sockaddr *)&cnt, sizeof(struct sockaddr_in));
	zip_unpackinit();
	while (1) {
		rdr = recv_block(buf1);
		if (rdr < 0) break;
		packed += rdr;
		rdr = zip_unpack(buf1, rdr, buf);
		unpacked += rdr;
		if (host_dest && rdr > 8) {
			if (!memcmp(buf, "qchs<", 5) && (p1 = memchr(buf, '>', rdr)) != NULL) {
				p = buf+5; *p1 = 0;
				if ((p1 = strchr(p, ':')) != NULL) {
					*p1++ = 0;
					cnt.sin_port = htons(atoi(p1));
				} else {
					cnt.sin_port = PORT;
				}
				name_resolve(p, (struct in_addr *)&cnt.sin_addr);
				connect(sock, (struct sockaddr *)&cnt, sizeof(struct sockaddr_in));
				chsv(&cnt, sizeof(struct sockaddr_in));
			}
		}
		if (!avgpktlen) avgpktlen = rdr;
		  else avgpktlen = (avgpktlen+rdr)>>1;
		while (send(sock, buf, rdr, 0) < 0);
	}
}

void sender_chsv(int (*r)(void *p, int l))
{
	while (!r(&cnt, sizeof(struct sockaddr_in)));
	connect(sock, &cnt, sizeof(struct sockaddr_in));
}

void sender_alrm(int s) { }

static void sender(void)
{
	zip_packinit();
	while (1) {
		if (rdr > 0) {
			unpacked += rdr;
			if (!avgpktlen) avgpktlen = rdr;
			  else avgpktlen = (avgpktlen+rdr)>>1;
			rdr = zip_pack(buf, rdr, buf1);
			packed += rdr;
			send_block(buf1, rdr);
		}
		if (!host_dest) alarm(2);
		rdr = recv(sock, buf, MAXBUF, 0);
		if (!host_dest) {
#ifdef HAVE_ERRNO_H
			if (rdr < 0 && errno == EINTR) {
#else
			if (rdr < 0) {
#endif
				rdr = sizeof(struct sockaddr_in);
				memset(&cnt, 0, rdr);
				cnt.sin_family = AF_INET;
				connect(sock, &cnt, rdr);
				while ((rdr = recvfrom(sock, buf, MAXBUF, 0, &cnt, &rdr)) < 0)
					rdr = sizeof(struct sockaddr_in);
				connect(sock, &cnt, sizeof(struct sockaddr_in));
			}
			alarm(0);
		}
	}
}
