/* gzip.h -- declarations for modules taken from gzip + gzip_layer
 * Copyright (C) 1997 Valery Shchedrin
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License, see the file COPYING.
 */

#include "config.h"
#include <stdio.h>

#define OF(x) x

#define WSIZE 0x8000
#define INBUFSIZ 0x8000
#define OUTBUFSIZ 0x4000
#define DIST_BUFSIZE 0x8000
#define get_byte() (*inp++)
#define MIN_MATCH 3
#define MAX_MATCH 258
#define MIN_LOOKAHEAD (MAX_MATCH+MIN_MATCH+1)
#define MAX_DIST  (WSIZE-MIN_LOOKAHEAD)
#define prev tab_prefix    /* hash link (see deflate.c) */
#define head (prev+WSIZE)  /* hash head (see deflate.c) */
#define BITS 16
#define UNKNOWN 0xffff
#define BINARY 0
#define ASCII 1
#define STORED 0
#define seekable() 0
#define translate_eol 0
#define local static
#define near
#define file_t int
#define NO_FILE (-1)
#define DEFLATED 8

typedef unsigned char uch;
typedef unsigned short ush;
typedef unsigned long ulg;
typedef void *voidp;

/* Extern variables */
extern int level;
extern ush *tab_prefix;
extern uch *window;
extern uch *inbuf, *inp, *outp;
extern ush *d_buf;
extern unsigned outcnt;

/* Extern functions */

extern int file_read OF((char *buf,  unsigned size));
extern void flush_window OF((void));

/* bits.c */
extern void bi_init OF((void));
extern void send_bits OF((unsigned int value, unsigned int length));
extern unsigned bi_reverse OF((unsigned code, int len));
extern int bi_windup OF((void));
extern void copy_block OF((char *buf, unsigned len, int header));

/* deflate.c */
extern void lm_init OF((int pack_level, ush *flags));
extern ulg deflate OF((void));

/* inflate.c */
extern int inflate OF((void));

/* trees.c */
extern void ct_init OF((ush *attr, int *methodp));
extern int ct_tally OF((int dist, int lc));
extern ulg flush_block OF((char *buf, ulg stored_len, int eof));

/* gzip_layer.c */
extern void zip_unpackinit OF((void));
extern void zip_unpackcleanup OF((void));
extern void zip_packinit OF((void));
extern void zip_packcleanup OF((void));
extern int zip_pack OF((uch *in, int inlen, uch *out));
extern int zip_unpack OF((uch *in, int inlen, uch *out));

#define memzero(ptr, len) memset( ptr ,0, len )

#define put_byte(c) { *outp++=(uch)(c); }
#define put_short(w) { put_byte((w) & 0xff); put_byte(((ush)(w)) >> 8); }

/* Not debugging */
#define warn(s1, s2)
#define error(s)
#define Assert(cond,msg)
#define Trace(x)
#define Tracev(x)
#define Tracevv(x)
#define Tracec(c,x)
#define Tracecv(c,x)

