#include "gzip.h"

#define BI_BUF_SIZE 16

static unsigned long bi_buf; /* bit buffer */
static int bi_valid;

void bi_init(void) { bi_buf = bi_valid = 0; }

void send_bits(value, length)
    unsigned int value;  /* value to send */
    unsigned int length; /* number of bits (<=16)*/
{
    bi_buf |= ((unsigned long)value) << bi_valid;
    bi_valid += length;
    while (bi_valid > BI_BUF_SIZE) {
        put_short(bi_buf);
        bi_valid -= BI_BUF_SIZE;
        bi_buf >>= BI_BUF_SIZE;
    }
}

unsigned bi_reverse(code, len)
    unsigned code; /* the value to invert */
    int len;       /* its bit length */
{
    register unsigned res = 0;
    do {
        res |= code & 1;
        code >>= 1, res <<= 1;
    } while (--len > 0);
    return res >> 1;
}

int bi_windup(void)
{
    int r = bi_valid;

    if (bi_valid > 8) {
        put_short(bi_buf);
    } else if (bi_valid > 0) {
        put_byte(bi_buf);
    }
    bi_buf = 0; bi_valid = 0;
    return r;
}

void copy_block(buf, len, header)
    char     *buf;    /* the input data */
    unsigned len;     /* its length */
    int      header;  /* true if block header must be written */
{
    bi_windup();              /* align on byte boundary */

    if (header) { put_short((ush)len); put_short((ush)~len); }
    while (len--) put_byte(*buf++);
}

