/* QuakeSpan - lets quake span UDP and IPX and across IPX routers
   By tz@execpc.com
   released under GPL (GNU Public License, email for more info)
   version 0.5
   todo: translate broadcasts, servers from list
 */

#define DEBUG

#include <netinet/in.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <linux/sockios.h>
#include <linux/ipx.h>
#include <sys/time.h>
#include <arpa/inet.h>
#include <netdb.h>

#include <sys/wait.h>

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>

#define MAX 4096
unsigned char       msg[MAX];

#define SADR (struct sockaddr *)

void                getudp(char *addrstr, struct sockaddr_in *ip_addr)
{
	int                 n;
	struct hostent     *host;

	ip_addr->sin_family = AF_INET;
	n = inet_addr(addrstr);

	if (n != INADDR_NONE)
		memcpy(&(ip_addr->sin_addr), &n, sizeof(n));
	else {
		host = gethostbyname(addrstr);
		if (host == NULL) {
			fprintf(stderr, "Hostname Lookup Failed\n");
			exit(-1);
		}
		memcpy((char *) &(ip_addr->sin_addr), host->h_addr, host->h_length);
	}
}

void                parseipx(char *addrstr, struct sockaddr_ipx *remote_addr)
{
	unsigned int        dest_network;
	int                 n;
	int                 node[6];

	strcpy(msg, addrstr);

	if (sscanf(msg, "%x:%2x%2x%2x%2x%2x%2x:%d",
		   &dest_network, &node[0], &node[1], &node[2],
		   &node[3], &node[4], &node[5], &n) != 8) {
		fprintf(stderr, "Bad IPX address format\n");
		exit(-1);
	}
	remote_addr->sipx_family = AF_IPX;
	remote_addr->sipx_type = 0x11;
	remote_addr->sipx_network = htonl(dest_network);
	remote_addr->sipx_port = htons(n);
	for (n = 0; n < 6; n++)
		remote_addr->sipx_node[n] = node[n];
}

int                 main(int argc, char *argv[])
{
	int                 ipxsockfd, udpsockfd, infosockfd, maxfd;
	int                 n;
	int                 cl, *clp, ucl, *uclp;
	int                 i, ifd, pid;
	fd_set              fds;
	struct sockaddr_ipx local_ipxaddr, remote_ipxaddr, *ripxaddr_p;
	int                 udpport = 26000, ipxport = 26000, infoport = 26500;
	int                 argp = 1, verbose = 0;
	struct sockaddr_in  remote_addr, local_addr, info_addr, *raddr_p;
	struct timeval      tv, *tvp;

	if (argc < 2) {
		fprintf(stderr,
			"Usage: quakerelay [-i ipxport] [-u udpport] [-r redirectport] qhost\n"
			"qhost can be ip address or DNS name\n"
			"port settings are for the ipx and udp broadcast port (default\n"
			"is 26000), the redirect port is for quakeredirect (def=26500)\n"
		  );
		exit(-1);
	}

       /* options come first */
	while ('-' == argv[argp][0]) {

		if (!strcmp(argv[argp], "-u")) {
			udpport = atoi(argv[++argp]);
			argp++;
		}

		if (!strcmp(argv[argp], "-i")) {
			ipxport = atoi(argv[++argp]);
			argp++;
		}

		if (!strcmp(argv[argp], "-r")) {
			infoport = atoi(argv[++argp]);
			argp++;
		}

		if (!strcmp(argv[argp], "-v")) {
			verbose = 1;
			argp++;
		}

	}

       /* set up ipx receive socket */
	cl = sizeof(local_ipxaddr);
	bzero(&local_ipxaddr, cl);
	local_ipxaddr.sipx_family = AF_IPX;
	local_ipxaddr.sipx_network = htonl(0x0);
	local_ipxaddr.sipx_type = 0x11;
	local_ipxaddr.sipx_port = htons(ipxport);
	ipxsockfd = socket(AF_IPX, SOCK_DGRAM, PF_IPX);
	bind(ipxsockfd, SADR & local_ipxaddr, cl);
	clp = &cl;
	ripxaddr_p = &remote_ipxaddr;
	remote_ipxaddr = local_ipxaddr;

       /* set up udp transmit socket */

	ucl = sizeof(remote_addr);
	bzero(&local_addr, ucl);
	bzero(&remote_addr, ucl);
	local_addr.sin_family = AF_INET;
	local_addr.sin_addr.s_addr = htonl(INADDR_ANY);
	uclp = NULL;
	raddr_p = NULL;
	getudp(argv[argp], &remote_addr);	/* get IP from hostname */
	remote_addr.sin_port = htons(udpport);

	info_addr = local_addr;
	info_addr.sin_port = htons(infoport);
	udpsockfd = socket(AF_INET, SOCK_DGRAM, 0);
	bind(udpsockfd, SADR & local_addr, cl);
	infosockfd = socket(AF_INET, SOCK_DGRAM, 0);
	bind(infosockfd, SADR & info_addr, cl);

	tvp = NULL;

	for (;;) {
	       /* this is to exit the spawned processes */
		if (tvp != NULL) {
			tv.tv_sec = 15;
			tv.tv_usec = 0;
		}

		FD_ZERO(&fds);
		FD_SET(udpsockfd, &fds);
		FD_SET(ipxsockfd, &fds);
		FD_SET(infosockfd, &fds);

		maxfd = ipxsockfd;
		if (udpsockfd > ipxsockfd)
			maxfd = udpsockfd;
		if (infosockfd > ipxsockfd)
			maxfd = infosockfd;
		maxfd++;

		if (0 >= select(maxfd, &fds, NULL, NULL, tvp)) {
			close(ipxsockfd);
			close(udpsockfd);
			exit(0);
		}

		if (FD_ISSET(infosockfd, &fds)) {
			n = recvfrom(infosockfd, msg, MAX, 0, SADR & info_addr, &ucl);
#ifdef DEBUG
			if (tvp == NULL && verbose) {
				fprintf(stderr, "INFO response %s\n", msg);
			}
#endif
			if (msg[0] == '?') {
				getsockname(ipxsockfd, SADR & local_ipxaddr, clp);
				sprintf(msg, "%08lx:%02x%02x%02x%02x%02x%02x:%d\n",
					htonl(local_ipxaddr.sipx_network),
					local_ipxaddr.sipx_node[0], local_ipxaddr.sipx_node[1],
					local_ipxaddr.sipx_node[2], local_ipxaddr.sipx_node[3],
					local_ipxaddr.sipx_node[4], local_ipxaddr.sipx_node[5],
					htons(local_ipxaddr.sipx_port)
				  );
				n = strlen(msg);

				sendto(infosockfd, msg, n, 0, SADR & info_addr, ucl);
				continue;
			}
			if (msg[0] == '@') {
				parseipx(&msg[1], ripxaddr_p);
				n -= strlen(msg) + 1;
				if (tvp == NULL && verbose) {
					fprintf(stderr, "Forward IPX %08lx:%02x%02x%02x%02x%02x%02x:%d -> UDP %d\n",
					    htonl(ripxaddr_p->sipx_network),
						ripxaddr_p->sipx_node[0], ripxaddr_p->sipx_node[1],
						ripxaddr_p->sipx_node[2], ripxaddr_p->sipx_node[3],
						ripxaddr_p->sipx_node[4], ripxaddr_p->sipx_node[5],
						htons(ripxaddr_p->sipx_port)
						,n);
				}
				sendto(udpsockfd, &msg[strlen(msg) + 2], n, 0, SADR & remote_addr, ucl);
			}

		}

	       /* process the connect response */

		if (FD_ISSET(ipxsockfd, &fds)) {
			n = recvfrom(ipxsockfd, msg, MAX, 0, SADR ripxaddr_p, clp);
#ifdef DEBUG
			if (tvp == NULL && verbose) {
				fprintf(stderr, "IPX %08lx:%02x%02x%02x%02x%02x%02x:%d -> UDP\n",
					htonl(ripxaddr_p->sipx_network),
					ripxaddr_p->sipx_node[0], ripxaddr_p->sipx_node[1],
					ripxaddr_p->sipx_node[2], ripxaddr_p->sipx_node[3],
					ripxaddr_p->sipx_node[4], ripxaddr_p->sipx_node[5],
					htons(ripxaddr_p->sipx_port)
				  );
			}
#endif
			sendto(udpsockfd, msg, n, 0, SADR & remote_addr, ucl);
		}

		if (FD_ISSET(udpsockfd, &fds)) {
			n = recvfrom(udpsockfd, msg, MAX, 0, SADR raddr_p, uclp);
#ifdef DEBUG
			if (tvp == NULL && verbose) {
				fprintf(stderr, "UDP reply -> IPX\n");
			}
#endif
			if (!(tvp == NULL && msg[4] == 0x81 && !msg[1] && msg[0] == 0x80))
				sendto(ipxsockfd, msg, n, 0, SADR & remote_ipxaddr, cl);

		       /* process the connect response */
			else {
			       /* FORK HERE */
				pid = fork();
				if (!pid) {
				       /* spawn again */
					if ((pid = fork())) {
						fprintf(stderr, "Spawning Quake Proxy Handler Pid %d\n", pid);
						exit(0);
					       /* if parent, exit (so init gets grandkid) */
					}
				}
				else {
				       /* wait for kid to exit and continue */
					waitpid(pid, NULL, 0);
				       /* create new udp socket for next connections */
					close(udpsockfd);
					udpsockfd = socket(AF_INET, SOCK_DGRAM, 0);
					bind(udpsockfd, SADR & local_addr, cl);
					continue;
				}
			       /* we are in grandkid */

				sscanf(&msg[5], "%*d.%*d.%*d.%*d:%d", &i);
				fprintf(stderr, "Quake Proxy to UDP at %s", &msg[5]);
				remote_addr.sin_port = htons(i);

				bzero(&local_ipxaddr, cl);
				local_ipxaddr.sipx_family = AF_IPX;
				local_ipxaddr.sipx_type = 0x11;
				ifd = socket(AF_IPX, SOCK_DGRAM, PF_IPX);
				bind(ifd, SADR & local_ipxaddr, cl);
				getsockname(ifd, SADR & local_ipxaddr, clp);
				sprintf(&msg[5], "%08lx:%02x%02x%02x%02x%02x%02x:%d",
					htonl(local_ipxaddr.sipx_network),
					local_ipxaddr.sipx_node[0], local_ipxaddr.sipx_node[1],
					local_ipxaddr.sipx_node[2], local_ipxaddr.sipx_node[3],
					local_ipxaddr.sipx_node[4], local_ipxaddr.sipx_node[5],
					htons(local_ipxaddr.sipx_port)
				  );
				msg[3] = 6 + strlen(&msg[5]);
				n = msg[3];

				fprintf(stderr, " to IPX address %s\n", &msg[5]);
			       /* enable timeout */
				tvp = &tv;
				sendto(ipxsockfd, msg, n, 0, SADR & remote_ipxaddr, cl);
				close(ipxsockfd);
				ipxsockfd = ifd;
			}
		}
	}
}
