/* quakemulti.c
   copyright tz@execpc.com, released under GPLd
   version 0.3
 */

#include <sys/socket.h>
#include <sys/time.h>
#include <linux/ipx.h>

#include <arpa/inet.h>
#include <netdb.h>

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>

#define MAX 4096
char                msg[MAX];

int                 infoport = 26500;

struct sockaddr_in  remote_udpaddr[10], local_udpaddr;
int                 remudpcnt = 0;

int                 udpsockfd;
int                 ucl;

#define SADR (struct sockaddr *)

int                 udpget(char *hoststr)
{
	int                 n;
	struct sockaddr_in  rem_udpad;
	struct hostent     *host;

	rem_udpad = local_udpaddr;

	rem_udpad.sin_port = htons(infoport);
	rem_udpad.sin_family = AF_INET;

	n = inet_addr(hoststr);

	if (n != INADDR_NONE)
		memcpy(&rem_udpad.sin_addr, &n, sizeof(n));
	else {
		host = gethostbyname(hoststr);
		if (host == NULL)
			return (-1);
		memcpy((char *) &rem_udpad.sin_addr, host->h_addr, host->h_length);
	}

	fprintf(stderr, "adding %s to remote udp\n", hoststr);
	remote_udpaddr[remudpcnt++] = rem_udpad;
/* should really verify it received */

	sendto(udpsockfd, "?", 1, 0, SADR & rem_udpad, ucl);
	n = recvfrom(udpsockfd, msg, MAX, 0, SADR & rem_udpad, &ucl);
	msg[n] = 0;
	return (0);
}

void                parseipx(char *addrstr, struct sockaddr_ipx *remote_addr)
{
	unsigned int        dest_network;
	int                 n;
	int                 node[6];

	strcpy(msg, addrstr);

	fprintf(stderr, "To Remote IPX addr %s", msg);
	if (sscanf(msg, "%x:%2x%2x%2x%2x%2x%2x:%d",
		   &dest_network, &node[0], &node[1], &node[2],
		   &node[3], &node[4], &node[5], &n) != 8) {
		fprintf(stderr, "Bad IPX address format\n");
		exit(-1);
	}
	remote_addr->sipx_family = AF_IPX;
	remote_addr->sipx_type = 0x11;
	remote_addr->sipx_network = htonl(dest_network);
	remote_addr->sipx_port = htons(n);
	for (n = 0; n < 6; n++)
		remote_addr->sipx_node[n] = node[n];
}

void                main(int argc, char *argv[])
{
	int                 sockfd, sockfd2;
	int                 argp, n, cl, *clp, cl1;
	fd_set              fds;
	struct sockaddr_ipx local_addr, *raddr_p, rem_addr;
	struct sockaddr_ipx remote_addr[16];
	int                 nremotes = 0, nserv = 0;
	char               *mp;
	int                 ipxnet = 0, ipxport = 26000;

	if (argc < 2 || !strcmp(argv[1], "-h") || !strcmp(argv[1], "--help")) {
		fprintf(stderr,
		 "usage: quakeredirect followed by one or more addresses:\n"
			" [-u IPaddr_of_quakespan[:qsudpport] | -i IPXNET:node_addr_12:ipxport]\n"
		 "  and options:  [-n ether_IPX_net] [-p ether_IPX_port] \n"
		"This will inquire the IPX address of the remote quakespan\n"
			"proxy (across an IPX router) and adjust things so that the\n"
			"client will connect directly to the server IPX port instead\n"
			"of requiring quakerouter.  The two options allow the IPX net\n"
			"address and/or port to be set.  If running a full ipx internal\n"
		"network, you will need the network number of the ethernet\n"
		  "interface.  The ipx port defaults to the default 26000\n"
			"\n"
		  );
		exit(-1);
	}

	ucl = sizeof(local_udpaddr);

	bzero(&local_udpaddr, ucl);
	local_udpaddr.sin_family = AF_INET;
	local_udpaddr.sin_addr.s_addr = htonl(INADDR_ANY);
	local_udpaddr.sin_port = htons(0);

	udpsockfd = socket(AF_INET, SOCK_DGRAM, 0);
	bind(udpsockfd, SADR & local_udpaddr, ucl);

	cl = sizeof(local_addr);
	bzero(&local_addr, cl);
	clp = &cl1;
	raddr_p = &rem_addr;

	local_addr.sipx_family = AF_IPX;
	local_addr.sipx_type = 0x11;

	argp = 0;
	while (++argp < argc) {
		if (!strcmp(argv[argp], "-p"))
			ipxport = atoi(argv[++argp]);
		if (!strcmp(argv[argp], "-n"))
			sscanf(argv[++argp], "%x", &ipxnet);
		if (!strcmp(argv[argp], "-i"))
			parseipx(argv[++argp], &remote_addr[nremotes++]);
		if (!strcmp(argv[argp], "-u")) {
			strcpy(msg, argv[++argp]);

		       /* look for explicit port number */
			if ((mp = strstr(msg, ":")) != NULL) {
				*mp++ = 0;
				sscanf(mp, "%d", &infoport);
			}

			udpget(msg);
		}
	}

	local_addr.sipx_network = htonl(ipxnet);
	local_addr.sipx_port = htons(ipxport);

	sockfd = socket(AF_IPX, SOCK_DGRAM, PF_IPX);
	sockfd2 = socket(AF_IPX, SOCK_DGRAM, PF_IPX);
	bind(sockfd, SADR & local_addr, cl);

	local_addr.sipx_port = htons(0);
	bind(sockfd2, SADR & local_addr, cl);

	getsockname(sockfd, SADR & local_addr, clp);
	fprintf(stderr, "Local IPX @ %08lx:%02x%02x%02x%02x%02x%02x:%d\n",
		htonl(local_addr.sipx_network),
		local_addr.sipx_node[0], local_addr.sipx_node[1],
		local_addr.sipx_node[2], local_addr.sipx_node[3],
		local_addr.sipx_node[4], local_addr.sipx_node[5],
		htons(local_addr.sipx_port)
	  );

	for (;;) {
		FD_ZERO(&fds);
		FD_SET(sockfd, &fds);
		FD_SET(sockfd2, &fds);
		select(sockfd2 + 1, &fds, NULL, NULL, NULL);
		if (FD_ISSET(sockfd2, &fds)) {
			n = recvfrom(sockfd2, msg, MAX, 0, SADR NULL, NULL);
			fprintf(stderr, "Forwarding Response %d %s\n", n, &msg[5]);
			sendto(sockfd, msg, n, 0, SADR & rem_addr, cl1);
		}
		if (FD_ISSET(sockfd, &fds)) {
	char                bigbuf[MAX];

			n = recvfrom(sockfd, msg, MAX, 0, SADR raddr_p, clp);
/* should print raddr_p address details */
			fprintf(stderr, "Forwarding Request %d\n", n);

			for (nserv = 0; nserv < nremotes; nserv++)
				sendto(sockfd2, msg, n, 0, SADR & remote_addr[nserv], cl);

			if (remudpcnt) {
				sprintf(bigbuf, "@%08lx:%02x%02x%02x%02x%02x%02x:%d%c",
					htonl(raddr_p->sipx_network),
				raddr_p->sipx_node[0], raddr_p->sipx_node[1],
				raddr_p->sipx_node[2], raddr_p->sipx_node[3],
				raddr_p->sipx_node[4], raddr_p->sipx_node[5],
					htons(raddr_p->sipx_port), 0
				  );
				fprintf(stderr, "from %s\n", bigbuf);

				memcpy(&bigbuf[strlen(bigbuf) + 1], msg, n);
				n += strlen(bigbuf) + 1;
				for (nserv = 0; nserv < remudpcnt; nserv++)
					sendto(udpsockfd, bigbuf, n, 0, SADR & remote_udpaddr[nserv], ucl);
			}

		}
	}
}
