#!/usr/local/bin/perl
##
## listback
## Perl script to backup the QstatList server database while stripping the date
## information.
##
## David G. Hesprich (Dark Grue)
## darkgrue@iname.com
## Last Revision: February 22, 1999
##
## QstatList is Copyright (c) 1999 David G. Hesprich (Dark Grue).
##
## This program is free software; you can redistribute it and/or modify it
## under the terms of the GNU General Public License as published by the
## Free Software Foundation; either version 2 of the License, or (at your
## option) any later version.
##
## This program is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
## General Public License for more details.
## 
## You should have received a copy of the GNU General Public License along
## with this program; if not, write to the Free Software Foundation, Inc.,
## 675 Mass Ave, Cambridge, MA 02139, USA.
## 
## ============================================================================
## README
##
## The script copies $LIST_DATA to $LIST_DATA.bak while zeroing out the
## server timeout data.
##
  
## Location of QstatList base install (qstatlist and qstatlist.conf).
##
$QSTATLIST_BASEDIR = '/usr/local/etc/qstatlist';


## Includes
##
use Getopt::Std;

require("$QSTATLIST_BASEDIR/qstatlist.conf");


## Define Variables
##
$DEBUG = 0;


## ============================================================================
## ============================================================================
##
## MAIN
##

# Process command-line options.
unless (getopts('d')) {
  print <<End_of_Here;

Usage: listbak.pl [switches]
  -d			set debugging flags (positive integer)
End_of_Here
   
  exit;
} 
$DEBUG = $opt_d if (defined($opt_d));

print "Getting $LIST_DATA for read operation...\n" if ($DEBUG);		# debug in		open(sfh, "<$LIST_DATA") || die("Can't read from file '$LIST_DATA': $!\n");
open(sfh, "<$LIST_DATA") || die("Can't read from file '$LIST_DATA': $!\n");
flock(sfh, $LOCK_SH);
print "  Got shared lock.\n" if ($DEBUG);				# debug info

print "Getting $LIST_DATA.bak for write operation...\n" if ($DEBUG);	# debug info
open(ofh, ">$LIST_DATA.bak") || die("Can't read from file '$LIST_DATA.bak': $!\n");
flock(ofh, $LOCK_EX);
print "  Got exclusive lock.\n" if ($DEBUG);				# debug info

print "  Working...\n" if ($DEBUG);					# debug info
while (<sfh>) {
  # Make sure we don't get tainted info!
  if (/^(?:($ST_PAT)\s)?(\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}\:\d+)\s(\d+)(?:\s+(.*))?$/) {
    print(ofh "$1 $2 0 $4\n");
    print "    $1 $2 0 $4\n" if ($DEBUG);				# debug info
  }
}

close(sfh);
flock(sfh, $LOCK_UN);
print "  Unlocked input.\n" if ($DEBUG);				# debug info

close(ofh);
flock(ofh, $LOCK_UN);
print "  Unlocked output.\n" if ($DEBUG);				# debug info

print "Done.\n" if ($DEBUG);						# debug info

exit(0);
