#!/usr/local/bin/perl
##
## stats.pl
## This package exists so that all user-configurable defaults can be set in one
## package and then used by all of the QstatList packages.
##
## David G. Hesprich (Dark Grue)
## darkgrue@iname.com
## Last Revision: February 22, 1999
##
## QstatList is Copyright (c) 1999 David G. Hesprich (Dark Grue).
##
## This program is free software; you can redistribute it and/or modify it
## under the terms of the GNU General Public License as published by the
## Free Software Foundation; either version 2 of the License, or (at your
## option) any later version.
##
## This program is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
## General Public License for more details.
##
## You should have received a copy of the GNU General Public License along
## with this program; if not, write to the Free Software Foundation, Inc.,
## 675 Mass Ave, Cambridge, MA 02139, USA.
##


## ============================================================================
## ============================================================================
## 
## PRIVATE SUBROUTINES
##

## Closure: Generate page head.
my $return_graph_head = sub ($$) {
  my($title) = shift(@_);
  my($prolog) = shift(@_);

  # Generate valid DOCTYPE for page testing purposes.
  print(sfh "<!DOCTYPE HTML PUBLIC \"-//Microsoft//DTD Internet  Explorer 3.0 HTML//EN\">\n\n");

  print(sfh <<End_of_Here);
<HTML>
<HEAD>
<TITLE>$title</TITLE>
<META NAME="Generated-By" CONTENT="QstatList v$QSTATLIST_VERSION">
<META NAME="robots" CONTENT="none">
End_of_Here

  # Generate valid EXPIRES for caching/proxy purposes.
  return_meta_expires($Time, 3600, sfh);

  print(sfh <<End_of_Here);
</HEAD>
<BODY BGCOLOR="#000000" TEXT="#FFFFFF" LINK="#FF3300" VLINK="#CC3300" ALINK="#66CC33">
<TABLE BORDER="0">
<TR><TD WIDTH="$TITLE_PIC_WIDTH">$TITLE_PIC</TD><TD WIDTH="20"></TD><TD VALIGN="MIDDLE"><FONT SIZE="+6">$title$prolog</FONT></TD></TR>
</TABLE>
End_of_Here

};


## Closure: Graph server distribution, build index page.
my $graph_index = sub () {
  local(*sfh);
  my($filehtml) = "$STATSDIR/index.html";
  my(@data);

  use GIFgraph::pie;

  # Instantiate a new graph.
  my($graph) = new GIFgraph::pie(252, 189);

  # Build data table.
  foreach my $servertype (sort(@DOLIST)) {
    push(@{$data[0]}, $servertype);
    if (defined($shour{$nowhour}{$servertype}{'servers'})) {
      push(@{$data[1]}, int($shour{$nowhour}{$servertype}{'servers'} / $shour{$nowhour}{$servertype}{'new'}));
    }
    else {
      # FIXME?
      # Pie graph has to have at least a total.
      push(@{$data[1]}, 1);
    }
  }

  # Set graph options.
  $graph->set(
    title	=> 'Server Distribution',
    t_margin	=> 10,
    b_margin	=> 10,
    l_margin	=> 10,
    r_margin	=> 10,
    transparent	=> 0,
  );

  # Start building framing page.
  print "\n  Getting HTML output file $filehtml for write operation...\n" if ($DEBUG >= 2);	# debug info
  open(sfh, ">$filehtml") || die("Can't write to file '$filehtml': $!\n");
  flock(sfh, $LOCK_EX);
  print "  Got exclusive lock on HTML file.\n" if ($DEBUG >= 2);	# debug info

  print "  Writing to file...\n" if ($DEBUG >= 2);			# debug info
  &$return_graph_head("QstatList Statistics", "</FONT><BR><FONT SIZE=\"-1\">Last Updated: $textnow");

  print(sfh <<End_of_Here);
<HR>
<P><BR></P>
<TABLE BORDER="0" CELLPADDING="3"><TR><TD>
  <TABLE BORDER="0">
  <TR><TD><IMG SRC="../icons/skull.gif" ALT="Skull" WIDTH="48" HEIGHT="48"></TD>
    <TD VALIGN="MIDDLE" NOWRAP="NOWRAP"><H1>Hourly Statistics</H1></TD></TR>
  </TABLE>
  <BLOCKQUOTE>
    <H3><A HREF="servers-h.html">Servers by Server Type</A></H3>
    <H3><A HREF="players-h.html">Players by Server Type</A></H3></BLOCKQUOTE>
  <P><BR></P>
  <TABLE BORDER="0">
  <TR><TD><IMG SRC="../icons/skull.gif" ALT="Skull" WIDTH="48" HEIGHT="48"></TD>
  <TD VALIGN="MIDDLE" NOWRAP="NOWRAP"><H1>Daily Statistics</H1></TD></TR>
  </TABLE>
  <BLOCKQUOTE>
    <H3><A HREF="servers-d.html">Servers by Server Type</A></H3>
    <H3><A HREF="players-d.html">Players by Server Type</A></H3></BLOCKQUOTE>
  <P><BR></P>
  <TABLE BORDER="0">
  <TR><TD><IMG SRC="../icons/skull.gif" ALT="Skull" WIDTH="48" HEIGHT="48"></TD>
    <TD VALIGN="MIDDLE" NOWRAP="NOWRAP"><H1>Monthly Statistics</H1></TD></TR>
  </TABLE>
  <BLOCKQUOTE>
    <H3><A HREF="servers-m.html">Servers by Server Type</A></H3>
    <H3><A HREF="players-m.html">Players by Server Type</A></H3></BLOCKQUOTE></TD>
<TD WIDTH="50"></TD>
<TD ALIGN="CENTER" VALIGN="TOP">
  <IMG SRC="serverdist.gif" ALT="Server Distribution by Servertype" WIDTH="252" HEIGHT="189" BORDER="0">
  <P><BR></P>
  <TABLE BORDER="1" CELLPADDING="3" WIDTH="100%">
  <TR><TH><FONT SIZE="+1">Servertype</FONT></TH><TH><FONT SIZE="+1">No. Known</FONT></TH></TR>
End_of_Here

  foreach (@{$data[0]}) {
    print(sfh "  <TR><TD NOWRAP=\"NOWRAP\"><B>$SERVERTYPE{$_}</B></TD><TD ALIGN=\"RIGHT\" NOWRAP=\"NOWRAP\">");
    if (defined($shour{$nowhour}{$_}{'servers'})) {
      print(sfh int($shour{$nowhour}{$_}{'servers'} / $shour{$nowhour}{$_}{'new'}));
    }
    else {
      print(sfh "N/A");
    }
    print(sfh "</TD></TR>\n");
  }

  print(sfh <<End_of_Here);
  </TABLE></TD>
</TR></TABLE>
End_of_Here

  # Generate page footer.
  return_html_tail(\*sfh);
  
  # Create the GIF graph.
  print "    Writing stats GIF for server distribution...\n" if ($DEBUG >= 2);	# debug info
  $graph->plot_to_gif("$STATSDIR/serverdist.gif", \@data);

  close(sfh);
  flock(sfh, $LOCK_UN);
  print "  Unlocked HTML output file.\n" if ($DEBUG >= 2);		# debug info
};


## Closure: Graph servers by month.
my $graph_month = sub ($$$) {
  my($title, $set1, $set2) = @_;

  local(*sfh);
  my($filehtml) = "$STATSDIR/$set1-m.html";
  my($count) = 0;
  my(%data);
  my(@headerrow);

  use GIFgraph::bars;

  # Start building framing page.
  print "\n  Getting HTML output file $filehtml for write operation...\n" if ($DEBUG >= 2);	# debug info
  open(sfh, ">$filehtml") || die("Can't write to file '$filehtml': $!\n");
  flock(sfh, $LOCK_EX);
  print "  Got exclusive lock on HTML file.\n" if ($DEBUG >= 2);	# debug info

  print "  Writing to file...\n" if ($DEBUG >= 2);			# debug info
  &$return_graph_head("$title by Server Type by Month", " ($textnowyear)");

  print(sfh "<HR>\n<FONT SIZE=\"-4\"><A HREF=\"#table\">Jump to Tabular Data</A></FONT>\n<P><BR></P>\n");

  # Calculate date.
  print(sfh "<P ALIGN=\"CENTER\"><FONT SIZE=\"+1\">Last updated: $textnow</FONT></P>\n");
  print(sfh "<CENTER><TABLE WIDTH=\"100%\" BORDER=\"0\">\n<TR>\n");

  # Build data tables.
  foreach my $servertype (sort(@DOLIST)) {
    # Master server don't have players, so skip them.
    next if (($set1 eq 'players') && ($servertype =~ /^($ST_QM_PAT)$/));

    # Set up the headers for the tabular data
    push(@headerrow, "<TH><FONT COLOR=\"$BGH{$servertype}\">$servertype</FONT></TH>");

    # Instantiate a new graph.
    my($graph) = new GIFgraph::bars(252, 189);

    @{$data{$servertype}[0]} = @MON;
    foreach my $month (1 .. 12) {
      if (defined($smonth{$month}{$servertype}{$set1})) {
        push(@{$data{$servertype}[1]}, int($smonth{$month}{$servertype}{$set1} / $smonth{$month}{$servertype}{'new'}));
        push(@{$data{$servertype}[2]}, int($smonth{$month}{$servertype}{$set2} / $smonth{$month}{$servertype}{'new'}));
      }
      else {
        push(@{$data{$servertype}[1]}, undef);
        push(@{$data{$servertype}[2]}, undef);
      }
    }

    # Set graph options.
    $graph->set(
      x_label		=> 'Time',
      y_label		=> "No. $title",
      title		=> "$SERVERTYPE{$servertype} Servers",
      t_margin		=> 1,
      b_margin		=> 1,
      l_margin		=> 1,
      r_margin		=> 10,
      transparent	=> 0,
      x_all_ticks	=> 1,
      x_label_position	=> 0.5,
      y_label_position	=> 0.5,
      x_labels_vertical	=> 1,
      x_min_value	=> 0,
      y_min_value	=> 0,
      overwrite		=> 1,
      marker_size	=> 1
    );
    $graph->set_legend('Total', 'Active');

    # Create the GIF graph.
    print "    Writing stats GIF for $servertype servers...\n" if ($DEBUG >= 2);	# debug info
    $graph->plot_to_gif("$STATSDIR/$servertype-$set1-m.gif", \@{$data{$servertype}});

    # Handle GIF placement in table.
    print(sfh "<TD ALIGN=\"CENTER\"><IMG SRC=\"$STATSDIR_URL$servertype-$set1-m.gif\" ALT=\"$SERVERTYPE{$servertype} Servers\" WIDTH=\"252\" HEIGHT=\"189\" BORDER=\"0\"></TD>\n");
    if (++$count == 2) {
      $count = 0;
      print(sfh "</TR>\n<TR>\n");
    }
  }
  print(sfh "<TD>&nbsp;</TD>\n") if ($count == 1);

  print(sfh <<End_of_Here);
</TR>
</TABLE></CENTER>
<HR WIDTH="80%">
<P><BR></P>
<CENTER><A NAME="table"></A>
<TABLE WIDTH="80%" BORDER="1" CELLPADDING="3">
End_of_Here

  print (sfh "<TR><TH ROWSPAN=\"2\">Month</TH><TH COLSPAN=\"", scalar(@headerrow), "\">Server Type<BR><FONT SIZE=\"-1\">(Active / Total)</FONT></TH></TR>\n");
  print (sfh "<TR>", join('', @headerrow), "</TR>\n");

  foreach $month (1 .. 12) {
    if ($month == $nowmonth) {
      print(sfh "<TR><TH BGCOLOR=\"#FFFF00\" NOWRAP=\"NOWRAP\"><FONT COLOR=\"#000000\"><B>$MON[$month - 1]</B></FONT></TH>");
    }
    elsif ($month > $nowmonth) {
      print(sfh "<TR><TH BGCOLOR=\"#666666\" NOWRAP=\"NOWRAP\"><FONT COLOR=\"#000000\"><B>$MON[$month - 1]</B></FONT></TH>");
    }
    else {
      print(sfh "<TR><TH NOWRAP=\"NOWRAP\">$MON[$month - 1]</TH>");
    }

    foreach (sort(@DOLIST)) {
      # Master server don't have players, so skip them.
      next if (($set1 eq 'players') && /^($ST_QM_PAT)$/);

      if ($month == $nowmonth) {
        print(sfh "<TD ALIGN=\"RIGHT\" BGCOLOR=\"#FFFF00\" NOWRAP=\"NOWRAP\"><FONT COLOR=\"#000000\">");
      }
      elsif ($month > $nowmonth) {
        print(sfh "<TD ALIGN=\"RIGHT\" BGCOLOR=\"#666666\" NOWRAP=\"NOWRAP\"><FONT COLOR=\"#000000\">");
      }
      else {
        print(sfh "<TD ALIGN=\"RIGHT\" NOWRAP=\"NOWRAP\"><FONT COLOR=\"$BGH{$_}\">");
      }
      if (defined(${$data{$_}[1]}[$month - 1])) {
        print(sfh "${$data{$_}[2]}[$month - 1]/${$data{$_}[1]}[$month - 1]");
      }
      else {
        print(sfh "N/A");
      }
      print(sfh "</FONT></TD>");
    }
    print(sfh "</TR>\n");
  }

  print(sfh <<End_of_Here);
</TABLE></CENTER>
End_of_Here

  # Generate page footer.
  return_html_tail(\*sfh);
  
  close(sfh);
  flock(sfh, $LOCK_UN);
  print "  Unlocked HTML output file.\n" if ($DEBUG >= 2);		# debug info
};


## Closure: Graph servers by day.
my $graph_day = sub ($$$) {
  my($title, $set1, $set2) = @_;

  local(*sfh);
  my($filehtml) = "$STATSDIR/$set1-d.html";
  my($count) = 0;
  my(%data);
  my(@headerrow);

  use GIFgraph::bars;

  # Start building framing page.
  print "\n  Getting HTML output file $filehtml for write operation...\n" if ($DEBUG >= 2);	# debug info
  open(sfh, ">$filehtml") || die("Can't write to file '$filehtml': $!\n");
  flock(sfh, $LOCK_EX);
  print "  Got exclusive lock on HTML file.\n" if ($DEBUG >= 2);	# debug info

  print "  Writing to file...\n" if ($DEBUG >= 2);			# debug info
  &$return_graph_head("$title by Server Type by Day", " ($MON[$nowmonth - 1], $textnowyear)");

  print(sfh "<HR>\n<FONT SIZE=\"-4\"><A HREF=\"#table\">Jump to Tabular Data</A></FONT>\n<P><BR></P>\n");

  # Calculate date.
  print(sfh "<P ALIGN=\"CENTER\"><FONT SIZE=\"+1\">Last updated: $textnow</FONT></P>\n");
  print(sfh "<CENTER><TABLE WIDTH=\"100%\" BORDER=\"0\">\n<TR>\n");

  # Build data tables.
  foreach my $servertype (sort(@DOLIST)) {
    # Master server don't have players, so skip them.
    next if (($set1 eq 'players') && ($servertype =~ /^($ST_QM_PAT)$/));

    # Set up the headers for the tabular data
    push(@headerrow, "<TH><FONT COLOR=\"$BGH{$servertype}\">$servertype</FONT></TH>");

    # Instantiate a new graph.
    my($graph) = new GIFgraph::bars(252, 189);

    foreach my $day (1 .. 31) {
      push(@{$data{$servertype}[0]}, $day);

      if (defined($sday{$day}{$servertype}{$set1})) {
        push(@{$data{$servertype}[1]}, int($sday{$day}{$servertype}{$set1} / $sday{$day}{$servertype}{'new'}));
        push(@{$data{$servertype}[2]}, int($sday{$day}{$servertype}{$set2} / $sday{$day}{$servertype}{'new'}));
      }
      else {
        push(@{$data{$servertype}[1]}, undef);
        push(@{$data{$servertype}[2]}, undef);
      }
    }

    # Set graph options.
    $graph->set(
      x_label		=> 'Time',
      y_label		=> "No. $title",
      title		=> "$SERVERTYPE{$servertype} Servers",
      t_margin		=> 1,
      b_margin		=> 1,
      l_margin		=> 1,
      r_margin		=> 10,
      transparent	=> 0,
      x_all_ticks	=> 1,
      x_label_position	=> 0.5,
      y_label_position	=> 0.5,
      x_labels_vertical	=> 1,
      x_min_value	=> 0,
      y_min_value	=> 0,
      overwrite		=> 1,
      marker_size	=> 1
    );
    $graph->set_legend('Total', 'Active');

    # Create the GIF graph.
    print "    Writing stats GIF for $servertype servers...\n" if ($DEBUG >= 2);	# debug info
    $graph->plot_to_gif("$STATSDIR/$servertype-$set1-d.gif", \@{$data{$servertype}});

    # Handle GIF placement in table.
    print(sfh "<TD ALIGN=\"CENTER\"><IMG SRC=\"$STATSDIR_URL$servertype-$set1-d.gif\" ALT=\"$SERVERTYPE{$servertype} Servers\" WIDTH=\"252\" HEIGHT=\"189\" BORDER=\"0\"></TD>\n");
    if (++$count == 2) {
      $count = 0;
      print(sfh "</TR>\n<TR>\n");
    }
  }
  print(sfh "<TD>&nbsp;</TD>\n") if ($count == 1);

  print(sfh <<End_of_Here);
</TR>
</TABLE></CENTER>
<HR WIDTH="80%">
<P><BR></P>
<CENTER><A NAME="table"></A>
<TABLE WIDTH="80%" BORDER="1" CELLPADDING="3">
End_of_Here

  print (sfh "<TR><TH ROWSPAN=\"2\">Day</TH><TH COLSPAN=\"", scalar(@headerrow), "\">Server Type<BR><FONT SIZE=\"-1\">(Active / Total)</FONT></TH></TR>\n");
  print (sfh "<TR>", join('', @headerrow), "</TR>\n");

  foreach $day (1 .. 31) {
    if ($day == $nowday) {
      print(sfh "<TR><TH BGCOLOR=\"#FFFF00\" NOWRAP=\"NOWRAP\"><FONT COLOR=\"#000000\"><B>$day</B></FONT></TH>");
    }
    elsif ($day > $nowday) {
      print(sfh "<TR><TH BGCOLOR=\"#666666\" NOWRAP=\"NOWRAP\"><FONT COLOR=\"#000000\"><B>$day</B></FONT></TH>");
    }
    else {
      print(sfh "<TR><TH NOWRAP=\"NOWRAP\">$day</TH>");
    }

    foreach (sort(@DOLIST)) {
      # Master server don't have players, so skip them.
      next if (($set1 eq 'players') && /^($ST_QM_PAT)$/);

      if ($day == $nowday) {
        print(sfh "<TD ALIGN=\"RIGHT\" BGCOLOR=\"#FFFF00\" NOWRAP=\"NOWRAP\"><FONT COLOR=\"#000000\">");
      }
      elsif ($day > $nowday) {
        print(sfh "<TD ALIGN=\"RIGHT\" BGCOLOR=\"#666666\" NOWRAP=\"NOWRAP\"><FONT COLOR=\"#000000\">");
      }
      else {
        print(sfh "<TD ALIGN=\"RIGHT\" NOWRAP=\"NOWRAP\"><FONT COLOR=\"$BGH{$_}\">");
      }
      if (defined(${$data{$_}[1]}[$day - 1]) || defined(${$data{$_}[2]}[$day - 1])) {
        print(sfh "${$data{$_}[2]}[$day - 1]/${$data{$_}[1]}[$day - 1]");
      }
      else {
        print(sfh "N/A");
      }
      print(sfh "</FONT></TD>");
    }
    print(sfh "</TR>\n");
  }

  print(sfh <<End_of_Here);
</TABLE></CENTER>
End_of_Here

  # Generate page footer.
  return_html_tail(\*sfh);
  
  close(sfh);
  flock(sfh, $LOCK_UN);
  print "  Unlocked HTML output file.\n" if ($DEBUG >= 2);		# debug info
};


## Closure: Graph servers by hour.
my $graph_hour = sub ($$$) {
  my($title, $set1, $set2) = @_;

  local(*sfh);
  my($filehtml) = "$STATSDIR/$set1-h.html";
  my($count) = 0;
  my(%data);
  my(@headerrow);

  use GIFgraph::linespoints;

  # Start building framing page.
  print "\n  Getting HTML output file $filehtml for write operation...\n" if ($DEBUG >= 2);	# debug info
  open(sfh, ">$filehtml") || die("Can't write to file '$filehtml': $!\n");
  flock(sfh, $LOCK_EX);
  print "  Got exclusive lock on HTML file.\n" if ($DEBUG >= 2);	# debug info

  print "  Writing to file...\n" if ($DEBUG >= 2);			# debug info
  &$return_graph_head("$title by Server Type by Hour", " ($textnowday, $MON[$nowmonth - 1] $nowday)");

  print(sfh "<HR>\n<FONT SIZE=\"-4\"><A HREF=\"#table\">Jump to Tabular Data</A></FONT>\n<P><BR></P>\n");

  # Calculate date.
  print(sfh "<P ALIGN=\"CENTER\"><FONT SIZE=\"+1\">Last updated: $textnow</FONT></P>\n");
  print(sfh "<CENTER><TABLE WIDTH=\"100%\" BORDER=\"0\">\n<TR>\n");

  # Build data tables.
  foreach my $servertype (sort(@DOLIST)) {
    # Master server don't have players, so skip them.
    next if (($set1 eq 'players') && ($servertype =~ /^($ST_QM_PAT)$/));

    # Set up the headers for the tabular data
    push(@headerrow, "<TH><FONT COLOR=\"$BGH{$servertype}\">$servertype</FONT></TH>");

    # Instantiate a new graph.
    my($graph) = new GIFgraph::linespoints(252, 189);

    foreach my $hour (0 .. 23) {
      push(@{$data{$servertype}[0]}, $hour);

      if (defined($shour{$hour}{$servertype}{$set1})) {
        push(@{$data{$servertype}[1]}, int($shour{$hour}{$servertype}{$set1} / $shour{$hour}{$servertype}{'new'}));
        push(@{$data{$servertype}[2]}, int($shour{$hour}{$servertype}{$set2} / $shour{$hour}{$servertype}{'new'}));
      }
      else {
        push(@{$data{$servertype}[1]}, undef);
        push(@{$data{$servertype}[2]}, undef);
      }
    }

    # Set graph options.
    $graph->set(
      x_label		=> 'Time',
      y_label		=> "No. $title",
      title		=> "$SERVERTYPE{$servertype} Servers",
      t_margin		=> 1,
      b_margin		=> 1,
      l_margin		=> 1,
      r_margin		=> 10,
      transparent	=> 0,
      x_all_ticks	=> 1,
      x_label_position	=> 0.5,
      y_label_position	=> 0.5,
      x_labels_vertical	=> 1,
      x_min_value	=> 0,
      y_min_value	=> 0,
      marker_size	=> 1
    );
    $graph->set_legend('Total', 'Active');

    # Create the GIF graph.
    print "    Writing stats GIF for $servertype servers...\n" if ($DEBUG >= 2);	# debug info
    $graph->plot_to_gif("$STATSDIR/$servertype-$set1-h.gif", \@{$data{$servertype}});

    # Handle GIF placement in table.
    print(sfh "<TD ALIGN=\"CENTER\"><IMG SRC=\"$STATSDIR_URL$servertype-$set1-h.gif\" ALT=\"$SERVERTYPE{$servertype} Servers\" WIDTH=\"252\" HEIGHT=\"189\" BORDER=\"0\"></TD>\n");
    if (++$count == 2) {
      $count = 0;
      print(sfh "</TR>\n<TR>\n");
    }
  }
  print(sfh "<TD>&nbsp;</TD>\n") if ($count == 1);

  print(sfh <<End_of_Here);
</TR>
</TABLE></CENTER>
<HR WIDTH="80%">
<P><BR></P>
<CENTER><A NAME="table"></A>
<TABLE WIDTH="80%" BORDER="1" CELLPADDING="3">
End_of_Here

  print (sfh "<TR><TH ROWSPAN=\"2\">Hour</TH><TH COLSPAN=\"", scalar(@headerrow), "\">Server Type<BR><FONT SIZE=\"-1\">(Active / Total)</FONT></TH></TR>\n");
  print (sfh "<TR>", join('', @headerrow), "</TR>\n");

  foreach $hour (0 .. 23) {
    if ($hour == $nowhour) {
      print(sfh "<TR><TH BGCOLOR=\"#FFFF00\" NOWRAP=\"NOWRAP\"><FONT COLOR=\"#000000\"><B>$hour</B></FONT></TH>");
    }
    elsif ($hour > $nowhour) {
      print(sfh "<TR><TH BGCOLOR=\"#666666\" NOWRAP=\"NOWRAP\"><FONT COLOR=\"#000000\"><B>$hour</B></FONT></TH>");
    }
    else {
      print(sfh "<TR><TH NOWRAP=\"NOWRAP\">$hour</TH>");
    }

    foreach (sort(@DOLIST)) {
      # Master server don't have players, so skip them.
      next if (($set1 eq 'players') && /^($ST_QM_PAT)$/);

      if ($hour == $nowhour) {
        print(sfh "<TD ALIGN=\"RIGHT\" BGCOLOR=\"#FFFF00\" NOWRAP=\"NOWRAP\"><FONT COLOR=\"#000000\">");
      }
      elsif ($hour > $nowhour) {
        print(sfh "<TD ALIGN=\"RIGHT\" BGCOLOR=\"#666666\" NOWRAP=\"NOWRAP\"><FONT COLOR=\"#000000\">");
      }
      else {
        print(sfh "<TD ALIGN=\"RIGHT\" NOWRAP=\"NOWRAP\"><FONT COLOR=\"$BGH{$_}\">");
      }
      if (defined(${$data{$_}[1]}[$hour - 1]) || defined(${$data{$_}[2]}[$hour - 1])) {
        print(sfh "${$data{$_}[2]}[$hour - 1]/${$data{$_}[1]}[$hour - 1]");
      }
      else {
        print(sfh "N/A");
      }
      print(sfh "</FONT></TD>");
    }
    print(sfh "</TR>\n");
  }

  print(sfh <<End_of_Here);
</TABLE></CENTER>
End_of_Here

  # Generate page footer.
  return_html_tail(\*sfh);
  
  close(sfh);
  flock(sfh, $LOCK_UN);
  print "  Unlocked HTML output file.\n" if ($DEBUG >= 2);		# debug info
};


## Closure: Write statistics data to stats log.
my $put_stats = sub () {
  print "\nGetting hourly stats file for append operation...\n" if ($DEBUG);	# debug info
  open(sfh, ">>$LIST_STATS") || die("Can't append to file '$LIST_STATS': $!\n");
  flock(sfh, $LOCK_EX);
  print "Got exclusive lock on hourly stats file.\n" if ($DEBUG);	# debug info

  print "Writing to file...\n" if ($DEBUG);				# debug info
  my($seconds, $minutes, $hour, $day, $month, $year) = localtime($Time);
  print(sfh sprintf("%02d/%02d/%04d %02d:%02d:%02d", $month + 1, $day, $year + 1900, $hour, $minutes, $seconds));
  foreach (@DOLIST) {
    # <servertype> <servers>, <actservers>, <maxplayers>, <players>
    print(sfh sprintf(" $_ %01d, %01d, %01d, %01d", $Rstats{$_}{'servers'}, $Rstats{$_}{'actservers'}, $Rstats{$_}{'maxplayers'}, $Rstats{$_}{'players'}));
  }
  print(sfh "\n");

  close(sfh);
  flock(sfh, $LOCK_UN);
  print "Unlocked hourly stats file.\n" if ($DEBUG);			# debug info
};


## ============================================================================
## ============================================================================
##
## MAIN
##

sub do_stats() {
  # Write data.
  &$put_stats();

  # Run process only if graphs are an hour or more old.
  if ((-e "$STATSDIR/index.html") && (-M _ < 0.0416)) {
    print "\nSkipping stats build.\n" if ($DEBUG);			# debug info
    return();
  }

  print "\n<-- Stats generation starting. -->\n" if ($DEBUG);		# debug info
									# debug info
  local(@MON) = qw(Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec);

  local($nowseconds, $nowminutes, $nowhour, $nowday, $nowmonth, $nowyear) = localtime($Time);
  $nowmonth++;
  $nowyear += 1900;

  local($textnow, $textnowday, $textnowyear) = scalar(localtime($Time)) =~ /^((\w+)\s+.+\s+(\d{4}))$/;
  local(%smonth, %sday, %shour);

  my($month, $day, $year, $hour, $minutes, $seconds);

  # Look 82800 seconds (= 23 hours) into the past.
  my($pastseconds, $pastminutes, $pasthour, $pastday, $pastmonth, $pastyear) = localtime($Time - 82800);
  my($pastindex) = sprintf("%04d%02d%02d%02d%02d%02d", $pastyear + 1900, $pastmonth + 1, $pastday, $pasthour, $pastminutes, $pastseconds);

  print "\nGetting $LIST_STATS for read operation...\n" if ($DEBUG);	# debug info
  open(sfh, "<$LIST_STATS") || die("Can't read from file '$LIST_STATS': $!\n");
  flock(sfh, $LOCK_SH);
  print "Got exclusive lock.\n" if ($DEBUG);				# debug info

  print "Reading from file...\n" if ($DEBUG);				# debug info
  while (<sfh>) {
    # Skip blank lines.
    next if (/^\n$/);
  
    # Remove trailing <CR> character.
    chop();

    # Make sure we don't get tainted info!
    unless (($month, $day, $year, $hour, $minutes, $seconds) = /^(\d{2})\/(\d{2})\/(\d{4})\s(\d{2}):(\d{2}):(\d{2})\s/) {
      print "  WARNING: Bogus entry found.  Skipping.\n" if ($DEBUG => 2);	# debug info
      next;
    }

    my($index) = join('', ($year, $month, $day, $hour, $minutes, $seconds));

    # Trim leading zero.
    $month =~ s/^0//;
    $day =~ s/^0//;
    $hour =~ s/^0//;

    while (/(?:($ST_PAT)\s(\d*),\s(\d*),\s(\d*),\s(\d*)\s*)/g) {
      # Average over the hour.
      # Use a rolling graph: new data overwrites old data as it is created so
      #   that the graph always shows 24hrs worth of data.
      if ($index > $pastindex) {
        $shour{$hour}{$1}{'new'}++;
        $shour{$hour}{$1}{'servers'} += $2;
        $shour{$hour}{$1}{'actservers'} += $3;
        $shour{$hour}{$1}{'players'} += $4;
        $shour{$hour}{$1}{'actplayers'} += $5;
      }

      # Average over the month.
      next if ($year != $nowyear);
      $smonth{$month}{$1}{'new'}++;
      $smonth{$month}{$1}{'servers'} += $2;
      $smonth{$month}{$1}{'actservers'} += $3;
      $smonth{$month}{$1}{'players'} += $4;
      $smonth{$month}{$1}{'actplayers'} += $5;

      # Average over the day.
      next if ($month != $nowmonth);
      $sday{$day}{$1}{'new'}++;
      $sday{$day}{$1}{'servers'} += $2;
      $sday{$day}{$1}{'actservers'} += $3;
      $sday{$day}{$1}{'players'} += $4;
      $sday{$day}{$1}{'actplayers'} += $5;
    }
  }

  close(sfh);
  flock(sfh, $LOCK_UN);
  print "Unlocked statistics log.\n" if ($DEBUG);			# debug info

  # Build graphs.
  print "\nCreating output files for statistics index...\n" if ($DEBUG);	# debug info
  &$graph_index();
  print "Done.\n" if ($DEBUG);						# debug info

  print "\nCreating output files for hourly statistics...\n" if ($DEBUG);	# debug info
  &$graph_hour('Servers', 'servers', 'actservers');
  &$graph_hour('Players', 'players', 'actplayers');
  print "Done.\n" if ($DEBUG);						# debug info

  print "\nCreating output files for daily statistics...\n" if ($DEBUG);	# debug info
  &$graph_day('Servers', 'servers', 'actservers');
  &$graph_day('Players', 'players', 'actplayers');
  print "Done.\n" if ($DEBUG);						# debug info

  print "\nCreating output files for monthly statistics...\n" if ($DEBUG);	# debug info
  &$graph_month('Servers', 'servers', 'actservers');
  &$graph_month('Players', 'players', 'actplayers');
  print "Done.\n" if ($DEBUG);						# debug info
									# debug info
  print "\n<-- Stats generation finished. -->\n" if ($DEBUG);		# debug info
}

1;  # THIS LINE MUST BE LAST -- DO NOT CHANGE IT
