/*************************************
/  Title : Quake Name Generator      /
/  Author: Matt Spaulding            /      
/  E-mail: mspauld@mindspring.com    /
/************************************/

#include <stdio.h>
#include <conio.h>

#define FALSE 0
#define TRUE 1
#define MAXLEN 15

/* Boolean flags */
int bo_togg,bo_alt,bo_dots,bo_gold,bo_space,bo_clan,bo_clanb4,bo_clangold;

/* 0-9 in gold */
char goldnums[]={'','','','','','','','','',''};

/* A-Z, a-z both in gold */
char goldlets[]={'','','','','','','','','','','','','','','',
			'','','','','','','','','','','',
		 '','','','','','','','','','','','','','','',
			'','','','','','','','','','',''};
char *cptr,str_clan[20]="\0";

char cvt_let(char);
void do_clan(void);

/*********************main()***********************************************************/
void main(int argc,char *argv[])
{
FILE *fptr;
char *t_cptr,ch_in,str_out[50]="\0",str_in[20]="\0",str_fname[255];

bo_togg=bo_alt=bo_dots=bo_gold=bo_space=bo_clan=bo_clanb4=bo_clangold=FALSE;

/*open appropriate output file*/
	strcpy(str_fname,argv[0]);
	t_cptr=strrchr(str_fname,'\\');
	*(++t_cptr)='\0';

	/* for a different name (eg. your 'autoexec.cfg') just change this string */
	strcat(str_fname,"qname.scr");	

	if ((fptr = fopen(str_fname, "a")) == NULL)
	{
	   fprintf(stderr, "Cannot open output file.\n");
	   exit(-1);
	}

/* Get some info */
	clrscr();
	printf("Quake Name Generator\n-------------------------\n");
	printf("The total length of the final string(including brackets+dots+spaces)\n");
	printf("must be less than 16 characters.  The player and clan names *should*\n");
	printf("consist of only upper/lower case letters or numbers.\n\n");
	printf("Enter Player Name->");
	gets(str_in);
	
	printf("Would you like to use alternating colors in the player name? ->");
	ch_in=getche();
	if ((ch_in=='y')||(ch_in=='Y'))
		bo_alt=TRUE;
	else
	{
		printf("\nWould you like to use gold letters for the player name? ->");
		ch_in=getche();
		if ((ch_in=='y')||(ch_in=='Y'))
			bo_gold=TRUE;
	}	

	printf("\nWould you like your player name to have surrounding centered dots? ->");
	ch_in=getche();
	if ((ch_in=='y')||(ch_in=='Y'))
	{	
		bo_dots=1;
	}
	else
	{
		printf("\nWould you like your player name to have surrounding curved braces? ->");
		ch_in=getche();
		if ((ch_in=='y')||(ch_in=='Y'))
			bo_dots=2;
	}

	printf("\nWould you like to include clan initials in []? ->");
	ch_in=getche();
	if ((ch_in=='y')||(ch_in=='Y'))
	{
		bo_clan=TRUE;
		printf("\nWould you like a space in between clan and player names? ->");
		ch_in=getche();
		if ((ch_in=='y')||(ch_in=='Y'))
			bo_space=TRUE;
		printf("\nEnter Clan Initials->");
		gets(str_clan);
		printf("Would you like to use gold letters for clan name? ->");
		ch_in=getche();
		if ((ch_in=='y')||(ch_in=='Y'))
			bo_clangold=TRUE;
		printf("\nWould you like the clan name to appear after the player name? ->");
		ch_in=getche();
		if ((ch_in!='y')&&(ch_in!='Y'))
			bo_clanb4=TRUE;
	}
	
	if( (strlen(str_in)+strlen(str_clan)+bo_clan*2+bo_space+(bo_dots&&1)*2) > MAXLEN )
	{
		fprintf(stderr,"\n\nHey bubba, you are over the limit of 15 characters.\nThink about it and try again.\n");
		exit(-1);
	}
	
/* Build the string... */
	cptr=str_out;
	
	/* clan stuff */
	if(bo_clanb4)
	{
		do_clan();
		if (bo_space)	*cptr++=' ';
	}

	/* player stuff */
	if(bo_dots)
		if(bo_dots==1)
			/* insert leading dot */
			*cptr++='';
			/* insert leading curved brace */
		else 	*cptr++='';

	t_cptr=str_in;
	while (*t_cptr!='\0')
	{
		if ( bo_gold || (bo_alt&&bo_togg) )
		{
			if(*t_cptr<='9' && *t_cptr>='0')
				*cptr++=goldnums[*t_cptr++-'0'];
			else if(*t_cptr>='A' && *t_cptr<='Z')
				*cptr++=goldlets[*t_cptr++-'A'];
			else if(*t_cptr>='a' && *t_cptr<='z')
				*cptr++=goldlets[*t_cptr++-'a'+26];
			else *cptr++=*t_cptr++;		
		}
		else *cptr++=*t_cptr++;
		if (bo_togg) bo_togg=FALSE;
		else bo_togg=TRUE;
	}

	if(bo_dots)
		if(bo_dots==1)
			/* insert trailing dot */
			*cptr++='';
			/* insert trailing curved brace */
		else 	*cptr++='';	
	
	/* more clan stuff */
	if(bo_clan && !bo_clanb4)
	{	
		if(bo_space) *cptr++=' ';
		do_clan();
	}
	
	*cptr='\0';

/* write to file */
	if(fprintf(fptr,"name \"%s\"\n",str_out)!=EOF)
		printf("\n\nData was written successfully\n\n"); 
	else
		fprintf(stderr,"Error: Data was not written.\n\n");
	printf("Hit any key to exit...");
	getche();
	printf("\n\n");
	close(fptr);
} /******* end main() *******************/


void do_clan(void)
{
char *t_cptr;

	/*insert leading bracket */
	*cptr++='';

	t_cptr=str_clan;
	while (*t_cptr!='\0')
	{
		if(bo_clangold)
		{
			if(*t_cptr<='9' && *t_cptr>='0')
				*cptr++=goldnums[*t_cptr++-'0'];
			else if(*t_cptr>='A' && *t_cptr<='Z')
				*cptr++=goldlets[*t_cptr++-'A'];
			else if(*t_cptr>='a' && *t_cptr<='z')
				*cptr++=goldlets[*t_cptr++-'a'+26];		
			else *cptr++=*t_cptr++;
		}
		else *cptr++=*t_cptr++;
	}

	/*insert trailing bracket */
	*cptr++='';
}/* basically the same as player name builder, just too lazy to combine */