#include <stdio.h>
#include <string.h>
#include "idsrc.h"

long PositionPAK(FILE *In,char *Name);
long PositionWAD(FILE *In,char *Name);

long PositionPAK(FILE *In,char *Name)
{
	packfile_t pf;
	packheader_t ph;
	long Pos;

	Pos = ftell(In);
	fread(&ph,sizeof(packheader_t),1,In);
	fseek(In,Pos + ph.dirofs,SEEK_SET);

	while(ftell(In)-(Pos+ph.dirofs) < ph.dirlen){
        fread(&pf,sizeof(packfile_t),1,In);
        if (strcmpi(pf.name,Name)==0)
			break;		
	}
	if (ftell(In)-(Pos + ph.dirofs) >= ph.dirlen)
		return -1;

	fseek(In,pf.filepos,SEEK_SET);
	return pf.filelen;
}

long PositionWAD(FILE *In,char *Name)
{
	wadinfo_t wi;
	lumpinfo_t li;
	long Pos;

	Pos = ftell(In);
    fread(&wi,sizeof(wadinfo_t),1,In);
    fseek(In,Pos+wi.infotableofs,SEEK_SET);
	while(wi.numlumps--){
		fread(&li,sizeof(lumpinfo_t),1,In);
        if (strcmpi(li.name,Name)==0)
			break;
	}

	if (wi.numlumps<=0)
		return -1;

	fseek(In,Pos+li.filepos,SEEK_SET);
	return	li.size;
}


