#include <dos.h>
#include <dir.h>
#include <mem.h>
#include <conio.h>
#include <stdarg.h>
#include "pakwad.c"

/*
    This compiles under Turbo C 2.0 and possibly other compilers as well =)
    This is VERY DOSSY, so I wouldn't even try to port it to other platforms.

    Improvements over V1.0:
        * Displays the character set by hitting F1
        * Uses F3 to exit instead of ESCAPE
        * vcprintf for formatted console printing
        * DOES NOT violate copyrights
        * Loads the character set from the PAK->WAD
        * Loads the Palette from the WAD
        * Does not assume anything without checking first
        * Smaller than QUAKNAME (82K) (it helps not having a background)
        * Full source included!!

    Questions/Comments:
        Well I'm between e-mail addresses right now, so send them to
        kotyk@pangea.usask.ca
*/

#define CHAR_SIZE   8*8*256
unsigned char CharSet[CHAR_SIZE];
unsigned char Palette[768];
unsigned char *Screen = (unsigned char *)0xA0000000;
char *AppName = "CONCHAR V2.0 - (C)1997";
char Formatting = 1;

/* Please don't be an AOL Llamma hacker d00d by changing the next line! */
unsigned char Psy[] = {29,30,144,'P',243,'y',203,'o',244,'y',235,145,30,31,0};

int VXOff=0,VYOff=0;
void vcprintf(char *fmt,...);

void InitGrafix(unsigned char Mode)
{
    struct REGPACK r;
    r.r_ax = Mode;
    intr(0x10,&r);
}

void SetPalette(void)
{
    struct REGPACK r;
    r.r_ax=0x1012;
    r.r_bx=0x0000;
    r.r_cx=0x00FF;
    r.r_dx=FP_OFF(Palette);
    r.r_es=FP_SEG(Palette);
    intr(0x10,&r);
}

void ClearScreen(void)
{
    VXOff=0; VYOff=0;
    memset(Screen,0,64000);
    vcprintf("%s %s\n",AppName,Psy);
    vcprintf("%cF1 - Char Set%c %cF3 - Exit%c\n",144,145,144,145);
}

void vputc(int c)
{
    /* 16 x 16 */
    int x,y,Offset;

    if (Formatting && ((c==13) || (c==10))){    /* Handle new line */
        VYOff+=8;
        VXOff=0;
    } else
        VXOff+=8;

    if(VXOff==320){             /* Wrap X */
        VYOff+=8;
        VXOff=0;
    }

    if (VYOff>=200)             /* Wrap Y (doesn't scroll) */
        ClearScreen();

    if (c!=13){                 /* Spit out the character */
        Offset = (c%16)*8 + (c/16)*1024;
        for(y=0;y<8;y++)
            for(x=0;x<8;x++)
                Screen[VXOff+x+(VYOff+y)*320] = CharSet[x+(y*128)+Offset];
    }
}

void vcprintf(char *fmt,...)
{
    va_list args;
    unsigned char Buffer[255],z=0;

    va_start(args,fmt);
    vsprintf(Buffer,fmt,args);
    va_end(args);

    while(Buffer[z])
        vputc(Buffer[z++]);
}

/* Checks for the existance of a file or directory */
int Exist(char *Path)
{
    struct ffblk File;
    return !findfirst(Path,&File,255);
}

/* NASTY!  Loads the needed files as best it can.. */
int LoadData(void)
{
    FILE *In;
    long a;
    char Path[128],FileName[128];

    printf("Looking for your Quake directory...");
    /* Find the ID1 directory */
    strcpy(Path,"\\QUAKE\\ID1");
    if (!Exist(Path)){
        strcpy(Path,"\\GAMES\\QUAKE\ID1");
        while (!Exist(Path)){
            puts("Directory not found.");
            printf("Please enter your QUAKE directory or ENTER if you have none:");
            gets(Path);
            if (Path[0]==0){
                puts("Sorry.. You need a copy of Quake to run this program.");
                return -1;
            }
            strcat(Path,"\\ID1");
        }
    } else puts("Found in \\QUAKE.");

    strcpy(FileName,Path);
    strcat(FileName,"\\PAK0.PAK");
    /* See if the .PAK is there */
    if ((In=fopen(FileName,"rb"))!=NULL){
        printf("Loading GFX.WAD from PAK0.PAK...");

        /* Load the Character set */
        if ((a = PositionPAK(In,"GFX.WAD"))>0){
            printf("Loading CONCHARS from GFX.WAD...");
            if ((a = PositionWAD(In,"CONCHARS"))>0){
                fread(CharSet,sizeof(char),a,In);
                puts("Done.");
            }else{
                puts("Unable to load CONCHARS.");
                fclose(In);
                return -1;
            }
        } else {
            puts("Unable to load GFX.WAD.");
            fclose(In);
            return -1;
        }
        rewind(In);
        /* Load the Palette */
        printf("Loading PALETTE.LMP from PAK0.PAK...");
        if ((a=PositionPAK(In,"GFX/PALETTE.LMP"))>0){
            fread(Palette,sizeof(char),a,In);
            puts("Done.");
        } else {
            puts("Unable to load PALETTE.LMP.");
            fclose(In);
            return -1;
        }
        fclose(In);
    } else {
        strcpy(FileName,Path);
        strcat(FileName,"\\GFX.WAD");
        printf("Loading CONCHARS from GFX.WAD...");
        if ((In=fopen(FileName,"rb"))!=NULL){
            if ((a=PositionWAD(In,"CONCHARS"))>0){
                fread(CharSet,sizeof(char),a,In);
                puts("Done.");
            } else {
                puts("Unable to load CONCHARS in GFX.WAD.");
                fclose(In);
                return -1;
            }
            fclose(In);
        } else {
            puts("Unable to open GFX.WAD.");
            return -1;
        }
        strcpy(FileName,Path);
        strcat(FileName,"\\GFX\\PALETTE.LMP");
        printf("Loading GFX/PALETTE.LMP...");
        if ((In=fopen(FileName,"rb"))!=NULL){
            fread(Palette,sizeof(char),768,In);
            fclose(In);
            puts("Done.");
        } else {
            printf("Unable to open [%s]\n",FileName);
            return -1;
        }
    }
    return 0;
}

int main(void)
{
    int x,a;
    printf("%s PsyKotyk\n",AppName);
    if (LoadData())
        return -1;

    for(x=0;x<768;x++)  /* Gamma correct */
        Palette[x]/=3;

    InitGrafix(0x13);   /* Go MCGA 256 Color */
    SetPalette();
    ClearScreen();
    do{
        a=getch();
        if (a==0){
            a=getch();
            if (a==61)      /* F3 */
                break;
            if (a==59){     /* F1 */
                ClearScreen();
                for(x=0;x<256;x++){
                    Formatting = 0;
                    vcprintf("%c%3d%c",x,x,x%8==0?'\n':' ');
                    Formatting = 1;
                    if  (x==128){
                        vcprintf("Press a key for more.\n");
                        getch();
                        ClearScreen();
                    }
                }
                vcprintf("\n");
            }
        } else
            vputc(a);
    }while(1);
    InitGrafix(0x03);       /* Go 80x25 color */
    return 0;
}

