/* QVER BSP Version Converter 1.0 by Tom Grandgent (Woofer)  7/27/96
 *
 * This should be completely portable C.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

int main(int argc, char **argv) {

	FILE *fp;
	int i, extension, ver = 29;
	char fname[80], vername[80];

	printf("QVER BSP Version Converter 1.0 by Tom Grandgent (Woofer)  7/27/96\n\n");

/* Check arguments. */
	if (argc < 2) {
		printf("Syntax: QVER blah[.bsp] [version]\n\n");
		printf("Possible values for version:\n\n");
		printf("  shareware\n");
		printf("  sw\n");
		printf("  registered\n");
		printf("  reg\n");
		printf("  [any valid version number from 1 to 255]\n\n");
		printf("Version 28 is shareware, 29 is registered.\n\n");
		printf("If the version number is omitted, the version of the BSP will be displayed.\n");
		return 1;
	}

	if (argc > 2) {

		ver = atoi(argv[2]);
		strcpy(vername, argv[2]);

		if (!strcasecmp(vername, "shareware"))
			ver = 28;
		else
			if (!strcasecmp(vername, "sw"))
				ver = 28;
			else
				if (!strcasecmp(vername, "registered"))
					ver = 29;
				else
					if (!strcasecmp(vername, "reg"))
						ver = 29;
						else
							if (!strcasecmp(vername, "regged"))
								ver = 29;

		if (ver < 1 || ver > 255) {
			printf("ERROR: Valid version numbers range from 1 to 255.\n");
			printf("(If you typed a word for the version, I didn't know what it meant.)\n");
			return 1;
		}
	}

	strcpy(fname, argv[1]);

/* Check for an extension.  Add .BSP if it's not already there. */
	extension = 0;
	for (i = 0; i < strlen(fname); i++) {
		if (fname[i] == '.')
			extension = 1;
	}
	if (!extension)
		strcat(fname, ".BSP");

/* Try to open the BSP file. */
	if (!(fp = fopen(fname, "rb+"))) {
		printf("ERROR: Couldn't open %s for reading.\n", fname);
		return 1;
	}

/* Display the file name (in caps). */
	for (i = 0; i < strlen(fname); i++)
		fname[i] = toupper(fname[i]);
	printf("BSP %s:\n\n", fname);

/* See what the version number of the BSP was. */
	i = fgetc(fp);

	if (argc > 2)
		printf("Old version: %d ", i);
	else
		printf("Version: %d ", i);
	switch (i) {
		case 28: printf("(Shareware)\n"); break;
		case 29: printf("(Registered)\n"); break;
		default: printf("\n");
	}

/* If the user wants to patch the BSP, do it. */

	if (argc > 2) {
		printf("New version: %d ", ver);
		switch (ver) {
			case 28: printf("(Shareware)\n"); break;
			case 29: printf("(Registered)\n"); break;
			default: printf("\n");
		}
		fseek(fp, 0, SEEK_SET);
		fputc(ver, fp);
	}

// Close the file, we're done.
	if (fclose(fp) == EOF) {
		printf("ERROR: Unable to close file %s.\n", fname);
	}

	return 0;
}
