/*
==============================================================================
Title: "16-bit Texture Enabler For 3Dfx's Win32 Quake OpenGL Miniport"
(c) 1998 by Matthias "Maddes" Buecher

Authors:
Matthias "Maddes" Buecher <maddes@bigfoot.com>

Important:
It should compile under Win32 with no errors, some warnings may still occur.

DISCLAIMER WARNING:
WE DO NOT ACCEPT RESPONSIBILITY FOR ANY EFFECTS, POSITIVE OR NEGATIVE,
THAT THIS CODE MAY CAUSE TOWARDS YOUR COMPUTER.
WE DO NOT SUPPORT MODIFICATIONS OF THIS CODE, USE ONLY AT YOUR OWN RISK.
THIS PATCH HAS NOT BEEN ENDORSED BY THE ID SOFTWARE CORPORATION.
THIS PROGRAM IS FREE OF CHARGE. IF YOU HAVE RECEIVED THIS PROGRAM THROUGH
PAYMENT, PLEASE CONTACT US.
OTHERWISE ENJOY THE PROGRAM. THANK YOU.
==============================================================================
*/

/* Compatible headers */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>

#define BUFLEN 10240	/* 10KB */

char *filename = "opengl32.dll";

long old;

unsigned char *orgname = "GL_EXT_shared_texture_palette";
unsigned char *newname = "DISABLEshared_texture_palette";
long searchlen;

unsigned char *orgname2 = "3DFX_set_global_palette";
unsigned char *newname2 = "DISABLEt_global_palette";
long searchlen2;


long compare(unsigned char *m1, unsigned char *m2, long n, long l)
{
	long i, j;

	for (i=0; i<=(n-l); i++)
	{
		if (m1[i] == m2[0])
		{
			for (j=0; j<l; j++)
			{
				if (m1[i+j] != m2[j]) break;
			}
			if (j==l) break;
		}
	}
	if (i<=(n-l)) return i;

	return -1;
}

void process_file(char *path)
{
	FILE *data;

	unsigned char buffer[BUFLEN];
	long foffset, bytes;
	long found;
	long found2;
	int flag_orgname, flag_newname;

	printf("*** Processing \"%s\"\n", path);

	/* open data file */
	data = fopen(path, "r+b");
	if (!data)
	{
		if (errno == EACCES)
			printf("Warning: can not access file - write protected or a directory?\n");
		else
			printf("Warning: file not found\n");
	}
	else
	{
		foffset = 0;
		flag_orgname = 0;
		flag_newname = 0;

		while (bytes = fread(buffer, 1, BUFLEN, data))
		{
			if (!flag_newname)
			{
				found = compare(buffer, orgname, bytes, searchlen);
				if (old)
					found2 = compare(buffer, orgname2, bytes, searchlen2);
				else
					found2 = -1;
				if ( found >= 0 || found2 >= 0)
				{
					flag_orgname = 1;
					if ( found >= 0 )
					{
						printf("Found \"%s\" at offset %li\n", orgname, foffset+found);
						if ( fseek(data, foffset+found, SEEK_SET) != 0 || ftell(data) != foffset+found )
						{
							printf("Error: can not position into file\n");
							break;
						}
						if ( fwrite(newname, searchlen, 1, data) != 1 )
						{
							printf("Error: can not write into file\n");
							break;
						}
					}
					if ( found2 >= 0 )
					{
						printf("Found \"%s\" at offset %li\n", orgname2, foffset+found2);
						if ( fseek(data, foffset+found2, SEEK_SET) != 0 || ftell(data) != foffset+found2 )
						{
							printf("Error: can not position into file\n");
							break;
						}
						if ( fwrite(newname2, searchlen2, 1, data) != 1 )
						{
							printf("Error: can not write into file\n");
							break;
						}
					}
					/* seek also needed to switch from writing to reading */
					if ( found > found2 )
					{
						fseek(data, foffset+found+searchlen, SEEK_SET);
					}
					else
					{
						fseek(data, foffset+found2+searchlen2, SEEK_SET);
					}
				}
			}
			if (!flag_orgname)
			{
				found = compare(buffer, newname, bytes, searchlen);
				found2 = compare(buffer, newname2, bytes, searchlen2);
				if ( found >= 0 || found2 >= 0)
				{
					flag_newname = 1;
					if ( found >= 0 )
					{
						printf("Found \"%s\" at offset %li\n", newname, foffset+found);
						if ( fseek(data, foffset+found, SEEK_SET) != 0 || ftell(data) != foffset+found )
						{
							printf("Error: can not position into file\n");
							break;
						}
						if ( fwrite(orgname, searchlen, 1, data) != 1 )
						{
							printf("Error: can not write into file\n");
							break;
						}
					}
					if ( found2 >= 0 )
					{
						printf("Found \"%s\" at offset %li\n", newname2, foffset+found2);
						if ( fseek(data, foffset+found2, SEEK_SET) != 0 || ftell(data) != foffset+found2 )
						{
							printf("Error: can not position into file\n");
							break;
						}
						if ( fwrite(orgname2, searchlen2, 1, data) != 1 )
						{
							printf("Error: can not write into file\n");
							break;
						}
					}
					/* seek also needed to switch from writing to reading */
					if ( found > found2 )
					{
						fseek(data, foffset+found+searchlen, SEEK_SET);
					}
					else
					{
						fseek(data, foffset+found2+searchlen2, SEEK_SET);
					}
				}
			}

			if (bytes < BUFLEN) break;
			foffset = ftell(data);
		}
		fclose(data);
	}
}

int main(int argc, char *argv[])
{
	/* display program header lines */
	printf("16-bit Texture Enabler For 3Dfx's Win32 Quake OpenGL Miniport\n");
	printf("(c) 1998 by Matthias \"Maddes\" Buecher\n\n");

	if (argc > 2)
	{
		/* syntax */
		printf("Usage: OGL16BIT [-old]\n");
		/* contact */
		printf("\nHow to contact the author:\n");
		printf("Matthias \"Maddes\" Buecher <maddes@bigfoot.com>\n");
	}
	else
	{
		old = 0;

		if (argc > 1 && !strcmp(argv[1],"-old"))
		{
			old = 1;			
		}

		searchlen = strlen(orgname);	/* GL_EXT_shared_texture_palette */
		searchlen2 = strlen(orgname2);	/* GL_EXT_paletted_texture */
		process_file(filename);
	}

	return 0;
}
