#ifndef	WAD_H
#define	WAD_H
/*
 * ============================================================================
 * structures
 * ============================================================================
 */

#define MAGIC_WAD2	MKID('W','A','D','2')	/* 0x57414432 */

struct wadheader {
  magick magic;
  /*
   * WAD2 
   */
  int numentries, offset;
};

#define NAMELEN_WAD 16
struct wadentry {
  int offset, wadsize, memsize;
  unsigned char type, compr;
  short int dummy;
  char name[16];
};

#define	CMP_NONE		0
/* bitdefs */
#define	CMP_LZSS		(1<<0)
#define	CMP_LZ77		(1<<1)				/* compressed with a LZ77 */
#define	CMP_BTPC		(1<<2)				/* compressed with a subtype of BTPC (lossless/lossy, 0-100) */
#define CMP_MIP0		(1<<3)				/* store only mip0 instead of all */
#define CMP_ALL			((1<<4)-1)

#define WAD2_PALETTE	'@'
#define WAD2_MIPMAP	'D'
#define WAD2_STATUSBAR	'B'
#define WAD2_CONPIC	'E'

/*
 * ============================================================================
 * globals
 * ============================================================================
 */

/*
 * ============================================================================
 * prototypes
 * ============================================================================
 */

struct palpic *GetWAD2Picture(HANDLE wadFile, struct wadentry *Entry);
struct rawdata *GetWAD2Raw(HANDLE wadFile, struct wadentry *Entry);
bool AddWAD2(struct palpic *inPic, struct rawdata *inData, char *wadName, operation procOper, filetype wadType);
bool ExtractWAD2(HANDLE file, FILE * script, char *destDir, char *entryName, unsigned char convert, operation procOper, filetype wadType);
bool CheckWAD2(HANDLE wadFile, struct wadheader *Header, bool newWad);
struct wadentry *FindWAD2(HANDLE wadFile, char *entryName, struct wadheader *Header, struct wadentry **Entry, filetype wadType);
struct wadentry *SearchWAD2(char *entryName, struct wadheader *Header, struct wadentry *allEntries, filetype wadType);

#endif
